#!/bin/sh
usage () {
        printf "$0\n"
        printf "USAGE:\n"
        printf "\t$0 [domain] [user] [pass] [jboss home] [jboss profile]\n"
        printf "Where:\n"
        printf "\tdomain        = domain name\n"
        printf "\tuser          = user name.\n"
        printf "\tpass          = password.\n"
        printf "\tjboss home    = path to jboss-as dir.\n"
        printf "\tjboss profile    = jboss profile.\n"
  return 0
}


if [ "$#" -ne 5 ]; then
	usage
	echo "Error: wrong number of arguments"
	exit 1
fi

DOMAIN=$1
USER=$2
PASS=$3
JB_HOME=$4
JB_PROFILE=$5
EAR_LIB=server/$JB_PROFILE/deploy/rhevm.ear/lib

RHEVM_LIB_PATH=/usr/share/rhevm/rhevm.ear/lib
JAVA_HOME_LIB=/usr/share/java

if [ -z "$JB_HOME" ]; then
	JB_HOME=/var/lib/jbossas
fi

if [ ! -d $JB_HOME/$EAR_LIB ]; then
	#if the rhevm-slimmed profile is missing, use /usr/share/rhevm/rhevm.ear
	CLASSPATH=$RHEVM_LIB_PATH/spring-tx-2.5.6.SEC02.jar:$RHEVM_LIB_PATH/commons-lang-2.4.jar:$JAVA_HOME_LIB/spring2/beans-2.5.6.jar:$JAVA_HOME_LIB/spring2/core-2.5.6.jar:$RHEVM_LIB_PATH/spring-ldap-core-1.3.0.RELEASE.jar:$RHEVM_LIB_PATH/utils-3.0.2-0001.jar:$RHEVM_LIB_PATH/rhevm-compat.jar:$JB_HOME/common/lib/commons-logging.jar
else
	CLASSPATH=$JB_HOME/$EAR_LIB/spring-tx-2.5.6.SEC02.jar:$JB_HOME/$EAR_LIB/commons-lang-2.4.jar:$JAVA_HOME_LIB/spring2/beans-2.5.6.jar:$JAVA_HOME_LIB/spring2/core-2.5.6.jar:$JB_HOME/$EAR_LIB/spring-ldap-core-1.3.0.RELEASE.jar:$JB_HOME/$EAR_LIB/utils-3.0.2-0001.jar:$JB_HOME/$EAR_LIB/rhevm-compat.jar:$JB_HOME/common/lib/commons-logging.jar
fi

for f in $(echo $CLASSPATH | sed 's/:/ /g')
do
	if [ ! -s $f ]; then
		echo "Error: can't run without missing JAR file: $f"
		exit 1
	fi
done

printf "\nVerifying authentication configuration...\n"
java -cp $CLASSPATH org.ovirt.engine.core.utils.ipa.SimpleAuthenticationCheck  -domain=$DOMAIN -user=$USER -password=$PASS
res=$?

if [ "$res" -gt "0" ]; then
	echo Error: failed authentication to domain $DOMAIN with user $USER
	exit $res
fi

exit $res
