SET NOCOUNT ON
go

declare @super_user_id_0001 uniqueidentifier
declare @power_user_id_0002 uniqueidentifier
declare @user_id_1001 uniqueidentifier

declare @CLUSTER_ADMIN_ID uniqueidentifier
declare @DATA_CENTER_ADMIN_ID uniqueidentifier
declare @STORAGE_ADMIN_ID uniqueidentifier
declare @HOST_ADMIN_ID uniqueidentifier
declare @NETWORK_ADMIN_ID uniqueidentifier
declare @VM_OPERATOR_ID uniqueidentifier
declare @VM_POOL_ADMIN_ID uniqueidentifier
declare @TEMPLATE_ADMIN_ID uniqueidentifier
declare @TEMPLATE_USER_ID uniqueidentifier

set @super_user_id_0001 = '00000000-0000-0000-0000-000000000001'
set @power_user_id_0002 = '00000000-0000-0000-0001-000000000002'
set @user_id_1001 = '00000000-0000-0000-0001-000000000001'

set @CLUSTER_ADMIN_ID = 'DEF00001-0000-0000-0000-DEF000000001'
set @DATA_CENTER_ADMIN_ID = 'DEF00002-0000-0000-0000-DEF000000002'
set @STORAGE_ADMIN_ID = 'DEF00003-0000-0000-0000-DEF000000003'
set @HOST_ADMIN_ID = 'DEF00004-0000-0000-0000-DEF000000004'
set @NETWORK_ADMIN_ID = 'DEF00005-0000-0000-0000-DEF000000005'
set @VM_OPERATOR_ID = 'DEF00006-0000-0000-0000-DEF000000006'
set @VM_POOL_ADMIN_ID = 'DEF00007-0000-0000-0000-DEF000000007'
set @TEMPLATE_ADMIN_ID = 'DEF00008-0000-0000-0000-DEF000000008'
set @TEMPLATE_USER_ID = 'DEF00009-0000-0000-0000-DEF000000009'

-------------
--SuperUser role
---------------
if (not exists (select id from roles where id = @super_user_id_0001))
begin
	INSERT INTO [roles] ([id],[name],[description],[is_readonly],[role_type]) VALUES (@super_user_id_0001,'SuperUser','Roles management administrator',1,1)
end
else
begin
	delete from [roles_groups] where [role_id] = @super_user_id_0001
end
---Vm Groups
--CREATE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,1)
--DELETE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,2)
--EDIT_VM_PROPERTIES
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,3)
--VM_BASIC_OPERATIONS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,4)
--CHANGE_VM_CD
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,5)
--MIGRATE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,6)
--CONNECT_TO_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,7)
--IMPORT_EXPORT_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,8)
--CONFIGURE_VM_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,9)
--CONFIGURE_VM_STORAGE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,10)
--MOVE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,11)
--MANIPULATE_VM_SNAPSHOTS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,12)
-- host (vds) actions groups
--CREATE_HOST
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,100)
--EDIT_HOST_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,101)
--DELETE_HOST
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,102)
--MANIPUTLATE_HOST
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,103)
--CONFIGURE_HOST_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,104)
-- templates actions groups
--CREATE_TEMPLATE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,200)
--EDIT_TEMPLATE_PROPERTIES
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,201)
--DELETE_TEMPLATE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,202)
--COPY_TEMPLATE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,203)
--CONFIGURE_TEMPLATE_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,204)
-- vm pools actions groups
--CREATE_VM_POOL
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,300)
--EDIT_VM_POOL_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,301)
--DELETE_VM_POOL
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,302)
--VM_POOL_BASIC_OPERATIONS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,303)
-- clusters actions groups
--CREATE_CLUSTER
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,400)
--EDIT_CLUSTER_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,401)
--DELETE_CLUSTER
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,402)
--CONFIGURE_CLUSTER_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,403)
-- users and MLA actions groups
--MANIPULATE_USERS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,500)
--MANIPULATE_ROLES
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,501)
--MANIPULATE_PERMISSIONS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,502)
-- storage domains actions groups
--CREATE_STORAGE_DOMAIN
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,600)
--EDIT_STORAGE_DOMAIN_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,601)
--DELETE_STORAGE_DOMAIN
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,602)
--MANIPULATE_STORAGE_DOMAIN
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,603)
-- storage pool actions groups
--CREATE_STORAGE_POOL
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,700)
--DELETE_STORAGE_POOL
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,701)
--EDIT_STORAGE_POOL_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,702)
--CONFIGURE_STORAGE_POOL_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,703)
-- oVirt generic
--CONFIGURE_RHEVM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@super_user_id_0001,800)

-------------
--User role
---------------
if (not exists (select id from roles where id = @user_id_1001))
begin
	INSERT INTO [roles] ([id],[name],[description],[is_readonly],[role_type]) VALUES (@user_id_1001,'RHEVMUser','oVirt user',1,2)
end
else
begin
	delete from [roles_groups] where [role_id] = @user_id_1001
end

--VM_BASIC_OPERATIONS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@user_id_1001,4)
--CHANGE_VM_CD
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@user_id_1001,5)
--CONNECT_TO_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@user_id_1001,7)
--VM_POOL_BASIC_OPERATIONS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@user_id_1001,303)

-------------
--PoewerUser role
---------------
if (not exists (select id from roles where id = @power_user_id_0002))
begin
	INSERT INTO [roles] ([id],[name],[description],[is_readonly],[role_type]) VALUES (@power_user_id_0002,'RHEVMPowerUser','oVirt power user',1,2)
end
else
begin
	delete from [roles_groups] where [role_id] = @power_user_id_0002
end

---Vm Groups
--CREATE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,1)
--DELETE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,2)
--EDIT_VM_PROPERTIES
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,3)
--VM_BASIC_OPERATIONS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,4)
--CHANGE_VM_CD
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,5)
--MIGRATE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,6)
--CONNECT_TO_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,7)
--IMPORT_EXPORT_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,8)
--CONFIGURE_VM_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,9)
--CONFIGURE_VM_STORAGE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,10)
--MOVE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,11)
--MANIPULATE_VM_SNAPSHOTS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,12)
-- templates actions groups
--CREATE_TEMPLATE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,200)
--EDIT_TEMPLATE_PROPERTIES
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,201)
--DELETE_TEMPLATE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,202)
--COPY_TEMPLATE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,203)
--CONFIGURE_TEMPLATE_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,204)
-- vm pools actions groups
--CREATE_VM_POOL
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,300)
--EDIT_VM_POOL_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,301)
--DELETE_VM_POOL
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,302)
--VM_POOL_BASIC_OPERATIONS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@power_user_id_0002,303)

-------------
--CLUSTER_ADMIN role
---------------
if (not exists (select id from roles where id = @CLUSTER_ADMIN_ID))
begin
	INSERT INTO [roles] ([id],[name],[description],[is_readonly],[role_type]) VALUES (@CLUSTER_ADMIN_ID,'ClusterAdmin','Cluster administrator',1,1)
end
else
begin
	delete from [roles_groups] where [role_id] = @CLUSTER_ADMIN_ID
end

---Vm Groups
--CREATE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,1)
--DELETE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,2)
--EDIT_VM_PROPERTIES
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,3)
--VM_BASIC_OPERATIONS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,4)
--CHANGE_VM_CD
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,5)
--MIGRATE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,6)
--CONNECT_TO_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,7)
--IMPORT_EXPORT_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,8)
--CONFIGURE_VM_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,9)
--CONFIGURE_VM_STORAGE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,10)
--MOVE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,11)
--MANIPULATE_VM_SNAPSHOTS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,12)
-- vm pools actions groups
--CREATE_VM_POOL
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,300)
--EDIT_VM_POOL_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,301)
--DELETE_VM_POOL
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,302)
--VM_POOL_BASIC_OPERATIONS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,303)
-- host (vds) actions groups
--CREATE_HOST
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,100)
--EDIT_HOST_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,101)
--DELETE_HOST
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,102)
--MANIPUTLATE_HOST
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,103)
--CONFIGURE_HOST_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,104)
-- clusters actions groups
--CREATE_CLUSTER
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,400)
--EDIT_CLUSTER_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,401)
--DELETE_CLUSTER
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,402)
--CONFIGURE_CLUSTER_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@CLUSTER_ADMIN_ID,403)

-------------
--DATA_CENTER_ADMIN role
---------------
if (not exists (select id from roles where id = @DATA_CENTER_ADMIN_ID))
begin
	INSERT INTO [roles] ([id],[name],[description],[is_readonly],[role_type]) VALUES (@DATA_CENTER_ADMIN_ID,'DataCenterAdmin','Data Center administrator',1,1)
end
else
begin
	delete from [roles_groups] where [role_id] = @DATA_CENTER_ADMIN_ID
end

---Vm Groups
--CREATE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,1)
--DELETE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,2)
--EDIT_VM_PROPERTIES
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,3)
--VM_BASIC_OPERATIONS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,4)
--CHANGE_VM_CD
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,5)
--MIGRATE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,6)
--CONNECT_TO_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,7)
--IMPORT_EXPORT_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,8)
--CONFIGURE_VM_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,9)
--CONFIGURE_VM_STORAGE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,10)
--MOVE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,11)
--MANIPULATE_VM_SNAPSHOTS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,12)
-- templates actions groups
--CREATE_TEMPLATE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,200)
--EDIT_TEMPLATE_PROPERTIES
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,201)
--DELETE_TEMPLATE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,202)
--COPY_TEMPLATE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,203)
--CONFIGURE_TEMPLATE_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,204)
-- vm pools actions groups
--CREATE_VM_POOL
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,300)
--EDIT_VM_POOL_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,301)
--DELETE_VM_POOL
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,302)
--VM_POOL_BASIC_OPERATIONS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,303)
-- host (vds) actions groups
--CREATE_HOST
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,100)
--EDIT_HOST_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,101)
--DELETE_HOST
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,102)
--MANIPUTLATE_HOST
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,103)
--CONFIGURE_HOST_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,104)
-- clusters actions groups
--CREATE_CLUSTER
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,400)
--EDIT_CLUSTER_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,401)
--DELETE_CLUSTER
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,402)
--CONFIGURE_CLUSTER_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,403)
-- storage pool actions groups
--CREATE_STORAGE_POOL
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,700)
--DELETE_STORAGE_POOL
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,701)
--EDIT_STORAGE_POOL_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,702)
--CONFIGURE_STORAGE_POOL_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@DATA_CENTER_ADMIN_ID,703)

-------------
--STORAGE_ADMIN role
---------------
if (not exists (select id from roles where id = @STORAGE_ADMIN_ID))
begin
	INSERT INTO [roles] ([id],[name],[description],[is_readonly],[role_type]) VALUES (@STORAGE_ADMIN_ID,'StorageAdmin','Storage administrator',1,1)
end
else
begin
	delete from [roles_groups] where [role_id] = @STORAGE_ADMIN_ID
end

-- storage domains actions groups
--CREATE_STORAGE_DOMAIN
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@STORAGE_ADMIN_ID,600)
--EDIT_STORAGE_DOMAIN_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@STORAGE_ADMIN_ID,601)
--DELETE_STORAGE_DOMAIN
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@STORAGE_ADMIN_ID,602)
--MANIPULATE_STORAGE_DOMAIN
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@STORAGE_ADMIN_ID,603)

-------------
--HOST_ADMIN role
---------------
if (not exists (select id from roles where id = @HOST_ADMIN_ID))
begin
	INSERT INTO [roles] ([id],[name],[description],[is_readonly],[role_type]) VALUES (@HOST_ADMIN_ID,'HostAdmin','Host administrator',1,1)
end
else
begin
	delete from [roles_groups] where [role_id] = @HOST_ADMIN_ID
end

-- host (vds) actions groups
--CREATE_HOST
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@HOST_ADMIN_ID,100)
--EDIT_HOST_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@HOST_ADMIN_ID,101)
--DELETE_HOST
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@HOST_ADMIN_ID,102)
--MANIPUTLATE_HOST
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@HOST_ADMIN_ID,103)
--CONFIGURE_HOST_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@HOST_ADMIN_ID,104)
-- storage domains actions groups
--CREATE_STORAGE_DOMAIN
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@HOST_ADMIN_ID,600)
--EDIT_STORAGE_DOMAIN_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@HOST_ADMIN_ID,601)
--DELETE_STORAGE_DOMAIN
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@HOST_ADMIN_ID,602)
--MANIPULATE_STORAGE_DOMAIN
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@HOST_ADMIN_ID,603)

-------------
--NETWORK_ADMIN role
---------------
if (not exists (select id from roles where id = @NETWORK_ADMIN_ID))
begin
	INSERT INTO [roles] ([id],[name],[description],[is_readonly],[role_type]) VALUES (@NETWORK_ADMIN_ID,'NetworkAdmin','Network administrator',1,1)
end
else
begin
	delete from [roles_groups] where [role_id] = @NETWORK_ADMIN_ID
end
--CONFIGURE_HOST_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@NETWORK_ADMIN_ID,104)
--MANIPUTLATE_HOST
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@NETWORK_ADMIN_ID,103)
--CONFIGURE_CLUSTER_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@NETWORK_ADMIN_ID,403)


-------------
--VM_OPERATOR role
---------------
if (not exists (select id from roles where id = @VM_OPERATOR_ID))
begin
	INSERT INTO [roles] ([id],[name],[description],[is_readonly],[role_type]) VALUES (@VM_OPERATOR_ID,'VmOperator','VM operator',1,2)
end
else
begin
	delete from [roles_groups] where [role_id] = @VM_OPERATOR_ID
end

---Vm Groups
--CREATE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_OPERATOR_ID,1)
--DELETE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_OPERATOR_ID,2)
--EDIT_VM_PROPERTIES
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_OPERATOR_ID,3)
--VM_BASIC_OPERATIONS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_OPERATOR_ID,4)
--CHANGE_VM_CD
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_OPERATOR_ID,5)
--MIGRATE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_OPERATOR_ID,6)
--CONNECT_TO_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_OPERATOR_ID,7)
--IMPORT_EXPORT_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_OPERATOR_ID,8)
--CONFIGURE_VM_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_OPERATOR_ID,9)
--CONFIGURE_VM_STORAGE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_OPERATOR_ID,10)
--MOVE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_OPERATOR_ID,11)
--MANIPULATE_VM_SNAPSHOTS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_OPERATOR_ID,12)


-------------
--VM_POOL_ADMIN role
---------------
if (not exists (select id from roles where id = @VM_POOL_ADMIN_ID))
begin
	INSERT INTO [roles] ([id],[name],[description],[is_readonly],[role_type]) VALUES (@VM_POOL_ADMIN_ID,'VmPoolAdmin','Vm-Pool administrator',1,1)
end
else
begin
	delete from [roles_groups] where [role_id] = @VM_POOL_ADMIN_ID
end
-- vm pools actions groups
--CREATE_VM_POOL
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_POOL_ADMIN_ID,300)
--EDIT_VM_POOL_CONFIGURATION
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_POOL_ADMIN_ID,301)
--DELETE_VM_POOL
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_POOL_ADMIN_ID,302)
--VM_POOL_BASIC_OPERATIONS
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@VM_POOL_ADMIN_ID,303)
-------------
--TEMPLATE_ADMIN role
---------------
if (not exists (select id from roles where id = @TEMPLATE_ADMIN_ID))
begin
	INSERT INTO [roles] ([id],[name],[description],[is_readonly],[role_type]) VALUES (@TEMPLATE_ADMIN_ID,'TemplateAdmin','Template administrator',1,1)
end
else
begin
	delete from [roles_groups] where [role_id] = @TEMPLATE_ADMIN_ID
end

-- templates actions groups
--CREATE_TEMPLATE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@TEMPLATE_ADMIN_ID,200)
--EDIT_TEMPLATE_PROPERTIES
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@TEMPLATE_ADMIN_ID,201)
--DELETE_TEMPLATE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@TEMPLATE_ADMIN_ID,202)
--COPY_TEMPLATE
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@TEMPLATE_ADMIN_ID,203)
--CONFIGURE_TEMPLATE_NETWORK
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@TEMPLATE_ADMIN_ID,204)

-------------
--TEMPLATE_USER role
---------------
if (not exists (select id from roles where id = @TEMPLATE_USER_ID))
begin
	INSERT INTO [roles] ([id],[name],[description],[is_readonly],[role_type]) VALUES (@TEMPLATE_USER_ID,'TemplateUser','Template User',1,2)
end
else
begin
	delete from [roles_groups] where [role_id] = @TEMPLATE_USER_ID
end

---Vm Groups
--CREATE_VM
INSERT INTO [roles_groups] ([role_id],[action_group_id]) VALUES (@TEMPLATE_USER_ID,1)
go
