package org.ovirt.engine.core.config.validation;

import java.util.HashMap;
import java.util.Map;

/**
 * The <code>RhevmConfigValidatorFactory</code> class is a action specific validator factory, that holds a map between
 * validator types and their classes.
 */
public class RhevmConfigValidatorFactory {
    private Map<ValidatorType, RhevmConfigValidator> validationMap;
    private static RhevmConfigValidatorFactory instance;
    static {
        instance = new RhevmConfigValidatorFactory();
    }

    private RhevmConfigValidatorFactory() {
        validationMap = new HashMap<ValidatorType, RhevmConfigValidator>();
        validationMap.put(ValidatorType.get, new GetValidator());
        validationMap.put(ValidatorType.set, new SetValidator());
    }

    public static RhevmConfigValidatorFactory instance() {
        return instance;
    }

    public RhevmConfigValidator getValidation(ValidatorType type) {
        return validationMap.get(type);
    }
}