using System;
using System.ComponentModel;
using System.Windows;
using System.Windows.Input;
using org.ovirt.engine.ui.uicommon;
using Microsoft.Practices.Unity;
using org.ovirt.engine.ui.uicommon.models.configure.roles_ui;

namespace UI.WPFClient
{
	public partial class RoleListView
	{
		private WindowView view;

		public new RoleListModel Model
		{
			get { return base.Model as RoleListModel; }
			set { base.Model = value; }
		}


		public RoleListView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName != "Window") return;

			if (Model.Window != null)
			{
				if (Model.LastExecutedCommand == Model.NewCommand)
				{
					view = TypeResolver.Instance.Resolve<RoleView>();
				}
				else if (Model.LastExecutedCommand == Model.EditCommand)
				{
					view = TypeResolver.Instance.Resolve<RoleView>();
				}
				else if (Model.LastExecutedCommand == Model.RemoveCommand)
				{
					view = TypeResolver.Instance.Resolve<RemoveView>();
				}
				else if (Model.LastExecutedCommand == Model.CloneCommand)
				{
					view = TypeResolver.Instance.Resolve<RoleView>();
				}
				else
				{
					throw new NotImplementedException();
				}

				view.Model = Model.Window;
				WindowManager.AddWindow(view);
			}
			else
			{
				WindowManager.RemoveWindow(view);
				view = null;
			}
		}

		private void RemoveCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.RemoveCommand.Execute();
		}

		private void NewCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.NewCommand.Execute();
		}

		private void EditCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.EditCommand.Execute();
		}

		private void RemoveCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.RemoveCommand.IsExecutionAllowed;
		}

		private void EditCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.EditCommand.IsExecutionAllowed;
		}
	}
}
