PRINT 'Processing repo_files_meta_data_sp.sql'

----------------------------------------------------------------
-- [dbo].[repo_file_meta_data] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertRepo_domain_file_meta_data')
BEGIN
    EXEC('CREATE PROCEDURE [dbo].[InsertRepo_domain_file_meta_data] AS RETURN')
END
GO

ALTER PROCEDURE [dbo].[InsertRepo_domain_file_meta_data]
    @repo_domain_id uniqueidentifier,
    @repo_file_name nvarchar(256),
    @size bigint,
    @date_created datetime,
    @last_refreshed bigint,
    @file_type int
AS
BEGIN
    SET NOCOUNT ON

    BEGIN TRY
    INSERT INTO [dbo].[repo_file_meta_data] ([repo_domain_id], [repo_file_name], [size], [date_created], [last_refreshed], [file_type])
    VALUES (@repo_domain_id, @repo_file_name, @size, @date_created, @last_refreshed, @file_type)

    END TRY

    BEGIN CATCH
        EXEC RethrowError;
   END CATCH

    SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteRepo_domain_file_list')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteRepo_domain_file_list] AS RETURN')
END
GO

ALTER PROCEDURE [dbo].[DeleteRepo_domain_file_list]
    @repo_domain_id uniqueidentifier,
    @file_type int
AS
BEGIN
    SET NOCOUNT ON

    DELETE FROM [dbo].[repo_file_meta_data]
    WHERE [repo_domain_id]=@repo_domain_id
      AND [file_type]=@file_type

    SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetRepo_files_by_storage_domain_and_storage_pool')
BEGIN
    EXEC('CREATE PROCEDURE [dbo].[GetRepo_files_by_storage_domain_and_storage_pool] AS RETURN')
END
GO

ALTER PROCEDURE [dbo].[GetRepo_files_by_storage_domain_and_storage_pool]
	@storage_pool_id uniqueidentifier,    
	@storage_domain_id uniqueidentifier, 
    @file_type int
AS
BEGIN
    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
    SET NOCOUNT ON

    SELECT
    [repo_file_view].[storage_pool_id],
    [repo_file_view].[storage_pool_status],
    [repo_file_view].[vds_status], 
    [repo_file_view].[storage_domain_id], 
    [repo_file_view].[storage_domain_status],
    [repo_file_view].[repo_file_name],
    [repo_file_view].[size],
    [repo_file_view].[date_created],
    [repo_file_view].[last_refreshed]
    FROM [dbo].[storage_domain_file_repos] [repo_file_view]
    WHERE [storage_pool_id]=@storage_pool_id
      AND [storage_domain_id]=@storage_domain_id 
      AND [file_type]=@file_type
	ORDER BY [repo_file_view].[last_refreshed]
    SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetRepo_files_by_storage_domain')
BEGIN
    EXEC('CREATE PROCEDURE [dbo].[GetRepo_files_by_storage_domain] AS RETURN')
END
GO

ALTER PROCEDURE [dbo].[GetRepo_files_by_storage_domain]
	@storage_domain_id uniqueidentifier,
    @file_type int
AS
BEGIN
    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
    SET NOCOUNT ON
    SELECT
    [repo_file].[repo_domain_id],
    [repo_file].[repo_file_name],
    [repo_file].[size],
    [repo_file].[date_created],
    [repo_file].[last_refreshed]
    FROM [dbo].[repo_file_meta_data] [repo_file]
    WHERE [repo_domain_id]=@storage_domain_id
      AND [file_type]=@file_type
	ORDER BY [repo_file].[last_refreshed]
    SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetRepo_files_in_all_storage_pools')
BEGIN
    EXEC('CREATE PROCEDURE [dbo].[GetRepo_files_in_all_storage_pools] AS RETURN')
END
GO

ALTER PROCEDURE [dbo].[GetRepo_files_in_all_storage_pools]
	@storage_domain_type int,
	@storage_pool_status int,
	@vds_status int,
	@storage_domain_status int
AS
BEGIN
    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
    SET NOCOUNT ON

    SELECT distinct
	[repo_file_view].[storage_domain_id], 
    [last_repo_refreshed].[last_refreshed],
	[repo_file_view].[file_type]
    FROM [dbo].[storage_domain_file_repos] as repo_file_view LEFT OUTER JOIN 
		 (SELECT storage_domain_id,file_type,
				 min([last_refreshed]) as last_refreshed
		  FROM [dbo].[storage_domain_file_repos]
          Group by storage_domain_id,file_type) as last_repo_refreshed ON [repo_file_view].storage_domain_id = [last_repo_refreshed].storage_domain_id
                                                                       AND [repo_file_view].file_type = [last_repo_refreshed].file_type
	WHERE [repo_file_view].[storage_domain_type] = @storage_domain_type 
	  AND [repo_file_view].[storage_pool_status] = @storage_pool_status 
	  AND [repo_file_view].[vds_status] = @vds_status
	  AND [repo_file_view].[storage_domain_status] = @storage_domain_status
    SET NOCOUNT OFF
END
GO