'''
Created on Apr 26, 2010

@author: mpastern
'''
from org.ovirt.engine.ui.sdk.converters import typeConverter
from org.ovirt.engine.ui.sdk.ext import configManager
import org.ovirt.engine.ui.sdk.containers.errorsContainer as Exceptions

import traceback as tb
import os
import sys

sys.path.append('/usr/share/rhevm'+ os.sep +'com'+os.sep +'redhat'+os.sep+'rhevm'+os.sep+'sdk')
sys.path.append(os.getcwd()+ os.sep +'RedHat'+os.sep+'RhevM'+os.sep+'SDK')

def getConfFilePath():
    #wnd
    if(os.name == 'nt' and (os.path.exists(os.getcwd() + '\Com\RedHat\RhevM\SDK\RedHat.RhevM.SDK.ini'))):
        return os.getcwd() + '\Com\RedHat\RhevM\SDK\RedHat.RhevM.SDK.ini'

    #non wind
    if((not os.name == 'nt') and os.path.exists('/usr/share/rhevm'+ os.sep +'com'+os.sep +'redhat'+os.sep+'rhevm'+os.sep+'sdk'+os.sep +'RedHat.RhevM.SDK.ini')):
            return '/usr/share/rhevm'+ os.sep +'com'+os.sep +'redhat'+os.sep+'rhevm'+os.sep+'sdk'+os.sep +'RedHat.RhevM.SDK.ini'
        
    for path in sys.path:
        cPath = path+os.sep +'RedHat.RhevM.SDK.ini'
        if(os.path.exists(cPath)):
            return cPath
        
    return None
def getConfig():
    file_path = getConfFilePath() 
    
#    print 'exist-'+str(os.path.exists(file_path))
#    print 'isfile-'+str(os.path.isfile(file_path))
#    print 'os.R_OK-'+str(os.access(file_path, os.R_OK))    
#    print 'pardir-'+str(os.pardir)
#    
#    print 'file path is: %s'%file_path
    if(os.path.exists(file_path) and os.path.isfile(file_path) and os.access(file_path, os.R_OK)):
        confObj = {}
        try:
            confObj["Url"] = configManager.getConfigValue("WebService", "url", file_path)
            confObj["Port"] = configManager.getConfigValue("WebService", "port", file_path)
            confObj["URLConnectionTimeout"] = int(configManager.getConfigValue("WebService", "URLConnectionTimeout", file_path))
            #confObj["ConstructionTimeout"] = float(configManager.getConfigValue("WebService", "ConstructionTimeout", file_path))
            confObj["Retxml"] = typeConverter.str2bool(configManager.getConfigValue("WebService", "retxml", file_path))            
            
            confObj["Debug"] = typeConverter.str2bool(configManager.getConfigValue("System", "debug", file_path))
            confObj["Secured"] = typeConverter.str2bool(configManager.getConfigValue("System", "secured", file_path))
            confObj["argumentProcessingAlgorithm"] = configManager.getConfigValue("System", "argumentProcessingAlgorithm", file_path)
            if(confObj["argumentProcessingAlgorithm"] == None or confObj["argumentProcessingAlgorithm"]==''): 
                confObj["argumentProcessingAlgorithm"] = 'root'
            
            confObj["Color"] = typeConverter.str2bool(configManager.getConfigValue("Console", "color", file_path))
            
            confObj["printArgumentsTypes"] = typeConverter.str2bool(configManager.getConfigValue("Help", "printArgumentsTypes", file_path))
            confObj["showEntitiesAnnotation"] = typeConverter.str2bool(configManager.getConfigValue("Help", "showEntitiesAnnotation", file_path))
            confObj["wrapMethodsHelp"] = typeConverter.str2bool(configManager.getConfigValue("Help", "wrapMethodsHelp", file_path))
                    
        except Exception, e: 
            print e
            tb.print_exc()
        return confObj
    else:
        raise Exceptions.ConfigurationFileNotFound(os.curdir,file_path)