﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon
{
	public static class Cloner
	{
		public static object Clone(object instance)
		{
			if (instance is VM)
			{
				return CloneVM((VM)instance);
			}
			if (instance is VDS)
			{
				return CloneVDS((VDS)instance);
			}
			if (instance is VDSGroup)
			{
				return CloneVDSGroup((VDSGroup)instance);
			}
			if (instance is storage_pool)
			{
				return CloneStorage_pool((storage_pool)instance);
			}
			if (instance is network)
			{
				return CloneNetwork((network)instance);
			}
			if (instance is vm_pools)
			{
				return CloneVmPool((vm_pools)instance);
			}
			if (instance is storage_domain_static)
			{
				return CloneStorageDomainStatic((storage_domain_static)instance);
			}
			if (instance is VmTemplate)
			{
				return CloneVmTemplate((VmTemplate)instance);
			}
			if (instance is VmNetworkInterface)
			{
				return CloneVmNetworkInterface((VmNetworkInterface)instance);
			}
			if (instance is VdsNetworkInterface)
			{
				return CloneVdsNetworkInterface((VdsNetworkInterface)instance);
			}
			if (instance is VmStatic)
			{
				return CloneVmStatic((VmStatic)instance);
			}
			if (instance is Version)
			{
				return CloneVersion((Version)instance);
			}


			//Throw exception to determine development needs.
			throw new NotImplementedException();
		}

		private static object CloneVM(VM instance)
		{
			if (instance == null)
			{
				return null;
			}

			VM vm = new VM();

			vm.acpi_enable = instance.acpi_enable;
			//TODO: this field is read only in serialization - not sure why it is cloned
            //vm.ActualDiskWithSnapshotsSize = instance.ActualDiskWithSnapshotsSize;
			vm.app_list = instance.app_list;
			vm.auto_startup = instance.auto_startup;
			vm.boot_sequence = instance.boot_sequence;
			vm.client_ip = instance.client_ip;
			vm.cpu_per_socket = instance.cpu_per_socket;
			vm.cpu_sys = instance.cpu_sys;
			vm.cpu_user = instance.cpu_user;
			vm.dedicated_vm_for_vds = instance.dedicated_vm_for_vds;
			vm.default_boot_sequence = instance.default_boot_sequence;
			vm.default_display_type = instance.default_display_type;
            //TODO: 1. DiskList is an array - CopyTo should be considered (if it can be converted to java, otherwise a simple loop is needed)
            //TODO: 2. it is also read only in serialization, so not sure why it is cloned. it is manipulated via addDriveToImageMap
			//vm.DiskList = instance.DiskList;
			vm.DiskSize = instance.DiskSize;
            //TODO: this is also an object, so needs to be cloned as well. while it is only accessed via VM.DiskMap, which creates a dictionary 
            // from it - actually the DiskImage's themselves are probably sharing the same reference...
			vm.DiskValueObjectMap = instance.DiskValueObjectMap;
			vm.display = instance.display;
			vm.display_ip = instance.display_ip;
			vm.display_secure_port = instance.display_secure_port;
			vm.display_type = instance.display_type;
            vm.elapsed_time = instance.elapsed_time;
            vm.RoundedElapsedTime = instance.RoundedElapsedTime;
            vm.ExitMessage = instance.ExitMessage;
			vm.ExitStatus = instance.ExitStatus;
			vm.fail_back = instance.fail_back;
			vm.guest_cur_user_id = instance.guest_cur_user_id;
			vm.guest_cur_user_name = instance.guest_cur_user_name;
			vm.guest_last_login_time = instance.guest_last_login_time;
			vm.guest_last_logout_time = instance.guest_last_logout_time;
			vm.guest_os = instance.guest_os;
			vm.guest_requested_memory = instance.guest_requested_memory;
            //TODO: Object, should be "cloned" (probably easiest via new Version(instance.GuestAgentVersion.ToString())
            // pay attention NOT to use lower case version in UICommon code.
			vm.GuestAgentVersion = instance.GuestAgentVersion;
			vm.initrd_url = instance.initrd_url;
            //TODO: array - need to consider cloning of array, and of actual interfaces
			vm.Interfaces = instance.Interfaces;
			vm.is_auto_suspend = instance.is_auto_suspend;
			vm.is_initialized = instance.is_initialized;
			vm.is_stateless = instance.is_stateless;
			vm.iso_path = instance.iso_path;
			vm.kernel_params = instance.kernel_params;
			vm.kernel_url = instance.kernel_url;
			vm.kvm_enable = instance.kvm_enable;
            //TODO: guid/nguid is an object, but code should treat it as immutable, and not change it's uuid directly.
            // (quick skim of code shows this should be safe with current code)
			vm.last_vds_run_on = instance.last_vds_run_on;
			vm.migrating_to_vds = instance.migrating_to_vds;
			vm.MigrationSupport = instance.MigrationSupport;
			vm.nice_level = instance.nice_level;
            //TODO: this is readonly in java, since it is computed.
            // options: use calculation here in cloner, or still wrap this in VM instead of serializing it
			//vm.num_of_cpus = instance.num_of_cpus;
			vm.num_of_monitors = instance.num_of_monitors;
			vm.num_of_sockets = instance.num_of_sockets;
			vm.origin = instance.origin;
			vm.VmPauseStatus = instance.VmPauseStatus;
			vm.priority = instance.priority;
			vm.run_on_vds = instance.run_on_vds;
			vm.run_on_vds_name = instance.run_on_vds_name;
			vm.session = instance.session;
            //TODO: see version comment above
			vm.SpiceDriverVersion = instance.SpiceDriverVersion;
			vm.status = instance.status;
			vm.storage_pool_id = instance.storage_pool_id;
			vm.storage_pool_name = instance.storage_pool_name;
			vm.time_zone = instance.time_zone;
			vm.TransparentHugePages = instance.TransparentHugePages;
			vm.usage_cpu_percent = instance.usage_cpu_percent;
			vm.usage_mem_percent = instance.usage_mem_percent;
			vm.usage_network_percent = instance.usage_network_percent;
			vm.usb_policy = instance.usb_policy;
			vm.utc_diff = instance.utc_diff;
			vm.vds_group_compatibility_version = instance.vds_group_compatibility_version;
			vm.vds_group_id = instance.vds_group_id;
			vm.vds_group_name = instance.vds_group_name;
			vm.vm_creation_date = instance.vm_creation_date;
			vm.vm_description = instance.vm_description;
			vm.vm_domain = instance.vm_domain;
			vm.vm_guid = instance.vm_guid;
			vm.vm_host = instance.vm_host;
			vm.vm_ip = instance.vm_ip;
			vm.vm_last_boot_time = instance.vm_last_boot_time;
			vm.vm_last_up_time = instance.vm_last_up_time;
			vm.vm_mem_size_mb = instance.vm_mem_size_mb;
			vm.vm_name = instance.vm_name;
			vm.vm_os = instance.vm_os;
			vm.vm_pid = instance.vm_pid;
			vm.vm_type = instance.vm_type;
			vm.VmPoolId = instance.VmPoolId;
			vm.VmPoolName = instance.VmPoolName;
			vm.vmt_guid = instance.vmt_guid;
			vm.vmt_name = instance.vmt_name;

			return vm;
		}

		private static object CloneVersion(Version instance)
		{
			return new Version(instance.ToString());
		}

		private static object CloneVDS(VDS instance)
		{
			VDS obj = new VDS();

			obj.host_name = instance.host_name;
			obj.ManagmentIp = instance.ManagmentIp;
			obj.pm_enabled = instance.pm_enabled;
			obj.PmOptionsMap = instance.PmOptionsMap;
			obj.pm_password = instance.pm_password;
			obj.pm_port = instance.pm_port;
			obj.pm_type = instance.pm_type;
			obj.pm_user = instance.pm_user;
			obj.port = instance.port;
			obj.server_SSL_enabled = instance.server_SSL_enabled;
			obj.vds_group_id = instance.vds_group_id;
			obj.vds_id = instance.vds_id;
			obj.vds_name = instance.vds_name;
			obj.vds_strength = instance.vds_strength;
			obj.vds_type = instance.vds_type;
			obj.UniqueId = instance.UniqueId;

			return obj;
		}

		private static storage_pool CloneStorage_pool(storage_pool instance)
		{
			storage_pool obj = new storage_pool();

			obj.description = instance.description;
			obj.Id = instance.Id;
			obj.name = instance.name;
			obj.storage_pool_type = instance.storage_pool_type;
			obj.status = instance.status;

			obj.master_domain_version = instance.master_domain_version;
			obj.LVER = instance.LVER;
			obj.recovery_mode = instance.recovery_mode;
			obj.spm_vds_id = instance.spm_vds_id;
			obj.compatibility_version = instance.compatibility_version;

			return obj;
		}

		private static VDSGroup CloneVDSGroup(VDSGroup instance)
		{
			VDSGroup obj = new VDSGroup();
			obj.ID = instance.ID;
			obj.name = instance.name;
			obj.description = instance.description;
			obj.cpu_name = instance.cpu_name;

			obj.selection_algorithm = instance.selection_algorithm;
			obj.high_utilization = instance.high_utilization;
			obj.low_utilization = instance.low_utilization;
			obj.cpu_over_commit_duration_minutes = instance.cpu_over_commit_duration_minutes;
			obj.hypervisor_type = instance.hypervisor_type;
			obj.compatibility_version = instance.compatibility_version;
			obj.MigrateOnError = instance.MigrateOnError;
			obj.TransparentHugepages = instance.TransparentHugepages;

			obj.storage_pool_id = instance.storage_pool_id;
			obj.max_vds_memory_over_commit = instance.max_vds_memory_over_commit;

			return obj;
		}
		private static network CloneNetwork(network instance)
		{
			network obj = new network();

			obj.addr = instance.addr;
			obj.description = instance.description;
			obj.Id = instance.Id;
			obj.name = instance.name;
			obj.subnet = instance.subnet;
			obj.gateway = instance.gateway;
			obj.type = instance.type;
			obj.vlan_id = instance.vlan_id;
			obj.stp = instance.stp;
			obj.Status = instance.Status;
			obj.storage_pool_id = instance.storage_pool_id;
			obj.is_display = instance.is_display;

			return obj;
		}

		private static vm_pools CloneVmPool(vm_pools instance)
		{
			vm_pools obj = new vm_pools();


			obj.vm_pool_description = instance.vm_pool_description;
			obj.vm_pool_id = instance.vm_pool_id;
			obj.vm_pool_name = instance.vm_pool_name;
			obj.vm_pool_type = instance.vm_pool_type;
			obj.vds_group_id = instance.vds_group_id;

			obj.vm_pool_type = instance.vm_pool_type;
			obj.parameters = instance.parameters;
			obj.DefaultEndTime = instance.DefaultEndTime;
			obj.DefaultStartTime = instance.DefaultStartTime;
			obj.DefaultTimeInDays = instance.DefaultTimeInDays;
			obj.vds_group_name = instance.vds_group_name;
			obj.vm_assigned_count = instance.vm_assigned_count;
			obj.vm_pool_description = instance.vm_pool_description;
			obj.vm_running_count = instance.vm_running_count;

			return obj;
		}

		private static storage_domain_static CloneStorageDomainStatic(storage_domain_static instance)
		{
			storage_domain_static obj = new storage_domain_static();
			obj.Connection = instance.Connection;
			obj.Id = instance.Id;
			obj.storage = instance.storage;
			obj.storage_domain_type = instance.storage_domain_type;
			obj.storage_type = instance.storage_type;
			obj.storage_name = instance.storage_name;
			obj.StorageFormat = instance.StorageFormat;

			return obj;
		}

		private static VmTemplate CloneVmTemplate(VmTemplate instance)
		{
			VmTemplate obj = new VmTemplate();
			obj.storage_pool_id = instance.storage_pool_id;
			obj.storage_pool_name = instance.storage_pool_name;
			obj.default_display_type = instance.default_display_type;
			obj.priority = instance.priority;
			obj.iso_path = instance.iso_path;
			obj.origin = instance.origin;
			obj.SizeGB = instance.SizeGB;
            //TODO: see comments above on DiskImageMap
			obj.DiskImageMap = instance.DiskImageMap;
			obj.Interfaces = instance.Interfaces;
			obj.auto_startup = instance.auto_startup;
			obj.child_count = instance.child_count;
			obj.cpu_per_socket = instance.cpu_per_socket;
			obj.creation_date = instance.creation_date;
			obj.default_boot_sequence = instance.default_boot_sequence;
			obj.description = instance.description;
			obj.domain = instance.domain;
			obj.fail_back = instance.fail_back;
			obj.hypervisor_type = instance.hypervisor_type;
			obj.is_auto_suspend = instance.is_auto_suspend;
			obj.is_stateless = instance.is_stateless;
			obj.mem_size_mb = instance.mem_size_mb;
			obj.name = instance.name;
			obj.nice_level = instance.nice_level;
			obj.num_of_monitors = instance.num_of_monitors;
			obj.num_of_sockets = instance.num_of_sockets;
			obj.operation_mode = instance.operation_mode;
			obj.status = instance.status;
			obj.time_zone = instance.time_zone;
			obj.usb_policy = instance.usb_policy;
			obj.vds_group_id = instance.vds_group_id;
			obj.vds_group_name = instance.vds_group_name;
			obj.vm_type = instance.vm_type;
			obj.Id = instance.Id;

			return obj;
		}

		private static VmStatic CloneVmStatic(VmStatic instance)
		{
			VmStatic obj = new VmStatic();

			obj.fail_back = instance.fail_back;
			obj.default_boot_sequence = instance.default_boot_sequence;
			obj.vm_type = instance.vm_type;
			obj.default_display_type = instance.default_display_type;
			obj.priority = instance.priority;
			obj.iso_path = instance.iso_path;
			obj.origin = instance.origin;
			obj.auto_startup = instance.auto_startup;
			obj.cpu_per_socket = instance.cpu_per_socket;
			obj.creation_date = instance.creation_date;
			obj.dedicated_vm_for_vds = instance.dedicated_vm_for_vds;
			obj.description = instance.description;
			obj.domain = instance.domain;
			obj.is_auto_suspend = instance.is_auto_suspend;
			obj.is_initialized = instance.is_initialized;
			obj.is_stateless = instance.is_stateless;
			obj.mem_size_mb = instance.mem_size_mb;
			obj.DiskSize = instance.DiskSize;
			obj.nice_level = instance.nice_level;
			obj.num_of_monitors = instance.num_of_monitors;
			obj.num_of_sockets = instance.num_of_sockets;
			obj.time_zone = instance.time_zone;
			obj.usb_policy = instance.usb_policy;
			obj.vds_group_id = instance.vds_group_id;
            obj.Id = instance.Id;
			obj.vm_name = instance.vm_name;
			obj.vmt_guid = instance.vmt_guid;

			return obj;
		}

		private static void CloneNetworkStatisticss(NetworkStatistics instance, NetworkStatistics obj)
		{
			obj.Id = instance.Id;
			obj.ReceiveDropRate = instance.ReceiveDropRate;
			obj.ReceiveRate = instance.ReceiveRate;
			obj.TransmitDropRate = instance.TransmitDropRate;
			obj.TransmitRate = instance.TransmitRate;
			obj.Status = instance.Status;
		}

		private static VdsNetworkStatistics CloneVdsNetworkStatistics(VdsNetworkStatistics instance)
		{
			VdsNetworkStatistics obj = new VdsNetworkStatistics();

			CloneNetworkStatisticss(instance, obj);
			obj.VdsId = instance.VdsId;

			return obj;
		}

		private static object CloneVdsNetworkInterface(VdsNetworkInterface vdsNetworkInterface)
		{
			VdsNetworkInterface obj = new VdsNetworkInterface();

			obj.Address = vdsNetworkInterface.Address;
			obj.Bonded = vdsNetworkInterface.Bonded;
			obj.BondName = vdsNetworkInterface.BondName;
			obj.BondOptions = vdsNetworkInterface.BondOptions;
			obj.BondType = vdsNetworkInterface.BondType;
			obj.BootProtocol = vdsNetworkInterface.BootProtocol;
			obj.Gateway = vdsNetworkInterface.Gateway;
			obj.Id = vdsNetworkInterface.Id;
			obj.MacAddress = vdsNetworkInterface.MacAddress;
			obj.Name = vdsNetworkInterface.Name;
			obj.NetworkName = vdsNetworkInterface.NetworkName;
			obj.Speed = vdsNetworkInterface.Speed;
			obj.Statistics = CloneVdsNetworkStatistics((VdsNetworkStatistics)vdsNetworkInterface.Statistics);

			return obj;
		}

		private static VmNetworkStatistics CloneVmNetworkStatistics(VmNetworkStatistics instance)
		{
			VmNetworkStatistics obj = new VmNetworkStatistics();

			CloneNetworkStatisticss(instance, obj);
			obj.VmId = instance.VmId;

			return obj;
		}

		private static object CloneVmNetworkInterface(VmNetworkInterface vmNetworkInterface)
		{
			VmNetworkInterface obj = new VmNetworkInterface();
			obj.Id = vmNetworkInterface.Id;
			obj.MacAddress = vmNetworkInterface.MacAddress;
			obj.Name = vmNetworkInterface.Name;
			obj.NetworkName = vmNetworkInterface.NetworkName;
			obj.Speed = vmNetworkInterface.Speed;
			obj.Type = vmNetworkInterface.Type;
			obj.VmId = vmNetworkInterface.VmId;
			obj.VmName = vmNetworkInterface.VmName;
			obj.VmTemplateId = vmNetworkInterface.VmTemplateId;
			obj.Statistics = CloneVmNetworkStatistics((VmNetworkStatistics)vmNetworkInterface.Statistics);

			return obj;
		}
	}
}
