using System;
using System.Text.RegularExpressions;
using org.ovirt.engine.ui.uicompat;

namespace org.ovirt.engine.ui.uicommon.validation
{
	public class HostAddressValidation : IValidation
	{
		public ValidationResult Validate(object value)
		{
			ValidationResult result = new ValidationResult();

			string val = (string)value;
			if (String.IsNullOrEmpty(val) || !UriValidator.IsValid(val))
			{
				result.Success = false;
				result.Reasons.Add("Address is not a valid host name or IP address.");
			}
			return result;
		}
	}
}