using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Microsoft.Practices.Unity;
using org.ovirt.engine.ui.uicommon;
using org.ovirt.engine.ui.uicommon.models.datacenters;

namespace UI.WPFClient
{
	public partial class DataCenterNetworkListView
	{
		private WindowView view;
		private WindowView view1;

		public new DataCenterNetworkListModel Model
		{
			get { return base.Model as DataCenterNetworkListModel; }
			set { base.Model = value; }
		}


		public DataCenterNetworkListView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName == "Window")
			{
				if (Model.Window != null)
				{
					if (Model.LastExecutedCommand == Model.NewCommand)
					{
						view = TypeResolver.Instance.Resolve<DataCenterNetworkView>();
					}
					else if (Model.LastExecutedCommand == Model.EditCommand)
					{
						view = TypeResolver.Instance.Resolve<DataCenterNetworkView>();
					}
					else if (Model.LastExecutedCommand == Model.RemoveCommand)
					{
						view = TypeResolver.Instance.Resolve<RemoveView>();
					}
					else
					{
						throw new NotImplementedException();
					}

					view.Model = Model.Window;
					WindowManager.AddWindow(view);
				}
				else
				{
					WindowManager.RemoveWindow(view);
					view = null;
				}
			}
			if (e.PropertyName == "ConfirmWindow")
			{
				if (Model.ConfirmWindow != null)
				{
					view1 = TypeResolver.Instance.Resolve<RemoveConfirmationView>();
					WindowManager.AddWindow(view1);
					view1.Model = Model.ConfirmWindow;
				}
				else
				{
					WindowManager.RemoveWindow(view1);
					view1 = null;
				}
			}
		}
	}
}
