'''
Created on May 16, 2010

@author: mpastern@redhat.com
'''
from org.ovirt.engine.ui.sdk.internals.argsWrapper import ArgsWrapper
from org.ovirt.engine.ui.cli.constructors.helpConstructor import HelpConstructor
from org.ovirt.engine.ui.sdk.constructors.brokersConstructor import BrokersConstructor
import org.ovirt.engine.ui.sdk.containers.errorsContainer as Exceptions

class CliInvocator(object):
    '''
    classdocs
    '''
    __client=None
    __args=''

    def __init__(self,client,args):
        '''
        Constructor
        '''
        self.__client = client
        self.__args = args
        
    def Invoke(self):
        return self.__analizeAndInvoke(ArgsWrapper(self.__args,self.__client))
    def InvokeByArgs(self,args={}):
        return self.__analizeAndInvoke(ArgsWrapper(self.__args,self.__client))
    def __analizeAndInvoke(self,aWrapper):
        if(self.__args == None or self.__args == '' or len(self.__args) == 0):
            raise Exceptions.NoArgumentsSpecified()
        else:
            fName,kwargs = aWrapper.wrapAndCollapseArgs()
            if((not fName==None) and fName == 'Help'):
                HelpConstructor(\
                                BrokersConstructor(self.__client).\
                                getContainer(), \
                                True).showUsage(params=kwargs)
            elif(not fName==None):
#TODO: Add support for methods overloads.   
                return self.__client.invokeMethod(fName, **kwargs)     
            else:
                raise Exceptions.MethodNotFound(fName)
