using System;
using System.Collections.Generic;
using System.Text;

namespace SearchBackend
{

    public class BaseAutoCompleter : IAutoCompleter
    {
        protected readonly Dictionary<string, string> mVerbs = new Dictionary<string, string>();
        protected readonly Dictionary<string, List<string>> mVerbCompletion = new Dictionary<string, List<string>>();

        public BaseAutoCompleter()
        {
            
        }

        public BaseAutoCompleter(string text)
        {
            mVerbs.Add(text,text);
            buildCompletions();
        }

        public BaseAutoCompleter(IEnumerable<string> text)
        {
            foreach (string s in text)
            {
                mVerbs.Add(s,s);
            }
            buildCompletions();
        }

        protected void buildCompletions()
        {
            List<string> emptyKeyList = new List<string>();
            foreach (string title in mVerbs.Keys)
            {
                emptyKeyList.Add(changeCaseDisplay(title));
                for (int idx = 1; idx <= title.Length; idx++)
                {
                    string curKey = title.Substring(0, idx);
                    if (!mVerbCompletion.ContainsKey(curKey))
                    {
                        List<string> newList = new List<string>();
                        mVerbCompletion.Add(curKey, newList);
                    }
                    List<string> curList = mVerbCompletion[curKey];
                    curList.Add(changeCaseDisplay(title));
                }
            }
            mVerbCompletion.Add("", emptyKeyList);
            mVerbCompletion.Add(" ", emptyKeyList);
        }

        public string[] getCompletion(string wordPart)
        {
            string[] retval = new string[0];
            if (mVerbCompletion.ContainsKey(wordPart.ToUpper()))
            {
                List<string> curList = mVerbCompletion[wordPart.ToUpper()];
                retval = new string[curList.Count];
                curList.CopyTo(retval);
            }
            return retval;
        }

        public bool validate(string text)
        {
            return mVerbs.ContainsKey(text.ToUpper());
        }

        public bool validateCompletion(string text)
        {
            return mVerbCompletion.ContainsKey(text);
        }

        public virtual string changeCaseDisplay(string text)
        {
			foreach (string s in Enum.GetNames(typeof(DayOfWeek)))
			{
				if (text == s)//days of the begin with capital letter 
				{
					return text;
				}
			}
            return text.ToLower();
        }
    }
}
