using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using System.Windows;
using org.ovirt.engine.ui.uicommon.models.vms;
using VdcCommon;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using System.Collections;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.pools
{
	public class PoolVmListModel : VmListModel
	{
		#region Commands

		public UICommand DetachCommand { get; private set; }

		#endregion

		#region Properties

		public new vm_pools Entity
		{
			get { return (vm_pools)base.Entity; }
			set { base.Entity = value; }
		}

		#endregion


		public PoolVmListModel()
		{
			Title = "Virtual Machines";

			DetachCommand = new UICommand("Detach", this);

			UpdateActionAvailability();
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();
			SearchCommand.Execute();
		}

		public override void Search()
		{
			if (Entity != null)
			{
				SearchString = String.Format("Vms: pool={0}", Entity.vm_pool_name);
				base.Search();
			}
		}
		protected override void EntityPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.EntityPropertyChanged(sender, e);

			if (e.PropertyName == "vm_pool_name")
			{
				SearchCommand.Execute();
			}
		}

		public void Detach()
		{
			if (Window != null)
			{
				return;
			}

			ConfirmationModel model = new ConfirmationModel();
			Window = model;
			model.Title = "Detach Virtual Machine(s)";
			model.HashName = "detach_virtual_machine";
			
			List<string> list = new List<string>();
			foreach (object item in SelectedItems)
			{
				VM a = (VM)item;
				list.Add(a.vm_name);
			}
			list.Sort();
			model.Items = list;

			model.Message = "Are you sure you want to detach selected Virtual Machine(s)?";

			model.Commands.Add(
				new UICommand("OnDetach", this)
				{
					Title = "OK",
					IsDefault = true
				});
			model.Commands.Add(
				new UICommand("Cancel", this)
				{
					Title = "Cancel",
					IsCancel = true
				});
		}

		public void OnDetach()
		{
			ConfirmationModel model = (ConfirmationModel)Window;

			if (model.Progress != null)
			{
				return;
			}

			List<VdcActionParametersBase> list = new List<VdcActionParametersBase>();
			foreach (object item in SelectedItems)
			{
				VM vm = (VM)item;
				list.Add(new RemoveVmFromPoolParameters(vm.vm_guid));
			}


			model.StartProgress(null);

			Frontend.RunMultipleAction(VdcActionType.RemoveVmFromPool, list,
				result =>
				{
					ConfirmationModel localModel = (ConfirmationModel)result.State;

					localModel.StopProgress();
					Cancel();
				},
				model
			);
		}

		protected override void OnSelectedItemChanged()
		{
			base.OnSelectedItemChanged();
			UpdateActionAvailability();
		}

		protected override void SelectedItemsChanged()
		{
			base.SelectedItemsChanged();
			UpdateActionAvailability();
		}

		protected override void SelectedItemPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.SelectedItemPropertyChanged(sender, e);

			switch (e.PropertyName)
			{
				case "status":
					UpdateActionAvailability();
					break;
			}
		}

		private void UpdateActionAvailability()
		{
			//			var items = SelectedItems != null ? SelectedItems.Cast<VM>().ToList() : new List<VM>();
			List<VM> items = SelectedItems != null ? Linq.Cast<VM>(SelectedItems) : new List<VM>();

			//          DetachCommand.IsExecutionAllowed = items.Count > 0 && items.All(a => a.status == VMStatus.Down);
			bool value = true;
			foreach (VM a in items)
			{
				if (a.status != VMStatus.Down)
				{
					value = false;
					break;
				}
			}
			DetachCommand.IsExecutionAllowed = items.Count > 0 && value;
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == DetachCommand)
			{
				Detach();
			}
			if (command.Name == "OnDetach")
			{
				OnDetach();
			}
			if (command.Name == "Cancel")
			{
				Cancel();
			}
		}
	}
}
