using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using org.ovirt.engine.ui.uicompat;
using org.ovirt.engine.ui.uicommon.validation;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public class RunOnceModel : Model
	{
		#region Properties

		public EntityModel AttachFloppy { get; private set; }
		public ListModel FloppyImage { get; private set; }
		public EntityModel AttachIso { get; private set; }
		public ListModel IsoImage { get; private set; }
		public ListModel DisplayProtocol { get; private set; }

		public EntityModel Initrd_path { get; private set; }
		public EntityModel Kernel_path { get; private set; }
		public EntityModel Kernel_parameters { get; private set; }

		public ListModel SysPrepDomainName { get; private set; }
		public EntityModel SysPrepUserName { get; private set; }
		public EntityModel SysPrepPassword { get; private set; }
		public EntityModel UseAlternateCredentials { get; private set; }
		public EntityModel IsSysprepEnabled { get; private set; }
		public EntityModel IsVmFirstRun { get; private set; }

		public EntityModel CustomProperties { get; private set; }

		public EntityModel RunAndPause { get; set; }
		public EntityModel RunAsStateless { get; set; }
		
		public bool IsLinux_Unassign_UnknownOS { get; set; }
		public bool IsWindowsOS { get; set; }
				
		private bool hwAcceleration;
		public bool HwAcceleration
		{
			get { return hwAcceleration; }
			set
			{
				if (hwAcceleration != value)
				{
					hwAcceleration = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HwAcceleration"));
				}
			}
		}
				
		private BootSequenceModel bootSequence;
		public BootSequenceModel BootSequence
		{
			get { return bootSequence; }
			set
			{
				if (bootSequence != value)
				{
					bootSequence = value;
					OnPropertyChanged(new PropertyChangedEventArgs("BootSequence"));
				}
			}
		}

		public bool Reinitialize
		{
			// The "sysprep" option was moved from a standalone check box to a
			// pseudo floppy disk image. In order not to change the back-end
			// interface, the Reinitialize variable was changed to a read-only
			// property and its value is based on the selected floppy image.
			get
			{
				return ((bool)AttachFloppy.Entity && FloppyImage.SelectedItem != null && FloppyImage.SelectedItem.Equals(@"[sysprep]"));
			}
		}

		public string FloppyImagePath
		{
			get
			{
				if ((bool)AttachFloppy.Entity)
				{
					return Reinitialize ? string.Empty : (string)FloppyImage.SelectedItem;
				}
				else
				{
					return string.Empty;
				}
			}
		}

		public List<string> CustomPropertiesKeysList { get; set; }


		#endregion

		public RunOnceModel()
		{
			AttachFloppy = new EntityModel();
			AttachFloppy.EntityChangedEvent.addListener(this);
			FloppyImage = new ListModel();
			FloppyImage.SelectedItemChangedEvent.addListener(this);
			AttachIso = new EntityModel();
			AttachIso.EntityChangedEvent.addListener(this);
			IsoImage = new ListModel();
			DisplayProtocol = new ListModel();
			BootSequence = new BootSequenceModel();

			Kernel_parameters = new EntityModel();
			Kernel_path = new EntityModel();
			Initrd_path = new EntityModel();

			SysPrepDomainName = new ListModel();
			SysPrepUserName = new EntityModel { IsChangable = false };
			SysPrepPassword = new EntityModel { IsChangable = false };

			IsSysprepEnabled = new EntityModel();
			IsVmFirstRun = new EntityModel { Entity = false };
			IsVmFirstRun.EntityChangedEvent.addListener(this);
			UseAlternateCredentials = new EntityModel { Entity = false };
			UseAlternateCredentials.EntityChangedEvent.addListener(this);

			CustomProperties = new EntityModel();

			RunAndPause = new EntityModel { Entity = false };
			RunAsStateless = new EntityModel { Entity = false };
		}

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			base.eventRaised(ev, sender, args);

			if (ev.Equals(ListModel.SelectedItemChangedEventDefinition))
			{
				if (sender == FloppyImage)
				{
					FloppyImage_SelectedItemChanged();
				}
			}
			else if (ev.Equals(EntityModel.EntityChangedEventDefinition))
			{
				if (sender == AttachFloppy)
				{
					AttachFloppy_EntityChanged();
				}
				else if (sender == AttachIso)
				{
					AttachIso_EntityChanged();
				}
				else if (sender == IsVmFirstRun)
				{
					IsVmFirstRun_EntityChanged();
				}
				else if (sender == UseAlternateCredentials)
				{
					UseAlternateCredentials_EntityChanged();
				}
			}
		}

		void AttachIso_EntityChanged()
		{
			IsoImage.IsChangable = (bool)AttachIso.Entity;
			BootSequence.CdromOption.IsChangable = (bool)AttachIso.Entity;
		}

		void AttachFloppy_EntityChanged()
		{
			FloppyImage.IsChangable = (bool)AttachFloppy.Entity;
			UpdateIsSysprepEnabled();
		}
		
		void UseAlternateCredentials_EntityChanged()
		{
			bool useAlternateCredentials = (bool) UseAlternateCredentials.Entity;

			SysPrepUserName.IsChangable = (bool)UseAlternateCredentials.Entity;
			SysPrepPassword.IsChangable = (bool)UseAlternateCredentials.Entity;
			
			SysPrepUserName.Entity = useAlternateCredentials ? String.Empty : null;
			SysPrepPassword.Entity = useAlternateCredentials ? String.Empty : null;
		}

		void IsVmFirstRun_EntityChanged()
		{
			UpdateIsSysprepEnabled();
		}

		void FloppyImage_SelectedItemChanged()
		{
			UpdateIsSysprepEnabled();
		}

		// Sysprep section is displayed only when VM's OS-type is 'Windows' 
		// and [Reinitialize-sysprep == true || IsVmFirstRun == true (IsVmFirstRun == !VM.is_initialized) and no attached floppy] 
		void UpdateIsSysprepEnabled()
		{
			bool isFloppyAttached = (bool) AttachFloppy.Entity;
			bool isVmFirstRun = (bool)IsVmFirstRun.Entity;

			IsSysprepEnabled.Entity = IsWindowsOS && (Reinitialize || (isVmFirstRun && !isFloppyAttached));
		}

		internal bool Validate()
		{
			IsoImage.IsValid = true;
			if ((bool)AttachIso.Entity)
			{
				IsoImage.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });
			}

			FloppyImage.IsValid = true;
			if ((bool)AttachFloppy.Entity)
			{
				FloppyImage.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });
			}

			Kernel_path.IsValid = true;
			Kernel_parameters.IsValid = true;
			Initrd_path.IsValid = true;
			if (Kernel_path.Entity == null)
			{
				Kernel_path.Entity = "";
			}
			if (Kernel_parameters.Entity == null)
			{
				Kernel_parameters.Entity = "";
			}
			if (Initrd_path.Entity == null)
			{
				Initrd_path.Entity = "";
			}

			CustomProperties.ValidateEntity(new IValidation[] { new CustomPropertyValidation(this.CustomPropertiesKeysList) });



			if (IsLinux_Unassign_UnknownOS && ((((string)Kernel_parameters.Entity).Length > 0 || ((string)Initrd_path.Entity).Length > 0) && ((string)Kernel_path.Entity).Length == 0))
			{
				int count = 0;
				string msg = "When ";
				if (((string)Kernel_parameters.Entity).Length > 0)
				{
					Kernel_parameters.IsValid = false;
					msg += "a kernel parameter argument ";
					count++;
				}
				if (((string)Initrd_path.Entity).Length > 0)
				{
					Initrd_path.IsValid = false;
					if (count == 1)
					{
						msg += "or ";
					}
					msg += "an initrd path ";
				}
				msg += "is used, kernel path must be non-empty";

				Kernel_path.IsValid = false;
				Initrd_path.InvalidityReasons.Add(msg);
				Kernel_parameters.InvalidityReasons.Add(msg);
				Kernel_path.InvalidityReasons.Add(msg);
			}

			return IsoImage.IsValid
				   && FloppyImage.IsValid
				   && Kernel_path.IsValid
				   && CustomProperties.IsValid;
		}
	}
}
