// OEM Private API

#ifndef _USB_REDIRECTOR_PRIVATE_API_H_
#define _USB_REDIRECTOR_PRIVATE_API_H_

#ifdef USBRDRAPI_EXPORTS
#define USBRDR_PRIVATE_API __declspec(dllexport)
#else
#define USBRDR_PRIVATE_API __declspec(dllimport)
#endif

#include "oem_private_data.h"

#define total_buf_len		1024
#define GetEstablishData 						0
#define EstablishConnection 					1
#define SetNumberOfAllowedDeviceConnectionsOnServer		3
#define SetNumberOfAllowedDeviceConnectionsOnClient		5

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

typedef struct _tagUsbRdrPrivate {

	unsigned char random_a[random_len_a];
	unsigned char key_offset;
	unsigned char random_b[random_len_b];
	unsigned char step;
	unsigned char random_c[random_len_c];
	unsigned char mul_offset;
	unsigned char random_d[random_len_d];
	unsigned char div_offset;
	
} USBRDRPRIVATE, *PUSBRDRPRIVATE;

USBRDR_PRIVATE_API
BOOL
UsbRedirectorServiceCall(ULONG nCommand, PVOID lpBuffer, ULONG ulcbBuffer);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // _USB_REDIRECTOR_PRIVATE_API_H_
