package staticcheck

import (
	"testing"

	"honnef.co/go/tools/lint/testutil"
)

func TestAll(t *testing.T) {
	checks := []testutil.Analyzer{
		{Analyzer: Analyzers["SA1000"], Tests: []testutil.Test{{Dir: "CheckRegexps"}}},
		{Analyzer: Analyzers["SA1001"], Tests: []testutil.Test{{Dir: "CheckTemplate"}}},
		{Analyzer: Analyzers["SA1002"], Tests: []testutil.Test{{Dir: "CheckTimeParse"}}},
		{Analyzer: Analyzers["SA1003"], Tests: []testutil.Test{{Dir: "CheckEncodingBinary"}, {Dir: "CheckEncodingBinary_go17", Version: "1.7"}, {Dir: "CheckEncodingBinary_go18", Version: "1.8"}}},
		{Analyzer: Analyzers["SA1004"], Tests: []testutil.Test{{Dir: "CheckTimeSleepConstant"}}},
		{Analyzer: Analyzers["SA1005"], Tests: []testutil.Test{{Dir: "CheckExec"}}},
		{Analyzer: Analyzers["SA1006"], Tests: []testutil.Test{{Dir: "CheckUnsafePrintf"}}},
		{Analyzer: Analyzers["SA1007"], Tests: []testutil.Test{{Dir: "CheckURLs"}}},
		{Analyzer: Analyzers["SA1008"], Tests: []testutil.Test{{Dir: "CheckCanonicalHeaderKey"}}},
		{Analyzer: Analyzers["SA1010"], Tests: []testutil.Test{{Dir: "checkStdlibUsageRegexpFindAll"}}},
		{Analyzer: Analyzers["SA1011"], Tests: []testutil.Test{{Dir: "checkStdlibUsageUTF8Cutset"}}},
		{Analyzer: Analyzers["SA1012"], Tests: []testutil.Test{{Dir: "checkStdlibUsageNilContext"}}},
		{Analyzer: Analyzers["SA1013"], Tests: []testutil.Test{{Dir: "checkStdlibUsageSeeker"}}},
		{Analyzer: Analyzers["SA1014"], Tests: []testutil.Test{{Dir: "CheckUnmarshalPointer"}}},
		{Analyzer: Analyzers["SA1015"], Tests: []testutil.Test{{Dir: "CheckLeakyTimeTick"}, {Dir: "CheckLeakyTimeTick-main"}}},
		{Analyzer: Analyzers["SA1016"], Tests: []testutil.Test{{Dir: "CheckUntrappableSignal"}}},
		{Analyzer: Analyzers["SA1017"], Tests: []testutil.Test{{Dir: "CheckUnbufferedSignalChan"}}},
		{Analyzer: Analyzers["SA1018"], Tests: []testutil.Test{{Dir: "CheckStringsReplaceZero"}}},
		{Analyzer: Analyzers["SA1019"], Tests: []testutil.Test{{Dir: "CheckDeprecated"}, {Dir: "CheckDeprecated_go14", Version: "1.4"}, {Dir: "CheckDeprecated_go18", Version: "1.8"}}},
		{Analyzer: Analyzers["SA1020"], Tests: []testutil.Test{{Dir: "CheckListenAddress"}}},
		{Analyzer: Analyzers["SA1021"], Tests: []testutil.Test{{Dir: "CheckBytesEqualIP"}}},
		{Analyzer: Analyzers["SA1023"], Tests: []testutil.Test{{Dir: "CheckWriterBufferModified"}}},
		{Analyzer: Analyzers["SA1024"], Tests: []testutil.Test{{Dir: "CheckNonUniqueCutset"}}},
		{Analyzer: Analyzers["SA1025"], Tests: []testutil.Test{{Dir: "CheckTimerResetReturnValue"}}},
		{Analyzer: Analyzers["SA1026"], Tests: []testutil.Test{{Dir: "CheckUnsupportedMarshal"}}},
		{Analyzer: Analyzers["SA2000"], Tests: []testutil.Test{{Dir: "CheckWaitgroupAdd"}}},
		{Analyzer: Analyzers["SA2001"], Tests: []testutil.Test{{Dir: "CheckEmptyCriticalSection"}}},
		{Analyzer: Analyzers["SA2002"], Tests: []testutil.Test{{Dir: "CheckConcurrentTesting"}}},
		{Analyzer: Analyzers["SA2003"], Tests: []testutil.Test{{Dir: "CheckDeferLock"}}},
		{Analyzer: Analyzers["SA3000"], Tests: []testutil.Test{{Dir: "CheckTestMainExit-1"}, {Dir: "CheckTestMainExit-2"}, {Dir: "CheckTestMainExit-3"}, {Dir: "CheckTestMainExit-4"}, {Dir: "CheckTestMainExit-5"}}},
		{Analyzer: Analyzers["SA3001"], Tests: []testutil.Test{{Dir: "CheckBenchmarkN"}}},
		{Analyzer: Analyzers["SA4000"], Tests: []testutil.Test{{Dir: "CheckLhsRhsIdentical"}}},
		{Analyzer: Analyzers["SA4001"], Tests: []testutil.Test{{Dir: "CheckIneffectiveCopy"}}},
		{Analyzer: Analyzers["SA4002"], Tests: []testutil.Test{{Dir: "CheckDiffSizeComparison"}}},
		{Analyzer: Analyzers["SA4003"], Tests: []testutil.Test{{Dir: "CheckExtremeComparison"}}},
		{Analyzer: Analyzers["SA4004"], Tests: []testutil.Test{{Dir: "CheckIneffectiveLoop"}}},
		{Analyzer: Analyzers["SA4006"], Tests: []testutil.Test{{Dir: "CheckUnreadVariableValues"}}},
		{Analyzer: Analyzers["SA4008"], Tests: []testutil.Test{{Dir: "CheckLoopCondition"}}},
		{Analyzer: Analyzers["SA4009"], Tests: []testutil.Test{{Dir: "CheckArgOverwritten"}}},
		{Analyzer: Analyzers["SA4010"], Tests: []testutil.Test{{Dir: "CheckIneffectiveAppend"}}},
		{Analyzer: Analyzers["SA4011"], Tests: []testutil.Test{{Dir: "CheckScopedBreak"}}},
		{Analyzer: Analyzers["SA4012"], Tests: []testutil.Test{{Dir: "CheckNaNComparison"}}},
		{Analyzer: Analyzers["SA4013"], Tests: []testutil.Test{{Dir: "CheckDoubleNegation"}}},
		{Analyzer: Analyzers["SA4014"], Tests: []testutil.Test{{Dir: "CheckRepeatedIfElse"}}},
		{Analyzer: Analyzers["SA4015"], Tests: []testutil.Test{{Dir: "CheckMathInt"}}},
		{Analyzer: Analyzers["SA4016"], Tests: []testutil.Test{{Dir: "CheckSillyBitwiseOps"}}},
		{Analyzer: Analyzers["SA4017"], Tests: []testutil.Test{{Dir: "CheckPureFunctions"}}},
		{Analyzer: Analyzers["SA4018"], Tests: []testutil.Test{{Dir: "CheckSelfAssignment"}}},
		{Analyzer: Analyzers["SA4019"], Tests: []testutil.Test{{Dir: "CheckDuplicateBuildConstraints"}}},
		{Analyzer: Analyzers["SA4020"], Tests: []testutil.Test{{Dir: "CheckUnreachableTypeCases"}}},
		{Analyzer: Analyzers["SA4021"], Tests: []testutil.Test{{Dir: "CheckSingleArgAppend"}}},
		{Analyzer: Analyzers["SA5000"], Tests: []testutil.Test{{Dir: "CheckNilMaps"}}},
		{Analyzer: Analyzers["SA5001"], Tests: []testutil.Test{{Dir: "CheckEarlyDefer"}}},
		{Analyzer: Analyzers["SA5002"], Tests: []testutil.Test{{Dir: "CheckInfiniteEmptyLoop"}}},
		{Analyzer: Analyzers["SA5003"], Tests: []testutil.Test{{Dir: "CheckDeferInInfiniteLoop"}}},
		{Analyzer: Analyzers["SA5004"], Tests: []testutil.Test{{Dir: "CheckLoopEmptyDefault"}}},
		{Analyzer: Analyzers["SA5005"], Tests: []testutil.Test{{Dir: "CheckCyclicFinalizer"}}},
		{Analyzer: Analyzers["SA5007"], Tests: []testutil.Test{{Dir: "CheckInfiniteRecursion"}}},
		{Analyzer: Analyzers["SA5008"], Tests: []testutil.Test{{Dir: "CheckStructTags"}}},
		{Analyzer: Analyzers["SA5009"], Tests: []testutil.Test{{Dir: "CheckPrintf"}}},
		{Analyzer: Analyzers["SA6000"], Tests: []testutil.Test{{Dir: "CheckRegexpMatchLoop"}}},
		{Analyzer: Analyzers["SA6002"], Tests: []testutil.Test{{Dir: "CheckSyncPoolValue"}}},
		{Analyzer: Analyzers["SA6003"], Tests: []testutil.Test{{Dir: "CheckRangeStringRunes"}}},
		{Analyzer: Analyzers["SA6005"], Tests: []testutil.Test{{Dir: "CheckToLowerToUpperComparison"}}},
		{Analyzer: Analyzers["SA9001"], Tests: []testutil.Test{{Dir: "CheckDubiousDeferInChannelRangeLoop"}}},
		{Analyzer: Analyzers["SA9002"], Tests: []testutil.Test{{Dir: "CheckNonOctalFileMode"}}},
		{Analyzer: Analyzers["SA9003"], Tests: []testutil.Test{{Dir: "CheckEmptyBranch"}}},
		{Analyzer: Analyzers["SA9004"], Tests: []testutil.Test{{Dir: "CheckMissingEnumTypesInDeclaration"}}},
		{Analyzer: Analyzers["SA9005"], Tests: []testutil.Test{{Dir: "CheckNoopMarshal"}}},
	}

	testutil.Run(t, checks)
}
