// Copyright (c) 2017 Uber Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package mocks

import (
	"github.com/stretchr/testify/mock"

	ui "github.com/jaegertracing/jaeger/model/json"
)

// QueryService is an autogenerated mock type for the QueryService type
type QueryService struct {
	mock.Mock
}

// GetTraces provides a mock function with given fields: serviceName, operation, tags
func (_m *QueryService) GetTraces(serviceName string, operation string, tags map[string]string) ([]*ui.Trace, error) {
	ret := _m.Called(serviceName, operation, tags)

	var r0 []*ui.Trace
	if rf, ok := ret.Get(0).(func(string, string, map[string]string) []*ui.Trace); ok {
		r0 = rf(serviceName, operation, tags)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*ui.Trace)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, map[string]string) error); ok {
		r1 = rf(serviceName, operation, tags)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
