// Copyright (c) 2017 Uber Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package mocks

import (
	"github.com/stretchr/testify/mock"
)

// AgentService is an autogenerated mock type for the AgentService type
type AgentService struct {
	mock.Mock
}

// GetSamplingRate provides a mock function with given fields: service, operation
func (_m *AgentService) GetSamplingRate(service string, operation string) (float64, error) {
	ret := _m.Called(service, operation)

	var r0 float64
	if rf, ok := ret.Get(0).(func(string, string) float64); ok {
		r0 = rf(service, operation)
	} else {
		r0 = ret.Get(0).(float64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(service, operation)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
