# CIS-controller

This repo contains the code of the `cis-controller`. This controller keeps track of resources of kind `CisPolicy` and apiVersion `policies.ibm.com/v1alpha1`.

## Quick 2 minutes demo

[![Watch the video](media/demo-screenshot.png)](https://ibm.box.com/s/40r5knshi9ardbnsep7054iulwsd7zkb)

##  CisPolicy CRD

The CIS policy is defined as a K8s CRD. This policy defines what tests should be validated in order to qualify the policy as `passed`

```yaml
apiVersion: policies.ibm.com/v1alpha1
kind: CisPolicy
metadata:
  labels:
    controller-tools.k8s.io: "1.0"
  name: cispolicy-kube-master
spec:
  severity: medium
  kubernetesCisPolicy:
    masterNodeRules:
      "1.1.1 Ensure that the --anonymous-auth argument is set to false": ignore
      "1.1.5 Ensure that the --insecure-bind-address argument is not set": validate
      "1.1.6 Ensure that the --insecure-port argument is set to 0": validate
      "1.1.9 Ensure that the --repair-malformed-updates argument is set to false": validate
      "1.1.10 Ensure that the admission control plugin AlwaysAdmit is not set": validate
      "1.1.11 Ensure that the admission control plugin AlwaysPullImages is set": validate
      "1.1.24 Ensure that the admission control policy is set to PodSecurityPolicy": validate
      "1.4.1 Ensure that the API server pod specification file permissions are set to 644 or more restrictive": validate
      "1.5.5 Ensure that the --peer-client-cert-auth argument is set to true": validate
      "1.5.3 Ensure that the --auto-tls argument is not set to true": validate
```

you can create the sample policy above using:

```bash
kubectl apply -f ./config/samples/cispolicy_k8sMaster.yaml
```

After creating the policy, the controller will automatically add a finalizer, and update the status field with the CIS available results

```bash
kubectl get   cispolicy.policies.ibm.com  cispolicy-kube-master -oyaml
```

The collected results is shown below:

```yaml
apiVersion: policies.ibm.com/v1alpha1
kind: CisPolicy
metadata:
  creationTimestamp: "2019-07-01T22:58:35Z"
  finalizers:
  - finalizer.ciscontroller.k8s.io
  generation: 3
  labels:
    cluster-namespace: managed-cluster
    controller-tools.k8s.io: "1.0"
  name: cispolicy-kube-master
  namespace: default
  resourceVersion: "8932465"
  selfLink: /apis/policies.ibm.com/v1alpha1/namespaces/default/cispolicies/cispolicy-kube-master
  uid: c1c29956-9c53-11e9-af27-005056a0e992
spec:
  kubernetesCisPolicy:
    masterNodeRules:
      1.1.1 Ensure that the --anonymous-auth argument is set to false: ignore
      1.1.5 Ensure that the --insecure-bind-address argument is not set: validate
      1.1.6 Ensure that the --insecure-port argument is set to 0: validate
      1.1.9 Ensure that the --repair-malformed-updates argument is set to false: validate
      1.1.10 Ensure that the admission control plugin AlwaysAdmit is not set: validate
      1.1.11 Ensure that the admission control plugin AlwaysPullImages is set: validate
      1.1.24 Ensure that the admission control policy is set to PodSecurityPolicy: validate
      1.4.1 Ensure that the API server pod specification file permissions are set to 644 or more restrictive: validate
      1.5.3 Ensure that the --auto-tls argument is not set to true: validate
      1.5.5 Ensure that the --peer-client-cert-auth argument is set to true: validate
  severity: medium
status:
  cisPolicyStatus:
    managed-cluster:
      clusterName: managed-cluster
      compliancy: NonCompliant
      masterNodeResults:
        1.1.5 Ensure that the --insecure-bind-address argument is not set: '[PASS]'
        1.1.6 Ensure that the --insecure-port argument is set to 0: '[PASS]'
        1.1.9 Ensure that the --repair-malformed-updates argument is set to false: '[PASS]'
        1.1.10 Ensure that the admission control plugin AlwaysAdmit is not set: '[FAIL]'
        1.1.11 Ensure that the admission control plugin AlwaysPullImages is set: '[PASS]'
        1.1.24 Ensure that the admission control policy is set to PodSecurityPolicy: '[PASS]'
        1.4.1 Ensure that the API server pod specification file permissions are set to 644 or more restrictive: '[PASS]'
        1.5.3 Ensure that the --auto-tls argument is not set to true: '[PASS]'
        1.5.5 Ensure that the --peer-client-cert-auth argument is set to true: '[WARN]'
      riskScore:
        cumulativeRiskScore: 6.8
        highestRiskScore: 6.8
        riskCategory: medium
```

## run

To start the controller you can use:

```bash
make install #once to make sure the CRDs are created
make run
```

## Testing

## tested on

* Go = go1.12.6 darwin/amd64
* Kubernetes = 1.15

## Generic golang tests

```bash
go test ./...
```
