// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

package cosminio

import (
	"bytes"
	"fmt"
	"io/ioutil"
	"reflect"
	"testing"
)

var fileContent = `
1.1.1: 6.4
1.1.2: 6.4
1.1.3: 6.4
1.1.4: 6.4
1.1.5: 6.4
1.1.6: 6.4
1.1.7: 7.5
1.1.8: 6.1
1.1.9: 7.5
1.1.10: 6.8
1.1.11: 3.3
1.1.12: 7.2
1.1.13: 6.4
1.1.14: 7.5
1.1.15: 3
1.1.16: 5.5
1.1.17: 3.6
1.1.18: 3.6
1.1.19: 6.4
1.1.20: 5
1.1.21: 6.4
1.1.22: 6.4
1.1.23: 6.4
1.1.24: 6.4
1.1.25: 6.4
1.1.26: 6.4
1.1.27: 1.7
1.1.28: 6.4
1.1.29: 7.5
1.1.30: 5
1.1.31: 6.4
1.1.32: 6.4
1.1.33: 3.6
1.1.34: 6.4
1.1.35: 3.6
1.1.36: 6.4
1.1.37: 6.4
1.1.38: 5
1.1.39: 6.4
1.2.1: 6.1
1.2.2: 6.4
1.3.1: 5
1.3.2: 6.1
1.3.3: 6.4
1.3.4: 6.4
1.3.5: 10000000 # test point
1.3.6: 6.4
1.3.7: 5
1.4.1: 4.6
1.4.2: 6.4
1.4.3: 4.3
1.4.4: 3.6
1.4.5: 4.3
1.4.6: 3.6
1.4.7: 4.6
1.4.8: 5
1.4.9: 4.6
1.4.10: 6.4
1.4.11: 3.6
1.4.12: 6.4
1.4.13: 7.5
1.4.14: 3.6
1.4.15: 3.6
1.4.16: 3.6
1.4.17: 3.6
1.4.18: 3.6
1.4.19: 2.1
1.4.20: 7.5
1.4.21: 3.6
1.5.1: 6.4
1.5.2: 6.4
1.5.3: 6.4
1.5.4: 6.4
1.5.5: 6.4
1.5.6: 6.4
1.6.1: 6.1
1.6.2: 4.3
1.7.1: 3.6
1.7.2: 3.6
1.7.3: 6.4
1.7.4: 3.6
1.7.5: 4.6
2.1.1: 6.4
2.1.2: 6.4
2.1.3: 6.4
2.1.4: 6.4
2.1.5: 6.4
2.1.6: 3.6
2.1.7: 6.8
2.1.8: 6.4
2.1.9: 3.3
2.1.10: 5
2.1.11: 6.4
2.1.12: 6.4
2.1.13: 7.5
2.1.14: 5
2.2.1: 3.6
2.2.2: 3.6
2.2.3: 6.1
2.2.4: 0
2.2.5: 4.6
2.2.6: 3.6
2.2.7: 4.6
2.2.8: 6.4
2.2.9: 3.6
2.2.10: 33.6 # another test point
`

func TestSetCISRulesScore(t *testing.T) {
	SetCISRulesScore("/some/path", FakeReadFile)
	fmt.Println(CISRulesScore)

	if !reflect.DeepEqual(CISRulesScore["1.3.5"], 1e+07) {
		t.Errorf("unexpeted test result. expecting %v, actual result = %v", 1e+07, CISRulesScore["1.3.5"])
	}

	if !reflect.DeepEqual(CISRulesScore["2.2.10"], 33.6) {
		t.Errorf("unexpeted test result. expecting %v, actual result = %v", 33.6, CISRulesScore["2.2.10"])
	}

}

func FakeReadFile(path string) ([]byte, error) {
	//for testing, path is ignored
	buf := bytes.NewBufferString(fileContent)
	return ioutil.ReadAll(buf)
}
