// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/resources/campaign_budget.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A campaign budget.
type CampaignBudget struct {
	// The resource name of the campaign budget.
	// Campaign budget resource names have the form:
	//
	// `customers/{customer_id}/campaignBudgets/{budget_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the campaign budget.
	//
	// A campaign budget is created using the CampaignBudgetService create
	// operation and is assigned a budget ID. A budget ID can be shared across
	// different campaigns; the system will then allocate the campaign budget
	// among different campaigns to get optimum results.
	Id *wrappers.Int64Value `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the campaign budget.
	//
	// When creating a campaign budget through CampaignBudgetService, every
	// explicitly shared campaign budget must have a non-null, non-empty name.
	// Campaign budgets that are not explicitly shared derive their name from the
	// attached campaign's name.
	//
	// The length of this string must be between 1 and 255, inclusive,
	// in UTF-8 bytes, (trimmed).
	Name *wrappers.StringValue `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The amount of the budget, in the local currency for the account.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit.
	AmountMicros *wrappers.Int64Value `protobuf:"bytes,5,opt,name=amount_micros,json=amountMicros,proto3" json:"amount_micros,omitempty"`
	// The lifetime amount of the budget, in the local currency for the account.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit.
	TotalAmountMicros *wrappers.Int64Value `protobuf:"bytes,10,opt,name=total_amount_micros,json=totalAmountMicros,proto3" json:"total_amount_micros,omitempty"`
	// The status of this campaign budget. This field is read-only.
	Status enums.BudgetStatusEnum_BudgetStatus `protobuf:"varint,6,opt,name=status,proto3,enum=google.ads.googleads.v0.enums.BudgetStatusEnum_BudgetStatus" json:"status,omitempty"`
	// The delivery method that determines the rate at which the campaign budget
	// is spent.
	//
	// Defaults to STANDARD if unspecified in a create operation.
	DeliveryMethod enums.BudgetDeliveryMethodEnum_BudgetDeliveryMethod `protobuf:"varint,7,opt,name=delivery_method,json=deliveryMethod,proto3,enum=google.ads.googleads.v0.enums.BudgetDeliveryMethodEnum_BudgetDeliveryMethod" json:"delivery_method,omitempty"`
	// Specifies whether the budget is explicitly shared. Defaults to true if
	// unspecified in a create operation.
	//
	// If true, the budget was created with the purpose of sharing
	// across one or more campaigns.
	//
	// If false, the budget was created with the intention of only being used
	// with a single campaign. The budget's name and status will stay in sync
	// with the campaign's name and status. Attempting to share the budget with a
	// second campaign will result in an error.
	//
	// A non-shared budget can become an explicitly shared. The same operation
	// must
	// also assign the budget a name.
	//
	// A shared campaign budget can never become non-shared.
	ExplicitlyShared *wrappers.BoolValue `protobuf:"bytes,8,opt,name=explicitly_shared,json=explicitlyShared,proto3" json:"explicitly_shared,omitempty"`
	// The number of campaigns actively using the budget.
	//
	// This field is read-only.
	ReferenceCount *wrappers.Int64Value `protobuf:"bytes,9,opt,name=reference_count,json=referenceCount,proto3" json:"reference_count,omitempty"`
	// Indicates whether there is a recommended budget for this campaign budget.
	//
	// This field is read-only.
	HasRecommendedBudget *wrappers.BoolValue `protobuf:"bytes,11,opt,name=has_recommended_budget,json=hasRecommendedBudget,proto3" json:"has_recommended_budget,omitempty"`
	// The recommended budget amount. If no recommendation is available, this will
	// be set to the budget amount.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit.
	//
	// This field is read-only.
	RecommendedBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,12,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
	// Period over which to spend the budget. Defaults to DAILY if not specified.
	Period enums.BudgetPeriodEnum_BudgetPeriod `protobuf:"varint,13,opt,name=period,proto3,enum=google.ads.googleads.v0.enums.BudgetPeriodEnum_BudgetPeriod" json:"period,omitempty"`
	// The estimated change in weekly clicks if the recommended budget is applied.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyClicks *wrappers.Int64Value `protobuf:"bytes,14,opt,name=recommended_budget_estimated_change_weekly_clicks,json=recommendedBudgetEstimatedChangeWeeklyClicks,proto3" json:"recommended_budget_estimated_change_weekly_clicks,omitempty"`
	// The estimated change in weekly cost in micros if the recommended budget is
	// applied. One million is equivalent to one currency unit.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyCostMicros *wrappers.Int64Value `protobuf:"bytes,15,opt,name=recommended_budget_estimated_change_weekly_cost_micros,json=recommendedBudgetEstimatedChangeWeeklyCostMicros,proto3" json:"recommended_budget_estimated_change_weekly_cost_micros,omitempty"`
	// The estimated change in weekly interactions if the recommended budget is
	// applied.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyInteractions *wrappers.Int64Value `protobuf:"bytes,16,opt,name=recommended_budget_estimated_change_weekly_interactions,json=recommendedBudgetEstimatedChangeWeeklyInteractions,proto3" json:"recommended_budget_estimated_change_weekly_interactions,omitempty"`
	// The estimated change in weekly views if the recommended budget is applied.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyViews *wrappers.Int64Value `protobuf:"bytes,17,opt,name=recommended_budget_estimated_change_weekly_views,json=recommendedBudgetEstimatedChangeWeeklyViews,proto3" json:"recommended_budget_estimated_change_weekly_views,omitempty"`
	XXX_NoUnkeyedLiteral                        struct{}             `json:"-"`
	XXX_unrecognized                            []byte               `json:"-"`
	XXX_sizecache                               int32                `json:"-"`
}

func (m *CampaignBudget) Reset()         { *m = CampaignBudget{} }
func (m *CampaignBudget) String() string { return proto.CompactTextString(m) }
func (*CampaignBudget) ProtoMessage()    {}
func (*CampaignBudget) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_budget_ff71560de998a5e7, []int{0}
}
func (m *CampaignBudget) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CampaignBudget.Unmarshal(m, b)
}
func (m *CampaignBudget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CampaignBudget.Marshal(b, m, deterministic)
}
func (dst *CampaignBudget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CampaignBudget.Merge(dst, src)
}
func (m *CampaignBudget) XXX_Size() int {
	return xxx_messageInfo_CampaignBudget.Size(m)
}
func (m *CampaignBudget) XXX_DiscardUnknown() {
	xxx_messageInfo_CampaignBudget.DiscardUnknown(m)
}

var xxx_messageInfo_CampaignBudget proto.InternalMessageInfo

func (m *CampaignBudget) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *CampaignBudget) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *CampaignBudget) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *CampaignBudget) GetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.AmountMicros
	}
	return nil
}

func (m *CampaignBudget) GetTotalAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TotalAmountMicros
	}
	return nil
}

func (m *CampaignBudget) GetStatus() enums.BudgetStatusEnum_BudgetStatus {
	if m != nil {
		return m.Status
	}
	return enums.BudgetStatusEnum_UNSPECIFIED
}

func (m *CampaignBudget) GetDeliveryMethod() enums.BudgetDeliveryMethodEnum_BudgetDeliveryMethod {
	if m != nil {
		return m.DeliveryMethod
	}
	return enums.BudgetDeliveryMethodEnum_UNSPECIFIED
}

func (m *CampaignBudget) GetExplicitlyShared() *wrappers.BoolValue {
	if m != nil {
		return m.ExplicitlyShared
	}
	return nil
}

func (m *CampaignBudget) GetReferenceCount() *wrappers.Int64Value {
	if m != nil {
		return m.ReferenceCount
	}
	return nil
}

func (m *CampaignBudget) GetHasRecommendedBudget() *wrappers.BoolValue {
	if m != nil {
		return m.HasRecommendedBudget
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetAmountMicros
	}
	return nil
}

func (m *CampaignBudget) GetPeriod() enums.BudgetPeriodEnum_BudgetPeriod {
	if m != nil {
		return m.Period
	}
	return enums.BudgetPeriodEnum_UNSPECIFIED
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyClicks() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyClicks
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyCostMicros
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyInteractions() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyInteractions
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyViews() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyViews
	}
	return nil
}

func init() {
	proto.RegisterType((*CampaignBudget)(nil), "google.ads.googleads.v0.resources.CampaignBudget")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/resources/campaign_budget.proto", fileDescriptor_campaign_budget_ff71560de998a5e7)
}

var fileDescriptor_campaign_budget_ff71560de998a5e7 = []byte{
	// 707 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x95, 0xdd, 0x4e, 0xd4, 0x40,
	0x18, 0x86, 0xd3, 0x05, 0x51, 0x06, 0x58, 0xa0, 0x18, 0xd3, 0xe0, 0x4f, 0x16, 0x0d, 0x09, 0x09,
	0xa6, 0x5b, 0xd0, 0x40, 0x52, 0x3d, 0x70, 0x77, 0x21, 0x04, 0x15, 0xb3, 0x59, 0xcc, 0x9a, 0x98,
	0x4d, 0x9a, 0xa1, 0xf3, 0xd1, 0x9d, 0xd0, 0x76, 0x9a, 0x99, 0xe9, 0x22, 0x67, 0xc6, 0x78, 0x6a,
	0xe2, 0x35, 0x78, 0xe8, 0x35, 0x78, 0x05, 0x5e, 0x8a, 0x57, 0x61, 0x76, 0xfa, 0xc3, 0xfe, 0x88,
	0xdd, 0x3d, 0x9b, 0xce, 0xbc, 0xef, 0x33, 0xef, 0x7c, 0xfd, 0xda, 0x41, 0xfb, 0x1e, 0x63, 0x9e,
	0x0f, 0x55, 0x4c, 0x44, 0x35, 0x19, 0xf6, 0x47, 0x3d, 0xab, 0xca, 0x41, 0xb0, 0x98, 0xbb, 0x20,
	0xaa, 0x2e, 0x0e, 0x22, 0x4c, 0xbd, 0xd0, 0x39, 0x8b, 0x89, 0x07, 0xd2, 0x8c, 0x38, 0x93, 0x4c,
	0xdf, 0x48, 0xd4, 0x26, 0x26, 0xc2, 0xcc, 0x8d, 0x66, 0xcf, 0x32, 0x73, 0xe3, 0xba, 0x7d, 0x13,
	0x1b, 0xc2, 0x38, 0x10, 0xd5, 0x04, 0xe7, 0x10, 0xf0, 0x69, 0x0f, 0xf8, 0x95, 0x13, 0x80, 0xec,
	0x32, 0x92, 0xe0, 0xd7, 0x77, 0x26, 0xf2, 0x46, 0xc0, 0xe9, 0x94, 0x16, 0x21, 0xb1, 0x8c, 0x45,
	0x6a, 0x79, 0x94, 0x5a, 0xd4, 0xd3, 0x59, 0x7c, 0x5e, 0xbd, 0xe4, 0x38, 0x8a, 0x80, 0xa7, 0xeb,
	0x8f, 0x7f, 0x2d, 0xa0, 0x72, 0x23, 0x3d, 0x7e, 0x5d, 0xf9, 0xf5, 0x27, 0x68, 0x29, 0x3b, 0xa1,
	0x13, 0xe2, 0x00, 0x0c, 0xad, 0xa2, 0x6d, 0xcd, 0xb7, 0x16, 0xb3, 0xc9, 0x77, 0x38, 0x00, 0x7d,
	0x1b, 0x95, 0x28, 0x31, 0x66, 0x2a, 0xda, 0xd6, 0xc2, 0xee, 0xfd, 0xb4, 0x3c, 0x66, 0xb6, 0x89,
	0x79, 0x1c, 0xca, 0xbd, 0xe7, 0x6d, 0xec, 0xc7, 0xd0, 0x2a, 0x51, 0xa2, 0x5b, 0x68, 0x56, 0x81,
	0x66, 0x95, 0xfc, 0xc1, 0x98, 0xfc, 0x54, 0x72, 0x1a, 0x7a, 0x89, 0x5e, 0x29, 0xf5, 0x57, 0x68,
	0x09, 0x07, 0x2c, 0x0e, 0xa5, 0x13, 0x50, 0x97, 0x33, 0x61, 0xdc, 0x2a, 0xde, 0x69, 0x31, 0x71,
	0x9c, 0x28, 0x83, 0xfe, 0x06, 0xad, 0x49, 0x26, 0xb1, 0xef, 0x0c, 0x73, 0x50, 0x31, 0x67, 0x55,
	0xf9, 0x6a, 0x83, 0xb0, 0xf7, 0x68, 0x2e, 0xa9, 0xaa, 0x31, 0x57, 0xd1, 0xb6, 0xca, 0xbb, 0x2f,
	0xcd, 0x9b, 0x7a, 0x43, 0xbd, 0x09, 0x33, 0xa9, 0xe4, 0xa9, 0xb2, 0x1c, 0x86, 0x71, 0x30, 0x34,
	0xd1, 0x4a, 0x59, 0x7a, 0x8c, 0x96, 0x47, 0x5a, 0xc3, 0xb8, 0xad, 0xf0, 0x6f, 0x27, 0xc2, 0x1f,
	0xa4, 0xde, 0x13, 0x65, 0x1d, 0xd8, 0x66, 0x78, 0xa1, 0x55, 0x26, 0x43, 0xcf, 0xfa, 0x11, 0x5a,
	0x85, 0x4f, 0x91, 0x4f, 0x5d, 0x2a, 0xfd, 0x2b, 0x47, 0x74, 0x31, 0x07, 0x62, 0xdc, 0x51, 0x75,
	0x59, 0x1f, 0xab, 0x4b, 0x9d, 0x31, 0x3f, 0x29, 0xcb, 0xca, 0xb5, 0xe9, 0x54, 0x79, 0xf4, 0x03,
	0xb4, 0xcc, 0xe1, 0x1c, 0x38, 0x84, 0x2e, 0x38, 0x6e, 0xbf, 0x5c, 0xc6, 0x7c, 0x71, 0x79, 0xcb,
	0xb9, 0xa7, 0xd1, 0xb7, 0xe8, 0x4d, 0x74, 0xaf, 0x8b, 0x85, 0xc3, 0xc1, 0x65, 0x41, 0x00, 0x21,
	0x01, 0x92, 0x7e, 0x86, 0xc6, 0x42, 0x61, 0xa6, 0xbb, 0x5d, 0x2c, 0x5a, 0xd7, 0xc6, 0xb4, 0x81,
	0x09, 0xaa, 0x8c, 0xd3, 0x46, 0xfa, 0x60, 0xb1, 0x38, 0xe8, 0x43, 0x3e, 0x4a, 0x1e, 0xed, 0x89,
	0xe4, 0xe3, 0x34, 0x96, 0xa6, 0xe8, 0x89, 0xa6, 0xb2, 0x0c, 0xbc, 0xac, 0x64, 0xa2, 0x95, 0xb2,
	0xf4, 0xaf, 0x1a, 0xda, 0xf9, 0x47, 0x78, 0x10, 0x92, 0x06, 0x58, 0x02, 0x71, 0xdc, 0x2e, 0x0e,
	0x3d, 0x70, 0x2e, 0x01, 0x2e, 0xfc, 0x2b, 0xc7, 0xf5, 0xa9, 0x7b, 0x21, 0x8c, 0x72, 0xf1, 0x69,
	0x9e, 0x8e, 0x9d, 0xe6, 0x30, 0x63, 0x36, 0x14, 0xf2, 0x83, 0x22, 0x36, 0x14, 0x50, 0xff, 0xa6,
	0xa1, 0xbd, 0x69, 0x62, 0x30, 0x91, 0x57, 0x76, 0xb9, 0x38, 0x8b, 0x35, 0x61, 0x16, 0x26, 0xb2,
	0x62, 0x7f, 0xd7, 0xd0, 0xfe, 0x14, 0x79, 0x68, 0x28, 0x81, 0x63, 0x57, 0x52, 0x16, 0x0a, 0x63,
	0xa5, 0x38, 0xd0, 0xee, 0x64, 0x81, 0x8e, 0x07, 0xb0, 0xfa, 0x17, 0x0d, 0x59, 0x53, 0x44, 0xea,
	0x51, 0xb8, 0x14, 0xc6, 0x6a, 0x71, 0x96, 0xed, 0xc9, 0xb2, 0xb4, 0xfb, 0xbc, 0xfa, 0xe7, 0x12,
	0xda, 0x74, 0x59, 0x60, 0x16, 0x5e, 0x55, 0xf5, 0xb5, 0xe1, 0xbf, 0x7c, 0xb3, 0xbf, 0x73, 0x53,
	0xfb, 0xf8, 0x3a, 0x75, 0x7a, 0xcc, 0xc7, 0xa1, 0x67, 0x32, 0xee, 0x55, 0x3d, 0x08, 0x55, 0xae,
	0xec, 0x8a, 0x89, 0xa8, 0xf8, 0xcf, 0xe5, 0xf9, 0x22, 0x1f, 0xfd, 0x28, 0xcd, 0x1c, 0xd5, 0x6a,
	0x3f, 0x4b, 0x1b, 0x47, 0x09, 0xb2, 0x46, 0x84, 0x99, 0x0c, 0xfb, 0xa3, 0xb6, 0x65, 0xb6, 0x32,
	0xe5, 0xef, 0x4c, 0xd3, 0xa9, 0x11, 0xd1, 0xc9, 0x35, 0x9d, 0xb6, 0xd5, 0xc9, 0x35, 0x7f, 0x4a,
	0x9b, 0xc9, 0x82, 0x6d, 0xd7, 0x88, 0xb0, 0xed, 0x5c, 0x65, 0xdb, 0x6d, 0xcb, 0xb6, 0x73, 0xdd,
	0xd9, 0x9c, 0x0a, 0xfb, 0xec, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x6a, 0xec, 0x75, 0x81, 0xe8,
	0x07, 0x00, 0x00,
}
