// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/services/recommendation_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v0/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import status "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [RecommendationService.GetRecommendation][google.ads.googleads.v0.services.RecommendationService.GetRecommendation].
type GetRecommendationRequest struct {
	// The resource name of the recommendation to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRecommendationRequest) Reset()         { *m = GetRecommendationRequest{} }
func (m *GetRecommendationRequest) String() string { return proto.CompactTextString(m) }
func (*GetRecommendationRequest) ProtoMessage()    {}
func (*GetRecommendationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_service_6d5455a10a27c4cd, []int{0}
}
func (m *GetRecommendationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRecommendationRequest.Unmarshal(m, b)
}
func (m *GetRecommendationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRecommendationRequest.Marshal(b, m, deterministic)
}
func (dst *GetRecommendationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRecommendationRequest.Merge(dst, src)
}
func (m *GetRecommendationRequest) XXX_Size() int {
	return xxx_messageInfo_GetRecommendationRequest.Size(m)
}
func (m *GetRecommendationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRecommendationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRecommendationRequest proto.InternalMessageInfo

func (m *GetRecommendationRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [RecommendationService.ApplyRecommendation][google.ads.googleads.v0.services.RecommendationService.ApplyRecommendation].
type ApplyRecommendationRequest struct {
	// The ID of the customer with the recommendation.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to apply recommendations.
	// If partial_failure=false all recommendations should be of the same type
	// There is a limit of 100 operations per request.
	Operations []*ApplyRecommendationOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, operations will be carried
	// out as a transaction if and only if they are all valid.
	// Default is false.
	PartialFailure       bool     `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplyRecommendationRequest) Reset()         { *m = ApplyRecommendationRequest{} }
func (m *ApplyRecommendationRequest) String() string { return proto.CompactTextString(m) }
func (*ApplyRecommendationRequest) ProtoMessage()    {}
func (*ApplyRecommendationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_service_6d5455a10a27c4cd, []int{1}
}
func (m *ApplyRecommendationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationRequest.Unmarshal(m, b)
}
func (m *ApplyRecommendationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationRequest.Marshal(b, m, deterministic)
}
func (dst *ApplyRecommendationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationRequest.Merge(dst, src)
}
func (m *ApplyRecommendationRequest) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationRequest.Size(m)
}
func (m *ApplyRecommendationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationRequest proto.InternalMessageInfo

func (m *ApplyRecommendationRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *ApplyRecommendationRequest) GetOperations() []*ApplyRecommendationOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ApplyRecommendationRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

// Information about the operation to apply a recommendation and any parameters
// to
// customize it.
type ApplyRecommendationOperation struct {
	// The resource name of the recommendation to apply.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Parameters to use when applying the recommendation.
	//
	// Types that are valid to be assigned to ApplyParameters:
	//	*ApplyRecommendationOperation_CampaignBudget
	//	*ApplyRecommendationOperation_TextAd
	//	*ApplyRecommendationOperation_Keyword
	//	*ApplyRecommendationOperation_TargetCpaOptIn
	ApplyParameters      isApplyRecommendationOperation_ApplyParameters `protobuf_oneof:"apply_parameters"`
	XXX_NoUnkeyedLiteral struct{}                                       `json:"-"`
	XXX_unrecognized     []byte                                         `json:"-"`
	XXX_sizecache        int32                                          `json:"-"`
}

func (m *ApplyRecommendationOperation) Reset()         { *m = ApplyRecommendationOperation{} }
func (m *ApplyRecommendationOperation) String() string { return proto.CompactTextString(m) }
func (*ApplyRecommendationOperation) ProtoMessage()    {}
func (*ApplyRecommendationOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_service_6d5455a10a27c4cd, []int{2}
}
func (m *ApplyRecommendationOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation.Marshal(b, m, deterministic)
}
func (dst *ApplyRecommendationOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation.Merge(dst, src)
}
func (m *ApplyRecommendationOperation) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation.Size(m)
}
func (m *ApplyRecommendationOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation proto.InternalMessageInfo

func (m *ApplyRecommendationOperation) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

type isApplyRecommendationOperation_ApplyParameters interface {
	isApplyRecommendationOperation_ApplyParameters()
}

type ApplyRecommendationOperation_CampaignBudget struct {
	CampaignBudget *ApplyRecommendationOperation_CampaignBudgetParameters `protobuf:"bytes,2,opt,name=campaign_budget,json=campaignBudget,proto3,oneof"`
}

type ApplyRecommendationOperation_TextAd struct {
	TextAd *ApplyRecommendationOperation_TextAdParameters `protobuf:"bytes,3,opt,name=text_ad,json=textAd,proto3,oneof"`
}

type ApplyRecommendationOperation_Keyword struct {
	Keyword *ApplyRecommendationOperation_KeywordParameters `protobuf:"bytes,4,opt,name=keyword,proto3,oneof"`
}

type ApplyRecommendationOperation_TargetCpaOptIn struct {
	TargetCpaOptIn *ApplyRecommendationOperation_TargetCpaOptInParameters `protobuf:"bytes,5,opt,name=target_cpa_opt_in,json=targetCpaOptIn,proto3,oneof"`
}

func (*ApplyRecommendationOperation_CampaignBudget) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_TextAd) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_Keyword) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_TargetCpaOptIn) isApplyRecommendationOperation_ApplyParameters() {}

func (m *ApplyRecommendationOperation) GetApplyParameters() isApplyRecommendationOperation_ApplyParameters {
	if m != nil {
		return m.ApplyParameters
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetCampaignBudget() *ApplyRecommendationOperation_CampaignBudgetParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_CampaignBudget); ok {
		return x.CampaignBudget
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetTextAd() *ApplyRecommendationOperation_TextAdParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_TextAd); ok {
		return x.TextAd
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetKeyword() *ApplyRecommendationOperation_KeywordParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_Keyword); ok {
		return x.Keyword
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetTargetCpaOptIn() *ApplyRecommendationOperation_TargetCpaOptInParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_TargetCpaOptIn); ok {
		return x.TargetCpaOptIn
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ApplyRecommendationOperation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ApplyRecommendationOperation_OneofMarshaler, _ApplyRecommendationOperation_OneofUnmarshaler, _ApplyRecommendationOperation_OneofSizer, []interface{}{
		(*ApplyRecommendationOperation_CampaignBudget)(nil),
		(*ApplyRecommendationOperation_TextAd)(nil),
		(*ApplyRecommendationOperation_Keyword)(nil),
		(*ApplyRecommendationOperation_TargetCpaOptIn)(nil),
	}
}

func _ApplyRecommendationOperation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ApplyRecommendationOperation)
	// apply_parameters
	switch x := m.ApplyParameters.(type) {
	case *ApplyRecommendationOperation_CampaignBudget:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CampaignBudget); err != nil {
			return err
		}
	case *ApplyRecommendationOperation_TextAd:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TextAd); err != nil {
			return err
		}
	case *ApplyRecommendationOperation_Keyword:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Keyword); err != nil {
			return err
		}
	case *ApplyRecommendationOperation_TargetCpaOptIn:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TargetCpaOptIn); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ApplyRecommendationOperation.ApplyParameters has unexpected type %T", x)
	}
	return nil
}

func _ApplyRecommendationOperation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ApplyRecommendationOperation)
	switch tag {
	case 2: // apply_parameters.campaign_budget
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ApplyRecommendationOperation_CampaignBudgetParameters)
		err := b.DecodeMessage(msg)
		m.ApplyParameters = &ApplyRecommendationOperation_CampaignBudget{msg}
		return true, err
	case 3: // apply_parameters.text_ad
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ApplyRecommendationOperation_TextAdParameters)
		err := b.DecodeMessage(msg)
		m.ApplyParameters = &ApplyRecommendationOperation_TextAd{msg}
		return true, err
	case 4: // apply_parameters.keyword
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ApplyRecommendationOperation_KeywordParameters)
		err := b.DecodeMessage(msg)
		m.ApplyParameters = &ApplyRecommendationOperation_Keyword{msg}
		return true, err
	case 5: // apply_parameters.target_cpa_opt_in
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ApplyRecommendationOperation_TargetCpaOptInParameters)
		err := b.DecodeMessage(msg)
		m.ApplyParameters = &ApplyRecommendationOperation_TargetCpaOptIn{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ApplyRecommendationOperation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ApplyRecommendationOperation)
	// apply_parameters
	switch x := m.ApplyParameters.(type) {
	case *ApplyRecommendationOperation_CampaignBudget:
		s := proto.Size(x.CampaignBudget)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ApplyRecommendationOperation_TextAd:
		s := proto.Size(x.TextAd)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ApplyRecommendationOperation_Keyword:
		s := proto.Size(x.Keyword)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ApplyRecommendationOperation_TargetCpaOptIn:
		s := proto.Size(x.TargetCpaOptIn)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Parameters to use when applying a campaign budget recommendation.
type ApplyRecommendationOperation_CampaignBudgetParameters struct {
	// New budget amount to set for target budget resource. This is a required
	// field.
	NewBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=new_budget_amount_micros,json=newBudgetAmountMicros,proto3" json:"new_budget_amount_micros,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}             `json:"-"`
	XXX_unrecognized      []byte               `json:"-"`
	XXX_sizecache         int32                `json:"-"`
}

func (m *ApplyRecommendationOperation_CampaignBudgetParameters) Reset() {
	*m = ApplyRecommendationOperation_CampaignBudgetParameters{}
}
func (m *ApplyRecommendationOperation_CampaignBudgetParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_CampaignBudgetParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_CampaignBudgetParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_service_6d5455a10a27c4cd, []int{2, 0}
}
func (m *ApplyRecommendationOperation_CampaignBudgetParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_CampaignBudgetParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters.Marshal(b, m, deterministic)
}
func (dst *ApplyRecommendationOperation_CampaignBudgetParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters.Merge(dst, src)
}
func (m *ApplyRecommendationOperation_CampaignBudgetParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters.Size(m)
}
func (m *ApplyRecommendationOperation_CampaignBudgetParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_CampaignBudgetParameters) GetNewBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.NewBudgetAmountMicros
	}
	return nil
}

// Parameters to use when applying a text ad recommendation.
type ApplyRecommendationOperation_TextAdParameters struct {
	// New ad to add to recommended ad group. All necessary fields need to be
	// set in this message. This is a required field.
	Ad                   *resources.Ad `protobuf:"bytes,1,opt,name=ad,proto3" json:"ad,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ApplyRecommendationOperation_TextAdParameters) Reset() {
	*m = ApplyRecommendationOperation_TextAdParameters{}
}
func (m *ApplyRecommendationOperation_TextAdParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_TextAdParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_TextAdParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_service_6d5455a10a27c4cd, []int{2, 1}
}
func (m *ApplyRecommendationOperation_TextAdParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_TextAdParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters.Marshal(b, m, deterministic)
}
func (dst *ApplyRecommendationOperation_TextAdParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters.Merge(dst, src)
}
func (m *ApplyRecommendationOperation_TextAdParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters.Size(m)
}
func (m *ApplyRecommendationOperation_TextAdParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_TextAdParameters) GetAd() *resources.Ad {
	if m != nil {
		return m.Ad
	}
	return nil
}

// Parameters to use when applying keyword recommendation.
type ApplyRecommendationOperation_KeywordParameters struct {
	// The ad group resource to add keyword to. This is a required field.
	AdGroup *wrappers.StringValue `protobuf:"bytes,1,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// The match type of the keyword. This is a required field.
	MatchType enums.KeywordMatchTypeEnum_KeywordMatchType `protobuf:"varint,2,opt,name=match_type,json=matchType,proto3,enum=google.ads.googleads.v0.enums.KeywordMatchTypeEnum_KeywordMatchType" json:"match_type,omitempty"`
	// Optional, CPC bid to set for the keyword. If not set, keyword will use
	// bid based on bidding strategy used by target ad group.
	CpcBidMicros         *wrappers.Int64Value `protobuf:"bytes,3,opt,name=cpc_bid_micros,json=cpcBidMicros,proto3" json:"cpc_bid_micros,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ApplyRecommendationOperation_KeywordParameters) Reset() {
	*m = ApplyRecommendationOperation_KeywordParameters{}
}
func (m *ApplyRecommendationOperation_KeywordParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_KeywordParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_KeywordParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_service_6d5455a10a27c4cd, []int{2, 2}
}
func (m *ApplyRecommendationOperation_KeywordParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_KeywordParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters.Marshal(b, m, deterministic)
}
func (dst *ApplyRecommendationOperation_KeywordParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters.Merge(dst, src)
}
func (m *ApplyRecommendationOperation_KeywordParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters.Size(m)
}
func (m *ApplyRecommendationOperation_KeywordParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_KeywordParameters) GetAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *ApplyRecommendationOperation_KeywordParameters) GetMatchType() enums.KeywordMatchTypeEnum_KeywordMatchType {
	if m != nil {
		return m.MatchType
	}
	return enums.KeywordMatchTypeEnum_UNSPECIFIED
}

func (m *ApplyRecommendationOperation_KeywordParameters) GetCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpcBidMicros
	}
	return nil
}

// Parameters to use when applying Target CPA recommendation.
type ApplyRecommendationOperation_TargetCpaOptInParameters struct {
	// Average CPA to use for Target CPA bidding strategy. This is a required
	// field.
	TargetCpaMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=target_cpa_micros,json=targetCpaMicros,proto3" json:"target_cpa_micros,omitempty"`
	// Optional, budget amount to set for the campaign.
	NewCampaignBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=new_campaign_budget_amount_micros,json=newCampaignBudgetAmountMicros,proto3" json:"new_campaign_budget_amount_micros,omitempty"`
	XXX_NoUnkeyedLiteral          struct{}             `json:"-"`
	XXX_unrecognized              []byte               `json:"-"`
	XXX_sizecache                 int32                `json:"-"`
}

func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) Reset() {
	*m = ApplyRecommendationOperation_TargetCpaOptInParameters{}
}
func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_TargetCpaOptInParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_TargetCpaOptInParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_service_6d5455a10a27c4cd, []int{2, 3}
}
func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters.Marshal(b, m, deterministic)
}
func (dst *ApplyRecommendationOperation_TargetCpaOptInParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters.Merge(dst, src)
}
func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters.Size(m)
}
func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) GetTargetCpaMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TargetCpaMicros
	}
	return nil
}

func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) GetNewCampaignBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.NewCampaignBudgetAmountMicros
	}
	return nil
}

// Response message for [RecommendationService.ApplyRecommendation][google.ads.googleads.v0.services.RecommendationService.ApplyRecommendation].
type ApplyRecommendationResponse struct {
	// Results of operations to apply recommendations.
	Results []*ApplyRecommendationResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors)
	// we return the RPC level error.
	PartialFailureError  *status.Status `protobuf:"bytes,2,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ApplyRecommendationResponse) Reset()         { *m = ApplyRecommendationResponse{} }
func (m *ApplyRecommendationResponse) String() string { return proto.CompactTextString(m) }
func (*ApplyRecommendationResponse) ProtoMessage()    {}
func (*ApplyRecommendationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_service_6d5455a10a27c4cd, []int{3}
}
func (m *ApplyRecommendationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationResponse.Unmarshal(m, b)
}
func (m *ApplyRecommendationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationResponse.Marshal(b, m, deterministic)
}
func (dst *ApplyRecommendationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationResponse.Merge(dst, src)
}
func (m *ApplyRecommendationResponse) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationResponse.Size(m)
}
func (m *ApplyRecommendationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationResponse proto.InternalMessageInfo

func (m *ApplyRecommendationResponse) GetResults() []*ApplyRecommendationResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *ApplyRecommendationResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

// The result of applying a recommendation.
type ApplyRecommendationResult struct {
	// Returned for successful applies.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplyRecommendationResult) Reset()         { *m = ApplyRecommendationResult{} }
func (m *ApplyRecommendationResult) String() string { return proto.CompactTextString(m) }
func (*ApplyRecommendationResult) ProtoMessage()    {}
func (*ApplyRecommendationResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_service_6d5455a10a27c4cd, []int{4}
}
func (m *ApplyRecommendationResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationResult.Unmarshal(m, b)
}
func (m *ApplyRecommendationResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationResult.Marshal(b, m, deterministic)
}
func (dst *ApplyRecommendationResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationResult.Merge(dst, src)
}
func (m *ApplyRecommendationResult) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationResult.Size(m)
}
func (m *ApplyRecommendationResult) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationResult.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationResult proto.InternalMessageInfo

func (m *ApplyRecommendationResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [RecommendationService.DismissRecommendation][google.ads.googleads.v0.services.RecommendationService.DismissRecommendation].
type DismissRecommendationRequest struct {
	// The ID of the customer with the recommendation.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to dismiss recommendations.
	// If partial_failure=false all recommendations should be of the same type
	// There is a limit of 100 operations per request.
	Operations []*DismissRecommendationRequest_DismissRecommendationOperation `protobuf:"bytes,3,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, operations will be carried in a
	// single transaction if and only if they are all valid.
	// Default is false.
	PartialFailure       bool     `protobuf:"varint,2,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DismissRecommendationRequest) Reset()         { *m = DismissRecommendationRequest{} }
func (m *DismissRecommendationRequest) String() string { return proto.CompactTextString(m) }
func (*DismissRecommendationRequest) ProtoMessage()    {}
func (*DismissRecommendationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_service_6d5455a10a27c4cd, []int{5}
}
func (m *DismissRecommendationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismissRecommendationRequest.Unmarshal(m, b)
}
func (m *DismissRecommendationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismissRecommendationRequest.Marshal(b, m, deterministic)
}
func (dst *DismissRecommendationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismissRecommendationRequest.Merge(dst, src)
}
func (m *DismissRecommendationRequest) XXX_Size() int {
	return xxx_messageInfo_DismissRecommendationRequest.Size(m)
}
func (m *DismissRecommendationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DismissRecommendationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DismissRecommendationRequest proto.InternalMessageInfo

func (m *DismissRecommendationRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *DismissRecommendationRequest) GetOperations() []*DismissRecommendationRequest_DismissRecommendationOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *DismissRecommendationRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

// Operation to dismiss a single recommendation identified by resource_name.
type DismissRecommendationRequest_DismissRecommendationOperation struct {
	// The resource name of the recommendation to dismiss.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DismissRecommendationRequest_DismissRecommendationOperation) Reset() {
	*m = DismissRecommendationRequest_DismissRecommendationOperation{}
}
func (m *DismissRecommendationRequest_DismissRecommendationOperation) String() string {
	return proto.CompactTextString(m)
}
func (*DismissRecommendationRequest_DismissRecommendationOperation) ProtoMessage() {}
func (*DismissRecommendationRequest_DismissRecommendationOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_service_6d5455a10a27c4cd, []int{5, 0}
}
func (m *DismissRecommendationRequest_DismissRecommendationOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation.Unmarshal(m, b)
}
func (m *DismissRecommendationRequest_DismissRecommendationOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation.Marshal(b, m, deterministic)
}
func (dst *DismissRecommendationRequest_DismissRecommendationOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation.Merge(dst, src)
}
func (m *DismissRecommendationRequest_DismissRecommendationOperation) XXX_Size() int {
	return xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation.Size(m)
}
func (m *DismissRecommendationRequest_DismissRecommendationOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation.DiscardUnknown(m)
}

var xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation proto.InternalMessageInfo

func (m *DismissRecommendationRequest_DismissRecommendationOperation) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Response message for [RecommendationService.DismissRecommendation][google.ads.googleads.v0.services.RecommendationService.DismissRecommendation].
type DismissRecommendationResponse struct {
	// Results of operations to dismiss recommendations.
	Results []*DismissRecommendationResponse_DismissRecommendationResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors)
	// we return the RPC level error.
	PartialFailureError  *status.Status `protobuf:"bytes,2,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *DismissRecommendationResponse) Reset()         { *m = DismissRecommendationResponse{} }
func (m *DismissRecommendationResponse) String() string { return proto.CompactTextString(m) }
func (*DismissRecommendationResponse) ProtoMessage()    {}
func (*DismissRecommendationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_service_6d5455a10a27c4cd, []int{6}
}
func (m *DismissRecommendationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismissRecommendationResponse.Unmarshal(m, b)
}
func (m *DismissRecommendationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismissRecommendationResponse.Marshal(b, m, deterministic)
}
func (dst *DismissRecommendationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismissRecommendationResponse.Merge(dst, src)
}
func (m *DismissRecommendationResponse) XXX_Size() int {
	return xxx_messageInfo_DismissRecommendationResponse.Size(m)
}
func (m *DismissRecommendationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DismissRecommendationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DismissRecommendationResponse proto.InternalMessageInfo

func (m *DismissRecommendationResponse) GetResults() []*DismissRecommendationResponse_DismissRecommendationResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *DismissRecommendationResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

// The result of dismissing a recommendation.
type DismissRecommendationResponse_DismissRecommendationResult struct {
	// Returned for successful dismissals.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DismissRecommendationResponse_DismissRecommendationResult) Reset() {
	*m = DismissRecommendationResponse_DismissRecommendationResult{}
}
func (m *DismissRecommendationResponse_DismissRecommendationResult) String() string {
	return proto.CompactTextString(m)
}
func (*DismissRecommendationResponse_DismissRecommendationResult) ProtoMessage() {}
func (*DismissRecommendationResponse_DismissRecommendationResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_service_6d5455a10a27c4cd, []int{6, 0}
}
func (m *DismissRecommendationResponse_DismissRecommendationResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult.Unmarshal(m, b)
}
func (m *DismissRecommendationResponse_DismissRecommendationResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult.Marshal(b, m, deterministic)
}
func (dst *DismissRecommendationResponse_DismissRecommendationResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult.Merge(dst, src)
}
func (m *DismissRecommendationResponse_DismissRecommendationResult) XXX_Size() int {
	return xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult.Size(m)
}
func (m *DismissRecommendationResponse_DismissRecommendationResult) XXX_DiscardUnknown() {
	xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult.DiscardUnknown(m)
}

var xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult proto.InternalMessageInfo

func (m *DismissRecommendationResponse_DismissRecommendationResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetRecommendationRequest)(nil), "google.ads.googleads.v0.services.GetRecommendationRequest")
	proto.RegisterType((*ApplyRecommendationRequest)(nil), "google.ads.googleads.v0.services.ApplyRecommendationRequest")
	proto.RegisterType((*ApplyRecommendationOperation)(nil), "google.ads.googleads.v0.services.ApplyRecommendationOperation")
	proto.RegisterType((*ApplyRecommendationOperation_CampaignBudgetParameters)(nil), "google.ads.googleads.v0.services.ApplyRecommendationOperation.CampaignBudgetParameters")
	proto.RegisterType((*ApplyRecommendationOperation_TextAdParameters)(nil), "google.ads.googleads.v0.services.ApplyRecommendationOperation.TextAdParameters")
	proto.RegisterType((*ApplyRecommendationOperation_KeywordParameters)(nil), "google.ads.googleads.v0.services.ApplyRecommendationOperation.KeywordParameters")
	proto.RegisterType((*ApplyRecommendationOperation_TargetCpaOptInParameters)(nil), "google.ads.googleads.v0.services.ApplyRecommendationOperation.TargetCpaOptInParameters")
	proto.RegisterType((*ApplyRecommendationResponse)(nil), "google.ads.googleads.v0.services.ApplyRecommendationResponse")
	proto.RegisterType((*ApplyRecommendationResult)(nil), "google.ads.googleads.v0.services.ApplyRecommendationResult")
	proto.RegisterType((*DismissRecommendationRequest)(nil), "google.ads.googleads.v0.services.DismissRecommendationRequest")
	proto.RegisterType((*DismissRecommendationRequest_DismissRecommendationOperation)(nil), "google.ads.googleads.v0.services.DismissRecommendationRequest.DismissRecommendationOperation")
	proto.RegisterType((*DismissRecommendationResponse)(nil), "google.ads.googleads.v0.services.DismissRecommendationResponse")
	proto.RegisterType((*DismissRecommendationResponse_DismissRecommendationResult)(nil), "google.ads.googleads.v0.services.DismissRecommendationResponse.DismissRecommendationResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// RecommendationServiceClient is the client API for RecommendationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RecommendationServiceClient interface {
	// Returns the requested recommendation in full detail.
	GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*resources.Recommendation, error)
	// Applies given recommendations with corresponding apply parameters.
	ApplyRecommendation(ctx context.Context, in *ApplyRecommendationRequest, opts ...grpc.CallOption) (*ApplyRecommendationResponse, error)
	// Dismisses given recommendations.
	DismissRecommendation(ctx context.Context, in *DismissRecommendationRequest, opts ...grpc.CallOption) (*DismissRecommendationResponse, error)
}

type recommendationServiceClient struct {
	cc *grpc.ClientConn
}

func NewRecommendationServiceClient(cc *grpc.ClientConn) RecommendationServiceClient {
	return &recommendationServiceClient{cc}
}

func (c *recommendationServiceClient) GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*resources.Recommendation, error) {
	out := new(resources.Recommendation)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.RecommendationService/GetRecommendation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommendationServiceClient) ApplyRecommendation(ctx context.Context, in *ApplyRecommendationRequest, opts ...grpc.CallOption) (*ApplyRecommendationResponse, error) {
	out := new(ApplyRecommendationResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.RecommendationService/ApplyRecommendation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommendationServiceClient) DismissRecommendation(ctx context.Context, in *DismissRecommendationRequest, opts ...grpc.CallOption) (*DismissRecommendationResponse, error) {
	out := new(DismissRecommendationResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.RecommendationService/DismissRecommendation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RecommendationServiceServer is the server API for RecommendationService service.
type RecommendationServiceServer interface {
	// Returns the requested recommendation in full detail.
	GetRecommendation(context.Context, *GetRecommendationRequest) (*resources.Recommendation, error)
	// Applies given recommendations with corresponding apply parameters.
	ApplyRecommendation(context.Context, *ApplyRecommendationRequest) (*ApplyRecommendationResponse, error)
	// Dismisses given recommendations.
	DismissRecommendation(context.Context, *DismissRecommendationRequest) (*DismissRecommendationResponse, error)
}

func RegisterRecommendationServiceServer(s *grpc.Server, srv RecommendationServiceServer) {
	s.RegisterService(&_RecommendationService_serviceDesc, srv)
}

func _RecommendationService_GetRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommendationServiceServer).GetRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.RecommendationService/GetRecommendation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommendationServiceServer).GetRecommendation(ctx, req.(*GetRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecommendationService_ApplyRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommendationServiceServer).ApplyRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.RecommendationService/ApplyRecommendation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommendationServiceServer).ApplyRecommendation(ctx, req.(*ApplyRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecommendationService_DismissRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DismissRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommendationServiceServer).DismissRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.RecommendationService/DismissRecommendation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommendationServiceServer).DismissRecommendation(ctx, req.(*DismissRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RecommendationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v0.services.RecommendationService",
	HandlerType: (*RecommendationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRecommendation",
			Handler:    _RecommendationService_GetRecommendation_Handler,
		},
		{
			MethodName: "ApplyRecommendation",
			Handler:    _RecommendationService_ApplyRecommendation_Handler,
		},
		{
			MethodName: "DismissRecommendation",
			Handler:    _RecommendationService_DismissRecommendation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v0/services/recommendation_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/services/recommendation_service.proto", fileDescriptor_recommendation_service_6d5455a10a27c4cd)
}

var fileDescriptor_recommendation_service_6d5455a10a27c4cd = []byte{
	// 1088 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0xc1, 0x72, 0xdc, 0x44,
	0x10, 0x45, 0x32, 0x89, 0xe3, 0x71, 0xb0, 0xe3, 0x49, 0xb9, 0x58, 0x64, 0x27, 0x2c, 0x4b, 0x28,
	0x5c, 0x7b, 0x90, 0x9c, 0x35, 0x31, 0xa0, 0x60, 0x27, 0xda, 0xc4, 0x71, 0x5c, 0x54, 0xb0, 0x4b,
	0x36, 0xa6, 0x0a, 0x0c, 0xaa, 0xb1, 0x66, 0x22, 0x04, 0x2b, 0x69, 0x98, 0x19, 0xd9, 0x71, 0xa5,
	0x7c, 0x20, 0xc5, 0x85, 0x33, 0x7f, 0x90, 0x23, 0x07, 0xbe, 0x00, 0x38, 0x72, 0xc8, 0x11, 0x6e,
	0x9c, 0x39, 0x71, 0xe6, 0x03, 0x28, 0x8d, 0x34, 0x1b, 0x6b, 0xbd, 0xf2, 0x2e, 0x36, 0xb9, 0xcd,
	0x4e, 0x77, 0xbf, 0xee, 0xd7, 0xdd, 0xd3, 0xad, 0x05, 0x4b, 0x41, 0x92, 0x04, 0x1d, 0x62, 0x21,
	0xcc, 0xad, 0xfc, 0x98, 0x9d, 0xf6, 0xe6, 0x2d, 0x4e, 0xd8, 0x5e, 0xe8, 0x13, 0x6e, 0x31, 0xe2,
	0x27, 0x51, 0x44, 0x62, 0x8c, 0x44, 0x98, 0xc4, 0x5e, 0x71, 0x6f, 0x52, 0x96, 0x88, 0x04, 0xd6,
	0x73, 0x1b, 0x13, 0x61, 0x6e, 0x76, 0xcd, 0xcd, 0xbd, 0x79, 0x53, 0x99, 0x1b, 0x8b, 0x55, 0x0e,
	0x48, 0x9c, 0x46, 0xdc, 0xfa, 0x9a, 0x1c, 0xec, 0x27, 0x0c, 0x7b, 0x11, 0x12, 0xfe, 0x97, 0x9e,
	0x38, 0xa0, 0x05, 0xb2, 0xd1, 0xac, 0xb2, 0x63, 0x84, 0x27, 0x29, 0xcb, 0x22, 0x43, 0xb8, 0xd0,
	0x5d, 0x1c, 0xac, 0x5b, 0x66, 0x51, 0xd8, 0xcd, 0x2a, 0x3b, 0x1a, 0x5a, 0x28, 0x8e, 0x13, 0x21,
	0x85, 0xbc, 0x90, 0x5e, 0x2d, 0xa4, 0xf2, 0xd7, 0x6e, 0xfa, 0xd0, 0xda, 0x67, 0x88, 0x52, 0xc2,
	0x94, 0xfc, 0xd5, 0x42, 0xce, 0xa8, 0x6f, 0x71, 0x81, 0x44, 0x5a, 0x08, 0x1a, 0xb7, 0x40, 0x6d,
	0x95, 0x08, 0xb7, 0xe4, 0xd1, 0x25, 0xdf, 0xa4, 0x84, 0x0b, 0xf8, 0x26, 0x78, 0x45, 0x05, 0xe5,
	0xc5, 0x28, 0x22, 0x35, 0xad, 0xae, 0xcd, 0x8d, 0xb9, 0x17, 0xd5, 0xe5, 0x47, 0x28, 0x22, 0x8d,
	0xdf, 0x34, 0x60, 0x38, 0x94, 0x76, 0x0e, 0xfa, 0x63, 0xbc, 0x0e, 0xc6, 0xfd, 0x94, 0x8b, 0x24,
	0x22, 0xcc, 0x0b, 0x71, 0x81, 0x00, 0xd4, 0xd5, 0x1a, 0x86, 0x5f, 0x00, 0x90, 0x50, 0xc2, 0x72,
	0x36, 0x35, 0xbd, 0x3e, 0x32, 0x37, 0xde, 0x5a, 0x36, 0x07, 0x95, 0xca, 0xec, 0xe3, 0x72, 0x5d,
	0xc1, 0xb8, 0x47, 0x10, 0xe1, 0xdb, 0x60, 0x92, 0x22, 0x26, 0x42, 0xd4, 0xf1, 0x1e, 0xa2, 0xb0,
	0x93, 0x32, 0x52, 0x1b, 0xa9, 0x6b, 0x73, 0x17, 0xdc, 0x89, 0xe2, 0xfa, 0x5e, 0x7e, 0xdb, 0xf8,
	0x75, 0x0c, 0xcc, 0x9e, 0x84, 0x3a, 0x54, 0x3a, 0xe0, 0x13, 0x0d, 0x4c, 0xfa, 0x28, 0xa2, 0x28,
	0x0c, 0x62, 0x6f, 0x37, 0xc5, 0x01, 0x11, 0x35, 0xbd, 0xae, 0xcd, 0x8d, 0xb7, 0x3e, 0x39, 0x1b,
	0x29, 0xf3, 0x4e, 0x81, 0xda, 0x96, 0xa0, 0x1b, 0x88, 0xa1, 0x88, 0x08, 0xc2, 0xf8, 0xfd, 0x97,
	0xdc, 0x09, 0xbf, 0x24, 0x83, 0x5f, 0x81, 0x51, 0x41, 0x1e, 0x09, 0x0f, 0x61, 0xc9, 0x75, 0xbc,
	0xb5, 0x7e, 0x46, 0xdf, 0x5b, 0xe4, 0x91, 0x70, 0x70, 0xc9, 0xe7, 0x79, 0x21, 0xef, 0x60, 0x07,
	0x8c, 0x16, 0xef, 0xa2, 0xf6, 0xb2, 0xf4, 0xb5, 0x71, 0x46, 0x5f, 0x1f, 0xe6, 0x68, 0x25, 0x67,
	0xca, 0x05, 0xfc, 0x4e, 0x03, 0x53, 0x02, 0xb1, 0x80, 0x08, 0xcf, 0xa7, 0xc8, 0x4b, 0xa8, 0xf0,
	0xc2, 0xb8, 0x76, 0xee, 0x7f, 0x49, 0xf0, 0x96, 0xc4, 0xbd, 0x43, 0xd1, 0x3a, 0x15, 0x6b, 0x71,
	0x39, 0xc1, 0xa2, 0x24, 0x33, 0x28, 0xa8, 0x55, 0x95, 0x03, 0x6e, 0x81, 0x5a, 0x4c, 0xf6, 0x8b,
	0xda, 0x7b, 0x28, 0x4a, 0xd2, 0x58, 0x78, 0x51, 0xe8, 0xb3, 0x84, 0xcb, 0x8e, 0x19, 0x6f, 0xcd,
	0xa8, 0x40, 0xd5, 0x6b, 0x35, 0xd7, 0x62, 0xb1, 0xf8, 0xce, 0x36, 0xea, 0xa4, 0xc4, 0x9d, 0x8e,
	0xc9, 0x7e, 0x8e, 0xe9, 0x48, 0xd3, 0x07, 0xd2, 0xd2, 0x58, 0x03, 0x97, 0x7a, 0x8b, 0x00, 0x6f,
	0x00, 0x1d, 0xe1, 0x02, 0xf3, 0xad, 0x4a, 0xf2, 0xdd, 0xb9, 0x62, 0x3a, 0xd8, 0xd5, 0x11, 0x36,
	0xfe, 0xd1, 0xc0, 0xd4, 0xb1, 0x24, 0xc3, 0x77, 0xc1, 0x05, 0x84, 0xbd, 0x80, 0x25, 0x29, 0x2d,
	0x20, 0x67, 0x8f, 0x85, 0xb9, 0x29, 0x58, 0x18, 0x07, 0x79, 0x9c, 0xa3, 0x08, 0xaf, 0x66, 0xca,
	0xd0, 0x07, 0xe0, 0xf9, 0x40, 0x94, 0xbd, 0x3e, 0xd1, 0xba, 0x5b, 0x19, 0x8d, 0x9c, 0xa4, 0xaa,
	0xc6, 0x0f, 0x32, 0xbb, 0xad, 0x03, 0x4a, 0x56, 0xe2, 0x34, 0x3a, 0x76, 0xe9, 0x8e, 0x45, 0xea,
	0x08, 0x1d, 0x30, 0xe1, 0x53, 0xdf, 0xdb, 0x0d, 0xb1, 0x4a, 0xe5, 0xc8, 0xe0, 0x54, 0x5e, 0xf4,
	0xa9, 0xdf, 0x0e, 0x71, 0x91, 0xc1, 0x67, 0x1a, 0xa8, 0x55, 0x95, 0x18, 0xae, 0x96, 0xda, 0x6a,
	0xf8, 0x6a, 0x4d, 0x76, 0x1b, 0x23, 0xf7, 0x02, 0x09, 0x78, 0x23, 0xab, 0x7e, 0xcf, 0x08, 0xe8,
	0x69, 0x03, 0x7d, 0x30, 0xf0, 0x95, 0x98, 0xec, 0x97, 0x5b, 0xec, 0x68, 0x3b, 0xb4, 0x21, 0xb8,
	0x84, 0xb2, 0x5e, 0xf6, 0x68, 0x97, 0x43, 0xe3, 0x67, 0x0d, 0xcc, 0xf4, 0x9d, 0xc4, 0x9c, 0x26,
	0x31, 0x27, 0xf0, 0x63, 0x30, 0xca, 0x08, 0x4f, 0x3b, 0x22, 0x63, 0x96, 0x8d, 0xd9, 0x9b, 0xa7,
	0x7a, 0x30, 0xae, 0xc4, 0x70, 0x15, 0x16, 0xbc, 0x07, 0xa6, 0x7b, 0x06, 0xac, 0x47, 0x18, 0x4b,
	0x58, 0xc1, 0x12, 0x2a, 0x27, 0x8c, 0xfa, 0xe6, 0xa6, 0x5c, 0x3d, 0xee, 0xe5, 0xf2, 0xe8, 0x5d,
	0xc9, 0xd4, 0x1b, 0xb7, 0xc1, 0x6b, 0x95, 0xde, 0x86, 0x5b, 0x45, 0x3f, 0xe9, 0x60, 0xf6, 0x6e,
	0xc8, 0xa3, 0x90, 0xf3, 0x53, 0x2e, 0xa3, 0xc3, 0xd2, 0x32, 0x1a, 0x91, 0x59, 0xfa, 0x7c, 0x70,
	0x96, 0x4e, 0x72, 0xda, 0x5f, 0x38, 0xf4, 0xae, 0xd2, 0xfb, 0xed, 0x2a, 0x63, 0x05, 0x5c, 0x3d,
	0x19, 0x76, 0xb8, 0x84, 0x3d, 0xd5, 0xc1, 0x95, 0x8a, 0xd8, 0x8b, 0x9e, 0x49, 0x7b, 0x7b, 0xe6,
	0xb3, 0x53, 0x67, 0x23, 0x47, 0xac, 0x94, 0xbe, 0x88, 0x9e, 0x32, 0xda, 0x60, 0xe6, 0x04, 0x7f,
	0x43, 0x25, 0xa9, 0xf5, 0xfd, 0x39, 0x30, 0x5d, 0xb6, 0xde, 0xcc, 0x99, 0xc2, 0x5f, 0x34, 0x30,
	0x75, 0xec, 0xe3, 0x09, 0xda, 0x83, 0x33, 0x54, 0xf5, 0xc5, 0x65, 0x5c, 0x1f, 0x62, 0x8a, 0x97,
	0x2d, 0x1b, 0xef, 0x3f, 0xf9, 0xe3, 0xaf, 0x1f, 0xf4, 0x05, 0x78, 0x3d, 0xfb, 0x86, 0x7c, 0x5c,
	0xa2, 0xb3, 0xa4, 0x3a, 0x9b, 0x5b, 0xcd, 0x9e, 0x8f, 0x4a, 0x6e, 0x35, 0x0f, 0xe1, 0xef, 0x1a,
	0xb8, 0xdc, 0xe7, 0xc9, 0xc1, 0x0f, 0x4e, 0x39, 0x17, 0x72, 0x0e, 0x4b, 0xa7, 0x9d, 0x2a, 0xb2,
	0x3f, 0x1a, 0xcb, 0x92, 0xcf, 0x7b, 0x8d, 0x85, 0x8c, 0xcf, 0x73, 0x02, 0x8f, 0x8f, 0x3c, 0xdc,
	0xa5, 0xe6, 0x61, 0x2f, 0x1d, 0x5b, 0x4e, 0x43, 0x5b, 0x6b, 0xc2, 0x3f, 0x35, 0x30, 0xdd, 0xb7,
	0xe6, 0x70, 0xf9, 0x6c, 0x0f, 0xd9, 0xb8, 0x75, 0xc6, 0xd6, 0x6f, 0xdc, 0x96, 0xd4, 0xec, 0xc6,
	0x8d, 0xff, 0x46, 0x0d, 0xe7, 0xa0, 0xb6, 0xd6, 0x6c, 0x7f, 0xab, 0x83, 0x6b, 0x7e, 0x12, 0x0d,
	0x0c, 0xa4, 0x6d, 0xf4, 0xed, 0xd8, 0x8d, 0x6c, 0xd1, 0x6c, 0x68, 0x9f, 0xde, 0x2f, 0xec, 0x83,
	0xa4, 0x83, 0xe2, 0xc0, 0x4c, 0x58, 0x60, 0x05, 0x24, 0x96, 0x6b, 0x48, 0xfd, 0x27, 0xa1, 0x21,
	0xaf, 0xfe, 0x9f, 0x75, 0x53, 0x1d, 0x9e, 0xea, 0x23, 0xab, 0x8e, 0xf3, 0xa3, 0x5e, 0x5f, 0xcd,
	0x01, 0x1d, 0xcc, 0xcd, 0xfc, 0x98, 0x9d, 0xb6, 0xe7, 0xcd, 0xc2, 0x31, 0x7f, 0xa6, 0x54, 0x76,
	0x1c, 0xcc, 0x77, 0xba, 0x2a, 0x3b, 0xdb, 0xf3, 0x3b, 0x4a, 0xe5, 0x6f, 0xfd, 0x5a, 0x7e, 0x6f,
	0xdb, 0x0e, 0xe6, 0xb6, 0xdd, 0x55, 0xb2, 0xed, 0xed, 0x79, 0xdb, 0x56, 0x6a, 0xbb, 0xe7, 0x65,
	0x9c, 0x0b, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x50, 0x57, 0x8d, 0x8c, 0x0e, 0x0e, 0x00, 0x00,
}
