// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/company.proto

package talent // import "google.golang.org/genproto/googleapis/cloud/talent/v4beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Enum that represents how user data owned by the company is used.
type Company_DataLearningType int32

const (
	// Default value.
	Company_DATA_LEARNING_TYPE_UNSPECIFIED Company_DataLearningType = 0
	// Data owned by this company is used to improve search/recommendation
	// quality across companies.
	Company_AGGREGATED Company_DataLearningType = 1
	// Data owned by this company is used to improve search/recommendation
	// quality for this company only.
	Company_ISOLATED Company_DataLearningType = 2
)

var Company_DataLearningType_name = map[int32]string{
	0: "DATA_LEARNING_TYPE_UNSPECIFIED",
	1: "AGGREGATED",
	2: "ISOLATED",
}
var Company_DataLearningType_value = map[string]int32{
	"DATA_LEARNING_TYPE_UNSPECIFIED": 0,
	"AGGREGATED":                     1,
	"ISOLATED":                       2,
}

func (x Company_DataLearningType) String() string {
	return proto.EnumName(Company_DataLearningType_name, int32(x))
}
func (Company_DataLearningType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_company_dbd4fb882d58cdba, []int{0, 0}
}

// A Company resource represents a company in the service. A company is the
// entity that owns job postings, that is, the hiring entity responsible for
// employing applicants for the job position.
type Company struct {
	// Required during company update.
	//
	// The resource name for a company. This is generated by the service when a
	// company is created.
	//
	// The format is "projects/{project_id}/companies/{company_id}", for example,
	// "projects/api-test-project/companies/foo".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required.
	//
	// The display name of the company, for example, "Google, LLC".
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required.
	//
	// Client side company identifier, used to uniquely identify the
	// company.
	//
	// The maximum number of allowed characters is 255.
	ExternalId string `protobuf:"bytes,3,opt,name=external_id,json=externalId,proto3" json:"external_id,omitempty"`
	// Optional.
	//
	// The employer's company size.
	Size CompanySize `protobuf:"varint,4,opt,name=size,proto3,enum=google.cloud.talent.v4beta1.CompanySize" json:"size,omitempty"`
	// Optional.
	//
	// The street address of the company's main headquarters, which may be
	// different from the job location. The service attempts
	// to geolocate the provided address, and populates a more specific
	// location wherever possible in [DerivedInfo.headquarters_location][google.cloud.talent.v4beta1.Company.DerivedInfo.headquarters_location].
	HeadquartersAddress string `protobuf:"bytes,5,opt,name=headquarters_address,json=headquartersAddress,proto3" json:"headquarters_address,omitempty"`
	// Optional.
	//
	// Set to true if it is the hiring agency that post jobs for other
	// employers.
	//
	// Defaults to false if not provided.
	HiringAgency bool `protobuf:"varint,6,opt,name=hiring_agency,json=hiringAgency,proto3" json:"hiring_agency,omitempty"`
	// Optional.
	//
	// Equal Employment Opportunity legal disclaimer text to be
	// associated with all jobs, and typically to be displayed in all
	// roles.
	//
	// The maximum number of allowed characters is 500.
	EeoText string `protobuf:"bytes,7,opt,name=eeo_text,json=eeoText,proto3" json:"eeo_text,omitempty"`
	// Optional.
	//
	// The URI representing the company's primary web site or home page,
	// for example, "https://www.google.com".
	//
	// The maximum number of allowed characters is 255.
	WebsiteUri string `protobuf:"bytes,8,opt,name=website_uri,json=websiteUri,proto3" json:"website_uri,omitempty"`
	// Optional.
	//
	// The URI to employer's career site or careers page on the employer's web
	// site, for example, "https://careers.google.com".
	CareerSiteUri string `protobuf:"bytes,9,opt,name=career_site_uri,json=careerSiteUri,proto3" json:"career_site_uri,omitempty"`
	// Optional.
	//
	// A URI that hosts the employer's company logo.
	ImageUri string `protobuf:"bytes,10,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	// Optional.
	//
	// A list of keys of filterable [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes], whose
	// corresponding `string_values` are used in keyword search. Jobs with
	// `string_values` under these specified field keys are returned if any
	// of the values matches the search keyword. Custom field values with
	// parenthesis, brackets and special symbols won't be properly searchable,
	// and those keyword queries need to be surrounded by quotes.
	KeywordSearchableJobCustomAttributes []string `protobuf:"bytes,11,rep,name=keyword_searchable_job_custom_attributes,json=keywordSearchableJobCustomAttributes,proto3" json:"keyword_searchable_job_custom_attributes,omitempty"`
	// Output only. Derived details about the company.
	DerivedInfo *Company_DerivedInfo `protobuf:"bytes,12,opt,name=derived_info,json=derivedInfo,proto3" json:"derived_info,omitempty"`
	// Output only. Indicates whether a company is flagged to be suspended from
	// public availability by the service when job content appears suspicious,
	// abusive, or spammy.
	Suspended bool `protobuf:"varint,13,opt,name=suspended,proto3" json:"suspended,omitempty"`
	// Optional.
	//
	// Indicates whether data owned by this company may be used to provide product
	// improvements across other companies.
	//
	// Defaults behavior is [DataLearningType.ISOLATED][google.cloud.talent.v4beta1.Company.DataLearningType.ISOLATED] if it's unset.
	LearningType         Company_DataLearningType `protobuf:"varint,14,opt,name=learning_type,json=learningType,proto3,enum=google.cloud.talent.v4beta1.Company_DataLearningType" json:"learning_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Company) Reset()         { *m = Company{} }
func (m *Company) String() string { return proto.CompactTextString(m) }
func (*Company) ProtoMessage()    {}
func (*Company) Descriptor() ([]byte, []int) {
	return fileDescriptor_company_dbd4fb882d58cdba, []int{0}
}
func (m *Company) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Company.Unmarshal(m, b)
}
func (m *Company) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Company.Marshal(b, m, deterministic)
}
func (dst *Company) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Company.Merge(dst, src)
}
func (m *Company) XXX_Size() int {
	return xxx_messageInfo_Company.Size(m)
}
func (m *Company) XXX_DiscardUnknown() {
	xxx_messageInfo_Company.DiscardUnknown(m)
}

var xxx_messageInfo_Company proto.InternalMessageInfo

func (m *Company) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Company) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Company) GetExternalId() string {
	if m != nil {
		return m.ExternalId
	}
	return ""
}

func (m *Company) GetSize() CompanySize {
	if m != nil {
		return m.Size
	}
	return CompanySize_COMPANY_SIZE_UNSPECIFIED
}

func (m *Company) GetHeadquartersAddress() string {
	if m != nil {
		return m.HeadquartersAddress
	}
	return ""
}

func (m *Company) GetHiringAgency() bool {
	if m != nil {
		return m.HiringAgency
	}
	return false
}

func (m *Company) GetEeoText() string {
	if m != nil {
		return m.EeoText
	}
	return ""
}

func (m *Company) GetWebsiteUri() string {
	if m != nil {
		return m.WebsiteUri
	}
	return ""
}

func (m *Company) GetCareerSiteUri() string {
	if m != nil {
		return m.CareerSiteUri
	}
	return ""
}

func (m *Company) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

func (m *Company) GetKeywordSearchableJobCustomAttributes() []string {
	if m != nil {
		return m.KeywordSearchableJobCustomAttributes
	}
	return nil
}

func (m *Company) GetDerivedInfo() *Company_DerivedInfo {
	if m != nil {
		return m.DerivedInfo
	}
	return nil
}

func (m *Company) GetSuspended() bool {
	if m != nil {
		return m.Suspended
	}
	return false
}

func (m *Company) GetLearningType() Company_DataLearningType {
	if m != nil {
		return m.LearningType
	}
	return Company_DATA_LEARNING_TYPE_UNSPECIFIED
}

// Derived details about the company.
type Company_DerivedInfo struct {
	// A structured headquarters location of the company, resolved from
	// [Company.hq_location][] if provided.
	HeadquartersLocation *Location `protobuf:"bytes,1,opt,name=headquarters_location,json=headquartersLocation,proto3" json:"headquarters_location,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Company_DerivedInfo) Reset()         { *m = Company_DerivedInfo{} }
func (m *Company_DerivedInfo) String() string { return proto.CompactTextString(m) }
func (*Company_DerivedInfo) ProtoMessage()    {}
func (*Company_DerivedInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_company_dbd4fb882d58cdba, []int{0, 0}
}
func (m *Company_DerivedInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Company_DerivedInfo.Unmarshal(m, b)
}
func (m *Company_DerivedInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Company_DerivedInfo.Marshal(b, m, deterministic)
}
func (dst *Company_DerivedInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Company_DerivedInfo.Merge(dst, src)
}
func (m *Company_DerivedInfo) XXX_Size() int {
	return xxx_messageInfo_Company_DerivedInfo.Size(m)
}
func (m *Company_DerivedInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Company_DerivedInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Company_DerivedInfo proto.InternalMessageInfo

func (m *Company_DerivedInfo) GetHeadquartersLocation() *Location {
	if m != nil {
		return m.HeadquartersLocation
	}
	return nil
}

func init() {
	proto.RegisterType((*Company)(nil), "google.cloud.talent.v4beta1.Company")
	proto.RegisterType((*Company_DerivedInfo)(nil), "google.cloud.talent.v4beta1.Company.DerivedInfo")
	proto.RegisterEnum("google.cloud.talent.v4beta1.Company_DataLearningType", Company_DataLearningType_name, Company_DataLearningType_value)
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/company.proto", fileDescriptor_company_dbd4fb882d58cdba)
}

var fileDescriptor_company_dbd4fb882d58cdba = []byte{
	// 623 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x93, 0xdd, 0x6e, 0xd3, 0x30,
	0x14, 0xc7, 0xc9, 0x36, 0xb6, 0xd6, 0x6d, 0xc7, 0x64, 0x86, 0x14, 0xb6, 0x89, 0x95, 0xf1, 0xa1,
	0x70, 0x93, 0xb2, 0x01, 0x57, 0x70, 0x93, 0xb5, 0xa5, 0x2a, 0xaa, 0x4a, 0x95, 0x64, 0x48, 0xec,
	0xc6, 0x72, 0x92, 0xb3, 0xcc, 0x90, 0xda, 0xc1, 0x76, 0xb6, 0x75, 0x97, 0x3c, 0x0a, 0x4f, 0xc6,
	0xa3, 0xa0, 0x3a, 0xd9, 0x17, 0x42, 0x63, 0x77, 0x39, 0xff, 0xf3, 0xfb, 0xfb, 0x1c, 0x9f, 0x1c,
	0xa3, 0x57, 0xa9, 0x10, 0x69, 0x06, 0x9d, 0x38, 0x13, 0x45, 0xd2, 0xd1, 0x34, 0x03, 0xae, 0x3b,
	0x27, 0x6f, 0x23, 0xd0, 0x74, 0xb7, 0x13, 0x8b, 0x69, 0x4e, 0xf9, 0xcc, 0xcd, 0xa5, 0xd0, 0x02,
	0x6f, 0x96, 0xa8, 0x6b, 0x50, 0xb7, 0x44, 0xdd, 0x0a, 0xdd, 0xd8, 0xaa, 0xce, 0xa1, 0x39, 0xeb,
	0x50, 0xce, 0x85, 0xa6, 0x9a, 0x09, 0xae, 0x4a, 0xeb, 0x86, 0xf3, 0x9f, 0x2a, 0x53, 0xc1, 0x4b,
	0x72, 0xe7, 0xf7, 0x32, 0x5a, 0xe9, 0x96, 0x65, 0x31, 0x46, 0x4b, 0x9c, 0x4e, 0xc1, 0xb6, 0xda,
	0x96, 0x53, 0xf7, 0xcd, 0x37, 0x7e, 0x8a, 0x9a, 0x09, 0x53, 0x79, 0x46, 0x67, 0xc4, 0xe4, 0x16,
	0x4c, 0xae, 0x51, 0x69, 0xe3, 0x39, 0xb2, 0x8d, 0x1a, 0x70, 0xa6, 0x41, 0x72, 0x9a, 0x11, 0x96,
	0xd8, 0x8b, 0x86, 0x40, 0x17, 0xd2, 0x30, 0xc1, 0x1f, 0xd0, 0x92, 0x62, 0xe7, 0x60, 0x2f, 0xb5,
	0x2d, 0x67, 0x75, 0xcf, 0x71, 0x6f, 0xb9, 0x97, 0x5b, 0xf5, 0x12, 0xb0, 0x73, 0xf0, 0x8d, 0x0b,
	0xef, 0xa2, 0xf5, 0x63, 0xa0, 0xc9, 0x8f, 0x82, 0x4a, 0x0d, 0x52, 0x11, 0x9a, 0x24, 0x12, 0x94,
	0xb2, 0xef, 0x9b, 0x3a, 0x0f, 0xaf, 0xe7, 0xbc, 0x32, 0x85, 0x9f, 0xa1, 0xd6, 0x31, 0x93, 0x8c,
	0xa7, 0x84, 0xa6, 0xc0, 0xe3, 0x99, 0xbd, 0xdc, 0xb6, 0x9c, 0x9a, 0xdf, 0x2c, 0x45, 0xcf, 0x68,
	0xf8, 0x31, 0xaa, 0x01, 0x08, 0xa2, 0xe1, 0x4c, 0xdb, 0x2b, 0xe6, 0xac, 0x15, 0x00, 0x11, 0xc2,
	0x99, 0x9e, 0xdf, 0xe8, 0x14, 0x22, 0xc5, 0x34, 0x90, 0x42, 0x32, 0xbb, 0x56, 0xde, 0xa8, 0x92,
	0x0e, 0x24, 0xc3, 0x2f, 0xd1, 0x83, 0x98, 0x4a, 0x00, 0x49, 0x2e, 0xa1, 0xba, 0x81, 0x5a, 0xa5,
	0x1c, 0x54, 0xdc, 0x26, 0xaa, 0xb3, 0x29, 0x4d, 0x4b, 0x02, 0x19, 0xa2, 0x66, 0x84, 0x79, 0xf2,
	0x0b, 0x72, 0xbe, 0xc3, 0xec, 0x54, 0xc8, 0x84, 0x28, 0xa0, 0x32, 0x3e, 0xa6, 0x51, 0x06, 0xe4,
	0x9b, 0x88, 0x48, 0x5c, 0x28, 0x2d, 0xa6, 0x84, 0x6a, 0x2d, 0x59, 0x54, 0x68, 0x50, 0x76, 0xa3,
	0xbd, 0xe8, 0xd4, 0xfd, 0xe7, 0x15, 0x1f, 0x5c, 0xe2, 0x9f, 0x44, 0xd4, 0x35, 0xb0, 0x77, 0xc9,
	0xe2, 0x00, 0x35, 0x13, 0x90, 0xec, 0x04, 0x12, 0xc2, 0xf8, 0x91, 0xb0, 0x9b, 0x6d, 0xcb, 0x69,
	0xec, 0xbd, 0xbe, 0xcb, 0xd8, 0xdd, 0x5e, 0x69, 0x1c, 0xf2, 0x23, 0xe1, 0x37, 0x92, 0xab, 0x00,
	0x6f, 0xa1, 0xba, 0x2a, 0x54, 0x0e, 0x3c, 0x81, 0xc4, 0x6e, 0x99, 0x71, 0x5e, 0x09, 0xf8, 0x10,
	0xb5, 0x32, 0xa0, 0x92, 0xcf, 0x47, 0xae, 0x67, 0x39, 0xd8, 0xab, 0xe6, 0x57, 0xbf, 0xbb, 0x5b,
	0x4d, 0xaa, 0xe9, 0xa8, 0x72, 0x87, 0xb3, 0x1c, 0xfc, 0x66, 0x76, 0x2d, 0xda, 0x60, 0xa8, 0x71,
	0xad, 0x2b, 0x7c, 0x88, 0x1e, 0xdd, 0x58, 0x87, 0x4c, 0xc4, 0x66, 0xf5, 0xcd, 0xd6, 0x36, 0xf6,
	0x5e, 0xdc, 0x5a, 0x72, 0x54, 0xc1, 0xfe, 0x8d, 0x95, 0xba, 0x50, 0x77, 0x42, 0xb4, 0xf6, 0x77,
	0x33, 0x78, 0x07, 0x3d, 0xe9, 0x79, 0xa1, 0x47, 0x46, 0x7d, 0xcf, 0x1f, 0x0f, 0xc7, 0x03, 0x12,
	0x7e, 0x9d, 0xf4, 0xc9, 0xc1, 0x38, 0x98, 0xf4, 0xbb, 0xc3, 0x8f, 0xc3, 0x7e, 0x6f, 0xed, 0x1e,
	0x5e, 0x45, 0xc8, 0x1b, 0x0c, 0xfc, 0xfe, 0xc0, 0x0b, 0xfb, 0xbd, 0x35, 0x0b, 0x37, 0x51, 0x6d,
	0x18, 0x7c, 0x1e, 0x99, 0x68, 0x61, 0xff, 0xa7, 0x85, 0xb6, 0x63, 0x31, 0xbd, 0xad, 0xb1, 0xfd,
	0xf5, 0x6a, 0x18, 0x3e, 0x28, 0x51, 0xc8, 0x18, 0x26, 0xf3, 0xc7, 0x39, 0xb1, 0x0e, 0xbd, 0xca,
	0x94, 0x8a, 0x8c, 0xf2, 0xd4, 0x15, 0x32, 0xed, 0xa4, 0xc0, 0xcd, 0xd3, 0xed, 0x94, 0x29, 0x9a,
	0x33, 0xf5, 0xcf, 0x77, 0xfe, 0xbe, 0x0c, 0x7f, 0x2d, 0x2c, 0x76, 0xc3, 0x20, 0x5a, 0x36, 0x9e,
	0x37, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x27, 0xc2, 0xa8, 0x56, 0x80, 0x04, 0x00, 0x00,
}
