package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeKubernetesTemplate invokes the cs.DescribeKubernetesTemplate API synchronously
// api document: https://help.aliyun.com/api/cs/describekubernetestemplate.html
func (client *Client) DescribeKubernetesTemplate(request *DescribeKubernetesTemplateRequest) (response *DescribeKubernetesTemplateResponse, err error) {
	response = CreateDescribeKubernetesTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeKubernetesTemplateWithChan invokes the cs.DescribeKubernetesTemplate API asynchronously
// api document: https://help.aliyun.com/api/cs/describekubernetestemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeKubernetesTemplateWithChan(request *DescribeKubernetesTemplateRequest) (<-chan *DescribeKubernetesTemplateResponse, <-chan error) {
	responseChan := make(chan *DescribeKubernetesTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeKubernetesTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeKubernetesTemplateWithCallback invokes the cs.DescribeKubernetesTemplate API asynchronously
// api document: https://help.aliyun.com/api/cs/describekubernetestemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeKubernetesTemplateWithCallback(request *DescribeKubernetesTemplateRequest, callback func(response *DescribeKubernetesTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeKubernetesTemplateResponse
		var err error
		defer close(result)
		response, err = client.DescribeKubernetesTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeKubernetesTemplateRequest is the request struct for api DescribeKubernetesTemplate
type DescribeKubernetesTemplateRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"ClusterId"`
}

// DescribeKubernetesTemplateResponse is the response struct for api DescribeKubernetesTemplate
type DescribeKubernetesTemplateResponse struct {
	*responses.BaseResponse
}

// CreateDescribeKubernetesTemplateRequest creates a request to invoke DescribeKubernetesTemplate API
func CreateDescribeKubernetesTemplateRequest() (request *DescribeKubernetesTemplateRequest) {
	request = &DescribeKubernetesTemplateRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeKubernetesTemplate", "/k8s/templates/[ClusterId]", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeKubernetesTemplateResponse creates a response to parse from DescribeKubernetesTemplate response
func CreateDescribeKubernetesTemplateResponse() (response *DescribeKubernetesTemplateResponse) {
	response = &DescribeKubernetesTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
