package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddMyGroupInstances invokes the cms.AddMyGroupInstances API synchronously
// api document: https://help.aliyun.com/api/cms/addmygroupinstances.html
func (client *Client) AddMyGroupInstances(request *AddMyGroupInstancesRequest) (response *AddMyGroupInstancesResponse, err error) {
	response = CreateAddMyGroupInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// AddMyGroupInstancesWithChan invokes the cms.AddMyGroupInstances API asynchronously
// api document: https://help.aliyun.com/api/cms/addmygroupinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddMyGroupInstancesWithChan(request *AddMyGroupInstancesRequest) (<-chan *AddMyGroupInstancesResponse, <-chan error) {
	responseChan := make(chan *AddMyGroupInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddMyGroupInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddMyGroupInstancesWithCallback invokes the cms.AddMyGroupInstances API asynchronously
// api document: https://help.aliyun.com/api/cms/addmygroupinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddMyGroupInstancesWithCallback(request *AddMyGroupInstancesRequest, callback func(response *AddMyGroupInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddMyGroupInstancesResponse
		var err error
		defer close(result)
		response, err = client.AddMyGroupInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddMyGroupInstancesRequest is the request struct for api AddMyGroupInstances
type AddMyGroupInstancesRequest struct {
	*requests.RpcRequest
	Instances string           `position:"Query" name:"Instances"`
	GroupId   requests.Integer `position:"Query" name:"GroupId"`
}

// AddMyGroupInstancesResponse is the response struct for api AddMyGroupInstances
type AddMyGroupInstancesResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorCode    int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateAddMyGroupInstancesRequest creates a request to invoke AddMyGroupInstances API
func CreateAddMyGroupInstancesRequest() (request *AddMyGroupInstancesRequest) {
	request = &AddMyGroupInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "AddMyGroupInstances", "cms", "openAPI")
	return
}

// CreateAddMyGroupInstancesResponse creates a response to parse from AddMyGroupInstances response
func CreateAddMyGroupInstancesResponse() (response *AddMyGroupInstancesResponse) {
	response = &AddMyGroupInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
