package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableActiveAlert invokes the cms.DisableActiveAlert API synchronously
// api document: https://help.aliyun.com/api/cms/disableactivealert.html
func (client *Client) DisableActiveAlert(request *DisableActiveAlertRequest) (response *DisableActiveAlertResponse, err error) {
	response = CreateDisableActiveAlertResponse()
	err = client.DoAction(request, response)
	return
}

// DisableActiveAlertWithChan invokes the cms.DisableActiveAlert API asynchronously
// api document: https://help.aliyun.com/api/cms/disableactivealert.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DisableActiveAlertWithChan(request *DisableActiveAlertRequest) (<-chan *DisableActiveAlertResponse, <-chan error) {
	responseChan := make(chan *DisableActiveAlertResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableActiveAlert(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableActiveAlertWithCallback invokes the cms.DisableActiveAlert API asynchronously
// api document: https://help.aliyun.com/api/cms/disableactivealert.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DisableActiveAlertWithCallback(request *DisableActiveAlertRequest, callback func(response *DisableActiveAlertResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableActiveAlertResponse
		var err error
		defer close(result)
		response, err = client.DisableActiveAlert(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableActiveAlertRequest is the request struct for api DisableActiveAlert
type DisableActiveAlertRequest struct {
	*requests.RpcRequest
	Product string `position:"Query" name:"Product"`
	UserId  string `position:"Query" name:"UserId"`
}

// DisableActiveAlertResponse is the response struct for api DisableActiveAlert
type DisableActiveAlertResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDisableActiveAlertRequest creates a request to invoke DisableActiveAlert API
func CreateDisableActiveAlertRequest() (request *DisableActiveAlertRequest) {
	request = &DisableActiveAlertRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "DisableActiveAlert", "cms", "openAPI")
	return
}

// CreateDisableActiveAlertResponse creates a response to parse from DisableActiveAlert response
func CreateDisableActiveAlertResponse() (response *DisableActiveAlertResponse) {
	response = &DisableActiveAlertResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
