package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVpc invokes the edas.ListVpc API synchronously
// api document: https://help.aliyun.com/api/edas/listvpc.html
func (client *Client) ListVpc(request *ListVpcRequest) (response *ListVpcResponse, err error) {
	response = CreateListVpcResponse()
	err = client.DoAction(request, response)
	return
}

// ListVpcWithChan invokes the edas.ListVpc API asynchronously
// api document: https://help.aliyun.com/api/edas/listvpc.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListVpcWithChan(request *ListVpcRequest) (<-chan *ListVpcResponse, <-chan error) {
	responseChan := make(chan *ListVpcResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVpc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVpcWithCallback invokes the edas.ListVpc API asynchronously
// api document: https://help.aliyun.com/api/edas/listvpc.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListVpcWithCallback(request *ListVpcRequest, callback func(response *ListVpcResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVpcResponse
		var err error
		defer close(result)
		response, err = client.ListVpc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVpcRequest is the request struct for api ListVpc
type ListVpcRequest struct {
	*requests.RoaRequest
}

// ListVpcResponse is the response struct for api ListVpc
type ListVpcResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	VpcList   VpcList `json:"VpcList" xml:"VpcList"`
}

// CreateListVpcRequest creates a request to invoke ListVpc API
func CreateListVpcRequest() (request *ListVpcRequest) {
	request = &ListVpcRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListVpc", "/pop/v5/vpc_list", "edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListVpcResponse creates a response to parse from ListVpc response
func CreateListVpcResponse() (response *ListVpcResponse) {
	response = &ListVpcResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
