// Package billing implements the Azure ARM Billing service API version 2018-11-01-preview.
//
// Billing client provides access to billing resources for Azure subscriptions.
package billing

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

const (
	// DefaultBaseURI is the default URI used for the service Billing
	DefaultBaseURI = "https://management.azure.com"
)

// BaseClient is the base client for Billing.
type BaseClient struct {
	autorest.Client
	BaseURI        string
	SubscriptionID string
}

// New creates an instance of the BaseClient client.
func New(subscriptionID string) BaseClient {
	return NewWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewWithBaseURI creates an instance of the BaseClient client.
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return BaseClient{
		Client:         autorest.NewClientWithUserAgent(UserAgent()),
		BaseURI:        baseURI,
		SubscriptionID: subscriptionID,
	}
}

// TransactionsByBillingProfile lists the transactions by billingProfileName for given start date and end date.
// Parameters:
// billingAccountName - billing Account Id.
// billingProfileName - billing Profile Id.
// startDate - start date
// endDate - end date
// filter - may be used to filter by transaction kind. The filter supports 'eq', 'lt', 'gt', 'le', 'ge', and
// 'and'. It does not currently support 'ne', 'or', or 'not'. Tag filter is a key value pair string where key
// and value is separated by a colon (:).
func (client BaseClient) TransactionsByBillingProfile(ctx context.Context, billingAccountName string, billingProfileName string, startDate string, endDate string, filter string) (result TransactionsListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.TransactionsByBillingProfile")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.TransactionsByBillingProfilePreparer(ctx, billingAccountName, billingProfileName, startDate, endDate, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.BaseClient", "TransactionsByBillingProfile", nil, "Failure preparing request")
		return
	}

	resp, err := client.TransactionsByBillingProfileSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.BaseClient", "TransactionsByBillingProfile", resp, "Failure sending request")
		return
	}

	result, err = client.TransactionsByBillingProfileResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.BaseClient", "TransactionsByBillingProfile", resp, "Failure responding to request")
	}

	return
}

// TransactionsByBillingProfilePreparer prepares the TransactionsByBillingProfile request.
func (client BaseClient) TransactionsByBillingProfilePreparer(ctx context.Context, billingAccountName string, billingProfileName string, startDate string, endDate string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName": autorest.Encode("path", billingAccountName),
		"billingProfileName": autorest.Encode("path", billingProfileName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"endDate":     autorest.Encode("query", endDate),
		"startDate":   autorest.Encode("query", startDate),
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/transactions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TransactionsByBillingProfileSender sends the TransactionsByBillingProfile request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) TransactionsByBillingProfileSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// TransactionsByBillingProfileResponder handles the response to the TransactionsByBillingProfile request. The method always
// closes the http.Response Body.
func (client BaseClient) TransactionsByBillingProfileResponder(resp *http.Response) (result TransactionsListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateAutoRenewForBillingAccount cancel product by product id
// Parameters:
// billingAccountName - billing Account Id.
// productName - invoice Id.
// body - update auto renew request parameters.
func (client BaseClient) UpdateAutoRenewForBillingAccount(ctx context.Context, billingAccountName string, productName string, body UpdateAutoRenewRequest) (result UpdateAutoRenewOperationSummary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.UpdateAutoRenewForBillingAccount")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateAutoRenewForBillingAccountPreparer(ctx, billingAccountName, productName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.BaseClient", "UpdateAutoRenewForBillingAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateAutoRenewForBillingAccountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.BaseClient", "UpdateAutoRenewForBillingAccount", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateAutoRenewForBillingAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.BaseClient", "UpdateAutoRenewForBillingAccount", resp, "Failure responding to request")
	}

	return
}

// UpdateAutoRenewForBillingAccountPreparer prepares the UpdateAutoRenewForBillingAccount request.
func (client BaseClient) UpdateAutoRenewForBillingAccountPreparer(ctx context.Context, billingAccountName string, productName string, body UpdateAutoRenewRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName": autorest.Encode("path", billingAccountName),
		"productName":        autorest.Encode("path", productName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/products/{productName}/updateAutoRenew", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateAutoRenewForBillingAccountSender sends the UpdateAutoRenewForBillingAccount request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) UpdateAutoRenewForBillingAccountSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateAutoRenewForBillingAccountResponder handles the response to the UpdateAutoRenewForBillingAccount request. The method always
// closes the http.Response Body.
func (client BaseClient) UpdateAutoRenewForBillingAccountResponder(resp *http.Response) (result UpdateAutoRenewOperationSummary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateAutoRenewForInvoiceSection cancel auto renew for product by product id
// Parameters:
// billingAccountName - billing Account Id.
// invoiceSectionName - invoiceSection Id.
// productName - invoice Id.
// body - update auto renew request parameters.
func (client BaseClient) UpdateAutoRenewForInvoiceSection(ctx context.Context, billingAccountName string, invoiceSectionName string, productName string, body UpdateAutoRenewRequest) (result UpdateAutoRenewOperationSummary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.UpdateAutoRenewForInvoiceSection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateAutoRenewForInvoiceSectionPreparer(ctx, billingAccountName, invoiceSectionName, productName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.BaseClient", "UpdateAutoRenewForInvoiceSection", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateAutoRenewForInvoiceSectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.BaseClient", "UpdateAutoRenewForInvoiceSection", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateAutoRenewForInvoiceSectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.BaseClient", "UpdateAutoRenewForInvoiceSection", resp, "Failure responding to request")
	}

	return
}

// UpdateAutoRenewForInvoiceSectionPreparer prepares the UpdateAutoRenewForInvoiceSection request.
func (client BaseClient) UpdateAutoRenewForInvoiceSectionPreparer(ctx context.Context, billingAccountName string, invoiceSectionName string, productName string, body UpdateAutoRenewRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName": autorest.Encode("path", billingAccountName),
		"invoiceSectionName": autorest.Encode("path", invoiceSectionName),
		"productName":        autorest.Encode("path", productName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoiceSections/{invoiceSectionName}/products/{productName}/updateAutoRenew", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateAutoRenewForInvoiceSectionSender sends the UpdateAutoRenewForInvoiceSection request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) UpdateAutoRenewForInvoiceSectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateAutoRenewForInvoiceSectionResponder handles the response to the UpdateAutoRenewForInvoiceSection request. The method always
// closes the http.Response Body.
func (client BaseClient) UpdateAutoRenewForInvoiceSectionResponder(resp *http.Response) (result UpdateAutoRenewOperationSummary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
