package billing

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/billing/mgmt/2018-11-01-preview/billing"

// AccountType enumerates the values for account type.
type AccountType string

const (
	// AccountTypeEnrollment ...
	AccountTypeEnrollment AccountType = "Enrollment"
	// AccountTypeOrganization ...
	AccountTypeOrganization AccountType = "Organization"
)

// PossibleAccountTypeValues returns an array of possible values for the AccountType const type.
func PossibleAccountTypeValues() []AccountType {
	return []AccountType{AccountTypeEnrollment, AccountTypeOrganization}
}

// EligibleProductType enumerates the values for eligible product type.
type EligibleProductType string

const (
	// AzureReservation ...
	AzureReservation EligibleProductType = "AzureReservation"
	// DevTestAzureSubscription ...
	DevTestAzureSubscription EligibleProductType = "DevTestAzureSubscription"
	// StandardAzureSubscription ...
	StandardAzureSubscription EligibleProductType = "StandardAzureSubscription"
)

// PossibleEligibleProductTypeValues returns an array of possible values for the EligibleProductType const type.
func PossibleEligibleProductTypeValues() []EligibleProductType {
	return []EligibleProductType{AzureReservation, DevTestAzureSubscription, StandardAzureSubscription}
}

// Frequency enumerates the values for frequency.
type Frequency string

const (
	// Monthly ...
	Monthly Frequency = "Monthly"
	// OneTime ...
	OneTime Frequency = "OneTime"
	// UsageBased ...
	UsageBased Frequency = "UsageBased"
)

// PossibleFrequencyValues returns an array of possible values for the Frequency const type.
func PossibleFrequencyValues() []Frequency {
	return []Frequency{Monthly, OneTime, UsageBased}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// CreditNote ...
	CreditNote Kind = "CreditNote"
	// Invoice ...
	Invoice Kind = "Invoice"
	// Receipt ...
	Receipt Kind = "Receipt"
	// VoidNote ...
	VoidNote Kind = "VoidNote"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{CreditNote, Invoice, Receipt, VoidNote}
}

// PaymentMethodType enumerates the values for payment method type.
type PaymentMethodType string

const (
	// ChequeWire ...
	ChequeWire PaymentMethodType = "ChequeWire"
	// Credits ...
	Credits PaymentMethodType = "Credits"
)

// PossiblePaymentMethodTypeValues returns an array of possible values for the PaymentMethodType const type.
func PossiblePaymentMethodTypeValues() []PaymentMethodType {
	return []PaymentMethodType{ChequeWire, Credits}
}

// ProductStatusType enumerates the values for product status type.
type ProductStatusType string

const (
	// Active ...
	Active ProductStatusType = "Active"
	// AutoRenew ...
	AutoRenew ProductStatusType = "AutoRenew"
	// Cancelled ...
	Cancelled ProductStatusType = "Cancelled"
	// Disabled ...
	Disabled ProductStatusType = "Disabled"
	// Expired ...
	Expired ProductStatusType = "Expired"
	// Expiring ...
	Expiring ProductStatusType = "Expiring"
	// Inactive ...
	Inactive ProductStatusType = "Inactive"
	// PastDue ...
	PastDue ProductStatusType = "PastDue"
)

// PossibleProductStatusTypeValues returns an array of possible values for the ProductStatusType const type.
func PossibleProductStatusTypeValues() []ProductStatusType {
	return []ProductStatusType{Active, AutoRenew, Cancelled, Disabled, Expired, Expiring, Inactive, PastDue}
}

// ProductTransferStatus enumerates the values for product transfer status.
type ProductTransferStatus string

const (
	// Completed ...
	Completed ProductTransferStatus = "Completed"
	// Failed ...
	Failed ProductTransferStatus = "Failed"
	// InProgress ...
	InProgress ProductTransferStatus = "InProgress"
	// NotStarted ...
	NotStarted ProductTransferStatus = "NotStarted"
)

// PossibleProductTransferStatusValues returns an array of possible values for the ProductTransferStatus const type.
func PossibleProductTransferStatusValues() []ProductTransferStatus {
	return []ProductTransferStatus{Completed, Failed, InProgress, NotStarted}
}

// ProductType enumerates the values for product type.
type ProductType string

const (
	// ProductTypeAzureReservation ...
	ProductTypeAzureReservation ProductType = "AzureReservation"
	// ProductTypeAzureSubscription ...
	ProductTypeAzureSubscription ProductType = "AzureSubscription"
)

// PossibleProductTypeValues returns an array of possible values for the ProductType const type.
func PossibleProductTypeValues() []ProductType {
	return []ProductType{ProductTypeAzureReservation, ProductTypeAzureSubscription}
}

// ReservationType enumerates the values for reservation type.
type ReservationType string

const (
	// Purchase ...
	Purchase ReservationType = "Purchase"
	// UsageCharge ...
	UsageCharge ReservationType = "Usage Charge"
)

// PossibleReservationTypeValues returns an array of possible values for the ReservationType const type.
func PossibleReservationTypeValues() []ReservationType {
	return []ReservationType{Purchase, UsageCharge}
}

// Status enumerates the values for status.
type Status string

const (
	// StatusDue ...
	StatusDue Status = "Due"
	// StatusPaid ...
	StatusPaid Status = "Paid"
	// StatusPastDue ...
	StatusPastDue Status = "PastDue"
	// StatusVoid ...
	StatusVoid Status = "Void"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{StatusDue, StatusPaid, StatusPastDue, StatusVoid}
}

// SubscriptionStatusType enumerates the values for subscription status type.
type SubscriptionStatusType string

const (
	// SubscriptionStatusTypeAbandoned ...
	SubscriptionStatusTypeAbandoned SubscriptionStatusType = "Abandoned"
	// SubscriptionStatusTypeActive ...
	SubscriptionStatusTypeActive SubscriptionStatusType = "Active"
	// SubscriptionStatusTypeDeleted ...
	SubscriptionStatusTypeDeleted SubscriptionStatusType = "Deleted"
	// SubscriptionStatusTypeInactive ...
	SubscriptionStatusTypeInactive SubscriptionStatusType = "Inactive"
	// SubscriptionStatusTypeWarning ...
	SubscriptionStatusTypeWarning SubscriptionStatusType = "Warning"
)

// PossibleSubscriptionStatusTypeValues returns an array of possible values for the SubscriptionStatusType const type.
func PossibleSubscriptionStatusTypeValues() []SubscriptionStatusType {
	return []SubscriptionStatusType{SubscriptionStatusTypeAbandoned, SubscriptionStatusTypeActive, SubscriptionStatusTypeDeleted, SubscriptionStatusTypeInactive, SubscriptionStatusTypeWarning}
}

// TransactionTypeKind enumerates the values for transaction type kind.
type TransactionTypeKind string

const (
	// All ...
	All TransactionTypeKind = "all"
	// Reservation ...
	Reservation TransactionTypeKind = "reservation"
)

// PossibleTransactionTypeKindValues returns an array of possible values for the TransactionTypeKind const type.
func PossibleTransactionTypeKindValues() []TransactionTypeKind {
	return []TransactionTypeKind{All, Reservation}
}

// TransferStatus enumerates the values for transfer status.
type TransferStatus string

const (
	// TransferStatusCanceled ...
	TransferStatusCanceled TransferStatus = "Canceled"
	// TransferStatusCompleted ...
	TransferStatusCompleted TransferStatus = "Completed"
	// TransferStatusCompletedWithErrors ...
	TransferStatusCompletedWithErrors TransferStatus = "CompletedWithErrors"
	// TransferStatusDeclined ...
	TransferStatusDeclined TransferStatus = "Declined"
	// TransferStatusFailed ...
	TransferStatusFailed TransferStatus = "Failed"
	// TransferStatusInProgress ...
	TransferStatusInProgress TransferStatus = "InProgress"
	// TransferStatusPending ...
	TransferStatusPending TransferStatus = "Pending"
)

// PossibleTransferStatusValues returns an array of possible values for the TransferStatus const type.
func PossibleTransferStatusValues() []TransferStatus {
	return []TransferStatus{TransferStatusCanceled, TransferStatusCompleted, TransferStatusCompletedWithErrors, TransferStatusDeclined, TransferStatusFailed, TransferStatusInProgress, TransferStatusPending}
}

// UpdateAutoRenew enumerates the values for update auto renew.
type UpdateAutoRenew string

const (
	// False ...
	False UpdateAutoRenew = "false"
	// True ...
	True UpdateAutoRenew = "true"
)

// PossibleUpdateAutoRenewValues returns an array of possible values for the UpdateAutoRenew const type.
func PossibleUpdateAutoRenewValues() []UpdateAutoRenew {
	return []UpdateAutoRenew{False, True}
}

// AcceptTransferProperties request parameters to accept transfer.
type AcceptTransferProperties struct {
	// ProductDetails - Request parameters to accept transfer.
	ProductDetails *[]ProductDetails `json:"productDetails,omitempty"`
}

// AcceptTransferRequest request parameters to accept transfer.
type AcceptTransferRequest struct {
	// AcceptTransferProperties - Request parameters to accept transfer.
	*AcceptTransferProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AcceptTransferRequest.
func (atr AcceptTransferRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atr.AcceptTransferProperties != nil {
		objectMap["properties"] = atr.AcceptTransferProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AcceptTransferRequest struct.
func (atr *AcceptTransferRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var acceptTransferProperties AcceptTransferProperties
				err = json.Unmarshal(*v, &acceptTransferProperties)
				if err != nil {
					return err
				}
				atr.AcceptTransferProperties = &acceptTransferProperties
			}
		}
	}

	return nil
}

// Account a billing account resource.
type Account struct {
	autorest.Response `json:"-"`
	// AccountProperties - A billing account.
	*AccountProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AccountProperties != nil {
		objectMap["properties"] = a.AccountProperties
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.Type != nil {
		objectMap["type"] = a.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Account struct.
func (a *Account) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				a.AccountProperties = &accountProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AccountListResult result of listing billing accounts.
type AccountListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of billing accounts.
	Value *[]Account `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AccountProperties the properties of the billing account.
type AccountProperties struct {
	// DisplayName - The billing account name.
	DisplayName *string `json:"displayName,omitempty"`
	// Company - The Company this billing account belongs to.
	Company *string `json:"company,omitempty"`
	// AccountType - The billing account Type. Possible values include: 'AccountTypeOrganization', 'AccountTypeEnrollment'
	AccountType AccountType `json:"accountType,omitempty"`
	// Address - The address associated with billing account.
	Address *Address `json:"address,omitempty"`
	// Country - The country associated with billing account..
	Country *string `json:"country,omitempty"`
	// InvoiceSections - The invoice sections associated to the billing account.
	InvoiceSections *[]InvoiceSection `json:"invoiceSections,omitempty"`
	// BillingProfiles - The billing profiles associated to the billing account.
	BillingProfiles *[]Profile `json:"billingProfiles,omitempty"`
	// EnrollmentDetails - The details about the associated legacy enrollment. By default this is not populated, unless it's specified in $expand.
	EnrollmentDetails *Enrollment `json:"enrollmentDetails,omitempty"`
	// Departments - The departments associated to the enrollment.
	Departments *[]Department `json:"departments,omitempty"`
	// EnrollmentAccounts - The accounts associated to the enrollment.
	EnrollmentAccounts *[]EnrollmentAccount `json:"enrollmentAccounts,omitempty"`
}

// Address address details.
type Address struct {
	// FirstName - First Name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last Name.
	LastName *string `json:"lastName,omitempty"`
	// CompanyName - Company Name.
	CompanyName *string `json:"companyName,omitempty"`
	// AddressLine1 - Address Line1.
	AddressLine1 *string `json:"addressLine1,omitempty"`
	// AddressLine2 - Address Line2.
	AddressLine2 *string `json:"addressLine2,omitempty"`
	// AddressLine3 - Address Line3.
	AddressLine3 *string `json:"addressLine3,omitempty"`
	// City - Address City.
	City *string `json:"city,omitempty"`
	// Region - Address Region.
	Region *string `json:"region,omitempty"`
	// Country - Country code uses ISO2, 2-digit format.
	Country *string `json:"country,omitempty"`
	// PostalCode - Address Postal Code.
	PostalCode *string `json:"postalCode,omitempty"`
}

// Amount the Amount.
type Amount struct {
	// Currency - The currency for the amount value.
	Currency *string `json:"currency,omitempty"`
	// Value - Amount value.
	Value *float64 `json:"value,omitempty"`
}

// AvailableBalance latest available balance on Monetary Credit PI.
type AvailableBalance struct {
	autorest.Response           `json:"-"`
	*AvailableBalanceProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailableBalance.
func (ab AvailableBalance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ab.AvailableBalanceProperties != nil {
		objectMap["properties"] = ab.AvailableBalanceProperties
	}
	if ab.ID != nil {
		objectMap["id"] = ab.ID
	}
	if ab.Name != nil {
		objectMap["name"] = ab.Name
	}
	if ab.Type != nil {
		objectMap["type"] = ab.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AvailableBalance struct.
func (ab *AvailableBalance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var availableBalanceProperties AvailableBalanceProperties
				err = json.Unmarshal(*v, &availableBalanceProperties)
				if err != nil {
					return err
				}
				ab.AvailableBalanceProperties = &availableBalanceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ab.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ab.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ab.Type = &typeVar
			}
		}
	}

	return nil
}

// AvailableBalanceProperties the properties of available balance.
type AvailableBalanceProperties struct {
	// Amount - Balance Amount.
	Amount *Amount `json:"amount,omitempty"`
}

// Department a department resource.
type Department struct {
	autorest.Response `json:"-"`
	// DepartmentProperties - A department.
	*DepartmentProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Department.
func (d Department) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DepartmentProperties != nil {
		objectMap["properties"] = d.DepartmentProperties
	}
	if d.ID != nil {
		objectMap["id"] = d.ID
	}
	if d.Name != nil {
		objectMap["name"] = d.Name
	}
	if d.Type != nil {
		objectMap["type"] = d.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Department struct.
func (d *Department) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var departmentProperties DepartmentProperties
				err = json.Unmarshal(*v, &departmentProperties)
				if err != nil {
					return err
				}
				d.DepartmentProperties = &departmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DepartmentListResult result of listing departments.
type DepartmentListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of departments.
	Value *[]Department `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DepartmentProperties the properties of the department.
type DepartmentProperties struct {
	// DepartmentName - The name for department.
	DepartmentName *string `json:"departmentName,omitempty"`
	// CostCenter - The cost center name.
	CostCenter *string `json:"costCenter,omitempty"`
	// Status - The status for department.
	Status *string `json:"status,omitempty"`
	// EnrollmentAccounts - Associated enrollment accounts. By default this is not populated, unless it's specified in $expand.
	EnrollmentAccounts *[]EnrollmentAccount `json:"enrollmentAccounts,omitempty"`
}

// DetailedTransferStatus detailed transfer status.
type DetailedTransferStatus struct {
	// ProductType - Type of product being transferred. Possible values include: 'ProductTypeAzureSubscription', 'ProductTypeAzureReservation'
	ProductType ProductType `json:"productType,omitempty"`
	// ProductID - Id of product being transferred.
	ProductID *string `json:"productId,omitempty"`
	// TransferStatus - Transfer status. Possible values include: 'NotStarted', 'InProgress', 'Completed', 'Failed'
	TransferStatus ProductTransferStatus `json:"transferStatus,omitempty"`
	// ErrorDetails - Error details for transfer execution.
	ErrorDetails *Error `json:"errorDetails,omitempty"`
}

// DownloadProperties the properties of the invoice download.
type DownloadProperties struct {
	// Kind - Document type. Possible values include: 'Invoice', 'VoidNote', 'Receipt', 'CreditNote'
	Kind Kind `json:"kind,omitempty"`
	// URL - Document URL.
	URL *string `json:"url,omitempty"`
}

// DownloadURL a secure URL that can be used to download a an entity until the URL expires.
type DownloadURL struct {
	autorest.Response `json:"-"`
	// ExpiryTime - The time in UTC at which this download URL will expire.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// URL - The URL to the PDF file.
	URL *string `json:"url,omitempty"`
}

// EnabledAzureSKUs details about the product.
type EnabledAzureSKUs struct {
	// SkuID - The sku id.
	SkuID *string `json:"skuId,omitempty"`
	// SkuDescription - The sku description.
	SkuDescription *string `json:"skuDescription,omitempty"`
}

// Enrollment current entity level details
type Enrollment struct {
	// StartDate - Enrollment Start Date
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - Enrollment End Date
	EndDate *date.Time `json:"endDate,omitempty"`
	// Currency - The currency associated with enrollment
	Currency *string `json:"currency,omitempty"`
	// Channel - The channel for Enrollment
	Channel *string `json:"channel,omitempty"`
	// Policies - The attributes associated with legacy enrollment.
	Policies *EnrollmentPolicies `json:"policies,omitempty"`
	// Language - The language for Enrollment
	Language *string `json:"language,omitempty"`
	// CountryCode - The countryCode for Enrollment
	CountryCode *string `json:"countryCode,omitempty"`
	// Status - Enrollment status
	Status *string `json:"status,omitempty"`
	// BillingCycle - Enrollment billing cycle
	BillingCycle *string `json:"billingCycle,omitempty"`
}

// EnrollmentAccount an account resource.
type EnrollmentAccount struct {
	autorest.Response `json:"-"`
	// EnrollmentAccountProperties - An account.
	*EnrollmentAccountProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EnrollmentAccount.
func (ea EnrollmentAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ea.EnrollmentAccountProperties != nil {
		objectMap["properties"] = ea.EnrollmentAccountProperties
	}
	if ea.ID != nil {
		objectMap["id"] = ea.ID
	}
	if ea.Name != nil {
		objectMap["name"] = ea.Name
	}
	if ea.Type != nil {
		objectMap["type"] = ea.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EnrollmentAccount struct.
func (ea *EnrollmentAccount) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var enrollmentAccountProperties EnrollmentAccountProperties
				err = json.Unmarshal(*v, &enrollmentAccountProperties)
				if err != nil {
					return err
				}
				ea.EnrollmentAccountProperties = &enrollmentAccountProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ea.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ea.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ea.Type = &typeVar
			}
		}
	}

	return nil
}

// EnrollmentAccountContext the rating context.
type EnrollmentAccountContext struct {
	// CostCenter - The cost center name.
	CostCenter *string `json:"costCenter,omitempty"`
	// StartDate - Account Start Date
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - Account End Date
	EndDate *date.Time `json:"endDate,omitempty"`
	// EnrollmentAccountName - The enrollment account id.
	EnrollmentAccountName *string `json:"enrollmentAccountName,omitempty"`
}

// EnrollmentAccountListResult result of listing enrollment accounts.
type EnrollmentAccountListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of enrollment accounts.
	Value *[]EnrollmentAccount `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// EnrollmentAccountProperties the properties of the account.
type EnrollmentAccountProperties struct {
	// AccountName - The account name.
	AccountName *string `json:"accountName,omitempty"`
	// CostCenter - The cost center name.
	CostCenter *string `json:"costCenter,omitempty"`
	// AccountOwner - The account owner
	AccountOwner *string `json:"accountOwner,omitempty"`
	// Status - The status for account.
	Status *string `json:"status,omitempty"`
	// StartDate - Account Start Date
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - Account End Date
	EndDate *date.Time `json:"endDate,omitempty"`
	// Department - Associated department. By default this is not populated, unless it's specified in $expand.
	Department *Department `json:"department,omitempty"`
}

// EnrollmentPolicies the attributes associated with legacy enrollment
type EnrollmentPolicies struct {
	// AccountOwnerViewCharges - The accountOwnerViewCharges flag for Enrollment
	AccountOwnerViewCharges *bool `json:"accountOwnerViewCharges,omitempty"`
	// DepartmentAdminViewCharges - The departmentAdminViewCharges flag for Enrollment
	DepartmentAdminViewCharges *bool `json:"departmentAdminViewCharges,omitempty"`
	// MarketplacesEnabled - The marketplaces flag for Enrollment
	MarketplacesEnabled *bool `json:"marketplacesEnabled,omitempty"`
	// ReservedInstancesEnabled - The reserved instances flag for Enrollment
	ReservedInstancesEnabled *bool `json:"reservedInstancesEnabled,omitempty"`
}

// Error error details for transfer execution.
type Error struct {
	// ErrorCode - Error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - Error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// ErrorDetails the details of the error.
type ErrorDetails struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error.
	Target *string `json:"target,omitempty"`
}

// ErrorResponse error response indicates that the service is not able to process the incoming request. The
// reason is provided in the error message.
type ErrorResponse struct {
	// Error - The details of the error.
	Error *ErrorDetails `json:"error,omitempty"`
}

// InitiateTransferProperties request parameters to initiate transfer.
type InitiateTransferProperties struct {
	// BillingProfileID - Target Usage context for devTest subscriptions.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// RecipientEmailID - Email Id of recipient for transfer.
	RecipientEmailID *string `json:"recipientEmailId,omitempty"`
}

// InitiateTransferRequest request parameters to initiate transfer.
type InitiateTransferRequest struct {
	// InitiateTransferProperties - Request parameters to initiate transfer.
	*InitiateTransferProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for InitiateTransferRequest.
func (itr InitiateTransferRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itr.InitiateTransferProperties != nil {
		objectMap["properties"] = itr.InitiateTransferProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InitiateTransferRequest struct.
func (itr *InitiateTransferRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var initiateTransferProperties InitiateTransferProperties
				err = json.Unmarshal(*v, &initiateTransferProperties)
				if err != nil {
					return err
				}
				itr.InitiateTransferProperties = &initiateTransferProperties
			}
		}
	}

	return nil
}

// InvoiceListResult result of listing invoices.
type InvoiceListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of invoices.
	Value *[]InvoiceSummary `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InvoicePricesheetDownloadFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InvoicePricesheetDownloadFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InvoicePricesheetDownloadFuture) Result(client InvoicePricesheetClient) (du DownloadURL, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicePricesheetDownloadFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.InvoicePricesheetDownloadFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if du.Response.Response, err = future.GetResult(sender); err == nil && du.Response.Response.StatusCode != http.StatusNoContent {
		du, err = client.DownloadResponder(du.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.InvoicePricesheetDownloadFuture", "Result", du.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InvoiceSection an InvoiceSection resource.
type InvoiceSection struct {
	autorest.Response `json:"-"`
	// InvoiceSectionProperties - The InvoiceSection.
	*InvoiceSectionProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for InvoiceSection.
func (is InvoiceSection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if is.InvoiceSectionProperties != nil {
		objectMap["properties"] = is.InvoiceSectionProperties
	}
	if is.ID != nil {
		objectMap["id"] = is.ID
	}
	if is.Name != nil {
		objectMap["name"] = is.Name
	}
	if is.Type != nil {
		objectMap["type"] = is.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InvoiceSection struct.
func (is *InvoiceSection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var invoiceSectionProperties InvoiceSectionProperties
				err = json.Unmarshal(*v, &invoiceSectionProperties)
				if err != nil {
					return err
				}
				is.InvoiceSectionProperties = &invoiceSectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				is.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				is.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				is.Type = &typeVar
			}
		}
	}

	return nil
}

// InvoiceSectionListResult result of listing invoice sections.
type InvoiceSectionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of invoice sections.
	Value *[]InvoiceSection `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InvoiceSectionProperties the properties of an InvoiceSection.
type InvoiceSectionProperties struct {
	// DisplayName - The name of the InvoiceSection.
	DisplayName *string `json:"displayName,omitempty"`
	// BillingProfiles - The billing profiles associated to the billing account.
	BillingProfiles *[]Profile `json:"billingProfiles,omitempty"`
}

// InvoiceSectionsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InvoiceSectionsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InvoiceSectionsCreateFuture) Result(client InvoiceSectionsClient) (is InvoiceSection, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoiceSectionsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.InvoiceSectionsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if is.Response.Response, err = future.GetResult(sender); err == nil && is.Response.Response.StatusCode != http.StatusNoContent {
		is, err = client.CreateResponder(is.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.InvoiceSectionsCreateFuture", "Result", is.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InvoiceSectionsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InvoiceSectionsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InvoiceSectionsUpdateFuture) Result(client InvoiceSectionsClient) (is InvoiceSection, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoiceSectionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.InvoiceSectionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if is.Response.Response, err = future.GetResult(sender); err == nil && is.Response.Response.StatusCode != http.StatusNoContent {
		is, err = client.UpdateResponder(is.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.InvoiceSectionsUpdateFuture", "Result", is.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InvoiceSummary an invoice resource.
type InvoiceSummary struct {
	autorest.Response `json:"-"`
	// InvoiceSummaryProperties - An invoice.
	*InvoiceSummaryProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for InvoiceSummary.
func (is InvoiceSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if is.InvoiceSummaryProperties != nil {
		objectMap["properties"] = is.InvoiceSummaryProperties
	}
	if is.ID != nil {
		objectMap["id"] = is.ID
	}
	if is.Name != nil {
		objectMap["name"] = is.Name
	}
	if is.Type != nil {
		objectMap["type"] = is.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InvoiceSummary struct.
func (is *InvoiceSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var invoiceSummaryProperties InvoiceSummaryProperties
				err = json.Unmarshal(*v, &invoiceSummaryProperties)
				if err != nil {
					return err
				}
				is.InvoiceSummaryProperties = &invoiceSummaryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				is.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				is.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				is.Type = &typeVar
			}
		}
	}

	return nil
}

// InvoiceSummaryProperties the properties of the invoice.
type InvoiceSummaryProperties struct {
	// DueDate - The due date for invoice.
	DueDate *date.Time `json:"dueDate,omitempty"`
	// InvoiceDate - The date when invoice was created.
	InvoiceDate *date.Time `json:"invoiceDate,omitempty"`
	// Status - Invoice status. Possible values include: 'StatusPastDue', 'StatusDue', 'StatusPaid', 'StatusVoid'
	Status Status `json:"status,omitempty"`
	// AmountDue - Amount due.
	AmountDue *Amount `json:"amountDue,omitempty"`
	// BilledAmount - Amount billed.
	BilledAmount *Amount `json:"billedAmount,omitempty"`
	// InvoicePeriodStartDate - The start date of the billing period.
	InvoicePeriodStartDate *date.Time `json:"invoicePeriodStartDate,omitempty"`
	// InvoicePeriodEndDate - The end date of the billing period.
	InvoicePeriodEndDate *date.Time `json:"invoicePeriodEndDate,omitempty"`
	// BillingProfile - The profile id which invoice belongs to.
	BillingProfile *string `json:"billingProfile,omitempty"`
	// BillingProfileName - The profile name which invoice belongs to.
	BillingProfileName *string `json:"billingProfileName,omitempty"`
	// PurchaseOrderNumber - The purchase identifier for the invoice.
	PurchaseOrderNumber *string `json:"purchaseOrderNumber,omitempty"`
	// DocumentUrls - List of document urls available to download including invoice and tax documents.
	DocumentUrls *[]DownloadProperties `json:"documentUrls,omitempty"`
	// Payments - List of payments.
	Payments *[]PaymentProperties `json:"payments,omitempty"`
}

// Operation a Billing REST API operation.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Billing.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Invoice, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result listing billing operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of billing operations supported by the Microsoft.Billing resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// OperationStatus status of the Billing POST/PUT operation.
type OperationStatus struct {
	// ID - The operation Id.
	ID *string `json:"id,omitempty"`
	// Status - Status of the pending operation
	Status *string `json:"status,omitempty"`
	// StatusDetail - Status Detail of the pending operation
	StatusDetail *string `json:"statusDetail,omitempty"`
}

// PaymentMethod a payment method resource.
type PaymentMethod struct {
	*PaymentMethodProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PaymentMethod.
func (pm PaymentMethod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pm.PaymentMethodProperties != nil {
		objectMap["properties"] = pm.PaymentMethodProperties
	}
	if pm.ID != nil {
		objectMap["id"] = pm.ID
	}
	if pm.Name != nil {
		objectMap["name"] = pm.Name
	}
	if pm.Type != nil {
		objectMap["type"] = pm.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PaymentMethod struct.
func (pm *PaymentMethod) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var paymentMethodProperties PaymentMethodProperties
				err = json.Unmarshal(*v, &paymentMethodProperties)
				if err != nil {
					return err
				}
				pm.PaymentMethodProperties = &paymentMethodProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pm.Type = &typeVar
			}
		}
	}

	return nil
}

// PaymentMethodProperties the properties of the payment method.
type PaymentMethodProperties struct {
	// MethodType - Payment method type. Possible values include: 'Credits', 'ChequeWire'
	MethodType PaymentMethodType `json:"methodType,omitempty"`
	// Details - Details about the payment method.
	Details *string `json:"details,omitempty"`
	// Expiration - Expiration date.
	Expiration *date.Time `json:"expiration,omitempty"`
	// Currency - The currency associated with the payment method.
	Currency *string `json:"currency,omitempty"`
}

// PaymentMethodsListResult result of listing payment methods.
type PaymentMethodsListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of payment methods.
	Value *[]PaymentMethod `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PaymentMethodsListResultIterator provides access to a complete listing of PaymentMethod values.
type PaymentMethodsListResultIterator struct {
	i    int
	page PaymentMethodsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PaymentMethodsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaymentMethodsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PaymentMethodsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PaymentMethodsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PaymentMethodsListResultIterator) Response() PaymentMethodsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PaymentMethodsListResultIterator) Value() PaymentMethod {
	if !iter.page.NotDone() {
		return PaymentMethod{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PaymentMethodsListResultIterator type.
func NewPaymentMethodsListResultIterator(page PaymentMethodsListResultPage) PaymentMethodsListResultIterator {
	return PaymentMethodsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pmlr PaymentMethodsListResult) IsEmpty() bool {
	return pmlr.Value == nil || len(*pmlr.Value) == 0
}

// paymentMethodsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pmlr PaymentMethodsListResult) paymentMethodsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if pmlr.NextLink == nil || len(to.String(pmlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pmlr.NextLink)))
}

// PaymentMethodsListResultPage contains a page of PaymentMethod values.
type PaymentMethodsListResultPage struct {
	fn   func(context.Context, PaymentMethodsListResult) (PaymentMethodsListResult, error)
	pmlr PaymentMethodsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PaymentMethodsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaymentMethodsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pmlr)
	if err != nil {
		return err
	}
	page.pmlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PaymentMethodsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PaymentMethodsListResultPage) NotDone() bool {
	return !page.pmlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PaymentMethodsListResultPage) Response() PaymentMethodsListResult {
	return page.pmlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PaymentMethodsListResultPage) Values() []PaymentMethod {
	if page.pmlr.IsEmpty() {
		return nil
	}
	return *page.pmlr.Value
}

// Creates a new instance of the PaymentMethodsListResultPage type.
func NewPaymentMethodsListResultPage(getNextPage func(context.Context, PaymentMethodsListResult) (PaymentMethodsListResult, error)) PaymentMethodsListResultPage {
	return PaymentMethodsListResultPage{fn: getNextPage}
}

// PaymentProperties the properties of the payment.
type PaymentProperties struct {
	// PaymentType - The type of payment.
	PaymentType *string `json:"paymentType,omitempty"`
	// Amount - The paid amount.
	Amount *Amount `json:"amount,omitempty"`
	// Date - The date of the payment.
	Date *date.Time `json:"date,omitempty"`
}

// Permissions the set of allowed action and not allowed actions a caller has on a billing account
type Permissions struct {
	// Actions - The set of actions that the caller is allowed to do
	Actions *[]string `json:"actions,omitempty"`
	// NotActions - The set of actions the caller is not allowed to do
	NotActions *[]string `json:"notActions,omitempty"`
}

// PermissionsListResult result of list billingPermissions a caller has on a billing account.
type PermissionsListResult struct {
	autorest.Response `json:"-"`
	// Value - The list OF billingPermissions a caller has on a billing account.
	Value *[]Permissions `json:"value,omitempty"`
}

// Policy the Policy.
type Policy struct {
	autorest.Response `json:"-"`
	*PolicyProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Policy.
func (p Policy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PolicyProperties != nil {
		objectMap["properties"] = p.PolicyProperties
	}
	if p.ID != nil {
		objectMap["id"] = p.ID
	}
	if p.Name != nil {
		objectMap["name"] = p.Name
	}
	if p.Type != nil {
		objectMap["type"] = p.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Policy struct.
func (p *Policy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var policyProperties PolicyProperties
				err = json.Unmarshal(*v, &policyProperties)
				if err != nil {
					return err
				}
				p.PolicyProperties = &policyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// PolicyProperties the properties of policy.
type PolicyProperties struct {
	// ReservationPurchasesAllowed - The reservationPurchasesAllowed flag.
	ReservationPurchasesAllowed *bool `json:"reservationPurchasesAllowed,omitempty"`
	// MarketplacePurchasesAllowed - The marketplacePurchasesAllowed flag.
	MarketplacePurchasesAllowed *bool `json:"marketplacePurchasesAllowed,omitempty"`
}

// ProductDetails details of the product to be transferred.
type ProductDetails struct {
	// ProductType - Type of the product to be transferred. Possible values include: 'ProductTypeAzureSubscription', 'ProductTypeAzureReservation'
	ProductType ProductType `json:"productType,omitempty"`
	// ProductID - Id of product to be transferred.
	ProductID *string `json:"productId,omitempty"`
}

// ProductsListResult result of listing products summary. It contains a list of available products
// summaries in reverse chronological order by purchase date.
type ProductsListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of products summary.
	Value *[]ProductSummary `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProductsListResultIterator provides access to a complete listing of ProductSummary values.
type ProductsListResultIterator struct {
	i    int
	page ProductsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProductsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProductsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProductsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProductsListResultIterator) Response() ProductsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProductsListResultIterator) Value() ProductSummary {
	if !iter.page.NotDone() {
		return ProductSummary{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProductsListResultIterator type.
func NewProductsListResultIterator(page ProductsListResultPage) ProductsListResultIterator {
	return ProductsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProductsListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// productsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProductsListResult) productsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if plr.NextLink == nil || len(to.String(plr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProductsListResultPage contains a page of ProductSummary values.
type ProductsListResultPage struct {
	fn  func(context.Context, ProductsListResult) (ProductsListResult, error)
	plr ProductsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProductsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.plr)
	if err != nil {
		return err
	}
	page.plr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProductsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProductsListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProductsListResultPage) Response() ProductsListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProductsListResultPage) Values() []ProductSummary {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the ProductsListResultPage type.
func NewProductsListResultPage(getNextPage func(context.Context, ProductsListResult) (ProductsListResult, error)) ProductsListResultPage {
	return ProductsListResultPage{fn: getNextPage}
}

// ProductSummary a product summary resource.
type ProductSummary struct {
	autorest.Response         `json:"-"`
	*ProductSummaryProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductSummary.
func (ps ProductSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ps.ProductSummaryProperties != nil {
		objectMap["properties"] = ps.ProductSummaryProperties
	}
	if ps.ID != nil {
		objectMap["id"] = ps.ID
	}
	if ps.Name != nil {
		objectMap["name"] = ps.Name
	}
	if ps.Type != nil {
		objectMap["type"] = ps.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProductSummary struct.
func (ps *ProductSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var productSummaryProperties ProductSummaryProperties
				err = json.Unmarshal(*v, &productSummaryProperties)
				if err != nil {
					return err
				}
				ps.ProductSummaryProperties = &productSummaryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ps.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ps.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ps.Type = &typeVar
			}
		}
	}

	return nil
}

// ProductSummaryProperties the properties of the product summary.
type ProductSummaryProperties struct {
	// DisplayName - The display name of the product.
	DisplayName *string `json:"displayName,omitempty"`
	// PurchaseDate - The date of purchase.
	PurchaseDate *date.Time `json:"purchaseDate,omitempty"`
	// ProductTypeID - The product type id.
	ProductTypeID *string `json:"productTypeId,omitempty"`
	// ProductType - The type of product.
	ProductType *string `json:"productType,omitempty"`
	// Status - Product status. Possible values include: 'Active', 'Inactive', 'PastDue', 'Expiring', 'Expired', 'Disabled', 'Cancelled', 'AutoRenew'
	Status ProductStatusType `json:"status,omitempty"`
	// EndDate - end date.
	EndDate *date.Time `json:"endDate,omitempty"`
	// BillingFrequency - Billing frequency. Possible values include: 'OneTime', 'Monthly', 'UsageBased'
	BillingFrequency Frequency `json:"billingFrequency,omitempty"`
	// LastCharge - Last month charges.
	LastCharge *Amount `json:"lastCharge,omitempty"`
	// LastChargeDate - The date of the last charge.
	LastChargeDate *date.Time `json:"lastChargeDate,omitempty"`
	// Quantity - The purchased product quantity.
	Quantity *float64 `json:"quantity,omitempty"`
	// SkuID - Sku Id.
	SkuID *string `json:"skuId,omitempty"`
	// SkuDescription - Sku description.
	SkuDescription *string `json:"skuDescription,omitempty"`
	// AvailabilityID - Availability Id.
	AvailabilityID *string `json:"availabilityId,omitempty"`
	// ParentProductID - Parent Product Id.
	ParentProductID *string `json:"parentProductId,omitempty"`
	// InvoiceSectionID - Invoice section id to which this product belongs.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// InvoiceSectionName - Invoice section name to which this product belongs.
	InvoiceSectionName *string `json:"invoiceSectionName,omitempty"`
	// BillingProfileID - Billing Profile id to which this product belongs.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileName - Billing Profile name to which this product belongs.
	BillingProfileName *string `json:"billingProfileName,omitempty"`
}

// Profile a billing profile resource.
type Profile struct {
	autorest.Response `json:"-"`
	// ProfileProperties - A billing profile.
	*ProfileProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Profile.
func (p Profile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProfileProperties != nil {
		objectMap["properties"] = p.ProfileProperties
	}
	if p.ID != nil {
		objectMap["id"] = p.ID
	}
	if p.Name != nil {
		objectMap["name"] = p.Name
	}
	if p.Type != nil {
		objectMap["type"] = p.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Profile struct.
func (p *Profile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var profileProperties ProfileProperties
				err = json.Unmarshal(*v, &profileProperties)
				if err != nil {
					return err
				}
				p.ProfileProperties = &profileProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// ProfileListResult result of listing billing profiles.
type ProfileListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of billing profiles.
	Value *[]Profile `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProfileProperties the properties of the billing profile.
type ProfileProperties struct {
	// DisplayName - The billing profile name.
	DisplayName *string `json:"displayName,omitempty"`
	// PoNumber - Purchase order number.
	PoNumber *string `json:"poNumber,omitempty"`
	// BillingAddress - Billing address.
	BillingAddress *Address `json:"billingAddress,omitempty"`
	// InvoiceEmailOptIn - If the billing profile is opted in to receive invoices via email.
	InvoiceEmailOptIn *bool `json:"invoiceEmailOptIn,omitempty"`
	// IsClassic - Is OMS bootstrapped billing profile.
	IsClassic *bool `json:"isClassic,omitempty"`
	// InvoiceDay - Invoice day.
	InvoiceDay *int32 `json:"invoiceDay,omitempty"`
	// Currency - The currency associated with the billing profile.
	Currency *string `json:"currency,omitempty"`
	// EnabledAzureSKUs - Information about the product.
	EnabledAzureSKUs *[]EnabledAzureSKUs `json:"enabledAzureSKUs,omitempty"`
	// InvoiceSections - The invoice sections associated to the billing profile.
	InvoiceSections *[]InvoiceSection `json:"invoiceSections,omitempty"`
}

// ProfilesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ProfilesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ProfilesUpdateFuture) Result(client ProfilesClient) (p Profile, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.ProfilesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.ProfilesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.UpdateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.ProfilesUpdateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Property the billing property.
type Property struct {
	autorest.Response `json:"-"`
	// ProductID - Product Id.
	ProductID *string `json:"productId,omitempty"`
	// BillingTenantID - Billing tenant Id.
	BillingTenantID *string `json:"billingTenantId,omitempty"`
	// BillingAccountID - Billing account Id.
	BillingAccountID *string `json:"billingAccountId,omitempty"`
	// BillingAccountName - Billing account name.
	BillingAccountName *string `json:"billingAccountName,omitempty"`
	// BillingProfileID - Billing profile Id.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileName - Billing profile name.
	BillingProfileName *string `json:"billingProfileName,omitempty"`
	// InvoiceSectionID - Invoice Section Id.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// InvoiceSectionName - Invoice Section name.
	InvoiceSectionName *string `json:"invoiceSectionName,omitempty"`
	// SkuID - SKU Id.
	SkuID *string `json:"skuId,omitempty"`
	// SkuDescription - SKU description.
	SkuDescription *string `json:"skuDescription,omitempty"`
}

// RecipientTransferDetails details of the transfer.
type RecipientTransferDetails struct {
	autorest.Response `json:"-"`
	// RecipientTransferProperties - Details of the transfer.
	*RecipientTransferProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RecipientTransferDetails.
func (rtd RecipientTransferDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rtd.RecipientTransferProperties != nil {
		objectMap["properties"] = rtd.RecipientTransferProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecipientTransferDetails struct.
func (rtd *RecipientTransferDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recipientTransferProperties RecipientTransferProperties
				err = json.Unmarshal(*v, &recipientTransferProperties)
				if err != nil {
					return err
				}
				rtd.RecipientTransferProperties = &recipientTransferProperties
			}
		}
	}

	return nil
}

// RecipientTransferDetailsListResult result of listing details of the transfer received by caller.
type RecipientTransferDetailsListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of transfers received by caller.
	Value *[]RecipientTransferDetails `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecipientTransferDetailsListResultIterator provides access to a complete listing of
// RecipientTransferDetails values.
type RecipientTransferDetailsListResultIterator struct {
	i    int
	page RecipientTransferDetailsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecipientTransferDetailsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecipientTransferDetailsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RecipientTransferDetailsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecipientTransferDetailsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecipientTransferDetailsListResultIterator) Response() RecipientTransferDetailsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecipientTransferDetailsListResultIterator) Value() RecipientTransferDetails {
	if !iter.page.NotDone() {
		return RecipientTransferDetails{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RecipientTransferDetailsListResultIterator type.
func NewRecipientTransferDetailsListResultIterator(page RecipientTransferDetailsListResultPage) RecipientTransferDetailsListResultIterator {
	return RecipientTransferDetailsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rtdlr RecipientTransferDetailsListResult) IsEmpty() bool {
	return rtdlr.Value == nil || len(*rtdlr.Value) == 0
}

// recipientTransferDetailsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rtdlr RecipientTransferDetailsListResult) recipientTransferDetailsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if rtdlr.NextLink == nil || len(to.String(rtdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rtdlr.NextLink)))
}

// RecipientTransferDetailsListResultPage contains a page of RecipientTransferDetails values.
type RecipientTransferDetailsListResultPage struct {
	fn    func(context.Context, RecipientTransferDetailsListResult) (RecipientTransferDetailsListResult, error)
	rtdlr RecipientTransferDetailsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecipientTransferDetailsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecipientTransferDetailsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rtdlr)
	if err != nil {
		return err
	}
	page.rtdlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RecipientTransferDetailsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecipientTransferDetailsListResultPage) NotDone() bool {
	return !page.rtdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecipientTransferDetailsListResultPage) Response() RecipientTransferDetailsListResult {
	return page.rtdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecipientTransferDetailsListResultPage) Values() []RecipientTransferDetails {
	if page.rtdlr.IsEmpty() {
		return nil
	}
	return *page.rtdlr.Value
}

// Creates a new instance of the RecipientTransferDetailsListResultPage type.
func NewRecipientTransferDetailsListResultPage(getNextPage func(context.Context, RecipientTransferDetailsListResult) (RecipientTransferDetailsListResult, error)) RecipientTransferDetailsListResultPage {
	return RecipientTransferDetailsListResultPage{fn: getNextPage}
}

// RecipientTransferProperties transfer Details.
type RecipientTransferProperties struct {
	// CreationTime - Transfer creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ExpirationTime - Transfer expiration time.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// AllowedProductType - Type of subscriptions that can be transferred.
	AllowedProductType *[]EligibleProductType `json:"allowedProductType,omitempty"`
	// TransferStatus - Overall transfer status. Possible values include: 'TransferStatusPending', 'TransferStatusInProgress', 'TransferStatusCompleted', 'TransferStatusCompletedWithErrors', 'TransferStatusFailed', 'TransferStatusCanceled', 'TransferStatusDeclined'
	TransferStatus TransferStatus `json:"transferStatus,omitempty"`
	// RecipientEmailID - Email Id of recipient of transfer.
	RecipientEmailID *string `json:"recipientEmailId,omitempty"`
	// InitiatorEmailID - Email Id of initiator of transfer.
	InitiatorEmailID *string `json:"initiatorEmailId,omitempty"`
	// CanceledBy - Email Id who user canceled the transfer.
	CanceledBy *string `json:"canceledBy,omitempty"`
	// LastModifiedTime - Transfer last modification time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// DetailedTransferStatus - Detailed transfer status.
	DetailedTransferStatus *[]DetailedTransferStatus `json:"detailedTransferStatus,omitempty"`
}

// Resource the Resource model definition.
type Resource struct {
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// RoleAssignment a role assignment
type RoleAssignment struct {
	autorest.Response `json:"-"`
	// RoleAssignmentProperties - The role assignment the caller has
	*RoleAssignmentProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleAssignment.
func (ra RoleAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ra.RoleAssignmentProperties != nil {
		objectMap["properties"] = ra.RoleAssignmentProperties
	}
	if ra.ID != nil {
		objectMap["id"] = ra.ID
	}
	if ra.Name != nil {
		objectMap["name"] = ra.Name
	}
	if ra.Type != nil {
		objectMap["type"] = ra.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleAssignment struct.
func (ra *RoleAssignment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var roleAssignmentProperties RoleAssignmentProperties
				err = json.Unmarshal(*v, &roleAssignmentProperties)
				if err != nil {
					return err
				}
				ra.RoleAssignmentProperties = &roleAssignmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ra.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ra.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ra.Type = &typeVar
			}
		}
	}

	return nil
}

// RoleAssignmentListResult result of get list of role assignments
type RoleAssignmentListResult struct {
	autorest.Response `json:"-"`
	// Value - The list role assignments
	Value *[]RoleAssignment `json:"value,omitempty"`
}

// RoleAssignmentPayload the payload use to update role assignment on a scope
type RoleAssignmentPayload struct {
	// PrincipalID - The user's principal id that the role gets assigned to
	PrincipalID *string `json:"principalId,omitempty"`
	// BillingRoleDefinitionName - The role definition id
	BillingRoleDefinitionName *string `json:"billingRoleDefinitionName,omitempty"`
}

// RoleAssignmentProperties the properties of the a role assignment.
type RoleAssignmentProperties struct {
	// CreatedOn - the date the role assignment is created
	CreatedOn *string `json:"createdOn,omitempty"`
	// CreatedByPrincipalTenantID - the creator's tenant Id
	CreatedByPrincipalTenantID *string `json:"createdByPrincipalTenantId,omitempty"`
	// CreatedByPrincipalID - the creator's principal Id
	CreatedByPrincipalID *string `json:"createdByPrincipalId,omitempty"`
	// Name - the name of the role assignment
	Name *string `json:"name,omitempty"`
	// PrincipalID - The user's principal id that the role gets assigned to
	PrincipalID *string `json:"principalId,omitempty"`
	// RoleDefinitionName - The role definition id
	RoleDefinitionName *string `json:"roleDefinitionName,omitempty"`
	// Scope - The scope the role get assigned to
	Scope *string `json:"scope,omitempty"`
}

// RoleDefinition result of get role definition for a role.
type RoleDefinition struct {
	autorest.Response `json:"-"`
	// RoleDefinitionProperties - The role definition for a role.
	*RoleDefinitionProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleDefinition.
func (rd RoleDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.RoleDefinitionProperties != nil {
		objectMap["properties"] = rd.RoleDefinitionProperties
	}
	if rd.ID != nil {
		objectMap["id"] = rd.ID
	}
	if rd.Name != nil {
		objectMap["name"] = rd.Name
	}
	if rd.Type != nil {
		objectMap["type"] = rd.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleDefinition struct.
func (rd *RoleDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var roleDefinitionProperties RoleDefinitionProperties
				err = json.Unmarshal(*v, &roleDefinitionProperties)
				if err != nil {
					return err
				}
				rd.RoleDefinitionProperties = &roleDefinitionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rd.Type = &typeVar
			}
		}
	}

	return nil
}

// RoleDefinitionListResult list the role definitions.
type RoleDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of role definitions.
	Value *[]RoleDefinition `json:"value,omitempty"`
}

// RoleDefinitionProperties the properties of the a role definition.
type RoleDefinitionProperties struct {
	// Description - The role description
	Description *string `json:"description,omitempty"`
	// PermissionsListResult - The billingPermissions the role has
	*PermissionsListResult `json:"permissions,omitempty"`
	// RoleName - The name of the role
	RoleName *string `json:"roleName,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleDefinitionProperties.
func (rdp RoleDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdp.Description != nil {
		objectMap["description"] = rdp.Description
	}
	if rdp.PermissionsListResult != nil {
		objectMap["permissions"] = rdp.PermissionsListResult
	}
	if rdp.RoleName != nil {
		objectMap["roleName"] = rdp.RoleName
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleDefinitionProperties struct.
func (rdp *RoleDefinitionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				rdp.Description = &description
			}
		case "permissions":
			if v != nil {
				var permissionsListResult PermissionsListResult
				err = json.Unmarshal(*v, &permissionsListResult)
				if err != nil {
					return err
				}
				rdp.PermissionsListResult = &permissionsListResult
			}
		case "roleName":
			if v != nil {
				var roleName string
				err = json.Unmarshal(*v, &roleName)
				if err != nil {
					return err
				}
				rdp.RoleName = &roleName
			}
		}
	}

	return nil
}

// SubscriptionProperties the usage context properties.
type SubscriptionProperties struct {
	// DisplayName - display name.
	DisplayName *string `json:"displayName,omitempty"`
	// SubscriptionID - Subscription Id.
	SubscriptionID *uuid.UUID `json:"subscriptionId,omitempty"`
	// SubscriptionBillingStatus - Subscription billing status. Possible values include: 'SubscriptionStatusTypeActive', 'SubscriptionStatusTypeInactive', 'SubscriptionStatusTypeAbandoned', 'SubscriptionStatusTypeDeleted', 'SubscriptionStatusTypeWarning'
	SubscriptionBillingStatus SubscriptionStatusType `json:"subscriptionBillingStatus,omitempty"`
	// LastMonthCharges - Last month charges.
	LastMonthCharges *Amount `json:"lastMonthCharges,omitempty"`
	// MonthToDateCharges - Month to date charges.
	MonthToDateCharges *Amount `json:"monthToDateCharges,omitempty"`
	// EnrollmentAccountContext - The enrollment account context.
	EnrollmentAccountContext *EnrollmentAccountContext `json:"enrollmentAccountContext,omitempty"`
	// BillingProfileID - Billing Profile id to which this product belongs.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileName - Billing Profile name to which this product belongs.
	BillingProfileName *string `json:"billingProfileName,omitempty"`
	// SkuID - The sku id.
	SkuID *string `json:"skuId,omitempty"`
	// SkuDescription - The sku description.
	SkuDescription *string `json:"skuDescription,omitempty"`
}

// SubscriptionsListResult result of listing billing subscriptions summary.
type SubscriptionsListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of billing subscriptions summary.
	Value *[]SubscriptionSummary `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubscriptionsListResultIterator provides access to a complete listing of SubscriptionSummary values.
type SubscriptionsListResultIterator struct {
	i    int
	page SubscriptionsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubscriptionsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubscriptionsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubscriptionsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubscriptionsListResultIterator) Response() SubscriptionsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubscriptionsListResultIterator) Value() SubscriptionSummary {
	if !iter.page.NotDone() {
		return SubscriptionSummary{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubscriptionsListResultIterator type.
func NewSubscriptionsListResultIterator(page SubscriptionsListResultPage) SubscriptionsListResultIterator {
	return SubscriptionsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SubscriptionsListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// subscriptionsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SubscriptionsListResult) subscriptionsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if slr.NextLink == nil || len(to.String(slr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SubscriptionsListResultPage contains a page of SubscriptionSummary values.
type SubscriptionsListResultPage struct {
	fn  func(context.Context, SubscriptionsListResult) (SubscriptionsListResult, error)
	slr SubscriptionsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubscriptionsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.slr)
	if err != nil {
		return err
	}
	page.slr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubscriptionsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubscriptionsListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubscriptionsListResultPage) Response() SubscriptionsListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubscriptionsListResultPage) Values() []SubscriptionSummary {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the SubscriptionsListResultPage type.
func NewSubscriptionsListResultPage(getNextPage func(context.Context, SubscriptionsListResult) (SubscriptionsListResult, error)) SubscriptionsListResultPage {
	return SubscriptionsListResultPage{fn: getNextPage}
}

// SubscriptionSummary a billing Subscription summary resource.
type SubscriptionSummary struct {
	autorest.Response       `json:"-"`
	*SubscriptionProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionSummary.
func (ss SubscriptionSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.SubscriptionProperties != nil {
		objectMap["properties"] = ss.SubscriptionProperties
	}
	if ss.ID != nil {
		objectMap["id"] = ss.ID
	}
	if ss.Name != nil {
		objectMap["name"] = ss.Name
	}
	if ss.Type != nil {
		objectMap["type"] = ss.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubscriptionSummary struct.
func (ss *SubscriptionSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subscriptionProperties SubscriptionProperties
				err = json.Unmarshal(*v, &subscriptionProperties)
				if err != nil {
					return err
				}
				ss.SubscriptionProperties = &subscriptionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ss.Type = &typeVar
			}
		}
	}

	return nil
}

// SubscriptionTransferFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SubscriptionTransferFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SubscriptionTransferFuture) Result(client SubscriptionClient) (tbsr TransferBillingSubscriptionResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.SubscriptionTransferFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.SubscriptionTransferFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tbsr.Response.Response, err = future.GetResult(sender); err == nil && tbsr.Response.Response.StatusCode != http.StatusNoContent {
		tbsr, err = client.TransferResponder(tbsr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.SubscriptionTransferFuture", "Result", tbsr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TransactionsListResult result of listing reservation transactions summary.
type TransactionsListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of reservation transactions summary.
	Value *[]TransactionsSummary `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TransactionsListResultIterator provides access to a complete listing of TransactionsSummary values.
type TransactionsListResultIterator struct {
	i    int
	page TransactionsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TransactionsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransactionsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TransactionsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TransactionsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TransactionsListResultIterator) Response() TransactionsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TransactionsListResultIterator) Value() TransactionsSummary {
	if !iter.page.NotDone() {
		return TransactionsSummary{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TransactionsListResultIterator type.
func NewTransactionsListResultIterator(page TransactionsListResultPage) TransactionsListResultIterator {
	return TransactionsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tlr TransactionsListResult) IsEmpty() bool {
	return tlr.Value == nil || len(*tlr.Value) == 0
}

// transactionsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tlr TransactionsListResult) transactionsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if tlr.NextLink == nil || len(to.String(tlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tlr.NextLink)))
}

// TransactionsListResultPage contains a page of TransactionsSummary values.
type TransactionsListResultPage struct {
	fn  func(context.Context, TransactionsListResult) (TransactionsListResult, error)
	tlr TransactionsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TransactionsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransactionsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tlr)
	if err != nil {
		return err
	}
	page.tlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TransactionsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TransactionsListResultPage) NotDone() bool {
	return !page.tlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TransactionsListResultPage) Response() TransactionsListResult {
	return page.tlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TransactionsListResultPage) Values() []TransactionsSummary {
	if page.tlr.IsEmpty() {
		return nil
	}
	return *page.tlr.Value
}

// Creates a new instance of the TransactionsListResultPage type.
func NewTransactionsListResultPage(getNextPage func(context.Context, TransactionsListResult) (TransactionsListResult, error)) TransactionsListResultPage {
	return TransactionsListResultPage{fn: getNextPage}
}

// TransactionsSummary a reservation transaction summary resource.
type TransactionsSummary struct {
	*TransactionsSummaryProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TransactionsSummary.
func (ts TransactionsSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ts.TransactionsSummaryProperties != nil {
		objectMap["properties"] = ts.TransactionsSummaryProperties
	}
	if ts.ID != nil {
		objectMap["id"] = ts.ID
	}
	if ts.Name != nil {
		objectMap["name"] = ts.Name
	}
	if ts.Type != nil {
		objectMap["type"] = ts.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransactionsSummary struct.
func (ts *TransactionsSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var transactionsSummaryProperties TransactionsSummaryProperties
				err = json.Unmarshal(*v, &transactionsSummaryProperties)
				if err != nil {
					return err
				}
				ts.TransactionsSummaryProperties = &transactionsSummaryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ts.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ts.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ts.Type = &typeVar
			}
		}
	}

	return nil
}

// TransactionsSummaryProperties the properties of the reservation transaction summary.
type TransactionsSummaryProperties struct {
	// Kind - The kind of transaction. Choices are all and reservation. Possible values include: 'All', 'Reservation'
	Kind TransactionTypeKind `json:"kind,omitempty"`
	// Date - The date of reservation transaction.
	Date *date.Time `json:"date,omitempty"`
	// Invoice - Invoice number or 'pending' if not invoiced.
	Invoice *string `json:"invoice,omitempty"`
	// OrderID - The reservation order id.
	OrderID *string `json:"orderId,omitempty"`
	// OrderName - The reservation order name.
	OrderName *string `json:"orderName,omitempty"`
	// ProductTypeID - The product type id.
	ProductTypeID *string `json:"productTypeId,omitempty"`
	// ProductType - The type of product.
	ProductType *string `json:"productType,omitempty"`
	// ProductDescription - Product description.
	ProductDescription *string `json:"productDescription,omitempty"`
	// TransactionType - Transaction types. Possible values include: 'Purchase', 'UsageCharge'
	TransactionType ReservationType `json:"transactionType,omitempty"`
	// TransactionAmount - Last charge associated with the purchase.
	TransactionAmount *Amount `json:"transactionAmount,omitempty"`
	// Quantity - Purchase quantity.
	Quantity *int32 `json:"quantity,omitempty"`
	// InvoiceSectionID - Invoice section id to which this product belongs.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// InvoiceSectionName - Invoice section name to which this product belongs.
	InvoiceSectionName *string `json:"invoiceSectionName,omitempty"`
	// BillingProfileID - Billing Profile id to which this product belongs.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileName - Billing Profile name to which this product belongs.
	BillingProfileName *string `json:"billingProfileName,omitempty"`
	// SubscriptionID - The subscription id.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// SubscriptionName - The subscription name.
	SubscriptionName *string `json:"subscriptionName,omitempty"`
}

// TransferBillingSubscriptionRequest request parameters to transfer billing subscription.
type TransferBillingSubscriptionRequest struct {
	// TransferBillingSubscriptionRequestProperties - Request parameters to transfer billing subscription.
	*TransferBillingSubscriptionRequestProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TransferBillingSubscriptionRequest.
func (tbsr TransferBillingSubscriptionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tbsr.TransferBillingSubscriptionRequestProperties != nil {
		objectMap["properties"] = tbsr.TransferBillingSubscriptionRequestProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransferBillingSubscriptionRequest struct.
func (tbsr *TransferBillingSubscriptionRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var transferBillingSubscriptionRequestProperties TransferBillingSubscriptionRequestProperties
				err = json.Unmarshal(*v, &transferBillingSubscriptionRequestProperties)
				if err != nil {
					return err
				}
				tbsr.TransferBillingSubscriptionRequestProperties = &transferBillingSubscriptionRequestProperties
			}
		}
	}

	return nil
}

// TransferBillingSubscriptionRequestProperties request parameters to transfer billing subscription.
type TransferBillingSubscriptionRequestProperties struct {
	// DestinationInvoiceSectionName - The destination invoiceSectionName.
	DestinationInvoiceSectionName *string `json:"destinationInvoiceSectionName,omitempty"`
}

// TransferBillingSubscriptionResult request parameters to transfer billing subscription.
type TransferBillingSubscriptionResult struct {
	autorest.Response `json:"-"`
	// TransferBillingSubscriptionResultProperties - Request parameters to transfer billing subscription.
	*TransferBillingSubscriptionResultProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TransferBillingSubscriptionResult.
func (tbsr TransferBillingSubscriptionResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tbsr.TransferBillingSubscriptionResultProperties != nil {
		objectMap["properties"] = tbsr.TransferBillingSubscriptionResultProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransferBillingSubscriptionResult struct.
func (tbsr *TransferBillingSubscriptionResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var transferBillingSubscriptionResultProperties TransferBillingSubscriptionResultProperties
				err = json.Unmarshal(*v, &transferBillingSubscriptionResultProperties)
				if err != nil {
					return err
				}
				tbsr.TransferBillingSubscriptionResultProperties = &transferBillingSubscriptionResultProperties
			}
		}
	}

	return nil
}

// TransferBillingSubscriptionResultProperties transfer billing subscription result properties.
type TransferBillingSubscriptionResultProperties struct {
	// BillingSubscriptionName - The destination billing subscription id.
	BillingSubscriptionName *string `json:"billingSubscriptionName,omitempty"`
}

// TransferDetails details of the transfer.
type TransferDetails struct {
	autorest.Response `json:"-"`
	// TransferProperties - Details of the transfer.
	*TransferProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TransferDetails.
func (td TransferDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if td.TransferProperties != nil {
		objectMap["properties"] = td.TransferProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransferDetails struct.
func (td *TransferDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var transferProperties TransferProperties
				err = json.Unmarshal(*v, &transferProperties)
				if err != nil {
					return err
				}
				td.TransferProperties = &transferProperties
			}
		}
	}

	return nil
}

// TransferDetailsListResult result of listing details of the transfer initiated by caller.
type TransferDetailsListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of transfers initiated by caller.
	Value *[]TransferDetails `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TransferDetailsListResultIterator provides access to a complete listing of TransferDetails values.
type TransferDetailsListResultIterator struct {
	i    int
	page TransferDetailsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TransferDetailsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransferDetailsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TransferDetailsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TransferDetailsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TransferDetailsListResultIterator) Response() TransferDetailsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TransferDetailsListResultIterator) Value() TransferDetails {
	if !iter.page.NotDone() {
		return TransferDetails{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TransferDetailsListResultIterator type.
func NewTransferDetailsListResultIterator(page TransferDetailsListResultPage) TransferDetailsListResultIterator {
	return TransferDetailsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tdlr TransferDetailsListResult) IsEmpty() bool {
	return tdlr.Value == nil || len(*tdlr.Value) == 0
}

// transferDetailsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tdlr TransferDetailsListResult) transferDetailsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if tdlr.NextLink == nil || len(to.String(tdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tdlr.NextLink)))
}

// TransferDetailsListResultPage contains a page of TransferDetails values.
type TransferDetailsListResultPage struct {
	fn   func(context.Context, TransferDetailsListResult) (TransferDetailsListResult, error)
	tdlr TransferDetailsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TransferDetailsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransferDetailsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tdlr)
	if err != nil {
		return err
	}
	page.tdlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TransferDetailsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TransferDetailsListResultPage) NotDone() bool {
	return !page.tdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TransferDetailsListResultPage) Response() TransferDetailsListResult {
	return page.tdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TransferDetailsListResultPage) Values() []TransferDetails {
	if page.tdlr.IsEmpty() {
		return nil
	}
	return *page.tdlr.Value
}

// Creates a new instance of the TransferDetailsListResultPage type.
func NewTransferDetailsListResultPage(getNextPage func(context.Context, TransferDetailsListResult) (TransferDetailsListResult, error)) TransferDetailsListResultPage {
	return TransferDetailsListResultPage{fn: getNextPage}
}

// TransferProductRequestProperties the properties of the product to initiate a transfer.
type TransferProductRequestProperties struct {
	// DestinationInvoiceSectionName - Destination invoice section id.
	DestinationInvoiceSectionName *string `json:"destinationInvoiceSectionName,omitempty"`
}

// TransferProperties transfer details
type TransferProperties struct {
	// CreationTime - Transfer creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ExpirationTime - Transfer expiration time.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// InvoiceSectionID - Target invoice section Id.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// BillingAccountID - Target billing account Id.
	BillingAccountID *string `json:"billingAccountId,omitempty"`
	// TransferStatus - Overall transfer status. Possible values include: 'TransferStatusPending', 'TransferStatusInProgress', 'TransferStatusCompleted', 'TransferStatusCompletedWithErrors', 'TransferStatusFailed', 'TransferStatusCanceled', 'TransferStatusDeclined'
	TransferStatus TransferStatus `json:"transferStatus,omitempty"`
	// RecipientEmailID - Email Id of recipient of transfer.
	RecipientEmailID *string `json:"recipientEmailId,omitempty"`
	// InitiatorEmailID - Email Id of initiator of transfer.
	InitiatorEmailID *string `json:"initiatorEmailId,omitempty"`
	// CanceledBy - Email Id who user canceled the transfer.
	CanceledBy *string `json:"canceledBy,omitempty"`
	// LastModifiedTime - Transfer last modification time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// DetailedTransferStatus - Detailed transfer status.
	DetailedTransferStatus *[]DetailedTransferStatus `json:"detailedTransferStatus,omitempty"`
}

// UpdateAutoRenewOperationSummary summary of cancel product operation
type UpdateAutoRenewOperationSummary struct {
	autorest.Response `json:"-"`
	// UpdateAutoRenewOperationSummaryProperties - Summary of update auto renew operation summary properties
	*UpdateAutoRenewOperationSummaryProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateAutoRenewOperationSummary.
func (uaros UpdateAutoRenewOperationSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uaros.UpdateAutoRenewOperationSummaryProperties != nil {
		objectMap["properties"] = uaros.UpdateAutoRenewOperationSummaryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateAutoRenewOperationSummary struct.
func (uaros *UpdateAutoRenewOperationSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateAutoRenewOperationSummaryProperties UpdateAutoRenewOperationSummaryProperties
				err = json.Unmarshal(*v, &updateAutoRenewOperationSummaryProperties)
				if err != nil {
					return err
				}
				uaros.UpdateAutoRenewOperationSummaryProperties = &updateAutoRenewOperationSummaryProperties
			}
		}
	}

	return nil
}

// UpdateAutoRenewOperationSummaryProperties update auto renew operation summary properties
type UpdateAutoRenewOperationSummaryProperties struct {
	// EndDate - The end date of this asset
	EndDate *date.Time `json:"endDate,omitempty"`
}

// UpdateAutoRenewRequest request parameters to update auto renew for support product.
type UpdateAutoRenewRequest struct {
	// AutoRenew - Request parameters to update auto renew policy a product. Possible values include: 'True', 'False'
	AutoRenew UpdateAutoRenew `json:"autoRenew,omitempty"`
}
