package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartTasks invokes the cms.StartTasks API synchronously
// api document: https://help.aliyun.com/api/cms/starttasks.html
func (client *Client) StartTasks(request *StartTasksRequest) (response *StartTasksResponse, err error) {
	response = CreateStartTasksResponse()
	err = client.DoAction(request, response)
	return
}

// StartTasksWithChan invokes the cms.StartTasks API asynchronously
// api document: https://help.aliyun.com/api/cms/starttasks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartTasksWithChan(request *StartTasksRequest) (<-chan *StartTasksResponse, <-chan error) {
	responseChan := make(chan *StartTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartTasksWithCallback invokes the cms.StartTasks API asynchronously
// api document: https://help.aliyun.com/api/cms/starttasks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartTasksWithCallback(request *StartTasksRequest, callback func(response *StartTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartTasksResponse
		var err error
		defer close(result)
		response, err = client.StartTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartTasksRequest is the request struct for api StartTasks
type StartTasksRequest struct {
	*requests.RpcRequest
	TaskIds string `position:"Query" name:"TaskIds"`
}

// StartTasksResponse is the response struct for api StartTasks
type StartTasksResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   string `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateStartTasksRequest creates a request to invoke StartTasks API
func CreateStartTasksRequest() (request *StartTasksRequest) {
	request = &StartTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "StartTasks", "cms", "openAPI")
	return
}

// CreateStartTasksResponse creates a response to parse from StartTasks response
func CreateStartTasksResponse() (response *StartTasksResponse) {
	response = &StartTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
