package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GatherLogsToken invokes the cs.GatherLogsToken API synchronously
// api document: https://help.aliyun.com/api/cs/gatherlogstoken.html
func (client *Client) GatherLogsToken(request *GatherLogsTokenRequest) (response *GatherLogsTokenResponse, err error) {
	response = CreateGatherLogsTokenResponse()
	err = client.DoAction(request, response)
	return
}

// GatherLogsTokenWithChan invokes the cs.GatherLogsToken API asynchronously
// api document: https://help.aliyun.com/api/cs/gatherlogstoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GatherLogsTokenWithChan(request *GatherLogsTokenRequest) (<-chan *GatherLogsTokenResponse, <-chan error) {
	responseChan := make(chan *GatherLogsTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GatherLogsToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GatherLogsTokenWithCallback invokes the cs.GatherLogsToken API asynchronously
// api document: https://help.aliyun.com/api/cs/gatherlogstoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GatherLogsTokenWithCallback(request *GatherLogsTokenRequest, callback func(response *GatherLogsTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GatherLogsTokenResponse
		var err error
		defer close(result)
		response, err = client.GatherLogsToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GatherLogsTokenRequest is the request struct for api GatherLogsToken
type GatherLogsTokenRequest struct {
	*requests.RoaRequest
	Token string `position:"Path" name:"Token"`
}

// GatherLogsTokenResponse is the response struct for api GatherLogsToken
type GatherLogsTokenResponse struct {
	*responses.BaseResponse
}

// CreateGatherLogsTokenRequest creates a request to invoke GatherLogsToken API
func CreateGatherLogsTokenRequest() (request *GatherLogsTokenRequest) {
	request = &GatherLogsTokenRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "GatherLogsToken", "/token/[Token]/gather_logs", "", "")
	request.Method = requests.POST
	return
}

// CreateGatherLogsTokenResponse creates a response to parse from GatherLogsToken response
func CreateGatherLogsTokenResponse() (response *GatherLogsTokenResponse) {
	response = &GatherLogsTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
