package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSignContractUrl invokes the finmall.GetSignContractUrl API synchronously
// api document: https://help.aliyun.com/api/finmall/getsigncontracturl.html
func (client *Client) GetSignContractUrl(request *GetSignContractUrlRequest) (response *GetSignContractUrlResponse, err error) {
	response = CreateGetSignContractUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetSignContractUrlWithChan invokes the finmall.GetSignContractUrl API asynchronously
// api document: https://help.aliyun.com/api/finmall/getsigncontracturl.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSignContractUrlWithChan(request *GetSignContractUrlRequest) (<-chan *GetSignContractUrlResponse, <-chan error) {
	responseChan := make(chan *GetSignContractUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSignContractUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSignContractUrlWithCallback invokes the finmall.GetSignContractUrl API asynchronously
// api document: https://help.aliyun.com/api/finmall/getsigncontracturl.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSignContractUrlWithCallback(request *GetSignContractUrlRequest, callback func(response *GetSignContractUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSignContractUrlResponse
		var err error
		defer close(result)
		response, err = client.GetSignContractUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSignContractUrlRequest is the request struct for api GetSignContractUrl
type GetSignContractUrlRequest struct {
	*requests.RpcRequest
	ExtInfo   string `position:"Query" name:"ExtInfo"`
	BizId     string `position:"Query" name:"BizId"`
	SceneId   string `position:"Query" name:"SceneId"`
	ReturnUrl string `position:"Query" name:"ReturnUrl"`
	UserId    string `position:"Query" name:"UserId"`
}

// GetSignContractUrlResponse is the response struct for api GetSignContractUrl
type GetSignContractUrlResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetSignContractUrlRequest creates a request to invoke GetSignContractUrl API
func CreateGetSignContractUrlRequest() (request *GetSignContractUrlRequest) {
	request = &GetSignContractUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "GetSignContractUrl", "finmall", "openAPI")
	return
}

// CreateGetSignContractUrlResponse creates a response to parse from GetSignContractUrl response
func CreateGetSignContractUrlResponse() (response *GetSignContractUrlResponse) {
	response = &GetSignContractUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
