package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifySMSToken invokes the finmall.VerifySMSToken API synchronously
// api document: https://help.aliyun.com/api/finmall/verifysmstoken.html
func (client *Client) VerifySMSToken(request *VerifySMSTokenRequest) (response *VerifySMSTokenResponse, err error) {
	response = CreateVerifySMSTokenResponse()
	err = client.DoAction(request, response)
	return
}

// VerifySMSTokenWithChan invokes the finmall.VerifySMSToken API asynchronously
// api document: https://help.aliyun.com/api/finmall/verifysmstoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) VerifySMSTokenWithChan(request *VerifySMSTokenRequest) (<-chan *VerifySMSTokenResponse, <-chan error) {
	responseChan := make(chan *VerifySMSTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifySMSToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifySMSTokenWithCallback invokes the finmall.VerifySMSToken API asynchronously
// api document: https://help.aliyun.com/api/finmall/verifysmstoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) VerifySMSTokenWithCallback(request *VerifySMSTokenRequest, callback func(response *VerifySMSTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifySMSTokenResponse
		var err error
		defer close(result)
		response, err = client.VerifySMSToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifySMSTokenRequest is the request struct for api VerifySMSToken
type VerifySMSTokenRequest struct {
	*requests.RpcRequest
	ActionType string `position:"Query" name:"ActionType"`
	UserId     string `position:"Query" name:"UserId"`
}

// VerifySMSTokenResponse is the response struct for api VerifySMSToken
type VerifySMSTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
}

// CreateVerifySMSTokenRequest creates a request to invoke VerifySMSToken API
func CreateVerifySMSTokenRequest() (request *VerifySMSTokenRequest) {
	request = &VerifySMSTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "VerifySMSToken", "finmall", "openAPI")
	return
}

// CreateVerifySMSTokenResponse creates a response to parse from VerifySMSToken response
func CreateVerifySMSTokenResponse() (response *VerifySMSTokenResponse) {
	response = &VerifySMSTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
