// Code generated by gen_tests.py and process_polyglot.py.
// Do not edit this file directly.
// The template for this file is located at:
// ../template.go.tpl
package reql_tests

import (
	"testing"
	"time"

	"github.com/stretchr/testify/suite"
	r "gopkg.in/gorethink/gorethink.v4"
	"gopkg.in/gorethink/gorethink.v4/internal/compare"
)

// Tests that manipulation data in tables
func TestSelectionSuite(t *testing.T) {
	suite.Run(t, new(SelectionSuite))
}

type SelectionSuite struct {
	suite.Suite

	session *r.Session
}

func (suite *SelectionSuite) SetupTest() {
	suite.T().Log("Setting up SelectionSuite")
	// Use imports to prevent errors
	_ = time.Time{}
	_ = compare.AnythingIsFine

	session, err := r.Connect(r.ConnectOpts{
		Address: url,
	})
	suite.Require().NoError(err, "Error returned when connecting to server")
	suite.session = session

	r.DBDrop("test").Exec(suite.session)
	err = r.DBCreate("test").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Wait().Exec(suite.session)
	suite.Require().NoError(err)

	r.DB("test").TableDrop("tbl").Exec(suite.session)
	err = r.DB("test").TableCreate("tbl").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Table("tbl").Wait().Exec(suite.session)
	suite.Require().NoError(err)
	r.DB("test").TableDrop("tbl2").Exec(suite.session)
	err = r.DB("test").TableCreate("tbl2").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Table("tbl2").Wait().Exec(suite.session)
	suite.Require().NoError(err)
	r.DB("test").TableDrop("tbl3").Exec(suite.session)
	err = r.DB("test").TableCreate("tbl3").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Table("tbl3").Wait().Exec(suite.session)
	suite.Require().NoError(err)
}

func (suite *SelectionSuite) TearDownSuite() {
	suite.T().Log("Tearing down SelectionSuite")

	if suite.session != nil {
		r.DB("rethinkdb").Table("_debug_scratch").Delete().Exec(suite.session)
		r.DB("test").TableDrop("tbl").Exec(suite.session)
		r.DB("test").TableDrop("tbl2").Exec(suite.session)
		r.DB("test").TableDrop("tbl3").Exec(suite.session)
		r.DBDrop("test").Exec(suite.session)

		suite.session.Close()
	}
}

func (suite *SelectionSuite) TestCases() {
	suite.T().Log("Running SelectionSuite: Tests that manipulation data in tables")

	tbl := r.DB("test").Table("tbl")
	_ = tbl // Prevent any noused variable errors
	tbl2 := r.DB("test").Table("tbl2")
	_ = tbl2 // Prevent any noused variable errors
	tbl3 := r.DB("test").Table("tbl3")
	_ = tbl3 // Prevent any noused variable errors

	{
		// selection.yaml line #6
		/* ({'deleted':0.0,'replaced':0.0,'unchanged':0.0,'errors':0.0,'skipped':0.0,'inserted':100}) */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0.0, "replaced": 0.0, "unchanged": 0.0, "errors": 0.0, "skipped": 0.0, "inserted": 100}
		/* tbl.insert([{'id':i, 'a':i%4} for i in xrange(100)]) */

		suite.T().Log("About to run line #6: tbl.Insert((func() []interface{} {\n    res := []interface{}{}\n    for iterator_ := 0; iterator_ < 100; iterator_++ {\n        i := iterator_\n        res = append(res, map[interface{}]interface{}{'id': i, 'a': r.Mod(i, 4), })\n    }\n    return res\n}()))")

		runAndAssert(suite.Suite, expected_, tbl.Insert((func() []interface{} {
			res := []interface{}{}
			for iterator_ := 0; iterator_ < 100; iterator_++ {
				i := iterator_
				res = append(res, map[interface{}]interface{}{"id": i, "a": r.Mod(i, 4)})
			}
			return res
		}())), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #6")
	}

	{
		// selection.yaml line #18
		/* ({'deleted':0.0,'replaced':0.0,'unchanged':0.0,'errors':0.0,'skipped':0.0,'inserted':100}) */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0.0, "replaced": 0.0, "unchanged": 0.0, "errors": 0.0, "skipped": 0.0, "inserted": 100}
		/* tbl2.insert([{'id':i, 'b':i%4} for i in xrange(100)]) */

		suite.T().Log("About to run line #18: tbl2.Insert((func() []interface{} {\n    res := []interface{}{}\n    for iterator_ := 0; iterator_ < 100; iterator_++ {\n        i := iterator_\n        res = append(res, map[interface{}]interface{}{'id': i, 'b': r.Mod(i, 4), })\n    }\n    return res\n}()))")

		runAndAssert(suite.Suite, expected_, tbl2.Insert((func() []interface{} {
			res := []interface{}{}
			for iterator_ := 0; iterator_ < 100; iterator_++ {
				i := iterator_
				res = append(res, map[interface{}]interface{}{"id": i, "b": r.Mod(i, 4)})
			}
			return res
		}())), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #18")
	}

	{
		// selection.yaml line #31
		/* 'TABLE' */
		var expected_ string = "TABLE"
		/* tbl.type_of() */

		suite.T().Log("About to run line #31: tbl.TypeOf()")

		runAndAssert(suite.Suite, expected_, tbl.TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #31")
	}

	{
		// selection.yaml line #35
		/* err("ReqlOpFailedError", 'Database `missing` does not exist.', [0]) */
		var expected_ Err = err("ReqlOpFailedError", "Database `missing` does not exist.")
		/* r.db('missing').table('bar') */

		suite.T().Log("About to run line #35: r.DB('missing').Table('bar')")

		runAndAssert(suite.Suite, expected_, r.DB("missing").Table("bar"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #35")
	}

	{
		// selection.yaml line #39
		/* err("ReqlOpFailedError", 'Table `test.missing` does not exist.', [0]) */
		var expected_ Err = err("ReqlOpFailedError", "Table `test.missing` does not exist.")
		/* r.db('test').table('missing') */

		suite.T().Log("About to run line #39: r.DB('test').Table('missing')")

		runAndAssert(suite.Suite, expected_, r.DB("test").Table("missing"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #39")
	}

	{
		// selection.yaml line #43
		/* ({"errors":1,"inserted":0}) */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"errors": 1, "inserted": 0}
		/* tbl.insert({"id":"\x00"}).pluck("errors","inserted") */

		suite.T().Log("About to run line #43: tbl.Insert(map[interface{}]interface{}{'id': '\\u0000', }).Pluck('errors', 'inserted')")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": "\u0000"}).Pluck("errors", "inserted"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #43")
	}

	{
		// selection.yaml line #46
		/* ({"errors":1,"inserted":0}) */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"errors": 1, "inserted": 0}
		/* tbl.insert({"id":["embedded",["null\x00"]]}).pluck("errors","inserted") */

		suite.T().Log("About to run line #46: tbl.Insert(map[interface{}]interface{}{'id': []interface{}{'embedded', []interface{}{'null\\u0000'}}, }).Pluck('errors', 'inserted')")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": []interface{}{"embedded", []interface{}{"null\u0000"}}}).Pluck("errors", "inserted"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #46")
	}

	{
		// selection.yaml line #51
		/* ({'deleted':0.0,'replaced':0.0,'unchanged':0.0,'errors':0.0,'skipped':0.0,'inserted':1}) */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0.0, "replaced": 0.0, "unchanged": 0.0, "errors": 0.0, "skipped": 0.0, "inserted": 1}
		/* tbl3.insert({'id':u'Здравствуй','value':u'Земля!'}) */

		suite.T().Log("About to run line #51: tbl3.Insert(map[interface{}]interface{}{'id': 'Здравствуй', 'value': 'Земля!', })")

		runAndAssert(suite.Suite, expected_, tbl3.Insert(map[interface{}]interface{}{"id": "Здравствуй", "value": "Земля!"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #51")
	}

	{
		// selection.yaml line #60
		/* {u'id':u'Здравствуй',u'value':u'Земля!'} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": "Здравствуй", "value": "Земля!"}
		/* tbl3.get('Здравствуй') */

		suite.T().Log("About to run line #60: tbl3.Get('Здравствуй')")

		runAndAssert(suite.Suite, expected_, tbl3.Get("Здравствуй"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #60")
	}

	{
		// selection.yaml line #73
		/* [{u'id':u'Здравствуй',u'value':u'Земля!'}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"id": "Здравствуй", "value": "Земля!"}}
		/* tbl3.filter({'value':'Земля!'}) */

		suite.T().Log("About to run line #73: tbl3.Filter(map[interface{}]interface{}{'value': 'Земля!', })")

		runAndAssert(suite.Suite, expected_, tbl3.Filter(map[interface{}]interface{}{"value": "Земля!"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #73")
	}

	{
		// selection.yaml line #86
		/* err("ReqlQueryLogicError", 'Database name `%` invalid (Use A-Za-z0-9_ only).', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Database name `%` invalid (Use A-Za-z0-9_ only).")
		/* r.db('%') */

		suite.T().Log("About to run line #86: r.DB('%')")

		runAndAssert(suite.Suite, expected_, r.DB("%"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #86")
	}

	{
		// selection.yaml line #89
		/* err("ReqlQueryLogicError", 'Table name `%` invalid (Use A-Za-z0-9_ only).', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Table name `%` invalid (Use A-Za-z0-9_ only).")
		/* r.db('test').table('%') */

		suite.T().Log("About to run line #89: r.DB('test').Table('%')")

		runAndAssert(suite.Suite, expected_, r.DB("test").Table("%"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #89")
	}

	{
		// selection.yaml line #93
		/* 100 */
		var expected_ int = 100
		/* tbl.count() */

		suite.T().Log("About to run line #93: tbl.Count()")

		runAndAssert(suite.Suite, expected_, tbl.Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #93")
	}

	// selection.yaml line #97
	// tbl2Name = tbl2.info().get_field('name')
	suite.T().Log("Possibly executing: var tbl2Name r.Term = tbl2.Info().Field('name')")

	tbl2Name := tbl2.Info().Field("name")
	_ = tbl2Name // Prevent any noused variable errors

	// selection.yaml line #98
	// tbl2DbName = tbl2.info().get_field('db').get_field('name')
	suite.T().Log("Possibly executing: var tbl2DbName r.Term = tbl2.Info().Field('db').Field('name')")

	tbl2DbName := tbl2.Info().Field("db").Field("name")
	_ = tbl2DbName // Prevent any noused variable errors

	{
		// selection.yaml line #101
		/* 100 */
		var expected_ int = 100
		/* r.db(tbl2DbName).table(tbl2Name, read_mode='outdated').count() */

		suite.T().Log("About to run line #101: r.DB(tbl2DbName).Table(tbl2Name).OptArgs(r.TableOpts{ReadMode: 'outdated', }).Count()")

		runAndAssert(suite.Suite, expected_, r.DB(tbl2DbName).Table(tbl2Name).OptArgs(r.TableOpts{ReadMode: "outdated"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #101")
	}

	{
		// selection.yaml line #102
		/* 100 */
		var expected_ int = 100
		/* r.db(tbl2DbName).table(tbl2Name, read_mode='single').count() */

		suite.T().Log("About to run line #102: r.DB(tbl2DbName).Table(tbl2Name).OptArgs(r.TableOpts{ReadMode: 'single', }).Count()")

		runAndAssert(suite.Suite, expected_, r.DB(tbl2DbName).Table(tbl2Name).OptArgs(r.TableOpts{ReadMode: "single"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #102")
	}

	{
		// selection.yaml line #103
		/* 100 */
		var expected_ int = 100
		/* r.db(tbl2DbName).table(tbl2Name, read_mode='majority').count() */

		suite.T().Log("About to run line #103: r.DB(tbl2DbName).Table(tbl2Name).OptArgs(r.TableOpts{ReadMode: 'majority', }).Count()")

		runAndAssert(suite.Suite, expected_, r.DB(tbl2DbName).Table(tbl2Name).OptArgs(r.TableOpts{ReadMode: "majority"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #103")
	}

	{
		// selection.yaml line #120
		/* err("ReqlQueryLogicError", 'Expected type STRING but found BOOL.') */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type STRING but found BOOL.")
		/* r.db(tbl2DbName).table(tbl2Name, read_mode=true).count() */

		suite.T().Log("About to run line #120: r.DB(tbl2DbName).Table(tbl2Name).OptArgs(r.TableOpts{ReadMode: true, }).Count()")

		runAndAssert(suite.Suite, expected_, r.DB(tbl2DbName).Table(tbl2Name).OptArgs(r.TableOpts{ReadMode: true}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #120")
	}

	{
		// selection.yaml line #125
		/* err("ReqlQueryLogicError", 'Read mode `fake` unrecognized (options are "majority", "single", and "outdated").') */
		var expected_ Err = err("ReqlQueryLogicError", "Read mode `fake` unrecognized (options are \"majority\", \"single\", and \"outdated\").")
		/* r.db(tbl2DbName).table(tbl2Name, read_mode='fake').count() */

		suite.T().Log("About to run line #125: r.DB(tbl2DbName).Table(tbl2Name).OptArgs(r.TableOpts{ReadMode: 'fake', }).Count()")

		runAndAssert(suite.Suite, expected_, r.DB(tbl2DbName).Table(tbl2Name).OptArgs(r.TableOpts{ReadMode: "fake"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #125")
	}

	{
		// selection.yaml line #130
		/* 2 */
		var expected_ int = 2
		/* tbl.get(20).count() */

		suite.T().Log("About to run line #130: tbl.Get(20).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Get(20).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #130")
	}

	{
		// selection.yaml line #134
		/* {'id':20,'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 20, "a": 0}
		/* tbl.get(20) */

		suite.T().Log("About to run line #134: tbl.Get(20)")

		runAndAssert(suite.Suite, expected_, tbl.Get(20), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #134")
	}

	{
		// selection.yaml line #138
		/* null */
		var expected_ interface{} = nil
		/* tbl.get(2000) */

		suite.T().Log("About to run line #138: tbl.Get(2000)")

		runAndAssert(suite.Suite, expected_, tbl.Get(2000), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #138")
	}

	// selection.yaml line #153
	// tblpkey = r.db('test').table('testpkey')
	suite.T().Log("Possibly executing: var tblpkey r.Term = r.DB('test').Table('testpkey')")

	tblpkey := r.DB("test").Table("testpkey")
	_ = tblpkey // Prevent any noused variable errors

	{
		// selection.yaml line #149
		/* partial({'tables_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1})
		/* r.db('test').table_create('testpkey', primary_key='foo') */

		suite.T().Log("About to run line #149: r.DB('test').TableCreate('testpkey').OptArgs(r.TableCreateOpts{PrimaryKey: 'foo', })")

		runAndAssert(suite.Suite, expected_, r.DB("test").TableCreate("testpkey").OptArgs(r.TableCreateOpts{PrimaryKey: "foo"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #149")
	}

	{
		// selection.yaml line #155
		/* {'deleted':0.0,'replaced':0.0,'unchanged':0.0,'errors':0.0,'skipped':0.0,'inserted':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0.0, "replaced": 0.0, "unchanged": 0.0, "errors": 0.0, "skipped": 0.0, "inserted": 1}
		/* tblpkey.insert({'foo':10,'a':10}) */

		suite.T().Log("About to run line #155: tblpkey.Insert(map[interface{}]interface{}{'foo': 10, 'a': 10, })")

		runAndAssert(suite.Suite, expected_, tblpkey.Insert(map[interface{}]interface{}{"foo": 10, "a": 10}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #155")
	}

	{
		// selection.yaml line #159
		/* {'foo':10,'a':10} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"foo": 10, "a": 10}
		/* tblpkey.get(10) */

		suite.T().Log("About to run line #159: tblpkey.Get(10)")

		runAndAssert(suite.Suite, expected_, tblpkey.Get(10), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #159")
	}

	{
		// selection.yaml line #163
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* tbl.get_all() */

		suite.T().Log("About to run line #163: tbl.GetAll()")

		runAndAssert(suite.Suite, expected_, tbl.GetAll(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #163")
	}

	{
		// selection.yaml line #165
		/* [{"id":20,"a":0}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"id": 20, "a": 0}}
		/* tbl.get_all(20) */

		suite.T().Log("About to run line #165: tbl.GetAll(20)")

		runAndAssert(suite.Suite, expected_, tbl.GetAll(20), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #165")
	}

	{
		// selection.yaml line #167
		/* "SELECTION<STREAM>" */
		var expected_ string = "SELECTION<STREAM>"
		/* tbl.get_all().type_of() */

		suite.T().Log("About to run line #167: tbl.GetAll().TypeOf()")

		runAndAssert(suite.Suite, expected_, tbl.GetAll().TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #167")
	}

	{
		// selection.yaml line #169
		/* "SELECTION<STREAM>" */
		var expected_ string = "SELECTION<STREAM>"
		/* tbl.get_all(20).type_of() */

		suite.T().Log("About to run line #169: tbl.GetAll(20).TypeOf()")

		runAndAssert(suite.Suite, expected_, tbl.GetAll(20).TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #169")
	}

	{
		// selection.yaml line #173
		/* 'TABLE_SLICE' */
		var expected_ string = "TABLE_SLICE"
		/* tbl.between(2, 1).type_of() */

		suite.T().Log("About to run line #173: tbl.Between(2, 1).TypeOf()")

		runAndAssert(suite.Suite, expected_, tbl.Between(2, 1).TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #173")
	}

	{
		// selection.yaml line #175
		/* 'TABLE_SLICE' */
		var expected_ string = "TABLE_SLICE"
		/* tbl.between(1, 2).type_of() */

		suite.T().Log("About to run line #175: tbl.Between(1, 2).TypeOf()")

		runAndAssert(suite.Suite, expected_, tbl.Between(1, 2).TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #175")
	}

	{
		// selection.yaml line #177
		/* 'TABLE_SLICE' */
		var expected_ string = "TABLE_SLICE"
		/* tbl.between(1, 2, index='id').type_of() */

		suite.T().Log("About to run line #177: tbl.Between(1, 2).OptArgs(r.BetweenOpts{Index: 'id', }).TypeOf()")

		runAndAssert(suite.Suite, expected_, tbl.Between(1, 2).OptArgs(r.BetweenOpts{Index: "id"}).TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #177")
	}

	{
		// selection.yaml line #181
		/* 'TABLE_SLICE' */
		var expected_ string = "TABLE_SLICE"
		/* tbl.between(1, 1, right_bound='closed').type_of() */

		suite.T().Log("About to run line #181: tbl.Between(1, 1).OptArgs(r.BetweenOpts{RightBound: 'closed', }).TypeOf()")

		runAndAssert(suite.Suite, expected_, tbl.Between(1, 1).OptArgs(r.BetweenOpts{RightBound: "closed"}).TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #181")
	}

	{
		// selection.yaml line #185
		/* 'TABLE_SLICE' */
		var expected_ string = "TABLE_SLICE"
		/* tbl.between(2, 1).type_of() */

		suite.T().Log("About to run line #185: tbl.Between(2, 1).TypeOf()")

		runAndAssert(suite.Suite, expected_, tbl.Between(2, 1).TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #185")
	}

	{
		// selection.yaml line #187
		/* 'TABLE_SLICE' */
		var expected_ string = "TABLE_SLICE"
		/* tbl.between(2, 1, index='id').type_of() */

		suite.T().Log("About to run line #187: tbl.Between(2, 1).OptArgs(r.BetweenOpts{Index: 'id', }).TypeOf()")

		runAndAssert(suite.Suite, expected_, tbl.Between(2, 1).OptArgs(r.BetweenOpts{Index: "id"}).TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #187")
	}

	{
		// selection.yaml line #192
		/* 0 */
		var expected_ int = 0
		/* tbl.between(21, 20).count() */

		suite.T().Log("About to run line #192: tbl.Between(21, 20).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(21, 20).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #192")
	}

	{
		// selection.yaml line #194
		/* 9 */
		var expected_ int = 9
		/* tbl.between(20, 29).count() */

		suite.T().Log("About to run line #194: tbl.Between(20, 29).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(20, 29).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #194")
	}

	{
		// selection.yaml line #196
		/* 9 */
		var expected_ int = 9
		/* tbl.between(-10, 9).count() */

		suite.T().Log("About to run line #196: tbl.Between(-10, 9).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(-10, 9).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #196")
	}

	{
		// selection.yaml line #198
		/* 20 */
		var expected_ int = 20
		/* tbl.between(80, 2000).count() */

		suite.T().Log("About to run line #198: tbl.Between(80, 2000).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(80, 2000).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #198")
	}

	{
		// selection.yaml line #200
		/* 100 */
		var expected_ int = 100
		/* tbl.between(-2000, 2000).count() */

		suite.T().Log("About to run line #200: tbl.Between(-2000, 2000).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(-2000, 2000).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #200")
	}

	{
		// selection.yaml line #205
		/* 10 */
		var expected_ int = 10
		/* tbl.between(20, 29, right_bound='closed').count() */

		suite.T().Log("About to run line #205: tbl.Between(20, 29).OptArgs(r.BetweenOpts{RightBound: 'closed', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(20, 29).OptArgs(r.BetweenOpts{RightBound: "closed"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #205")
	}

	{
		// selection.yaml line #209
		/* 10 */
		var expected_ int = 10
		/* tbl.between(-10, 9, right_bound='closed').count() */

		suite.T().Log("About to run line #209: tbl.Between(-10, 9).OptArgs(r.BetweenOpts{RightBound: 'closed', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(-10, 9).OptArgs(r.BetweenOpts{RightBound: "closed"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #209")
	}

	{
		// selection.yaml line #213
		/* 20 */
		var expected_ int = 20
		/* tbl.between(80, 2000, right_bound='closed').count() */

		suite.T().Log("About to run line #213: tbl.Between(80, 2000).OptArgs(r.BetweenOpts{RightBound: 'closed', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(80, 2000).OptArgs(r.BetweenOpts{RightBound: "closed"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #213")
	}

	{
		// selection.yaml line #217
		/* 100 */
		var expected_ int = 100
		/* tbl.between(-2000, 2000, right_bound='closed').count() */

		suite.T().Log("About to run line #217: tbl.Between(-2000, 2000).OptArgs(r.BetweenOpts{RightBound: 'closed', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(-2000, 2000).OptArgs(r.BetweenOpts{RightBound: "closed"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #217")
	}

	{
		// selection.yaml line #223
		/* 8 */
		var expected_ int = 8
		/* tbl.between(20, 29, left_bound='open').count() */

		suite.T().Log("About to run line #223: tbl.Between(20, 29).OptArgs(r.BetweenOpts{LeftBound: 'open', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(20, 29).OptArgs(r.BetweenOpts{LeftBound: "open"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #223")
	}

	{
		// selection.yaml line #227
		/* 9 */
		var expected_ int = 9
		/* tbl.between(-10, 9, left_bound='open').count() */

		suite.T().Log("About to run line #227: tbl.Between(-10, 9).OptArgs(r.BetweenOpts{LeftBound: 'open', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(-10, 9).OptArgs(r.BetweenOpts{LeftBound: "open"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #227")
	}

	{
		// selection.yaml line #231
		/* 19 */
		var expected_ int = 19
		/* tbl.between(80, 2000, left_bound='open').count() */

		suite.T().Log("About to run line #231: tbl.Between(80, 2000).OptArgs(r.BetweenOpts{LeftBound: 'open', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(80, 2000).OptArgs(r.BetweenOpts{LeftBound: "open"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #231")
	}

	{
		// selection.yaml line #235
		/* 100 */
		var expected_ int = 100
		/* tbl.between(-2000, 2000, left_bound='open').count() */

		suite.T().Log("About to run line #235: tbl.Between(-2000, 2000).OptArgs(r.BetweenOpts{LeftBound: 'open', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(-2000, 2000).OptArgs(r.BetweenOpts{LeftBound: "open"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #235")
	}

	{
		// selection.yaml line #240
		/* err('ReqlQueryLogicError', 'Expected type TABLE_SLICE but found DATUM:', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type TABLE_SLICE but found DATUM:")
		/* r.expr([1, 2, 3]).between(-1, 2) */

		suite.T().Log("About to run line #240: r.Expr([]interface{}{1, 2, 3}).Between(-1, 2)")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1, 2, 3}).Between(-1, 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #240")
	}

	{
		// selection.yaml line #244
		/* 2 */
		var expected_ int = 2
		/* tbl.between(r.minval, 2).count() */

		suite.T().Log("About to run line #244: tbl.Between(r.MinVal, 2).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(r.MinVal, 2).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #244")
	}

	{
		// selection.yaml line #247
		/* 3 */
		var expected_ int = 3
		/* tbl.between(r.minval, 2, right_bound='closed').count() */

		suite.T().Log("About to run line #247: tbl.Between(r.MinVal, 2).OptArgs(r.BetweenOpts{RightBound: 'closed', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(r.MinVal, 2).OptArgs(r.BetweenOpts{RightBound: "closed"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #247")
	}

	{
		// selection.yaml line #251
		/* 2 */
		var expected_ int = 2
		/* tbl.between(r.minval, 2, left_bound='open').count() */

		suite.T().Log("About to run line #251: tbl.Between(r.MinVal, 2).OptArgs(r.BetweenOpts{LeftBound: 'open', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(r.MinVal, 2).OptArgs(r.BetweenOpts{LeftBound: "open"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #251")
	}

	{
		// selection.yaml line #255
		/* 98 */
		var expected_ int = 98
		/* tbl.between(2, r.maxval).count() */

		suite.T().Log("About to run line #255: tbl.Between(2, r.MaxVal).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(2, r.MaxVal).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #255")
	}

	{
		// selection.yaml line #265
		/* err('ReqlQueryLogicError', 'Cannot use `nu' + 'll` in BETWEEN, use `r.minval` or `r.maxval` to denote unboundedness.') */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot use `nu"+"ll` in BETWEEN, use `r.minval` or `r.maxval` to denote unboundedness.")
		/* tbl.between(null, 2).count() */

		suite.T().Log("About to run line #265: tbl.Between(nil, 2).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(nil, 2).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #265")
	}

	{
		// selection.yaml line #266
		/* err('ReqlQueryLogicError', 'Cannot use `nu' + 'll` in BETWEEN, use `r.minval` or `r.maxval` to denote unboundedness.') */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot use `nu"+"ll` in BETWEEN, use `r.minval` or `r.maxval` to denote unboundedness.")
		/* tbl.between(2, null).count() */

		suite.T().Log("About to run line #266: tbl.Between(2, nil).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(2, nil).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #266")
	}

	{
		// selection.yaml line #267
		/* err('ReqlQueryLogicError', 'Cannot use `nu' + 'll` in BETWEEN, use `r.minval` or `r.maxval` to denote unboundedness.') */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot use `nu"+"ll` in BETWEEN, use `r.minval` or `r.maxval` to denote unboundedness.")
		/* tbl.between(null, null).count() */

		suite.T().Log("About to run line #267: tbl.Between(nil, nil).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Between(nil, nil).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #267")
	}

	{
		// selection.yaml line #271
		/* 1 */
		var expected_ int = 1
		/* tblpkey.between(9, 11).count() */

		suite.T().Log("About to run line #271: tblpkey.Between(9, 11).Count()")

		runAndAssert(suite.Suite, expected_, tblpkey.Between(9, 11).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #271")
	}

	{
		// selection.yaml line #274
		/* 0 */
		var expected_ int = 0
		/* tblpkey.between(11, 12).count() */

		suite.T().Log("About to run line #274: tblpkey.Between(11, 12).Count()")

		runAndAssert(suite.Suite, expected_, tblpkey.Between(11, 12).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #274")
	}

	{
		// selection.yaml line #278
		/* 25 */
		var expected_ int = 25
		/* tbl.filter(lambda row:row['a'] > 2).count() */

		suite.T().Log("About to run line #278: tbl.Filter(func(row r.Term) interface{} { return row.AtIndex('a').Gt(2)}).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Filter(func(row r.Term) interface{} { return row.AtIndex("a").Gt(2) }).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #278")
	}

	{
		// selection.yaml line #284
		/* 100 */
		var expected_ int = 100
		/* tbl.filter(lambda row: 1).count() */

		suite.T().Log("About to run line #284: tbl.Filter(func(row r.Term) interface{} { return 1}).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Filter(func(row r.Term) interface{} { return 1 }).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #284")
	}

	{
		// selection.yaml line #290
		/* [4, 5] */
		var expected_ []interface{} = []interface{}{4, 5}
		/* r.expr([1, 2, 3, 4, 5]).filter(r.row > 2).filter(r.row > 3) */

		suite.T().Log("About to run line #290: r.Expr([]interface{}{1, 2, 3, 4, 5}).Filter(r.Row.Gt(2)).Filter(r.Row.Gt(3))")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1, 2, 3, 4, 5}).Filter(r.Row.Gt(2)).Filter(r.Row.Gt(3)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #290")
	}

	// selection.yaml line #296
	// nested = r.expr([[1, 2], [3, 4], [5, 6]])
	suite.T().Log("Possibly executing: var nested r.Term = r.Expr([]interface{}{[]interface{}{1, 2}, []interface{}{3, 4}, []interface{}{5, 6}})")

	nested := r.Expr([]interface{}{[]interface{}{1, 2}, []interface{}{3, 4}, []interface{}{5, 6}})
	_ = nested // Prevent any noused variable errors

	{
		// selection.yaml line #298
		/* [[3, 4], [5, 6]] */
		var expected_ []interface{} = []interface{}{[]interface{}{3, 4}, []interface{}{5, 6}}
		/* nested.filter(lambda x: x.filter(lambda y: y >= 4).count() > 0) */

		suite.T().Log("About to run line #298: nested.Filter(func(x r.Term) interface{} { return x.Filter(func(y r.Term) interface{} { return r.Ge(y, 4)}).Count().Gt(0)})")

		runAndAssert(suite.Suite, expected_, nested.Filter(func(x r.Term) interface{} {
			return x.Filter(func(y r.Term) interface{} { return r.Ge(y, 4) }).Count().Gt(0)
		}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #298")
	}

	{
		// selection.yaml line #303
		/* ([[3, 4], [5, 6]]) */
		var expected_ []interface{} = []interface{}{[]interface{}{3, 4}, []interface{}{5, 6}}
		/* nested.filter(r.row.filter(lambda y: y >= 4).count() > 0) */

		suite.T().Log("About to run line #303: nested.Filter(r.Row.Filter(func(y r.Term) interface{} { return r.Ge(y, 4)}).Count().Gt(0))")

		runAndAssert(suite.Suite, expected_, nested.Filter(r.Row.Filter(func(y r.Term) interface{} { return r.Ge(y, 4) }).Count().Gt(0)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #303")
	}

	{
		// selection.yaml line #307
		/* err("ReqlCompileError", 'Cannot use r.row in nested queries.  Use functions instead.', [0]) */
		var expected_ Err = err("ReqlCompileError", "Cannot use r.row in nested queries.  Use functions instead.")
		/* nested.filter(lambda x: x.filter(r.row >= 4).count() > 0) */

		suite.T().Log("About to run line #307: nested.Filter(func(x r.Term) interface{} { return x.Filter(r.Row.Ge(4)).Count().Gt(0)})")

		runAndAssert(suite.Suite, expected_, nested.Filter(func(x r.Term) interface{} { return x.Filter(r.Row.Ge(4)).Count().Gt(0) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #307")
	}

	{
		// selection.yaml line #311
		/* err("ReqlCompileError", 'Cannot use r.row in nested queries.  Use functions instead.', [0]) */
		var expected_ Err = err("ReqlCompileError", "Cannot use r.row in nested queries.  Use functions instead.")
		/* r.expr([[1, 2], [3, 4], [5, 6]]).filter(r.row.filter(r.row >= 4).count() > 0) */

		suite.T().Log("About to run line #311: r.Expr([]interface{}{[]interface{}{1, 2}, []interface{}{3, 4}, []interface{}{5, 6}}).Filter(r.Row.Filter(r.Row.Ge(4)).Count().Gt(0))")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{[]interface{}{1, 2}, []interface{}{3, 4}, []interface{}{5, 6}}).Filter(r.Row.Filter(r.Row.Ge(4)).Count().Gt(0)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #311")
	}

	{
		// selection.yaml line #316
		/* [{'a':1,'b':2,'c':3}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1, "b": 2, "c": 3}}
		/* r.expr([{'a':1,'b':1,'c':3},{'a':1,'b':2,'c':3}]).filter({'a':1,'b':2}) */

		suite.T().Log("About to run line #316: r.Expr([]interface{}{map[interface{}]interface{}{'a': 1, 'b': 1, 'c': 3, }, map[interface{}]interface{}{'a': 1, 'b': 2, 'c': 3, }}).Filter(map[interface{}]interface{}{'a': 1, 'b': 2, })")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{map[interface{}]interface{}{"a": 1, "b": 1, "c": 3}, map[interface{}]interface{}{"a": 1, "b": 2, "c": 3}}).Filter(map[interface{}]interface{}{"a": 1, "b": 2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #316")
	}

	{
		// selection.yaml line #319
		/* [{'a':1,'b':1,'c':3},{'a':1,'b':2,'c':3}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1, "b": 1, "c": 3}, map[interface{}]interface{}{"a": 1, "b": 2, "c": 3}}
		/* r.expr([{'a':1,'b':1,'c':3},{'a':1,'b':2,'c':3}]).filter({'a':1}) */

		suite.T().Log("About to run line #319: r.Expr([]interface{}{map[interface{}]interface{}{'a': 1, 'b': 1, 'c': 3, }, map[interface{}]interface{}{'a': 1, 'b': 2, 'c': 3, }}).Filter(map[interface{}]interface{}{'a': 1, })")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{map[interface{}]interface{}{"a": 1, "b": 1, "c": 3}, map[interface{}]interface{}{"a": 1, "b": 2, "c": 3}}).Filter(map[interface{}]interface{}{"a": 1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #319")
	}

	{
		// selection.yaml line #323
		/* [{'a':1,'b':1,'c':3}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1, "b": 1, "c": 3}}
		/* r.expr([{'a':1,'b':1,'c':3},{'a':1,'b':2,'c':3}]).filter({'a':r.row['b']}) */

		suite.T().Log("About to run line #323: r.Expr([]interface{}{map[interface{}]interface{}{'a': 1, 'b': 1, 'c': 3, }, map[interface{}]interface{}{'a': 1, 'b': 2, 'c': 3, }}).Filter(map[interface{}]interface{}{'a': r.Row.AtIndex('b'), })")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{map[interface{}]interface{}{"a": 1, "b": 1, "c": 3}, map[interface{}]interface{}{"a": 1, "b": 2, "c": 3}}).Filter(map[interface{}]interface{}{"a": r.Row.AtIndex("b")}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #323")
	}

	{
		// selection.yaml line #329
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* r.expr([{'a':1}]).filter({'b':1}) */

		suite.T().Log("About to run line #329: r.Expr([]interface{}{map[interface{}]interface{}{'a': 1, }}).Filter(map[interface{}]interface{}{'b': 1, })")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{map[interface{}]interface{}{"a": 1}}).Filter(map[interface{}]interface{}{"b": 1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #329")
	}

	{
		// selection.yaml line #335
		/* 25 */
		var expected_ int = 25
		/* tbl.count(lambda row: {'a':1}) */

		suite.T().Log("About to run line #335: tbl.Count(func(row r.Term) interface{} { return map[interface{}]interface{}{'a': 1, }})")

		runAndAssert(suite.Suite, expected_, tbl.Count(func(row r.Term) interface{} { return map[interface{}]interface{}{"a": 1} }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #335")
	}

	{
		// selection.yaml line #341
		/* 2 */
		var expected_ int = 2
		/* r.expr([1,2,3,1]).count(1) */

		suite.T().Log("About to run line #341: r.Expr([]interface{}{1, 2, 3, 1}).Count(1)")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1, 2, 3, 1}).Count(1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #341")
	}

	{
		// selection.yaml line #344
		/* 2 */
		var expected_ int = 2
		/* r.expr([null, 4, null, 'foo']).count(null) */

		suite.T().Log("About to run line #344: r.Expr([]interface{}{nil, 4, nil, 'foo'}).Count(nil)")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{nil, 4, nil, "foo"}).Count(nil), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #344")
	}

	{
		// selection.yaml line #348
		/* err('ReqlQueryLogicError', 'Expected type DATUM but found TABLE:', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type DATUM but found TABLE:")
		/* r.expr(5) + tbl */

		suite.T().Log("About to run line #348: r.Expr(5).Add(tbl)")

		runAndAssert(suite.Suite, expected_, r.Expr(5).Add(tbl), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #348")
	}

	{
		// selection.yaml line #353
		/* "SELECTION<STREAM>" */
		var expected_ string = "SELECTION<STREAM>"
		/* tbl.has_fields('field').type_of() */

		suite.T().Log("About to run line #353: tbl.HasFields('field').TypeOf()")

		runAndAssert(suite.Suite, expected_, tbl.HasFields("field").TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #353")
	}
}
