// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotanalytics

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchPutMessage = "BatchPutMessage"

// BatchPutMessageRequest generates a "aws/request.Request" representing the
// client's request for the BatchPutMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchPutMessage for more information on using the BatchPutMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchPutMessageRequest method.
//    req, resp := client.BatchPutMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/BatchPutMessage
func (c *IoTAnalytics) BatchPutMessageRequest(input *BatchPutMessageInput) (req *request.Request, output *BatchPutMessageOutput) {
	op := &request.Operation{
		Name:       opBatchPutMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/messages/batch",
	}

	if input == nil {
		input = &BatchPutMessageInput{}
	}

	output = &BatchPutMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchPutMessage API operation for AWS IoT Analytics.
//
// Sends messages to a channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation BatchPutMessage for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/BatchPutMessage
func (c *IoTAnalytics) BatchPutMessage(input *BatchPutMessageInput) (*BatchPutMessageOutput, error) {
	req, out := c.BatchPutMessageRequest(input)
	return out, req.Send()
}

// BatchPutMessageWithContext is the same as BatchPutMessage with the addition of
// the ability to pass a context and additional request options.
//
// See BatchPutMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) BatchPutMessageWithContext(ctx aws.Context, input *BatchPutMessageInput, opts ...request.Option) (*BatchPutMessageOutput, error) {
	req, out := c.BatchPutMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelPipelineReprocessing = "CancelPipelineReprocessing"

// CancelPipelineReprocessingRequest generates a "aws/request.Request" representing the
// client's request for the CancelPipelineReprocessing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelPipelineReprocessing for more information on using the CancelPipelineReprocessing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelPipelineReprocessingRequest method.
//    req, resp := client.CancelPipelineReprocessingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CancelPipelineReprocessing
func (c *IoTAnalytics) CancelPipelineReprocessingRequest(input *CancelPipelineReprocessingInput) (req *request.Request, output *CancelPipelineReprocessingOutput) {
	op := &request.Operation{
		Name:       opCancelPipelineReprocessing,
		HTTPMethod: "DELETE",
		HTTPPath:   "/pipelines/{pipelineName}/reprocessing/{reprocessingId}",
	}

	if input == nil {
		input = &CancelPipelineReprocessingInput{}
	}

	output = &CancelPipelineReprocessingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelPipelineReprocessing API operation for AWS IoT Analytics.
//
// Cancels the reprocessing of data through the pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation CancelPipelineReprocessing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CancelPipelineReprocessing
func (c *IoTAnalytics) CancelPipelineReprocessing(input *CancelPipelineReprocessingInput) (*CancelPipelineReprocessingOutput, error) {
	req, out := c.CancelPipelineReprocessingRequest(input)
	return out, req.Send()
}

// CancelPipelineReprocessingWithContext is the same as CancelPipelineReprocessing with the addition of
// the ability to pass a context and additional request options.
//
// See CancelPipelineReprocessing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) CancelPipelineReprocessingWithContext(ctx aws.Context, input *CancelPipelineReprocessingInput, opts ...request.Option) (*CancelPipelineReprocessingOutput, error) {
	req, out := c.CancelPipelineReprocessingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannel = "CreateChannel"

// CreateChannelRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannel for more information on using the CreateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateChannelRequest method.
//    req, resp := client.CreateChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateChannel
func (c *IoTAnalytics) CreateChannelRequest(input *CreateChannelInput) (req *request.Request, output *CreateChannelOutput) {
	op := &request.Operation{
		Name:       opCreateChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/channels",
	}

	if input == nil {
		input = &CreateChannelInput{}
	}

	output = &CreateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannel API operation for AWS IoT Analytics.
//
// Creates a channel. A channel collects data from an MQTT topic and archives
// the raw, unprocessed messages before publishing the data to a pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation CreateChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   A resource with the same name already exists.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The command caused an internal limit to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateChannel
func (c *IoTAnalytics) CreateChannel(input *CreateChannelInput) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	return out, req.Send()
}

// CreateChannelWithContext is the same as CreateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) CreateChannelWithContext(ctx aws.Context, input *CreateChannelInput, opts ...request.Option) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataset = "CreateDataset"

// CreateDatasetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataset for more information on using the CreateDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDatasetRequest method.
//    req, resp := client.CreateDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateDataset
func (c *IoTAnalytics) CreateDatasetRequest(input *CreateDatasetInput) (req *request.Request, output *CreateDatasetOutput) {
	op := &request.Operation{
		Name:       opCreateDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/datasets",
	}

	if input == nil {
		input = &CreateDatasetInput{}
	}

	output = &CreateDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataset API operation for AWS IoT Analytics.
//
// Creates a data set. A data set stores data retrieved from a data store by
// applying a "queryAction" (a SQL query) or a "containerAction" (executing
// a containerized application). This operation creates the skeleton of a data
// set. The data set can be populated manually by calling "CreateDatasetContent"
// or automatically according to a "trigger" you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation CreateDataset for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   A resource with the same name already exists.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The command caused an internal limit to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateDataset
func (c *IoTAnalytics) CreateDataset(input *CreateDatasetInput) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	return out, req.Send()
}

// CreateDatasetWithContext is the same as CreateDataset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) CreateDatasetWithContext(ctx aws.Context, input *CreateDatasetInput, opts ...request.Option) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatasetContent = "CreateDatasetContent"

// CreateDatasetContentRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatasetContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatasetContent for more information on using the CreateDatasetContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDatasetContentRequest method.
//    req, resp := client.CreateDatasetContentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateDatasetContent
func (c *IoTAnalytics) CreateDatasetContentRequest(input *CreateDatasetContentInput) (req *request.Request, output *CreateDatasetContentOutput) {
	op := &request.Operation{
		Name:       opCreateDatasetContent,
		HTTPMethod: "POST",
		HTTPPath:   "/datasets/{datasetName}/content",
	}

	if input == nil {
		input = &CreateDatasetContentInput{}
	}

	output = &CreateDatasetContentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDatasetContent API operation for AWS IoT Analytics.
//
// Creates the content of a data set by applying a SQL action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation CreateDatasetContent for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateDatasetContent
func (c *IoTAnalytics) CreateDatasetContent(input *CreateDatasetContentInput) (*CreateDatasetContentOutput, error) {
	req, out := c.CreateDatasetContentRequest(input)
	return out, req.Send()
}

// CreateDatasetContentWithContext is the same as CreateDatasetContent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatasetContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) CreateDatasetContentWithContext(ctx aws.Context, input *CreateDatasetContentInput, opts ...request.Option) (*CreateDatasetContentOutput, error) {
	req, out := c.CreateDatasetContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatastore = "CreateDatastore"

// CreateDatastoreRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatastore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatastore for more information on using the CreateDatastore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDatastoreRequest method.
//    req, resp := client.CreateDatastoreRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateDatastore
func (c *IoTAnalytics) CreateDatastoreRequest(input *CreateDatastoreInput) (req *request.Request, output *CreateDatastoreOutput) {
	op := &request.Operation{
		Name:       opCreateDatastore,
		HTTPMethod: "POST",
		HTTPPath:   "/datastores",
	}

	if input == nil {
		input = &CreateDatastoreInput{}
	}

	output = &CreateDatastoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDatastore API operation for AWS IoT Analytics.
//
// Creates a data store, which is a repository for messages.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation CreateDatastore for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   A resource with the same name already exists.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The command caused an internal limit to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreateDatastore
func (c *IoTAnalytics) CreateDatastore(input *CreateDatastoreInput) (*CreateDatastoreOutput, error) {
	req, out := c.CreateDatastoreRequest(input)
	return out, req.Send()
}

// CreateDatastoreWithContext is the same as CreateDatastore with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatastore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) CreateDatastoreWithContext(ctx aws.Context, input *CreateDatastoreInput, opts ...request.Option) (*CreateDatastoreOutput, error) {
	req, out := c.CreateDatastoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePipeline = "CreatePipeline"

// CreatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the CreatePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePipeline for more information on using the CreatePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePipelineRequest method.
//    req, resp := client.CreatePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreatePipeline
func (c *IoTAnalytics) CreatePipelineRequest(input *CreatePipelineInput) (req *request.Request, output *CreatePipelineOutput) {
	op := &request.Operation{
		Name:       opCreatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/pipelines",
	}

	if input == nil {
		input = &CreatePipelineInput{}
	}

	output = &CreatePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePipeline API operation for AWS IoT Analytics.
//
// Creates a pipeline. A pipeline consumes messages from one or more channels
// and allows you to process the messages before storing them in a data store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation CreatePipeline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   A resource with the same name already exists.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The command caused an internal limit to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CreatePipeline
func (c *IoTAnalytics) CreatePipeline(input *CreatePipelineInput) (*CreatePipelineOutput, error) {
	req, out := c.CreatePipelineRequest(input)
	return out, req.Send()
}

// CreatePipelineWithContext is the same as CreatePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) CreatePipelineWithContext(ctx aws.Context, input *CreatePipelineInput, opts ...request.Option) (*CreatePipelineOutput, error) {
	req, out := c.CreatePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannel = "DeleteChannel"

// DeleteChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannel for more information on using the DeleteChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteChannelRequest method.
//    req, resp := client.DeleteChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteChannel
func (c *IoTAnalytics) DeleteChannelRequest(input *DeleteChannelInput) (req *request.Request, output *DeleteChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelName}",
	}

	if input == nil {
		input = &DeleteChannelInput{}
	}

	output = &DeleteChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannel API operation for AWS IoT Analytics.
//
// Deletes the specified channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation DeleteChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteChannel
func (c *IoTAnalytics) DeleteChannel(input *DeleteChannelInput) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	return out, req.Send()
}

// DeleteChannelWithContext is the same as DeleteChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) DeleteChannelWithContext(ctx aws.Context, input *DeleteChannelInput, opts ...request.Option) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataset = "DeleteDataset"

// DeleteDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataset for more information on using the DeleteDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDatasetRequest method.
//    req, resp := client.DeleteDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDataset
func (c *IoTAnalytics) DeleteDatasetRequest(input *DeleteDatasetInput) (req *request.Request, output *DeleteDatasetOutput) {
	op := &request.Operation{
		Name:       opDeleteDataset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/datasets/{datasetName}",
	}

	if input == nil {
		input = &DeleteDatasetInput{}
	}

	output = &DeleteDatasetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataset API operation for AWS IoT Analytics.
//
// Deletes the specified data set.
//
// You do not have to delete the content of the data set before you perform
// this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation DeleteDataset for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDataset
func (c *IoTAnalytics) DeleteDataset(input *DeleteDatasetInput) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	return out, req.Send()
}

// DeleteDatasetWithContext is the same as DeleteDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) DeleteDatasetWithContext(ctx aws.Context, input *DeleteDatasetInput, opts ...request.Option) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDatasetContent = "DeleteDatasetContent"

// DeleteDatasetContentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDatasetContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDatasetContent for more information on using the DeleteDatasetContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDatasetContentRequest method.
//    req, resp := client.DeleteDatasetContentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDatasetContent
func (c *IoTAnalytics) DeleteDatasetContentRequest(input *DeleteDatasetContentInput) (req *request.Request, output *DeleteDatasetContentOutput) {
	op := &request.Operation{
		Name:       opDeleteDatasetContent,
		HTTPMethod: "DELETE",
		HTTPPath:   "/datasets/{datasetName}/content",
	}

	if input == nil {
		input = &DeleteDatasetContentInput{}
	}

	output = &DeleteDatasetContentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDatasetContent API operation for AWS IoT Analytics.
//
// Deletes the content of the specified data set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation DeleteDatasetContent for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDatasetContent
func (c *IoTAnalytics) DeleteDatasetContent(input *DeleteDatasetContentInput) (*DeleteDatasetContentOutput, error) {
	req, out := c.DeleteDatasetContentRequest(input)
	return out, req.Send()
}

// DeleteDatasetContentWithContext is the same as DeleteDatasetContent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDatasetContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) DeleteDatasetContentWithContext(ctx aws.Context, input *DeleteDatasetContentInput, opts ...request.Option) (*DeleteDatasetContentOutput, error) {
	req, out := c.DeleteDatasetContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDatastore = "DeleteDatastore"

// DeleteDatastoreRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDatastore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDatastore for more information on using the DeleteDatastore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDatastoreRequest method.
//    req, resp := client.DeleteDatastoreRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDatastore
func (c *IoTAnalytics) DeleteDatastoreRequest(input *DeleteDatastoreInput) (req *request.Request, output *DeleteDatastoreOutput) {
	op := &request.Operation{
		Name:       opDeleteDatastore,
		HTTPMethod: "DELETE",
		HTTPPath:   "/datastores/{datastoreName}",
	}

	if input == nil {
		input = &DeleteDatastoreInput{}
	}

	output = &DeleteDatastoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDatastore API operation for AWS IoT Analytics.
//
// Deletes the specified data store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation DeleteDatastore for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDatastore
func (c *IoTAnalytics) DeleteDatastore(input *DeleteDatastoreInput) (*DeleteDatastoreOutput, error) {
	req, out := c.DeleteDatastoreRequest(input)
	return out, req.Send()
}

// DeleteDatastoreWithContext is the same as DeleteDatastore with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDatastore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) DeleteDatastoreWithContext(ctx aws.Context, input *DeleteDatastoreInput, opts ...request.Option) (*DeleteDatastoreOutput, error) {
	req, out := c.DeleteDatastoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePipeline = "DeletePipeline"

// DeletePipelineRequest generates a "aws/request.Request" representing the
// client's request for the DeletePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePipeline for more information on using the DeletePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePipelineRequest method.
//    req, resp := client.DeletePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeletePipeline
func (c *IoTAnalytics) DeletePipelineRequest(input *DeletePipelineInput) (req *request.Request, output *DeletePipelineOutput) {
	op := &request.Operation{
		Name:       opDeletePipeline,
		HTTPMethod: "DELETE",
		HTTPPath:   "/pipelines/{pipelineName}",
	}

	if input == nil {
		input = &DeletePipelineInput{}
	}

	output = &DeletePipelineOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePipeline API operation for AWS IoT Analytics.
//
// Deletes the specified pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation DeletePipeline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeletePipeline
func (c *IoTAnalytics) DeletePipeline(input *DeletePipelineInput) (*DeletePipelineOutput, error) {
	req, out := c.DeletePipelineRequest(input)
	return out, req.Send()
}

// DeletePipelineWithContext is the same as DeletePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) DeletePipelineWithContext(ctx aws.Context, input *DeletePipelineInput, opts ...request.Option) (*DeletePipelineOutput, error) {
	req, out := c.DeletePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannel = "DescribeChannel"

// DescribeChannelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannel for more information on using the DescribeChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeChannelRequest method.
//    req, resp := client.DescribeChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeChannel
func (c *IoTAnalytics) DescribeChannelRequest(input *DescribeChannelInput) (req *request.Request, output *DescribeChannelOutput) {
	op := &request.Operation{
		Name:       opDescribeChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelName}",
	}

	if input == nil {
		input = &DescribeChannelInput{}
	}

	output = &DescribeChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannel API operation for AWS IoT Analytics.
//
// Retrieves information about a channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation DescribeChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeChannel
func (c *IoTAnalytics) DescribeChannel(input *DescribeChannelInput) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	return out, req.Send()
}

// DescribeChannelWithContext is the same as DescribeChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) DescribeChannelWithContext(ctx aws.Context, input *DescribeChannelInput, opts ...request.Option) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataset = "DescribeDataset"

// DescribeDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataset for more information on using the DescribeDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDatasetRequest method.
//    req, resp := client.DescribeDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeDataset
func (c *IoTAnalytics) DescribeDatasetRequest(input *DescribeDatasetInput) (req *request.Request, output *DescribeDatasetOutput) {
	op := &request.Operation{
		Name:       opDescribeDataset,
		HTTPMethod: "GET",
		HTTPPath:   "/datasets/{datasetName}",
	}

	if input == nil {
		input = &DescribeDatasetInput{}
	}

	output = &DescribeDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataset API operation for AWS IoT Analytics.
//
// Retrieves information about a data set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation DescribeDataset for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeDataset
func (c *IoTAnalytics) DescribeDataset(input *DescribeDatasetInput) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	return out, req.Send()
}

// DescribeDatasetWithContext is the same as DescribeDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) DescribeDatasetWithContext(ctx aws.Context, input *DescribeDatasetInput, opts ...request.Option) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDatastore = "DescribeDatastore"

// DescribeDatastoreRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDatastore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDatastore for more information on using the DescribeDatastore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDatastoreRequest method.
//    req, resp := client.DescribeDatastoreRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeDatastore
func (c *IoTAnalytics) DescribeDatastoreRequest(input *DescribeDatastoreInput) (req *request.Request, output *DescribeDatastoreOutput) {
	op := &request.Operation{
		Name:       opDescribeDatastore,
		HTTPMethod: "GET",
		HTTPPath:   "/datastores/{datastoreName}",
	}

	if input == nil {
		input = &DescribeDatastoreInput{}
	}

	output = &DescribeDatastoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDatastore API operation for AWS IoT Analytics.
//
// Retrieves information about a data store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation DescribeDatastore for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeDatastore
func (c *IoTAnalytics) DescribeDatastore(input *DescribeDatastoreInput) (*DescribeDatastoreOutput, error) {
	req, out := c.DescribeDatastoreRequest(input)
	return out, req.Send()
}

// DescribeDatastoreWithContext is the same as DescribeDatastore with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDatastore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) DescribeDatastoreWithContext(ctx aws.Context, input *DescribeDatastoreInput, opts ...request.Option) (*DescribeDatastoreOutput, error) {
	req, out := c.DescribeDatastoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLoggingOptions = "DescribeLoggingOptions"

// DescribeLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLoggingOptions for more information on using the DescribeLoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLoggingOptionsRequest method.
//    req, resp := client.DescribeLoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeLoggingOptions
func (c *IoTAnalytics) DescribeLoggingOptionsRequest(input *DescribeLoggingOptionsInput) (req *request.Request, output *DescribeLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeLoggingOptions,
		HTTPMethod: "GET",
		HTTPPath:   "/logging",
	}

	if input == nil {
		input = &DescribeLoggingOptionsInput{}
	}

	output = &DescribeLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLoggingOptions API operation for AWS IoT Analytics.
//
// Retrieves the current settings of the AWS IoT Analytics logging options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation DescribeLoggingOptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribeLoggingOptions
func (c *IoTAnalytics) DescribeLoggingOptions(input *DescribeLoggingOptionsInput) (*DescribeLoggingOptionsOutput, error) {
	req, out := c.DescribeLoggingOptionsRequest(input)
	return out, req.Send()
}

// DescribeLoggingOptionsWithContext is the same as DescribeLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) DescribeLoggingOptionsWithContext(ctx aws.Context, input *DescribeLoggingOptionsInput, opts ...request.Option) (*DescribeLoggingOptionsOutput, error) {
	req, out := c.DescribeLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePipeline = "DescribePipeline"

// DescribePipelineRequest generates a "aws/request.Request" representing the
// client's request for the DescribePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePipeline for more information on using the DescribePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePipelineRequest method.
//    req, resp := client.DescribePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribePipeline
func (c *IoTAnalytics) DescribePipelineRequest(input *DescribePipelineInput) (req *request.Request, output *DescribePipelineOutput) {
	op := &request.Operation{
		Name:       opDescribePipeline,
		HTTPMethod: "GET",
		HTTPPath:   "/pipelines/{pipelineName}",
	}

	if input == nil {
		input = &DescribePipelineInput{}
	}

	output = &DescribePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePipeline API operation for AWS IoT Analytics.
//
// Retrieves information about a pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation DescribePipeline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DescribePipeline
func (c *IoTAnalytics) DescribePipeline(input *DescribePipelineInput) (*DescribePipelineOutput, error) {
	req, out := c.DescribePipelineRequest(input)
	return out, req.Send()
}

// DescribePipelineWithContext is the same as DescribePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) DescribePipelineWithContext(ctx aws.Context, input *DescribePipelineInput, opts ...request.Option) (*DescribePipelineOutput, error) {
	req, out := c.DescribePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDatasetContent = "GetDatasetContent"

// GetDatasetContentRequest generates a "aws/request.Request" representing the
// client's request for the GetDatasetContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDatasetContent for more information on using the GetDatasetContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDatasetContentRequest method.
//    req, resp := client.GetDatasetContentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/GetDatasetContent
func (c *IoTAnalytics) GetDatasetContentRequest(input *GetDatasetContentInput) (req *request.Request, output *GetDatasetContentOutput) {
	op := &request.Operation{
		Name:       opGetDatasetContent,
		HTTPMethod: "GET",
		HTTPPath:   "/datasets/{datasetName}/content",
	}

	if input == nil {
		input = &GetDatasetContentInput{}
	}

	output = &GetDatasetContentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDatasetContent API operation for AWS IoT Analytics.
//
// Retrieves the contents of a data set as pre-signed URIs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation GetDatasetContent for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/GetDatasetContent
func (c *IoTAnalytics) GetDatasetContent(input *GetDatasetContentInput) (*GetDatasetContentOutput, error) {
	req, out := c.GetDatasetContentRequest(input)
	return out, req.Send()
}

// GetDatasetContentWithContext is the same as GetDatasetContent with the addition of
// the ability to pass a context and additional request options.
//
// See GetDatasetContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) GetDatasetContentWithContext(ctx aws.Context, input *GetDatasetContentInput, opts ...request.Option) (*GetDatasetContentOutput, error) {
	req, out := c.GetDatasetContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChannels = "ListChannels"

// ListChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannels for more information on using the ListChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChannelsRequest method.
//    req, resp := client.ListChannelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListChannels
func (c *IoTAnalytics) ListChannelsRequest(input *ListChannelsInput) (req *request.Request, output *ListChannelsOutput) {
	op := &request.Operation{
		Name:       opListChannels,
		HTTPMethod: "GET",
		HTTPPath:   "/channels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsInput{}
	}

	output = &ListChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannels API operation for AWS IoT Analytics.
//
// Retrieves a list of channels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation ListChannels for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListChannels
func (c *IoTAnalytics) ListChannels(input *ListChannelsInput) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	return out, req.Send()
}

// ListChannelsWithContext is the same as ListChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) ListChannelsWithContext(ctx aws.Context, input *ListChannelsInput, opts ...request.Option) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsPages iterates over the pages of a ListChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListChannels operation.
//    pageNum := 0
//    err := client.ListChannelsPages(params,
//        func(page *ListChannelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTAnalytics) ListChannelsPages(input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool) error {
	return c.ListChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsPagesWithContext same as ListChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) ListChannelsPagesWithContext(ctx aws.Context, input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListChannelsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListDatasetContents = "ListDatasetContents"

// ListDatasetContentsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasetContents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasetContents for more information on using the ListDatasetContents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDatasetContentsRequest method.
//    req, resp := client.ListDatasetContentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatasetContents
func (c *IoTAnalytics) ListDatasetContentsRequest(input *ListDatasetContentsInput) (req *request.Request, output *ListDatasetContentsOutput) {
	op := &request.Operation{
		Name:       opListDatasetContents,
		HTTPMethod: "GET",
		HTTPPath:   "/datasets/{datasetName}/contents",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetContentsInput{}
	}

	output = &ListDatasetContentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasetContents API operation for AWS IoT Analytics.
//
// Lists information about data set contents that have been created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation ListDatasetContents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatasetContents
func (c *IoTAnalytics) ListDatasetContents(input *ListDatasetContentsInput) (*ListDatasetContentsOutput, error) {
	req, out := c.ListDatasetContentsRequest(input)
	return out, req.Send()
}

// ListDatasetContentsWithContext is the same as ListDatasetContents with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasetContents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) ListDatasetContentsWithContext(ctx aws.Context, input *ListDatasetContentsInput, opts ...request.Option) (*ListDatasetContentsOutput, error) {
	req, out := c.ListDatasetContentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetContentsPages iterates over the pages of a ListDatasetContents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasetContents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDatasetContents operation.
//    pageNum := 0
//    err := client.ListDatasetContentsPages(params,
//        func(page *ListDatasetContentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTAnalytics) ListDatasetContentsPages(input *ListDatasetContentsInput, fn func(*ListDatasetContentsOutput, bool) bool) error {
	return c.ListDatasetContentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetContentsPagesWithContext same as ListDatasetContentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) ListDatasetContentsPagesWithContext(ctx aws.Context, input *ListDatasetContentsInput, fn func(*ListDatasetContentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetContentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetContentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDatasetContentsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListDatasets = "ListDatasets"

// ListDatasetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasets for more information on using the ListDatasets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDatasetsRequest method.
//    req, resp := client.ListDatasetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatasets
func (c *IoTAnalytics) ListDatasetsRequest(input *ListDatasetsInput) (req *request.Request, output *ListDatasetsOutput) {
	op := &request.Operation{
		Name:       opListDatasets,
		HTTPMethod: "GET",
		HTTPPath:   "/datasets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetsInput{}
	}

	output = &ListDatasetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasets API operation for AWS IoT Analytics.
//
// Retrieves information about data sets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation ListDatasets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatasets
func (c *IoTAnalytics) ListDatasets(input *ListDatasetsInput) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	return out, req.Send()
}

// ListDatasetsWithContext is the same as ListDatasets with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) ListDatasetsWithContext(ctx aws.Context, input *ListDatasetsInput, opts ...request.Option) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetsPages iterates over the pages of a ListDatasets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDatasets operation.
//    pageNum := 0
//    err := client.ListDatasetsPages(params,
//        func(page *ListDatasetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTAnalytics) ListDatasetsPages(input *ListDatasetsInput, fn func(*ListDatasetsOutput, bool) bool) error {
	return c.ListDatasetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetsPagesWithContext same as ListDatasetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) ListDatasetsPagesWithContext(ctx aws.Context, input *ListDatasetsInput, fn func(*ListDatasetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDatasetsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListDatastores = "ListDatastores"

// ListDatastoresRequest generates a "aws/request.Request" representing the
// client's request for the ListDatastores operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatastores for more information on using the ListDatastores
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDatastoresRequest method.
//    req, resp := client.ListDatastoresRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatastores
func (c *IoTAnalytics) ListDatastoresRequest(input *ListDatastoresInput) (req *request.Request, output *ListDatastoresOutput) {
	op := &request.Operation{
		Name:       opListDatastores,
		HTTPMethod: "GET",
		HTTPPath:   "/datastores",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatastoresInput{}
	}

	output = &ListDatastoresOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatastores API operation for AWS IoT Analytics.
//
// Retrieves a list of data stores.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation ListDatastores for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListDatastores
func (c *IoTAnalytics) ListDatastores(input *ListDatastoresInput) (*ListDatastoresOutput, error) {
	req, out := c.ListDatastoresRequest(input)
	return out, req.Send()
}

// ListDatastoresWithContext is the same as ListDatastores with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatastores for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) ListDatastoresWithContext(ctx aws.Context, input *ListDatastoresInput, opts ...request.Option) (*ListDatastoresOutput, error) {
	req, out := c.ListDatastoresRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatastoresPages iterates over the pages of a ListDatastores operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatastores method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDatastores operation.
//    pageNum := 0
//    err := client.ListDatastoresPages(params,
//        func(page *ListDatastoresOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTAnalytics) ListDatastoresPages(input *ListDatastoresInput, fn func(*ListDatastoresOutput, bool) bool) error {
	return c.ListDatastoresPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatastoresPagesWithContext same as ListDatastoresPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) ListDatastoresPagesWithContext(ctx aws.Context, input *ListDatastoresInput, fn func(*ListDatastoresOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatastoresInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatastoresRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDatastoresOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListPipelines = "ListPipelines"

// ListPipelinesRequest generates a "aws/request.Request" representing the
// client's request for the ListPipelines operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPipelines for more information on using the ListPipelines
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPipelinesRequest method.
//    req, resp := client.ListPipelinesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListPipelines
func (c *IoTAnalytics) ListPipelinesRequest(input *ListPipelinesInput) (req *request.Request, output *ListPipelinesOutput) {
	op := &request.Operation{
		Name:       opListPipelines,
		HTTPMethod: "GET",
		HTTPPath:   "/pipelines",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPipelinesInput{}
	}

	output = &ListPipelinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPipelines API operation for AWS IoT Analytics.
//
// Retrieves a list of pipelines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation ListPipelines for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListPipelines
func (c *IoTAnalytics) ListPipelines(input *ListPipelinesInput) (*ListPipelinesOutput, error) {
	req, out := c.ListPipelinesRequest(input)
	return out, req.Send()
}

// ListPipelinesWithContext is the same as ListPipelines with the addition of
// the ability to pass a context and additional request options.
//
// See ListPipelines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) ListPipelinesWithContext(ctx aws.Context, input *ListPipelinesInput, opts ...request.Option) (*ListPipelinesOutput, error) {
	req, out := c.ListPipelinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPipelinesPages iterates over the pages of a ListPipelines operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPipelines method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPipelines operation.
//    pageNum := 0
//    err := client.ListPipelinesPages(params,
//        func(page *ListPipelinesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTAnalytics) ListPipelinesPages(input *ListPipelinesInput, fn func(*ListPipelinesOutput, bool) bool) error {
	return c.ListPipelinesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPipelinesPagesWithContext same as ListPipelinesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) ListPipelinesPagesWithContext(ctx aws.Context, input *ListPipelinesInput, fn func(*ListPipelinesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPipelinesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPipelinesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListPipelinesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListTagsForResource
func (c *IoTAnalytics) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS IoT Analytics.
//
// Lists the tags (metadata) which you have assigned to the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The command caused an internal limit to be exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListTagsForResource
func (c *IoTAnalytics) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLoggingOptions = "PutLoggingOptions"

// PutLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutLoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLoggingOptions for more information on using the PutLoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutLoggingOptionsRequest method.
//    req, resp := client.PutLoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/PutLoggingOptions
func (c *IoTAnalytics) PutLoggingOptionsRequest(input *PutLoggingOptionsInput) (req *request.Request, output *PutLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opPutLoggingOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/logging",
	}

	if input == nil {
		input = &PutLoggingOptionsInput{}
	}

	output = &PutLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutLoggingOptions API operation for AWS IoT Analytics.
//
// Sets or updates the AWS IoT Analytics logging options.
//
// Note that if you update the value of any loggingOptions field, it takes up
// to one minute for the change to take effect. Also, if you change the policy
// attached to the role you specified in the roleArn field (for example, to
// correct an invalid policy) it takes up to 5 minutes for that change to take
// effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation PutLoggingOptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/PutLoggingOptions
func (c *IoTAnalytics) PutLoggingOptions(input *PutLoggingOptionsInput) (*PutLoggingOptionsOutput, error) {
	req, out := c.PutLoggingOptionsRequest(input)
	return out, req.Send()
}

// PutLoggingOptionsWithContext is the same as PutLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) PutLoggingOptionsWithContext(ctx aws.Context, input *PutLoggingOptionsInput, opts ...request.Option) (*PutLoggingOptionsOutput, error) {
	req, out := c.PutLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRunPipelineActivity = "RunPipelineActivity"

// RunPipelineActivityRequest generates a "aws/request.Request" representing the
// client's request for the RunPipelineActivity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RunPipelineActivity for more information on using the RunPipelineActivity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RunPipelineActivityRequest method.
//    req, resp := client.RunPipelineActivityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/RunPipelineActivity
func (c *IoTAnalytics) RunPipelineActivityRequest(input *RunPipelineActivityInput) (req *request.Request, output *RunPipelineActivityOutput) {
	op := &request.Operation{
		Name:       opRunPipelineActivity,
		HTTPMethod: "POST",
		HTTPPath:   "/pipelineactivities/run",
	}

	if input == nil {
		input = &RunPipelineActivityInput{}
	}

	output = &RunPipelineActivityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RunPipelineActivity API operation for AWS IoT Analytics.
//
// Simulates the results of running a pipeline activity on a message payload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation RunPipelineActivity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/RunPipelineActivity
func (c *IoTAnalytics) RunPipelineActivity(input *RunPipelineActivityInput) (*RunPipelineActivityOutput, error) {
	req, out := c.RunPipelineActivityRequest(input)
	return out, req.Send()
}

// RunPipelineActivityWithContext is the same as RunPipelineActivity with the addition of
// the ability to pass a context and additional request options.
//
// See RunPipelineActivity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) RunPipelineActivityWithContext(ctx aws.Context, input *RunPipelineActivityInput, opts ...request.Option) (*RunPipelineActivityOutput, error) {
	req, out := c.RunPipelineActivityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSampleChannelData = "SampleChannelData"

// SampleChannelDataRequest generates a "aws/request.Request" representing the
// client's request for the SampleChannelData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SampleChannelData for more information on using the SampleChannelData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SampleChannelDataRequest method.
//    req, resp := client.SampleChannelDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/SampleChannelData
func (c *IoTAnalytics) SampleChannelDataRequest(input *SampleChannelDataInput) (req *request.Request, output *SampleChannelDataOutput) {
	op := &request.Operation{
		Name:       opSampleChannelData,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelName}/sample",
	}

	if input == nil {
		input = &SampleChannelDataInput{}
	}

	output = &SampleChannelDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SampleChannelData API operation for AWS IoT Analytics.
//
// Retrieves a sample of messages from the specified channel ingested during
// the specified timeframe. Up to 10 messages can be retrieved.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation SampleChannelData for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/SampleChannelData
func (c *IoTAnalytics) SampleChannelData(input *SampleChannelDataInput) (*SampleChannelDataOutput, error) {
	req, out := c.SampleChannelDataRequest(input)
	return out, req.Send()
}

// SampleChannelDataWithContext is the same as SampleChannelData with the addition of
// the ability to pass a context and additional request options.
//
// See SampleChannelData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) SampleChannelDataWithContext(ctx aws.Context, input *SampleChannelDataInput, opts ...request.Option) (*SampleChannelDataOutput, error) {
	req, out := c.SampleChannelDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartPipelineReprocessing = "StartPipelineReprocessing"

// StartPipelineReprocessingRequest generates a "aws/request.Request" representing the
// client's request for the StartPipelineReprocessing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartPipelineReprocessing for more information on using the StartPipelineReprocessing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartPipelineReprocessingRequest method.
//    req, resp := client.StartPipelineReprocessingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/StartPipelineReprocessing
func (c *IoTAnalytics) StartPipelineReprocessingRequest(input *StartPipelineReprocessingInput) (req *request.Request, output *StartPipelineReprocessingOutput) {
	op := &request.Operation{
		Name:       opStartPipelineReprocessing,
		HTTPMethod: "POST",
		HTTPPath:   "/pipelines/{pipelineName}/reprocessing",
	}

	if input == nil {
		input = &StartPipelineReprocessingInput{}
	}

	output = &StartPipelineReprocessingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartPipelineReprocessing API operation for AWS IoT Analytics.
//
// Starts the reprocessing of raw message data through the pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation StartPipelineReprocessing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   A resource with the same name already exists.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/StartPipelineReprocessing
func (c *IoTAnalytics) StartPipelineReprocessing(input *StartPipelineReprocessingInput) (*StartPipelineReprocessingOutput, error) {
	req, out := c.StartPipelineReprocessingRequest(input)
	return out, req.Send()
}

// StartPipelineReprocessingWithContext is the same as StartPipelineReprocessing with the addition of
// the ability to pass a context and additional request options.
//
// See StartPipelineReprocessing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) StartPipelineReprocessingWithContext(ctx aws.Context, input *StartPipelineReprocessingInput, opts ...request.Option) (*StartPipelineReprocessingOutput, error) {
	req, out := c.StartPipelineReprocessingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/TagResource
func (c *IoTAnalytics) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResource API operation for AWS IoT Analytics.
//
// Adds to or modifies the tags of the given resource. Tags are metadata which
// can be used to manage a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The command caused an internal limit to be exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/TagResource
func (c *IoTAnalytics) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UntagResource
func (c *IoTAnalytics) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResource API operation for AWS IoT Analytics.
//
// Removes the given tags (metadata) from the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The command caused an internal limit to be exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UntagResource
func (c *IoTAnalytics) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannel = "UpdateChannel"

// UpdateChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannel for more information on using the UpdateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateChannelRequest method.
//    req, resp := client.UpdateChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdateChannel
func (c *IoTAnalytics) UpdateChannelRequest(input *UpdateChannelInput) (req *request.Request, output *UpdateChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{channelName}",
	}

	if input == nil {
		input = &UpdateChannelInput{}
	}

	output = &UpdateChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateChannel API operation for AWS IoT Analytics.
//
// Updates the settings of a channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation UpdateChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdateChannel
func (c *IoTAnalytics) UpdateChannel(input *UpdateChannelInput) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	return out, req.Send()
}

// UpdateChannelWithContext is the same as UpdateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) UpdateChannelWithContext(ctx aws.Context, input *UpdateChannelInput, opts ...request.Option) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataset = "UpdateDataset"

// UpdateDatasetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataset for more information on using the UpdateDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDatasetRequest method.
//    req, resp := client.UpdateDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdateDataset
func (c *IoTAnalytics) UpdateDatasetRequest(input *UpdateDatasetInput) (req *request.Request, output *UpdateDatasetOutput) {
	op := &request.Operation{
		Name:       opUpdateDataset,
		HTTPMethod: "PUT",
		HTTPPath:   "/datasets/{datasetName}",
	}

	if input == nil {
		input = &UpdateDatasetInput{}
	}

	output = &UpdateDatasetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDataset API operation for AWS IoT Analytics.
//
// Updates the settings of a data set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation UpdateDataset for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdateDataset
func (c *IoTAnalytics) UpdateDataset(input *UpdateDatasetInput) (*UpdateDatasetOutput, error) {
	req, out := c.UpdateDatasetRequest(input)
	return out, req.Send()
}

// UpdateDatasetWithContext is the same as UpdateDataset with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) UpdateDatasetWithContext(ctx aws.Context, input *UpdateDatasetInput, opts ...request.Option) (*UpdateDatasetOutput, error) {
	req, out := c.UpdateDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDatastore = "UpdateDatastore"

// UpdateDatastoreRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDatastore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDatastore for more information on using the UpdateDatastore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDatastoreRequest method.
//    req, resp := client.UpdateDatastoreRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdateDatastore
func (c *IoTAnalytics) UpdateDatastoreRequest(input *UpdateDatastoreInput) (req *request.Request, output *UpdateDatastoreOutput) {
	op := &request.Operation{
		Name:       opUpdateDatastore,
		HTTPMethod: "PUT",
		HTTPPath:   "/datastores/{datastoreName}",
	}

	if input == nil {
		input = &UpdateDatastoreInput{}
	}

	output = &UpdateDatastoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDatastore API operation for AWS IoT Analytics.
//
// Updates the settings of a data store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation UpdateDatastore for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdateDatastore
func (c *IoTAnalytics) UpdateDatastore(input *UpdateDatastoreInput) (*UpdateDatastoreOutput, error) {
	req, out := c.UpdateDatastoreRequest(input)
	return out, req.Send()
}

// UpdateDatastoreWithContext is the same as UpdateDatastore with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDatastore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) UpdateDatastoreWithContext(ctx aws.Context, input *UpdateDatastoreInput, opts ...request.Option) (*UpdateDatastoreOutput, error) {
	req, out := c.UpdateDatastoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePipeline = "UpdatePipeline"

// UpdatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePipeline for more information on using the UpdatePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePipelineRequest method.
//    req, resp := client.UpdatePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdatePipeline
func (c *IoTAnalytics) UpdatePipelineRequest(input *UpdatePipelineInput) (req *request.Request, output *UpdatePipelineOutput) {
	op := &request.Operation{
		Name:       opUpdatePipeline,
		HTTPMethod: "PUT",
		HTTPPath:   "/pipelines/{pipelineName}",
	}

	if input == nil {
		input = &UpdatePipelineInput{}
	}

	output = &UpdatePipelineOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdatePipeline API operation for AWS IoT Analytics.
//
// Updates the settings of a pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Analytics's
// API operation UpdatePipeline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource with the specified name could not be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal failure.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was denied due to request throttling.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The command caused an internal limit to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdatePipeline
func (c *IoTAnalytics) UpdatePipeline(input *UpdatePipelineInput) (*UpdatePipelineOutput, error) {
	req, out := c.UpdatePipelineRequest(input)
	return out, req.Send()
}

// UpdatePipelineWithContext is the same as UpdatePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTAnalytics) UpdatePipelineWithContext(ctx aws.Context, input *UpdatePipelineInput, opts ...request.Option) (*UpdatePipelineOutput, error) {
	req, out := c.UpdatePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An activity that adds other attributes based on existing attributes in the
// message.
type AddAttributesActivity struct {
	_ struct{} `type:"structure"`

	// A list of 1-50 "AttributeNameMapping" objects that map an existing attribute
	// to a new attribute.
	//
	// The existing attributes remain in the message, so if you want to remove the
	// originals, use "RemoveAttributeActivity".
	//
	// Attributes is a required field
	Attributes map[string]*string `locationName:"attributes" min:"1" type:"map" required:"true"`

	// The name of the 'addAttributes' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`
}

// String returns the string representation
func (s AddAttributesActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddAttributesActivity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddAttributesActivity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddAttributesActivity"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.Attributes != nil && len(s.Attributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attributes", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Next", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *AddAttributesActivity) SetAttributes(v map[string]*string) *AddAttributesActivity {
	s.Attributes = v
	return s
}

// SetName sets the Name field's value.
func (s *AddAttributesActivity) SetName(v string) *AddAttributesActivity {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *AddAttributesActivity) SetNext(v string) *AddAttributesActivity {
	s.Next = &v
	return s
}

// Contains informations about errors.
type BatchPutMessageErrorEntry struct {
	_ struct{} `type:"structure"`

	// The code associated with the error.
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// The message associated with the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The ID of the message that caused the error. (See the value corresponding
	// to the "messageId" key in the message object.)
	MessageId *string `locationName:"messageId" min:"1" type:"string"`
}

// String returns the string representation
func (s BatchPutMessageErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutMessageErrorEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchPutMessageErrorEntry) SetErrorCode(v string) *BatchPutMessageErrorEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchPutMessageErrorEntry) SetErrorMessage(v string) *BatchPutMessageErrorEntry {
	s.ErrorMessage = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *BatchPutMessageErrorEntry) SetMessageId(v string) *BatchPutMessageErrorEntry {
	s.MessageId = &v
	return s
}

type BatchPutMessageInput struct {
	_ struct{} `type:"structure"`

	// The name of the channel where the messages are sent.
	//
	// ChannelName is a required field
	ChannelName *string `locationName:"channelName" min:"1" type:"string" required:"true"`

	// The list of messages to be sent. Each message has format: '{ "messageId":
	// "string", "payload": "string"}'.
	//
	// Messages is a required field
	Messages []*Message `locationName:"messages" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchPutMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutMessageInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.Messages == nil {
		invalidParams.Add(request.NewErrParamRequired("Messages"))
	}
	if s.Messages != nil {
		for i, v := range s.Messages {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Messages", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *BatchPutMessageInput) SetChannelName(v string) *BatchPutMessageInput {
	s.ChannelName = &v
	return s
}

// SetMessages sets the Messages field's value.
func (s *BatchPutMessageInput) SetMessages(v []*Message) *BatchPutMessageInput {
	s.Messages = v
	return s
}

type BatchPutMessageOutput struct {
	_ struct{} `type:"structure"`

	// A list of any errors encountered when sending the messages to the channel.
	BatchPutMessageErrorEntries []*BatchPutMessageErrorEntry `locationName:"batchPutMessageErrorEntries" type:"list"`
}

// String returns the string representation
func (s BatchPutMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutMessageOutput) GoString() string {
	return s.String()
}

// SetBatchPutMessageErrorEntries sets the BatchPutMessageErrorEntries field's value.
func (s *BatchPutMessageOutput) SetBatchPutMessageErrorEntries(v []*BatchPutMessageErrorEntry) *BatchPutMessageOutput {
	s.BatchPutMessageErrorEntries = v
	return s
}

type CancelPipelineReprocessingInput struct {
	_ struct{} `type:"structure"`

	// The name of pipeline for which data reprocessing is canceled.
	//
	// PipelineName is a required field
	PipelineName *string `location:"uri" locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The ID of the reprocessing task (returned by "StartPipelineReprocessing").
	//
	// ReprocessingId is a required field
	ReprocessingId *string `location:"uri" locationName:"reprocessingId" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelPipelineReprocessingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelPipelineReprocessingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelPipelineReprocessingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelPipelineReprocessingInput"}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.ReprocessingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReprocessingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineName sets the PipelineName field's value.
func (s *CancelPipelineReprocessingInput) SetPipelineName(v string) *CancelPipelineReprocessingInput {
	s.PipelineName = &v
	return s
}

// SetReprocessingId sets the ReprocessingId field's value.
func (s *CancelPipelineReprocessingInput) SetReprocessingId(v string) *CancelPipelineReprocessingInput {
	s.ReprocessingId = &v
	return s
}

type CancelPipelineReprocessingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelPipelineReprocessingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelPipelineReprocessingOutput) GoString() string {
	return s.String()
}

// A collection of data from an MQTT topic. Channels archive the raw, unprocessed
// messages before publishing the data to a pipeline.
type Channel struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	Arn *string `locationName:"arn" type:"string"`

	// When the channel was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// When the channel was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The name of the channel.
	Name *string `locationName:"name" min:"1" type:"string"`

	// How long, in days, message data is kept for the channel.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`

	// The status of the channel.
	Status *string `locationName:"status" type:"string" enum:"ChannelStatus"`
}

// String returns the string representation
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Channel) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Channel) SetArn(v string) *Channel {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Channel) SetCreationTime(v time.Time) *Channel {
	s.CreationTime = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *Channel) SetLastUpdateTime(v time.Time) *Channel {
	s.LastUpdateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Channel) SetName(v string) *Channel {
	s.Name = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *Channel) SetRetentionPeriod(v *RetentionPeriod) *Channel {
	s.RetentionPeriod = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Channel) SetStatus(v string) *Channel {
	s.Status = &v
	return s
}

// The activity that determines the source of the messages to be processed.
type ChannelActivity struct {
	_ struct{} `type:"structure"`

	// The name of the channel from which the messages are processed.
	//
	// ChannelName is a required field
	ChannelName *string `locationName:"channelName" min:"1" type:"string" required:"true"`

	// The name of the 'channel' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`
}

// String returns the string representation
func (s ChannelActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelActivity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChannelActivity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChannelActivity"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Next", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *ChannelActivity) SetChannelName(v string) *ChannelActivity {
	s.ChannelName = &v
	return s
}

// SetName sets the Name field's value.
func (s *ChannelActivity) SetName(v string) *ChannelActivity {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *ChannelActivity) SetNext(v string) *ChannelActivity {
	s.Next = &v
	return s
}

// Statistics information about the channel.
type ChannelStatistics struct {
	_ struct{} `type:"structure"`

	// The estimated size of the channel.
	Size *EstimatedResourceSize `locationName:"size" type:"structure"`
}

// String returns the string representation
func (s ChannelStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelStatistics) GoString() string {
	return s.String()
}

// SetSize sets the Size field's value.
func (s *ChannelStatistics) SetSize(v *EstimatedResourceSize) *ChannelStatistics {
	s.Size = v
	return s
}

// A summary of information about a channel.
type ChannelSummary struct {
	_ struct{} `type:"structure"`

	// The name of the channel.
	ChannelName *string `locationName:"channelName" min:"1" type:"string"`

	// When the channel was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The last time the channel was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The status of the channel.
	Status *string `locationName:"status" type:"string" enum:"ChannelStatus"`
}

// String returns the string representation
func (s ChannelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelSummary) GoString() string {
	return s.String()
}

// SetChannelName sets the ChannelName field's value.
func (s *ChannelSummary) SetChannelName(v string) *ChannelSummary {
	s.ChannelName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ChannelSummary) SetCreationTime(v time.Time) *ChannelSummary {
	s.CreationTime = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *ChannelSummary) SetLastUpdateTime(v time.Time) *ChannelSummary {
	s.LastUpdateTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChannelSummary) SetStatus(v string) *ChannelSummary {
	s.Status = &v
	return s
}

// Information needed to run the "containerAction" to produce data set contents.
type ContainerDatasetAction struct {
	_ struct{} `type:"structure"`

	// The ARN of the role which gives permission to the system to access needed
	// resources in order to run the "containerAction". This includes, at minimum,
	// permission to retrieve the data set contents which are the input to the containerized
	// application.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `locationName:"executionRoleArn" min:"20" type:"string" required:"true"`

	// The ARN of the Docker container stored in your account. The Docker container
	// contains an application and needed support libraries and is used to generate
	// data set contents.
	//
	// Image is a required field
	Image *string `locationName:"image" type:"string" required:"true"`

	// Configuration of the resource which executes the "containerAction".
	//
	// ResourceConfiguration is a required field
	ResourceConfiguration *ResourceConfiguration `locationName:"resourceConfiguration" type:"structure" required:"true"`

	// The values of variables used within the context of the execution of the containerized
	// application (basically, parameters passed to the application). Each variable
	// must have a name and a value given by one of "stringValue", "datasetContentVersionValue",
	// or "outputFileUriValue".
	Variables []*Variable `locationName:"variables" type:"list"`
}

// String returns the string representation
func (s ContainerDatasetAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerDatasetAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerDatasetAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerDatasetAction"}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 20))
	}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.ResourceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceConfiguration"))
	}
	if s.ResourceConfiguration != nil {
		if err := s.ResourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ResourceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *ContainerDatasetAction) SetExecutionRoleArn(v string) *ContainerDatasetAction {
	s.ExecutionRoleArn = &v
	return s
}

// SetImage sets the Image field's value.
func (s *ContainerDatasetAction) SetImage(v string) *ContainerDatasetAction {
	s.Image = &v
	return s
}

// SetResourceConfiguration sets the ResourceConfiguration field's value.
func (s *ContainerDatasetAction) SetResourceConfiguration(v *ResourceConfiguration) *ContainerDatasetAction {
	s.ResourceConfiguration = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *ContainerDatasetAction) SetVariables(v []*Variable) *ContainerDatasetAction {
	s.Variables = v
	return s
}

type CreateChannelInput struct {
	_ struct{} `type:"structure"`

	// The name of the channel.
	//
	// ChannelName is a required field
	ChannelName *string `locationName:"channelName" min:"1" type:"string" required:"true"`

	// How long, in days, message data is kept for the channel.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`

	// Metadata which can be used to manage the channel.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s CreateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.RetentionPeriod != nil {
		if err := s.RetentionPeriod.Validate(); err != nil {
			invalidParams.AddNested("RetentionPeriod", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *CreateChannelInput) SetChannelName(v string) *CreateChannelInput {
	s.ChannelName = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *CreateChannelInput) SetRetentionPeriod(v *RetentionPeriod) *CreateChannelInput {
	s.RetentionPeriod = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelInput) SetTags(v []*Tag) *CreateChannelInput {
	s.Tags = v
	return s
}

type CreateChannelOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `locationName:"channelArn" type:"string"`

	// The name of the channel.
	ChannelName *string `locationName:"channelName" min:"1" type:"string"`

	// How long, in days, message data is kept for the channel.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`
}

// String returns the string representation
func (s CreateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateChannelOutput) SetChannelArn(v string) *CreateChannelOutput {
	s.ChannelArn = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *CreateChannelOutput) SetChannelName(v string) *CreateChannelOutput {
	s.ChannelName = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *CreateChannelOutput) SetRetentionPeriod(v *RetentionPeriod) *CreateChannelOutput {
	s.RetentionPeriod = v
	return s
}

type CreateDatasetContentInput struct {
	_ struct{} `type:"structure"`

	// The name of the data set.
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"datasetName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDatasetContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetContentInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *CreateDatasetContentInput) SetDatasetName(v string) *CreateDatasetContentInput {
	s.DatasetName = &v
	return s
}

type CreateDatasetContentOutput struct {
	_ struct{} `type:"structure"`

	// The version ID of the data set contents which are being created.
	VersionId *string `locationName:"versionId" min:"7" type:"string"`
}

// String returns the string representation
func (s CreateDatasetContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetContentOutput) GoString() string {
	return s.String()
}

// SetVersionId sets the VersionId field's value.
func (s *CreateDatasetContentOutput) SetVersionId(v string) *CreateDatasetContentOutput {
	s.VersionId = &v
	return s
}

type CreateDatasetInput struct {
	_ struct{} `type:"structure"`

	// A list of actions that create the data set contents.
	//
	// Actions is a required field
	Actions []*DatasetAction `locationName:"actions" min:"1" type:"list" required:"true"`

	// The name of the data set.
	//
	// DatasetName is a required field
	DatasetName *string `locationName:"datasetName" min:"1" type:"string" required:"true"`

	// [Optional] How long, in days, message data is kept for the data set. If not
	// given or set to null, the latest version of the dataset content plus the
	// latest succeeded version (if they are different) are retained for at most
	// 90 days.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`

	// Metadata which can be used to manage the data set.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`

	// A list of triggers. A trigger causes data set contents to be populated at
	// a specified time interval or when another data set's contents are created.
	// The list of triggers can be empty or contain up to five DataSetTrigger objects.
	Triggers []*DatasetTrigger `locationName:"triggers" type:"list"`
}

// String returns the string representation
func (s CreateDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Actions", 1))
	}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RetentionPeriod != nil {
		if err := s.RetentionPeriod.Validate(); err != nil {
			invalidParams.AddNested("RetentionPeriod", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Triggers != nil {
		for i, v := range s.Triggers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Triggers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *CreateDatasetInput) SetActions(v []*DatasetAction) *CreateDatasetInput {
	s.Actions = v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *CreateDatasetInput) SetDatasetName(v string) *CreateDatasetInput {
	s.DatasetName = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *CreateDatasetInput) SetRetentionPeriod(v *RetentionPeriod) *CreateDatasetInput {
	s.RetentionPeriod = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDatasetInput) SetTags(v []*Tag) *CreateDatasetInput {
	s.Tags = v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *CreateDatasetInput) SetTriggers(v []*DatasetTrigger) *CreateDatasetInput {
	s.Triggers = v
	return s
}

type CreateDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the data set.
	DatasetArn *string `locationName:"datasetArn" type:"string"`

	// The name of the data set.
	DatasetName *string `locationName:"datasetName" min:"1" type:"string"`

	// How long, in days, message data is kept for the data set.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`
}

// String returns the string representation
func (s CreateDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatasetOutput) GoString() string {
	return s.String()
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *CreateDatasetOutput) SetDatasetArn(v string) *CreateDatasetOutput {
	s.DatasetArn = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *CreateDatasetOutput) SetDatasetName(v string) *CreateDatasetOutput {
	s.DatasetName = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *CreateDatasetOutput) SetRetentionPeriod(v *RetentionPeriod) *CreateDatasetOutput {
	s.RetentionPeriod = v
	return s
}

type CreateDatastoreInput struct {
	_ struct{} `type:"structure"`

	// The name of the data store.
	//
	// DatastoreName is a required field
	DatastoreName *string `locationName:"datastoreName" min:"1" type:"string" required:"true"`

	// How long, in days, message data is kept for the data store.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`

	// Metadata which can be used to manage the data store.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s CreateDatastoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatastoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatastoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatastoreInput"}
	if s.DatastoreName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreName"))
	}
	if s.DatastoreName != nil && len(*s.DatastoreName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.RetentionPeriod != nil {
		if err := s.RetentionPeriod.Validate(); err != nil {
			invalidParams.AddNested("RetentionPeriod", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *CreateDatastoreInput) SetDatastoreName(v string) *CreateDatastoreInput {
	s.DatastoreName = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *CreateDatastoreInput) SetRetentionPeriod(v *RetentionPeriod) *CreateDatastoreInput {
	s.RetentionPeriod = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDatastoreInput) SetTags(v []*Tag) *CreateDatastoreInput {
	s.Tags = v
	return s
}

type CreateDatastoreOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the data store.
	DatastoreArn *string `locationName:"datastoreArn" type:"string"`

	// The name of the data store.
	DatastoreName *string `locationName:"datastoreName" min:"1" type:"string"`

	// How long, in days, message data is kept for the data store.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`
}

// String returns the string representation
func (s CreateDatastoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatastoreOutput) GoString() string {
	return s.String()
}

// SetDatastoreArn sets the DatastoreArn field's value.
func (s *CreateDatastoreOutput) SetDatastoreArn(v string) *CreateDatastoreOutput {
	s.DatastoreArn = &v
	return s
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *CreateDatastoreOutput) SetDatastoreName(v string) *CreateDatastoreOutput {
	s.DatastoreName = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *CreateDatastoreOutput) SetRetentionPeriod(v *RetentionPeriod) *CreateDatastoreOutput {
	s.RetentionPeriod = v
	return s
}

type CreatePipelineInput struct {
	_ struct{} `type:"structure"`

	// A list of pipeline activities.
	//
	// The list can be 1-25 PipelineActivity objects. Activities perform transformations
	// on your messages, such as removing, renaming, or adding message attributes;
	// filtering messages based on attribute values; invoking your Lambda functions
	// on messages for advanced processing; or performing mathematical transformations
	// to normalize device data.
	//
	// PipelineActivities is a required field
	PipelineActivities []*PipelineActivity `locationName:"pipelineActivities" min:"1" type:"list" required:"true"`

	// The name of the pipeline.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// Metadata which can be used to manage the pipeline.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s CreatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePipelineInput"}
	if s.PipelineActivities == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineActivities"))
	}
	if s.PipelineActivities != nil && len(s.PipelineActivities) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineActivities", 1))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.PipelineActivities != nil {
		for i, v := range s.PipelineActivities {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PipelineActivities", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineActivities sets the PipelineActivities field's value.
func (s *CreatePipelineInput) SetPipelineActivities(v []*PipelineActivity) *CreatePipelineInput {
	s.PipelineActivities = v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *CreatePipelineInput) SetPipelineName(v string) *CreatePipelineInput {
	s.PipelineName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePipelineInput) SetTags(v []*Tag) *CreatePipelineInput {
	s.Tags = v
	return s
}

type CreatePipelineOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the pipeline.
	PipelineArn *string `locationName:"pipelineArn" type:"string"`

	// The name of the pipeline.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePipelineOutput) GoString() string {
	return s.String()
}

// SetPipelineArn sets the PipelineArn field's value.
func (s *CreatePipelineOutput) SetPipelineArn(v string) *CreatePipelineOutput {
	s.PipelineArn = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *CreatePipelineOutput) SetPipelineName(v string) *CreatePipelineOutput {
	s.PipelineName = &v
	return s
}

// Information about a data set.
type Dataset struct {
	_ struct{} `type:"structure"`

	// The "DatasetAction" objects that automatically create the data set contents.
	Actions []*DatasetAction `locationName:"actions" min:"1" type:"list"`

	// The ARN of the data set.
	Arn *string `locationName:"arn" type:"string"`

	// When the data set was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The last time the data set was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The name of the data set.
	Name *string `locationName:"name" min:"1" type:"string"`

	// [Optional] How long, in days, message data is kept for the data set.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`

	// The status of the data set.
	Status *string `locationName:"status" type:"string" enum:"DatasetStatus"`

	// The "DatasetTrigger" objects that specify when the data set is automatically
	// updated.
	Triggers []*DatasetTrigger `locationName:"triggers" type:"list"`
}

// String returns the string representation
func (s Dataset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Dataset) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *Dataset) SetActions(v []*DatasetAction) *Dataset {
	s.Actions = v
	return s
}

// SetArn sets the Arn field's value.
func (s *Dataset) SetArn(v string) *Dataset {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Dataset) SetCreationTime(v time.Time) *Dataset {
	s.CreationTime = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *Dataset) SetLastUpdateTime(v time.Time) *Dataset {
	s.LastUpdateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Dataset) SetName(v string) *Dataset {
	s.Name = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *Dataset) SetRetentionPeriod(v *RetentionPeriod) *Dataset {
	s.RetentionPeriod = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Dataset) SetStatus(v string) *Dataset {
	s.Status = &v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *Dataset) SetTriggers(v []*DatasetTrigger) *Dataset {
	s.Triggers = v
	return s
}

// A "DatasetAction" object specifying the query that creates the data set content.
type DatasetAction struct {
	_ struct{} `type:"structure"`

	// The name of the data set action by which data set contents are automatically
	// created.
	ActionName *string `locationName:"actionName" min:"1" type:"string"`

	// Information which allows the system to run a containerized application in
	// order to create the data set contents. The application must be in a Docker
	// container along with any needed support libraries.
	ContainerAction *ContainerDatasetAction `locationName:"containerAction" type:"structure"`

	// An "SqlQueryDatasetAction" object that contains the SQL query to modify the
	// message.
	QueryAction *SqlQueryDatasetAction `locationName:"queryAction" type:"structure"`
}

// String returns the string representation
func (s DatasetAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetAction"}
	if s.ActionName != nil && len(*s.ActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionName", 1))
	}
	if s.ContainerAction != nil {
		if err := s.ContainerAction.Validate(); err != nil {
			invalidParams.AddNested("ContainerAction", err.(request.ErrInvalidParams))
		}
	}
	if s.QueryAction != nil {
		if err := s.QueryAction.Validate(); err != nil {
			invalidParams.AddNested("QueryAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionName sets the ActionName field's value.
func (s *DatasetAction) SetActionName(v string) *DatasetAction {
	s.ActionName = &v
	return s
}

// SetContainerAction sets the ContainerAction field's value.
func (s *DatasetAction) SetContainerAction(v *ContainerDatasetAction) *DatasetAction {
	s.ContainerAction = v
	return s
}

// SetQueryAction sets the QueryAction field's value.
func (s *DatasetAction) SetQueryAction(v *SqlQueryDatasetAction) *DatasetAction {
	s.QueryAction = v
	return s
}

type DatasetActionSummary struct {
	_ struct{} `type:"structure"`

	// The name of the action which automatically creates the data set's contents.
	ActionName *string `locationName:"actionName" min:"1" type:"string"`

	// The type of action by which the data set's contents are automatically created.
	ActionType *string `locationName:"actionType" type:"string" enum:"DatasetActionType"`
}

// String returns the string representation
func (s DatasetActionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetActionSummary) GoString() string {
	return s.String()
}

// SetActionName sets the ActionName field's value.
func (s *DatasetActionSummary) SetActionName(v string) *DatasetActionSummary {
	s.ActionName = &v
	return s
}

// SetActionType sets the ActionType field's value.
func (s *DatasetActionSummary) SetActionType(v string) *DatasetActionSummary {
	s.ActionType = &v
	return s
}

// The state of the data set contents and the reason they are in this state.
type DatasetContentStatus struct {
	_ struct{} `type:"structure"`

	// The reason the data set contents are in this state.
	Reason *string `locationName:"reason" type:"string"`

	// The state of the data set contents. Can be one of "READY", "CREATING", "SUCCEEDED"
	// or "FAILED".
	State *string `locationName:"state" type:"string" enum:"DatasetContentState"`
}

// String returns the string representation
func (s DatasetContentStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetContentStatus) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *DatasetContentStatus) SetReason(v string) *DatasetContentStatus {
	s.Reason = &v
	return s
}

// SetState sets the State field's value.
func (s *DatasetContentStatus) SetState(v string) *DatasetContentStatus {
	s.State = &v
	return s
}

// Summary information about data set contents.
type DatasetContentSummary struct {
	_ struct{} `type:"structure"`

	// The actual time the creation of the data set contents was started.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The time the creation of the data set contents was scheduled to start.
	ScheduleTime *time.Time `locationName:"scheduleTime" type:"timestamp"`

	// The status of the data set contents.
	Status *DatasetContentStatus `locationName:"status" type:"structure"`

	// The version of the data set contents.
	Version *string `locationName:"version" min:"7" type:"string"`
}

// String returns the string representation
func (s DatasetContentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetContentSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DatasetContentSummary) SetCreationTime(v time.Time) *DatasetContentSummary {
	s.CreationTime = &v
	return s
}

// SetScheduleTime sets the ScheduleTime field's value.
func (s *DatasetContentSummary) SetScheduleTime(v time.Time) *DatasetContentSummary {
	s.ScheduleTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetContentSummary) SetStatus(v *DatasetContentStatus) *DatasetContentSummary {
	s.Status = v
	return s
}

// SetVersion sets the Version field's value.
func (s *DatasetContentSummary) SetVersion(v string) *DatasetContentSummary {
	s.Version = &v
	return s
}

// The data set whose latest contents will be used as input to the notebook
// or application.
type DatasetContentVersionValue struct {
	_ struct{} `type:"structure"`

	// The name of the data set whose latest contents will be used as input to the
	// notebook or application.
	//
	// DatasetName is a required field
	DatasetName *string `locationName:"datasetName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DatasetContentVersionValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetContentVersionValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetContentVersionValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetContentVersionValue"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *DatasetContentVersionValue) SetDatasetName(v string) *DatasetContentVersionValue {
	s.DatasetName = &v
	return s
}

// The reference to a data set entry.
type DatasetEntry struct {
	_ struct{} `type:"structure"`

	// The pre-signed URI of the data set item.
	DataURI *string `locationName:"dataURI" type:"string"`

	// The name of the data set item.
	EntryName *string `locationName:"entryName" type:"string"`
}

// String returns the string representation
func (s DatasetEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetEntry) GoString() string {
	return s.String()
}

// SetDataURI sets the DataURI field's value.
func (s *DatasetEntry) SetDataURI(v string) *DatasetEntry {
	s.DataURI = &v
	return s
}

// SetEntryName sets the EntryName field's value.
func (s *DatasetEntry) SetEntryName(v string) *DatasetEntry {
	s.EntryName = &v
	return s
}

// A summary of information about a data set.
type DatasetSummary struct {
	_ struct{} `type:"structure"`

	// A list of "DataActionSummary" objects.
	Actions []*DatasetActionSummary `locationName:"actions" min:"1" type:"list"`

	// The time the data set was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The name of the data set.
	DatasetName *string `locationName:"datasetName" min:"1" type:"string"`

	// The last time the data set was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The status of the data set.
	Status *string `locationName:"status" type:"string" enum:"DatasetStatus"`

	// A list of triggers. A trigger causes data set content to be populated at
	// a specified time interval or when another data set is populated. The list
	// of triggers can be empty or contain up to five DataSetTrigger objects
	Triggers []*DatasetTrigger `locationName:"triggers" type:"list"`
}

// String returns the string representation
func (s DatasetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetSummary) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *DatasetSummary) SetActions(v []*DatasetActionSummary) *DatasetSummary {
	s.Actions = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DatasetSummary) SetCreationTime(v time.Time) *DatasetSummary {
	s.CreationTime = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *DatasetSummary) SetDatasetName(v string) *DatasetSummary {
	s.DatasetName = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *DatasetSummary) SetLastUpdateTime(v time.Time) *DatasetSummary {
	s.LastUpdateTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetSummary) SetStatus(v string) *DatasetSummary {
	s.Status = &v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *DatasetSummary) SetTriggers(v []*DatasetTrigger) *DatasetSummary {
	s.Triggers = v
	return s
}

// The "DatasetTrigger" that specifies when the data set is automatically updated.
type DatasetTrigger struct {
	_ struct{} `type:"structure"`

	// The data set whose content creation will trigger the creation of this data
	// set's contents.
	Dataset *TriggeringDataset `locationName:"dataset" type:"structure"`

	// The "Schedule" when the trigger is initiated.
	Schedule *Schedule `locationName:"schedule" type:"structure"`
}

// String returns the string representation
func (s DatasetTrigger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetTrigger) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetTrigger) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetTrigger"}
	if s.Dataset != nil {
		if err := s.Dataset.Validate(); err != nil {
			invalidParams.AddNested("Dataset", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataset sets the Dataset field's value.
func (s *DatasetTrigger) SetDataset(v *TriggeringDataset) *DatasetTrigger {
	s.Dataset = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *DatasetTrigger) SetSchedule(v *Schedule) *DatasetTrigger {
	s.Schedule = v
	return s
}

// Information about a data store.
type Datastore struct {
	_ struct{} `type:"structure"`

	// The ARN of the data store.
	Arn *string `locationName:"arn" type:"string"`

	// When the data store was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The last time the data store was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The name of the data store.
	Name *string `locationName:"name" min:"1" type:"string"`

	// How long, in days, message data is kept for the data store.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`

	// The status of a data store:
	//
	// CREATINGThe data store is being created.
	//
	// ACTIVEThe data store has been created and can be used.
	//
	// DELETINGThe data store is being deleted.
	Status *string `locationName:"status" type:"string" enum:"DatastoreStatus"`
}

// String returns the string representation
func (s Datastore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Datastore) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Datastore) SetArn(v string) *Datastore {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Datastore) SetCreationTime(v time.Time) *Datastore {
	s.CreationTime = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *Datastore) SetLastUpdateTime(v time.Time) *Datastore {
	s.LastUpdateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Datastore) SetName(v string) *Datastore {
	s.Name = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *Datastore) SetRetentionPeriod(v *RetentionPeriod) *Datastore {
	s.RetentionPeriod = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Datastore) SetStatus(v string) *Datastore {
	s.Status = &v
	return s
}

// The 'datastore' activity that specifies where to store the processed data.
type DatastoreActivity struct {
	_ struct{} `type:"structure"`

	// The name of the data store where processed messages are stored.
	//
	// DatastoreName is a required field
	DatastoreName *string `locationName:"datastoreName" min:"1" type:"string" required:"true"`

	// The name of the 'datastore' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DatastoreActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatastoreActivity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatastoreActivity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatastoreActivity"}
	if s.DatastoreName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreName"))
	}
	if s.DatastoreName != nil && len(*s.DatastoreName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *DatastoreActivity) SetDatastoreName(v string) *DatastoreActivity {
	s.DatastoreName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DatastoreActivity) SetName(v string) *DatastoreActivity {
	s.Name = &v
	return s
}

// Statistical information about the data store.
type DatastoreStatistics struct {
	_ struct{} `type:"structure"`

	// The estimated size of the data store.
	Size *EstimatedResourceSize `locationName:"size" type:"structure"`
}

// String returns the string representation
func (s DatastoreStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatastoreStatistics) GoString() string {
	return s.String()
}

// SetSize sets the Size field's value.
func (s *DatastoreStatistics) SetSize(v *EstimatedResourceSize) *DatastoreStatistics {
	s.Size = v
	return s
}

// A summary of information about a data store.
type DatastoreSummary struct {
	_ struct{} `type:"structure"`

	// When the data store was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The name of the data store.
	DatastoreName *string `locationName:"datastoreName" min:"1" type:"string"`

	// The last time the data store was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The status of the data store.
	Status *string `locationName:"status" type:"string" enum:"DatastoreStatus"`
}

// String returns the string representation
func (s DatastoreSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatastoreSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DatastoreSummary) SetCreationTime(v time.Time) *DatastoreSummary {
	s.CreationTime = &v
	return s
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *DatastoreSummary) SetDatastoreName(v string) *DatastoreSummary {
	s.DatastoreName = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *DatastoreSummary) SetLastUpdateTime(v time.Time) *DatastoreSummary {
	s.LastUpdateTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatastoreSummary) SetStatus(v string) *DatastoreSummary {
	s.Status = &v
	return s
}

type DeleteChannelInput struct {
	_ struct{} `type:"structure"`

	// The name of the channel to delete.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"channelName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *DeleteChannelInput) SetChannelName(v string) *DeleteChannelInput {
	s.ChannelName = &v
	return s
}

type DeleteChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelOutput) GoString() string {
	return s.String()
}

type DeleteDatasetContentInput struct {
	_ struct{} `type:"structure"`

	// The name of the data set whose content is deleted.
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"datasetName" min:"1" type:"string" required:"true"`

	// The version of the data set whose content is deleted. You can also use the
	// strings "$LATEST" or "$LATEST_SUCCEEDED" to delete the latest or latest successfully
	// completed data set. If not specified, "$LATEST_SUCCEEDED" is the default.
	VersionId *string `location:"querystring" locationName:"versionId" min:"7" type:"string"`
}

// String returns the string representation
func (s DeleteDatasetContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatasetContentInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.VersionId != nil && len(*s.VersionId) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *DeleteDatasetContentInput) SetDatasetName(v string) *DeleteDatasetContentInput {
	s.DatasetName = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteDatasetContentInput) SetVersionId(v string) *DeleteDatasetContentInput {
	s.VersionId = &v
	return s
}

type DeleteDatasetContentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDatasetContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetContentOutput) GoString() string {
	return s.String()
}

type DeleteDatasetInput struct {
	_ struct{} `type:"structure"`

	// The name of the data set to delete.
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"datasetName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatasetInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *DeleteDatasetInput) SetDatasetName(v string) *DeleteDatasetInput {
	s.DatasetName = &v
	return s
}

type DeleteDatasetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetOutput) GoString() string {
	return s.String()
}

type DeleteDatastoreInput struct {
	_ struct{} `type:"structure"`

	// The name of the data store to delete.
	//
	// DatastoreName is a required field
	DatastoreName *string `location:"uri" locationName:"datastoreName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDatastoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatastoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatastoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatastoreInput"}
	if s.DatastoreName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreName"))
	}
	if s.DatastoreName != nil && len(*s.DatastoreName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *DeleteDatastoreInput) SetDatastoreName(v string) *DeleteDatastoreInput {
	s.DatastoreName = &v
	return s
}

type DeleteDatastoreOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDatastoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatastoreOutput) GoString() string {
	return s.String()
}

type DeletePipelineInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline to delete.
	//
	// PipelineName is a required field
	PipelineName *string `location:"uri" locationName:"pipelineName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePipelineInput"}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineName sets the PipelineName field's value.
func (s *DeletePipelineInput) SetPipelineName(v string) *DeletePipelineInput {
	s.PipelineName = &v
	return s
}

type DeletePipelineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePipelineOutput) GoString() string {
	return s.String()
}

// When you create data set contents using message data from a specified time
// frame, some message data may still be "in flight" when processing begins,
// and so will not arrive in time to be processed. Use this field to make allowances
// for the "in flight" time of your message data, so that data not processed
// from the previous time frame will be included with the next time frame. Without
// this, missed message data would be excluded from processing during the next
// time frame as well, because its timestamp places it within the previous time
// frame.
type DeltaTime struct {
	_ struct{} `type:"structure"`

	// The number of seconds of estimated "in flight" lag time of message data.
	//
	// OffsetSeconds is a required field
	OffsetSeconds *int64 `locationName:"offsetSeconds" type:"integer" required:"true"`

	// An expression by which the time of the message data may be determined. This
	// may be the name of a timestamp field, or a SQL expression which is used to
	// derive the time the message data was generated.
	//
	// TimeExpression is a required field
	TimeExpression *string `locationName:"timeExpression" type:"string" required:"true"`
}

// String returns the string representation
func (s DeltaTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeltaTime) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeltaTime) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeltaTime"}
	if s.OffsetSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("OffsetSeconds"))
	}
	if s.TimeExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeExpression"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOffsetSeconds sets the OffsetSeconds field's value.
func (s *DeltaTime) SetOffsetSeconds(v int64) *DeltaTime {
	s.OffsetSeconds = &v
	return s
}

// SetTimeExpression sets the TimeExpression field's value.
func (s *DeltaTime) SetTimeExpression(v string) *DeltaTime {
	s.TimeExpression = &v
	return s
}

type DescribeChannelInput struct {
	_ struct{} `type:"structure"`

	// The name of the channel whose information is retrieved.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"channelName" min:"1" type:"string" required:"true"`

	// If true, additional statistical information about the channel is included
	// in the response.
	IncludeStatistics *bool `location:"querystring" locationName:"includeStatistics" type:"boolean"`
}

// String returns the string representation
func (s DescribeChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *DescribeChannelInput) SetChannelName(v string) *DescribeChannelInput {
	s.ChannelName = &v
	return s
}

// SetIncludeStatistics sets the IncludeStatistics field's value.
func (s *DescribeChannelInput) SetIncludeStatistics(v bool) *DescribeChannelInput {
	s.IncludeStatistics = &v
	return s
}

type DescribeChannelOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the channel.
	Channel *Channel `locationName:"channel" type:"structure"`

	// Statistics about the channel. Included if the 'includeStatistics' parameter
	// is set to true in the request.
	Statistics *ChannelStatistics `locationName:"statistics" type:"structure"`
}

// String returns the string representation
func (s DescribeChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *DescribeChannelOutput) SetChannel(v *Channel) *DescribeChannelOutput {
	s.Channel = v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *DescribeChannelOutput) SetStatistics(v *ChannelStatistics) *DescribeChannelOutput {
	s.Statistics = v
	return s
}

type DescribeDatasetInput struct {
	_ struct{} `type:"structure"`

	// The name of the data set whose information is retrieved.
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"datasetName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *DescribeDatasetInput) SetDatasetName(v string) *DescribeDatasetInput {
	s.DatasetName = &v
	return s
}

type DescribeDatasetOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the data set.
	Dataset *Dataset `locationName:"dataset" type:"structure"`
}

// String returns the string representation
func (s DescribeDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetOutput) GoString() string {
	return s.String()
}

// SetDataset sets the Dataset field's value.
func (s *DescribeDatasetOutput) SetDataset(v *Dataset) *DescribeDatasetOutput {
	s.Dataset = v
	return s
}

type DescribeDatastoreInput struct {
	_ struct{} `type:"structure"`

	// The name of the data store
	//
	// DatastoreName is a required field
	DatastoreName *string `location:"uri" locationName:"datastoreName" min:"1" type:"string" required:"true"`

	// If true, additional statistical information about the datastore is included
	// in the response.
	IncludeStatistics *bool `location:"querystring" locationName:"includeStatistics" type:"boolean"`
}

// String returns the string representation
func (s DescribeDatastoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatastoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatastoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatastoreInput"}
	if s.DatastoreName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreName"))
	}
	if s.DatastoreName != nil && len(*s.DatastoreName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *DescribeDatastoreInput) SetDatastoreName(v string) *DescribeDatastoreInput {
	s.DatastoreName = &v
	return s
}

// SetIncludeStatistics sets the IncludeStatistics field's value.
func (s *DescribeDatastoreInput) SetIncludeStatistics(v bool) *DescribeDatastoreInput {
	s.IncludeStatistics = &v
	return s
}

type DescribeDatastoreOutput struct {
	_ struct{} `type:"structure"`

	// Information about the data store.
	Datastore *Datastore `locationName:"datastore" type:"structure"`

	// Additional statistical information about the data store. Included if the
	// 'includeStatistics' parameter is set to true in the request.
	Statistics *DatastoreStatistics `locationName:"statistics" type:"structure"`
}

// String returns the string representation
func (s DescribeDatastoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatastoreOutput) GoString() string {
	return s.String()
}

// SetDatastore sets the Datastore field's value.
func (s *DescribeDatastoreOutput) SetDatastore(v *Datastore) *DescribeDatastoreOutput {
	s.Datastore = v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *DescribeDatastoreOutput) SetStatistics(v *DatastoreStatistics) *DescribeDatastoreOutput {
	s.Statistics = v
	return s
}

type DescribeLoggingOptionsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoggingOptionsInput) GoString() string {
	return s.String()
}

type DescribeLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The current settings of the AWS IoT Analytics logging options.
	LoggingOptions *LoggingOptions `locationName:"loggingOptions" type:"structure"`
}

// String returns the string representation
func (s DescribeLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoggingOptionsOutput) GoString() string {
	return s.String()
}

// SetLoggingOptions sets the LoggingOptions field's value.
func (s *DescribeLoggingOptionsOutput) SetLoggingOptions(v *LoggingOptions) *DescribeLoggingOptionsOutput {
	s.LoggingOptions = v
	return s
}

type DescribePipelineInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline whose information is retrieved.
	//
	// PipelineName is a required field
	PipelineName *string `location:"uri" locationName:"pipelineName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePipelineInput"}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineName sets the PipelineName field's value.
func (s *DescribePipelineInput) SetPipelineName(v string) *DescribePipelineInput {
	s.PipelineName = &v
	return s
}

type DescribePipelineOutput struct {
	_ struct{} `type:"structure"`

	// A "Pipeline" object that contains information about the pipeline.
	Pipeline *Pipeline `locationName:"pipeline" type:"structure"`
}

// String returns the string representation
func (s DescribePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePipelineOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *DescribePipelineOutput) SetPipeline(v *Pipeline) *DescribePipelineOutput {
	s.Pipeline = v
	return s
}

// An activity that adds data from the AWS IoT device registry to your message.
type DeviceRegistryEnrichActivity struct {
	_ struct{} `type:"structure"`

	// The name of the attribute that is added to the message.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" min:"1" type:"string" required:"true"`

	// The name of the 'deviceRegistryEnrich' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`

	// The ARN of the role that allows access to the device's registry information.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The name of the IoT device whose registry information is added to the message.
	//
	// ThingName is a required field
	ThingName *string `locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeviceRegistryEnrichActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceRegistryEnrichActivity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeviceRegistryEnrichActivity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeviceRegistryEnrichActivity"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Attribute != nil && len(*s.Attribute) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attribute", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Next", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *DeviceRegistryEnrichActivity) SetAttribute(v string) *DeviceRegistryEnrichActivity {
	s.Attribute = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeviceRegistryEnrichActivity) SetName(v string) *DeviceRegistryEnrichActivity {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *DeviceRegistryEnrichActivity) SetNext(v string) *DeviceRegistryEnrichActivity {
	s.Next = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DeviceRegistryEnrichActivity) SetRoleArn(v string) *DeviceRegistryEnrichActivity {
	s.RoleArn = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DeviceRegistryEnrichActivity) SetThingName(v string) *DeviceRegistryEnrichActivity {
	s.ThingName = &v
	return s
}

// An activity that adds information from the AWS IoT Device Shadows service
// to a message.
type DeviceShadowEnrichActivity struct {
	_ struct{} `type:"structure"`

	// The name of the attribute that is added to the message.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" min:"1" type:"string" required:"true"`

	// The name of the 'deviceShadowEnrich' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`

	// The ARN of the role that allows access to the device's shadow.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The name of the IoT device whose shadow information is added to the message.
	//
	// ThingName is a required field
	ThingName *string `locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeviceShadowEnrichActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceShadowEnrichActivity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeviceShadowEnrichActivity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeviceShadowEnrichActivity"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Attribute != nil && len(*s.Attribute) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attribute", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Next", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *DeviceShadowEnrichActivity) SetAttribute(v string) *DeviceShadowEnrichActivity {
	s.Attribute = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeviceShadowEnrichActivity) SetName(v string) *DeviceShadowEnrichActivity {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *DeviceShadowEnrichActivity) SetNext(v string) *DeviceShadowEnrichActivity {
	s.Next = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DeviceShadowEnrichActivity) SetRoleArn(v string) *DeviceShadowEnrichActivity {
	s.RoleArn = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DeviceShadowEnrichActivity) SetThingName(v string) *DeviceShadowEnrichActivity {
	s.ThingName = &v
	return s
}

// The estimated size of the resource.
type EstimatedResourceSize struct {
	_ struct{} `type:"structure"`

	// The time when the estimate of the size of the resource was made.
	EstimatedOn *time.Time `locationName:"estimatedOn" type:"timestamp"`

	// The estimated size of the resource in bytes.
	EstimatedSizeInBytes *float64 `locationName:"estimatedSizeInBytes" type:"double"`
}

// String returns the string representation
func (s EstimatedResourceSize) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EstimatedResourceSize) GoString() string {
	return s.String()
}

// SetEstimatedOn sets the EstimatedOn field's value.
func (s *EstimatedResourceSize) SetEstimatedOn(v time.Time) *EstimatedResourceSize {
	s.EstimatedOn = &v
	return s
}

// SetEstimatedSizeInBytes sets the EstimatedSizeInBytes field's value.
func (s *EstimatedResourceSize) SetEstimatedSizeInBytes(v float64) *EstimatedResourceSize {
	s.EstimatedSizeInBytes = &v
	return s
}

// An activity that filters a message based on its attributes.
type FilterActivity struct {
	_ struct{} `type:"structure"`

	// An expression that looks like a SQL WHERE clause that must return a Boolean
	// value.
	//
	// Filter is a required field
	Filter *string `locationName:"filter" min:"1" type:"string" required:"true"`

	// The name of the 'filter' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`
}

// String returns the string representation
func (s FilterActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterActivity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FilterActivity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FilterActivity"}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.Filter != nil && len(*s.Filter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filter", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Next", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *FilterActivity) SetFilter(v string) *FilterActivity {
	s.Filter = &v
	return s
}

// SetName sets the Name field's value.
func (s *FilterActivity) SetName(v string) *FilterActivity {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *FilterActivity) SetNext(v string) *FilterActivity {
	s.Next = &v
	return s
}

type GetDatasetContentInput struct {
	_ struct{} `type:"structure"`

	// The name of the data set whose contents are retrieved.
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"datasetName" min:"1" type:"string" required:"true"`

	// The version of the data set whose contents are retrieved. You can also use
	// the strings "$LATEST" or "$LATEST_SUCCEEDED" to retrieve the contents of
	// the latest or latest successfully completed data set. If not specified, "$LATEST_SUCCEEDED"
	// is the default.
	VersionId *string `location:"querystring" locationName:"versionId" min:"7" type:"string"`
}

// String returns the string representation
func (s GetDatasetContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDatasetContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDatasetContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDatasetContentInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.VersionId != nil && len(*s.VersionId) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *GetDatasetContentInput) SetDatasetName(v string) *GetDatasetContentInput {
	s.DatasetName = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetDatasetContentInput) SetVersionId(v string) *GetDatasetContentInput {
	s.VersionId = &v
	return s
}

type GetDatasetContentOutput struct {
	_ struct{} `type:"structure"`

	// A list of "DatasetEntry" objects.
	Entries []*DatasetEntry `locationName:"entries" type:"list"`

	// The status of the data set content.
	Status *DatasetContentStatus `locationName:"status" type:"structure"`

	// The time when the request was made.
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp"`
}

// String returns the string representation
func (s GetDatasetContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDatasetContentOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *GetDatasetContentOutput) SetEntries(v []*DatasetEntry) *GetDatasetContentOutput {
	s.Entries = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDatasetContentOutput) SetStatus(v *DatasetContentStatus) *GetDatasetContentOutput {
	s.Status = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *GetDatasetContentOutput) SetTimestamp(v time.Time) *GetDatasetContentOutput {
	s.Timestamp = &v
	return s
}

// An activity that runs a Lambda function to modify the message.
type LambdaActivity struct {
	_ struct{} `type:"structure"`

	// The number of messages passed to the Lambda function for processing.
	//
	// The AWS Lambda function must be able to process all of these messages within
	// five minutes, which is the maximum timeout duration for Lambda functions.
	//
	// BatchSize is a required field
	BatchSize *int64 `locationName:"batchSize" min:"1" type:"integer" required:"true"`

	// The name of the Lambda function that is run on the message.
	//
	// LambdaName is a required field
	LambdaName *string `locationName:"lambdaName" min:"1" type:"string" required:"true"`

	// The name of the 'lambda' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`
}

// String returns the string representation
func (s LambdaActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaActivity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaActivity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaActivity"}
	if s.BatchSize == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchSize"))
	}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.LambdaName == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaName"))
	}
	if s.LambdaName != nil && len(*s.LambdaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Next", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *LambdaActivity) SetBatchSize(v int64) *LambdaActivity {
	s.BatchSize = &v
	return s
}

// SetLambdaName sets the LambdaName field's value.
func (s *LambdaActivity) SetLambdaName(v string) *LambdaActivity {
	s.LambdaName = &v
	return s
}

// SetName sets the Name field's value.
func (s *LambdaActivity) SetName(v string) *LambdaActivity {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *LambdaActivity) SetNext(v string) *LambdaActivity {
	s.Next = &v
	return s
}

type ListChannelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this request.
	//
	// The default value is 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelsInput) SetMaxResults(v int64) *ListChannelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsInput) SetNextToken(v string) *ListChannelsInput {
	s.NextToken = &v
	return s
}

type ListChannelsOutput struct {
	_ struct{} `type:"structure"`

	// A list of "ChannelSummary" objects.
	ChannelSummaries []*ChannelSummary `locationName:"channelSummaries" type:"list"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelsOutput) GoString() string {
	return s.String()
}

// SetChannelSummaries sets the ChannelSummaries field's value.
func (s *ListChannelsOutput) SetChannelSummaries(v []*ChannelSummary) *ListChannelsOutput {
	s.ChannelSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsOutput) SetNextToken(v string) *ListChannelsOutput {
	s.NextToken = &v
	return s
}

type ListDatasetContentsInput struct {
	_ struct{} `type:"structure"`

	// The name of the data set whose contents information you want to list.
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"datasetName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDatasetContentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetContentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetContentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetContentsInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *ListDatasetContentsInput) SetDatasetName(v string) *ListDatasetContentsInput {
	s.DatasetName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetContentsInput) SetMaxResults(v int64) *ListDatasetContentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetContentsInput) SetNextToken(v string) *ListDatasetContentsInput {
	s.NextToken = &v
	return s
}

type ListDatasetContentsOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about data set contents that have been created.
	DatasetContentSummaries []*DatasetContentSummary `locationName:"datasetContentSummaries" type:"list"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDatasetContentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetContentsOutput) GoString() string {
	return s.String()
}

// SetDatasetContentSummaries sets the DatasetContentSummaries field's value.
func (s *ListDatasetContentsOutput) SetDatasetContentSummaries(v []*DatasetContentSummary) *ListDatasetContentsOutput {
	s.DatasetContentSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetContentsOutput) SetNextToken(v string) *ListDatasetContentsOutput {
	s.NextToken = &v
	return s
}

type ListDatasetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this request.
	//
	// The default value is 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDatasetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetsInput) SetMaxResults(v int64) *ListDatasetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsInput) SetNextToken(v string) *ListDatasetsInput {
	s.NextToken = &v
	return s
}

type ListDatasetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of "DatasetSummary" objects.
	DatasetSummaries []*DatasetSummary `locationName:"datasetSummaries" type:"list"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDatasetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetsOutput) GoString() string {
	return s.String()
}

// SetDatasetSummaries sets the DatasetSummaries field's value.
func (s *ListDatasetsOutput) SetDatasetSummaries(v []*DatasetSummary) *ListDatasetsOutput {
	s.DatasetSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsOutput) SetNextToken(v string) *ListDatasetsOutput {
	s.NextToken = &v
	return s
}

type ListDatastoresInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this request.
	//
	// The default value is 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDatastoresInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatastoresInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatastoresInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatastoresInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatastoresInput) SetMaxResults(v int64) *ListDatastoresInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatastoresInput) SetNextToken(v string) *ListDatastoresInput {
	s.NextToken = &v
	return s
}

type ListDatastoresOutput struct {
	_ struct{} `type:"structure"`

	// A list of "DatastoreSummary" objects.
	DatastoreSummaries []*DatastoreSummary `locationName:"datastoreSummaries" type:"list"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDatastoresOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatastoresOutput) GoString() string {
	return s.String()
}

// SetDatastoreSummaries sets the DatastoreSummaries field's value.
func (s *ListDatastoresOutput) SetDatastoreSummaries(v []*DatastoreSummary) *ListDatastoresOutput {
	s.DatastoreSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatastoresOutput) SetNextToken(v string) *ListDatastoresOutput {
	s.NextToken = &v
	return s
}

type ListPipelinesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this request.
	//
	// The default value is 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListPipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPipelinesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPipelinesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPipelinesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPipelinesInput) SetMaxResults(v int64) *ListPipelinesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPipelinesInput) SetNextToken(v string) *ListPipelinesInput {
	s.NextToken = &v
	return s
}

type ListPipelinesOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of "PipelineSummary" objects.
	PipelineSummaries []*PipelineSummary `locationName:"pipelineSummaries" type:"list"`
}

// String returns the string representation
func (s ListPipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPipelinesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPipelinesOutput) SetNextToken(v string) *ListPipelinesOutput {
	s.NextToken = &v
	return s
}

// SetPipelineSummaries sets the PipelineSummaries field's value.
func (s *ListPipelinesOutput) SetPipelineSummaries(v []*PipelineSummary) *ListPipelinesOutput {
	s.PipelineSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource whose tags you want to list.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags (metadata) which you have assigned to the resource.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Information about logging options.
type LoggingOptions struct {
	_ struct{} `type:"structure"`

	// If true, logging is enabled for AWS IoT Analytics.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// The logging level. Currently, only "ERROR" is supported.
	//
	// Level is a required field
	Level *string `locationName:"level" type:"string" required:"true" enum:"LoggingLevel"`

	// The ARN of the role that grants permission to AWS IoT Analytics to perform
	// logging.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingOptions"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Level == nil {
		invalidParams.Add(request.NewErrParamRequired("Level"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *LoggingOptions) SetEnabled(v bool) *LoggingOptions {
	s.Enabled = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *LoggingOptions) SetLevel(v string) *LoggingOptions {
	s.Level = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *LoggingOptions) SetRoleArn(v string) *LoggingOptions {
	s.RoleArn = &v
	return s
}

// An activity that computes an arithmetic expression using the message's attributes.
type MathActivity struct {
	_ struct{} `type:"structure"`

	// The name of the attribute that will contain the result of the math operation.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" min:"1" type:"string" required:"true"`

	// An expression that uses one or more existing attributes and must return an
	// integer value.
	//
	// Math is a required field
	Math *string `locationName:"math" min:"1" type:"string" required:"true"`

	// The name of the 'math' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`
}

// String returns the string representation
func (s MathActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MathActivity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MathActivity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MathActivity"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Attribute != nil && len(*s.Attribute) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attribute", 1))
	}
	if s.Math == nil {
		invalidParams.Add(request.NewErrParamRequired("Math"))
	}
	if s.Math != nil && len(*s.Math) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Math", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Next", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *MathActivity) SetAttribute(v string) *MathActivity {
	s.Attribute = &v
	return s
}

// SetMath sets the Math field's value.
func (s *MathActivity) SetMath(v string) *MathActivity {
	s.Math = &v
	return s
}

// SetName sets the Name field's value.
func (s *MathActivity) SetName(v string) *MathActivity {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *MathActivity) SetNext(v string) *MathActivity {
	s.Next = &v
	return s
}

// Information about a message.
type Message struct {
	_ struct{} `type:"structure"`

	// The ID you wish to assign to the message. Each "messageId" must be unique
	// within each batch sent.
	//
	// MessageId is a required field
	MessageId *string `locationName:"messageId" min:"1" type:"string" required:"true"`

	// The payload of the message. This may be a JSON string or a Base64-encoded
	// string representing binary data (in which case you must decode it by means
	// of a pipeline activity).
	//
	// Payload is automatically base64 encoded/decoded by the SDK.
	//
	// Payload is a required field
	Payload []byte `locationName:"payload" type:"blob" required:"true"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Message) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Message) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Message"}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 1))
	}
	if s.Payload == nil {
		invalidParams.Add(request.NewErrParamRequired("Payload"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessageId sets the MessageId field's value.
func (s *Message) SetMessageId(v string) *Message {
	s.MessageId = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *Message) SetPayload(v []byte) *Message {
	s.Payload = v
	return s
}

// The URI of the location where data set contents are stored, usually the URI
// of a file in an S3 bucket.
type OutputFileUriValue struct {
	_ struct{} `type:"structure"`

	// The URI of the location where data set contents are stored, usually the URI
	// of a file in an S3 bucket.
	//
	// FileName is a required field
	FileName *string `locationName:"fileName" type:"string" required:"true"`
}

// String returns the string representation
func (s OutputFileUriValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputFileUriValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputFileUriValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputFileUriValue"}
	if s.FileName == nil {
		invalidParams.Add(request.NewErrParamRequired("FileName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileName sets the FileName field's value.
func (s *OutputFileUriValue) SetFileName(v string) *OutputFileUriValue {
	s.FileName = &v
	return s
}

// Contains information about a pipeline.
type Pipeline struct {
	_ struct{} `type:"structure"`

	// The activities that perform transformations on the messages.
	Activities []*PipelineActivity `locationName:"activities" min:"1" type:"list"`

	// The ARN of the pipeline.
	Arn *string `locationName:"arn" type:"string"`

	// When the pipeline was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The last time the pipeline was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The name of the pipeline.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A summary of information about the pipeline reprocessing.
	ReprocessingSummaries []*ReprocessingSummary `locationName:"reprocessingSummaries" type:"list"`
}

// String returns the string representation
func (s Pipeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Pipeline) GoString() string {
	return s.String()
}

// SetActivities sets the Activities field's value.
func (s *Pipeline) SetActivities(v []*PipelineActivity) *Pipeline {
	s.Activities = v
	return s
}

// SetArn sets the Arn field's value.
func (s *Pipeline) SetArn(v string) *Pipeline {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Pipeline) SetCreationTime(v time.Time) *Pipeline {
	s.CreationTime = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *Pipeline) SetLastUpdateTime(v time.Time) *Pipeline {
	s.LastUpdateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Pipeline) SetName(v string) *Pipeline {
	s.Name = &v
	return s
}

// SetReprocessingSummaries sets the ReprocessingSummaries field's value.
func (s *Pipeline) SetReprocessingSummaries(v []*ReprocessingSummary) *Pipeline {
	s.ReprocessingSummaries = v
	return s
}

// An activity that performs a transformation on a message.
type PipelineActivity struct {
	_ struct{} `type:"structure"`

	// Adds other attributes based on existing attributes in the message.
	AddAttributes *AddAttributesActivity `locationName:"addAttributes" type:"structure"`

	// Determines the source of the messages to be processed.
	Channel *ChannelActivity `locationName:"channel" type:"structure"`

	// Specifies where to store the processed message data.
	Datastore *DatastoreActivity `locationName:"datastore" type:"structure"`

	// Adds data from the AWS IoT device registry to your message.
	DeviceRegistryEnrich *DeviceRegistryEnrichActivity `locationName:"deviceRegistryEnrich" type:"structure"`

	// Adds information from the AWS IoT Device Shadows service to a message.
	DeviceShadowEnrich *DeviceShadowEnrichActivity `locationName:"deviceShadowEnrich" type:"structure"`

	// Filters a message based on its attributes.
	Filter *FilterActivity `locationName:"filter" type:"structure"`

	// Runs a Lambda function to modify the message.
	Lambda *LambdaActivity `locationName:"lambda" type:"structure"`

	// Computes an arithmetic expression using the message's attributes and adds
	// it to the message.
	Math *MathActivity `locationName:"math" type:"structure"`

	// Removes attributes from a message.
	RemoveAttributes *RemoveAttributesActivity `locationName:"removeAttributes" type:"structure"`

	// Creates a new message using only the specified attributes from the original
	// message.
	SelectAttributes *SelectAttributesActivity `locationName:"selectAttributes" type:"structure"`
}

// String returns the string representation
func (s PipelineActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineActivity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipelineActivity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipelineActivity"}
	if s.AddAttributes != nil {
		if err := s.AddAttributes.Validate(); err != nil {
			invalidParams.AddNested("AddAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.Channel != nil {
		if err := s.Channel.Validate(); err != nil {
			invalidParams.AddNested("Channel", err.(request.ErrInvalidParams))
		}
	}
	if s.Datastore != nil {
		if err := s.Datastore.Validate(); err != nil {
			invalidParams.AddNested("Datastore", err.(request.ErrInvalidParams))
		}
	}
	if s.DeviceRegistryEnrich != nil {
		if err := s.DeviceRegistryEnrich.Validate(); err != nil {
			invalidParams.AddNested("DeviceRegistryEnrich", err.(request.ErrInvalidParams))
		}
	}
	if s.DeviceShadowEnrich != nil {
		if err := s.DeviceShadowEnrich.Validate(); err != nil {
			invalidParams.AddNested("DeviceShadowEnrich", err.(request.ErrInvalidParams))
		}
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.Lambda != nil {
		if err := s.Lambda.Validate(); err != nil {
			invalidParams.AddNested("Lambda", err.(request.ErrInvalidParams))
		}
	}
	if s.Math != nil {
		if err := s.Math.Validate(); err != nil {
			invalidParams.AddNested("Math", err.(request.ErrInvalidParams))
		}
	}
	if s.RemoveAttributes != nil {
		if err := s.RemoveAttributes.Validate(); err != nil {
			invalidParams.AddNested("RemoveAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.SelectAttributes != nil {
		if err := s.SelectAttributes.Validate(); err != nil {
			invalidParams.AddNested("SelectAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddAttributes sets the AddAttributes field's value.
func (s *PipelineActivity) SetAddAttributes(v *AddAttributesActivity) *PipelineActivity {
	s.AddAttributes = v
	return s
}

// SetChannel sets the Channel field's value.
func (s *PipelineActivity) SetChannel(v *ChannelActivity) *PipelineActivity {
	s.Channel = v
	return s
}

// SetDatastore sets the Datastore field's value.
func (s *PipelineActivity) SetDatastore(v *DatastoreActivity) *PipelineActivity {
	s.Datastore = v
	return s
}

// SetDeviceRegistryEnrich sets the DeviceRegistryEnrich field's value.
func (s *PipelineActivity) SetDeviceRegistryEnrich(v *DeviceRegistryEnrichActivity) *PipelineActivity {
	s.DeviceRegistryEnrich = v
	return s
}

// SetDeviceShadowEnrich sets the DeviceShadowEnrich field's value.
func (s *PipelineActivity) SetDeviceShadowEnrich(v *DeviceShadowEnrichActivity) *PipelineActivity {
	s.DeviceShadowEnrich = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *PipelineActivity) SetFilter(v *FilterActivity) *PipelineActivity {
	s.Filter = v
	return s
}

// SetLambda sets the Lambda field's value.
func (s *PipelineActivity) SetLambda(v *LambdaActivity) *PipelineActivity {
	s.Lambda = v
	return s
}

// SetMath sets the Math field's value.
func (s *PipelineActivity) SetMath(v *MathActivity) *PipelineActivity {
	s.Math = v
	return s
}

// SetRemoveAttributes sets the RemoveAttributes field's value.
func (s *PipelineActivity) SetRemoveAttributes(v *RemoveAttributesActivity) *PipelineActivity {
	s.RemoveAttributes = v
	return s
}

// SetSelectAttributes sets the SelectAttributes field's value.
func (s *PipelineActivity) SetSelectAttributes(v *SelectAttributesActivity) *PipelineActivity {
	s.SelectAttributes = v
	return s
}

// A summary of information about a pipeline.
type PipelineSummary struct {
	_ struct{} `type:"structure"`

	// When the pipeline was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// When the pipeline was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The name of the pipeline.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string"`

	// A summary of information about the pipeline reprocessing.
	ReprocessingSummaries []*ReprocessingSummary `locationName:"reprocessingSummaries" type:"list"`
}

// String returns the string representation
func (s PipelineSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *PipelineSummary) SetCreationTime(v time.Time) *PipelineSummary {
	s.CreationTime = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *PipelineSummary) SetLastUpdateTime(v time.Time) *PipelineSummary {
	s.LastUpdateTime = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *PipelineSummary) SetPipelineName(v string) *PipelineSummary {
	s.PipelineName = &v
	return s
}

// SetReprocessingSummaries sets the ReprocessingSummaries field's value.
func (s *PipelineSummary) SetReprocessingSummaries(v []*ReprocessingSummary) *PipelineSummary {
	s.ReprocessingSummaries = v
	return s
}

type PutLoggingOptionsInput struct {
	_ struct{} `type:"structure"`

	// The new values of the AWS IoT Analytics logging options.
	//
	// LoggingOptions is a required field
	LoggingOptions *LoggingOptions `locationName:"loggingOptions" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLoggingOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLoggingOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLoggingOptionsInput"}
	if s.LoggingOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggingOptions"))
	}
	if s.LoggingOptions != nil {
		if err := s.LoggingOptions.Validate(); err != nil {
			invalidParams.AddNested("LoggingOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingOptions sets the LoggingOptions field's value.
func (s *PutLoggingOptionsInput) SetLoggingOptions(v *LoggingOptions) *PutLoggingOptionsInput {
	s.LoggingOptions = v
	return s
}

type PutLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLoggingOptionsOutput) GoString() string {
	return s.String()
}

// Information which is used to filter message data, to segregate it according
// to the time frame in which it arrives.
type QueryFilter struct {
	_ struct{} `type:"structure"`

	// Used to limit data to that which has arrived since the last execution of
	// the action. When you create data set contents using message data from a specified
	// time frame, some message data may still be "in flight" when processing begins,
	// and so will not arrive in time to be processed. Use this field to make allowances
	// for the "in flight" time of you message data, so that data not processed
	// from a previous time frame will be included with the next time frame. Without
	// this, missed message data would be excluded from processing during the next
	// time frame as well, because its timestamp places it within the previous time
	// frame.
	DeltaTime *DeltaTime `locationName:"deltaTime" type:"structure"`
}

// String returns the string representation
func (s QueryFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryFilter"}
	if s.DeltaTime != nil {
		if err := s.DeltaTime.Validate(); err != nil {
			invalidParams.AddNested("DeltaTime", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeltaTime sets the DeltaTime field's value.
func (s *QueryFilter) SetDeltaTime(v *DeltaTime) *QueryFilter {
	s.DeltaTime = v
	return s
}

// An activity that removes attributes from a message.
type RemoveAttributesActivity struct {
	_ struct{} `type:"structure"`

	// A list of 1-50 attributes to remove from the message.
	//
	// Attributes is a required field
	Attributes []*string `locationName:"attributes" min:"1" type:"list" required:"true"`

	// The name of the 'removeAttributes' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`
}

// String returns the string representation
func (s RemoveAttributesActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAttributesActivity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveAttributesActivity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveAttributesActivity"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.Attributes != nil && len(s.Attributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attributes", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Next", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *RemoveAttributesActivity) SetAttributes(v []*string) *RemoveAttributesActivity {
	s.Attributes = v
	return s
}

// SetName sets the Name field's value.
func (s *RemoveAttributesActivity) SetName(v string) *RemoveAttributesActivity {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *RemoveAttributesActivity) SetNext(v string) *RemoveAttributesActivity {
	s.Next = &v
	return s
}

// Information about pipeline reprocessing.
type ReprocessingSummary struct {
	_ struct{} `type:"structure"`

	// The time the pipeline reprocessing was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The 'reprocessingId' returned by "StartPipelineReprocessing".
	Id *string `locationName:"id" type:"string"`

	// The status of the pipeline reprocessing.
	Status *string `locationName:"status" type:"string" enum:"ReprocessingStatus"`
}

// String returns the string representation
func (s ReprocessingSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReprocessingSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ReprocessingSummary) SetCreationTime(v time.Time) *ReprocessingSummary {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReprocessingSummary) SetId(v string) *ReprocessingSummary {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReprocessingSummary) SetStatus(v string) *ReprocessingSummary {
	s.Status = &v
	return s
}

// The configuration of the resource used to execute the "containerAction".
type ResourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The type of the compute resource used to execute the "containerAction". Possible
	// values are: ACU_1 (vCPU=4, memory=16GiB) or ACU_2 (vCPU=8, memory=32GiB).
	//
	// ComputeType is a required field
	ComputeType *string `locationName:"computeType" type:"string" required:"true" enum:"ComputeType"`

	// The size (in GB) of the persistent storage available to the resource instance
	// used to execute the "containerAction" (min: 1, max: 50).
	//
	// VolumeSizeInGB is a required field
	VolumeSizeInGB *int64 `locationName:"volumeSizeInGB" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s ResourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceConfiguration"}
	if s.ComputeType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeType"))
	}
	if s.VolumeSizeInGB == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeSizeInGB"))
	}
	if s.VolumeSizeInGB != nil && *s.VolumeSizeInGB < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VolumeSizeInGB", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeType sets the ComputeType field's value.
func (s *ResourceConfiguration) SetComputeType(v string) *ResourceConfiguration {
	s.ComputeType = &v
	return s
}

// SetVolumeSizeInGB sets the VolumeSizeInGB field's value.
func (s *ResourceConfiguration) SetVolumeSizeInGB(v int64) *ResourceConfiguration {
	s.VolumeSizeInGB = &v
	return s
}

// How long, in days, message data is kept.
type RetentionPeriod struct {
	_ struct{} `type:"structure"`

	// The number of days that message data is kept. The "unlimited" parameter must
	// be false.
	NumberOfDays *int64 `locationName:"numberOfDays" min:"1" type:"integer"`

	// If true, message data is kept indefinitely.
	Unlimited *bool `locationName:"unlimited" type:"boolean"`
}

// String returns the string representation
func (s RetentionPeriod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetentionPeriod) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetentionPeriod) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetentionPeriod"}
	if s.NumberOfDays != nil && *s.NumberOfDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfDays", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNumberOfDays sets the NumberOfDays field's value.
func (s *RetentionPeriod) SetNumberOfDays(v int64) *RetentionPeriod {
	s.NumberOfDays = &v
	return s
}

// SetUnlimited sets the Unlimited field's value.
func (s *RetentionPeriod) SetUnlimited(v bool) *RetentionPeriod {
	s.Unlimited = &v
	return s
}

type RunPipelineActivityInput struct {
	_ struct{} `type:"structure"`

	// The sample message payloads on which the pipeline activity is run.
	//
	// Payloads is a required field
	Payloads [][]byte `locationName:"payloads" min:"1" type:"list" required:"true"`

	// The pipeline activity that is run. This must not be a 'channel' activity
	// or a 'datastore' activity because these activities are used in a pipeline
	// only to load the original message and to store the (possibly) transformed
	// message. If a 'lambda' activity is specified, only short-running Lambda functions
	// (those with a timeout of less than 30 seconds or less) can be used.
	//
	// PipelineActivity is a required field
	PipelineActivity *PipelineActivity `locationName:"pipelineActivity" type:"structure" required:"true"`
}

// String returns the string representation
func (s RunPipelineActivityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunPipelineActivityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunPipelineActivityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RunPipelineActivityInput"}
	if s.Payloads == nil {
		invalidParams.Add(request.NewErrParamRequired("Payloads"))
	}
	if s.Payloads != nil && len(s.Payloads) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Payloads", 1))
	}
	if s.PipelineActivity == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineActivity"))
	}
	if s.PipelineActivity != nil {
		if err := s.PipelineActivity.Validate(); err != nil {
			invalidParams.AddNested("PipelineActivity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPayloads sets the Payloads field's value.
func (s *RunPipelineActivityInput) SetPayloads(v [][]byte) *RunPipelineActivityInput {
	s.Payloads = v
	return s
}

// SetPipelineActivity sets the PipelineActivity field's value.
func (s *RunPipelineActivityInput) SetPipelineActivity(v *PipelineActivity) *RunPipelineActivityInput {
	s.PipelineActivity = v
	return s
}

type RunPipelineActivityOutput struct {
	_ struct{} `type:"structure"`

	// In case the pipeline activity fails, the log message that is generated.
	LogResult *string `locationName:"logResult" type:"string"`

	// The enriched or transformed sample message payloads as base64-encoded strings.
	// (The results of running the pipeline activity on each input sample message
	// payload, encoded in base64.)
	Payloads [][]byte `locationName:"payloads" min:"1" type:"list"`
}

// String returns the string representation
func (s RunPipelineActivityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunPipelineActivityOutput) GoString() string {
	return s.String()
}

// SetLogResult sets the LogResult field's value.
func (s *RunPipelineActivityOutput) SetLogResult(v string) *RunPipelineActivityOutput {
	s.LogResult = &v
	return s
}

// SetPayloads sets the Payloads field's value.
func (s *RunPipelineActivityOutput) SetPayloads(v [][]byte) *RunPipelineActivityOutput {
	s.Payloads = v
	return s
}

type SampleChannelDataInput struct {
	_ struct{} `type:"structure"`

	// The name of the channel whose message samples are retrieved.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"channelName" min:"1" type:"string" required:"true"`

	// The end of the time window from which sample messages are retrieved.
	EndTime *time.Time `location:"querystring" locationName:"endTime" type:"timestamp"`

	// The number of sample messages to be retrieved. The limit is 10, the default
	// is also 10.
	MaxMessages *int64 `location:"querystring" locationName:"maxMessages" min:"1" type:"integer"`

	// The start of the time window from which sample messages are retrieved.
	StartTime *time.Time `location:"querystring" locationName:"startTime" type:"timestamp"`
}

// String returns the string representation
func (s SampleChannelDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SampleChannelDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SampleChannelDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SampleChannelDataInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.MaxMessages != nil && *s.MaxMessages < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxMessages", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *SampleChannelDataInput) SetChannelName(v string) *SampleChannelDataInput {
	s.ChannelName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *SampleChannelDataInput) SetEndTime(v time.Time) *SampleChannelDataInput {
	s.EndTime = &v
	return s
}

// SetMaxMessages sets the MaxMessages field's value.
func (s *SampleChannelDataInput) SetMaxMessages(v int64) *SampleChannelDataInput {
	s.MaxMessages = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *SampleChannelDataInput) SetStartTime(v time.Time) *SampleChannelDataInput {
	s.StartTime = &v
	return s
}

type SampleChannelDataOutput struct {
	_ struct{} `type:"structure"`

	// The list of message samples. Each sample message is returned as a base64-encoded
	// string.
	Payloads [][]byte `locationName:"payloads" min:"1" type:"list"`
}

// String returns the string representation
func (s SampleChannelDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SampleChannelDataOutput) GoString() string {
	return s.String()
}

// SetPayloads sets the Payloads field's value.
func (s *SampleChannelDataOutput) SetPayloads(v [][]byte) *SampleChannelDataOutput {
	s.Payloads = v
	return s
}

// The schedule for when to trigger an update.
type Schedule struct {
	_ struct{} `type:"structure"`

	// The expression that defines when to trigger an update. For more information,
	// see  Schedule Expressions for Rules (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html)
	// in the Amazon CloudWatch documentation.
	Expression *string `locationName:"expression" type:"string"`
}

// String returns the string representation
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Schedule) GoString() string {
	return s.String()
}

// SetExpression sets the Expression field's value.
func (s *Schedule) SetExpression(v string) *Schedule {
	s.Expression = &v
	return s
}

// Creates a new message using only the specified attributes from the original
// message.
type SelectAttributesActivity struct {
	_ struct{} `type:"structure"`

	// A list of the attributes to select from the message.
	//
	// Attributes is a required field
	Attributes []*string `locationName:"attributes" min:"1" type:"list" required:"true"`

	// The name of the 'selectAttributes' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`
}

// String returns the string representation
func (s SelectAttributesActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelectAttributesActivity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelectAttributesActivity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SelectAttributesActivity"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.Attributes != nil && len(s.Attributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attributes", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Next", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *SelectAttributesActivity) SetAttributes(v []*string) *SelectAttributesActivity {
	s.Attributes = v
	return s
}

// SetName sets the Name field's value.
func (s *SelectAttributesActivity) SetName(v string) *SelectAttributesActivity {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *SelectAttributesActivity) SetNext(v string) *SelectAttributesActivity {
	s.Next = &v
	return s
}

// The SQL query to modify the message.
type SqlQueryDatasetAction struct {
	_ struct{} `type:"structure"`

	// Pre-filters applied to message data.
	Filters []*QueryFilter `locationName:"filters" type:"list"`

	// A SQL query string.
	//
	// SqlQuery is a required field
	SqlQuery *string `locationName:"sqlQuery" type:"string" required:"true"`
}

// String returns the string representation
func (s SqlQueryDatasetAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqlQueryDatasetAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqlQueryDatasetAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SqlQueryDatasetAction"}
	if s.SqlQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("SqlQuery"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SqlQueryDatasetAction) SetFilters(v []*QueryFilter) *SqlQueryDatasetAction {
	s.Filters = v
	return s
}

// SetSqlQuery sets the SqlQuery field's value.
func (s *SqlQueryDatasetAction) SetSqlQuery(v string) *SqlQueryDatasetAction {
	s.SqlQuery = &v
	return s
}

type StartPipelineReprocessingInput struct {
	_ struct{} `type:"structure"`

	// The end time (exclusive) of raw message data that is reprocessed.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The name of the pipeline on which to start reprocessing.
	//
	// PipelineName is a required field
	PipelineName *string `location:"uri" locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The start time (inclusive) of raw message data that is reprocessed.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`
}

// String returns the string representation
func (s StartPipelineReprocessingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartPipelineReprocessingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartPipelineReprocessingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartPipelineReprocessingInput"}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *StartPipelineReprocessingInput) SetEndTime(v time.Time) *StartPipelineReprocessingInput {
	s.EndTime = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *StartPipelineReprocessingInput) SetPipelineName(v string) *StartPipelineReprocessingInput {
	s.PipelineName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StartPipelineReprocessingInput) SetStartTime(v time.Time) *StartPipelineReprocessingInput {
	s.StartTime = &v
	return s
}

type StartPipelineReprocessingOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the pipeline reprocessing activity that was started.
	ReprocessingId *string `locationName:"reprocessingId" type:"string"`
}

// String returns the string representation
func (s StartPipelineReprocessingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartPipelineReprocessingOutput) GoString() string {
	return s.String()
}

// SetReprocessingId sets the ReprocessingId field's value.
func (s *StartPipelineReprocessingOutput) SetReprocessingId(v string) *StartPipelineReprocessingOutput {
	s.ReprocessingId = &v
	return s
}

// A set of key/value pairs which are used to manage the resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The tag's value.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource whose tags will be modified.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The new or modified tags for the resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Information about the data set whose content generation will trigger the
// new data set content generation.
type TriggeringDataset struct {
	_ struct{} `type:"structure"`

	// The name of the data set whose content generation will trigger the new data
	// set content generation.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TriggeringDataset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TriggeringDataset) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TriggeringDataset) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TriggeringDataset"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *TriggeringDataset) SetName(v string) *TriggeringDataset {
	s.Name = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource whose tags will be removed.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The keys of those tags which will be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateChannelInput struct {
	_ struct{} `type:"structure"`

	// The name of the channel to be updated.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"channelName" min:"1" type:"string" required:"true"`

	// How long, in days, message data is kept for the channel.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`
}

// String returns the string representation
func (s UpdateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelInput"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.RetentionPeriod != nil {
		if err := s.RetentionPeriod.Validate(); err != nil {
			invalidParams.AddNested("RetentionPeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *UpdateChannelInput) SetChannelName(v string) *UpdateChannelInput {
	s.ChannelName = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *UpdateChannelInput) SetRetentionPeriod(v *RetentionPeriod) *UpdateChannelInput {
	s.RetentionPeriod = v
	return s
}

type UpdateChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelOutput) GoString() string {
	return s.String()
}

type UpdateDatasetInput struct {
	_ struct{} `type:"structure"`

	// A list of "DatasetAction" objects.
	//
	// Actions is a required field
	Actions []*DatasetAction `locationName:"actions" min:"1" type:"list" required:"true"`

	// The name of the data set to update.
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"datasetName" min:"1" type:"string" required:"true"`

	// How long, in days, message data is kept for the data set.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`

	// A list of "DatasetTrigger" objects. The list can be empty or can contain
	// up to five DataSetTrigger objects.
	Triggers []*DatasetTrigger `locationName:"triggers" type:"list"`
}

// String returns the string representation
func (s UpdateDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDatasetInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Actions", 1))
	}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RetentionPeriod != nil {
		if err := s.RetentionPeriod.Validate(); err != nil {
			invalidParams.AddNested("RetentionPeriod", err.(request.ErrInvalidParams))
		}
	}
	if s.Triggers != nil {
		for i, v := range s.Triggers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Triggers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *UpdateDatasetInput) SetActions(v []*DatasetAction) *UpdateDatasetInput {
	s.Actions = v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *UpdateDatasetInput) SetDatasetName(v string) *UpdateDatasetInput {
	s.DatasetName = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *UpdateDatasetInput) SetRetentionPeriod(v *RetentionPeriod) *UpdateDatasetInput {
	s.RetentionPeriod = v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *UpdateDatasetInput) SetTriggers(v []*DatasetTrigger) *UpdateDatasetInput {
	s.Triggers = v
	return s
}

type UpdateDatasetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDatasetOutput) GoString() string {
	return s.String()
}

type UpdateDatastoreInput struct {
	_ struct{} `type:"structure"`

	// The name of the data store to be updated.
	//
	// DatastoreName is a required field
	DatastoreName *string `location:"uri" locationName:"datastoreName" min:"1" type:"string" required:"true"`

	// How long, in days, message data is kept for the data store.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`
}

// String returns the string representation
func (s UpdateDatastoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDatastoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDatastoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDatastoreInput"}
	if s.DatastoreName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreName"))
	}
	if s.DatastoreName != nil && len(*s.DatastoreName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreName", 1))
	}
	if s.RetentionPeriod != nil {
		if err := s.RetentionPeriod.Validate(); err != nil {
			invalidParams.AddNested("RetentionPeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *UpdateDatastoreInput) SetDatastoreName(v string) *UpdateDatastoreInput {
	s.DatastoreName = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *UpdateDatastoreInput) SetRetentionPeriod(v *RetentionPeriod) *UpdateDatastoreInput {
	s.RetentionPeriod = v
	return s
}

type UpdateDatastoreOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDatastoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDatastoreOutput) GoString() string {
	return s.String()
}

type UpdatePipelineInput struct {
	_ struct{} `type:"structure"`

	// A list of "PipelineActivity" objects.
	//
	// The list can be 1-25 PipelineActivity objects. Activities perform transformations
	// on your messages, such as removing, renaming or adding message attributes;
	// filtering messages based on attribute values; invoking your Lambda functions
	// on messages for advanced processing; or performing mathematical transformations
	// to normalize device data.
	//
	// PipelineActivities is a required field
	PipelineActivities []*PipelineActivity `locationName:"pipelineActivities" min:"1" type:"list" required:"true"`

	// The name of the pipeline to update.
	//
	// PipelineName is a required field
	PipelineName *string `location:"uri" locationName:"pipelineName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipelineInput"}
	if s.PipelineActivities == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineActivities"))
	}
	if s.PipelineActivities != nil && len(s.PipelineActivities) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineActivities", 1))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.PipelineActivities != nil {
		for i, v := range s.PipelineActivities {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PipelineActivities", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineActivities sets the PipelineActivities field's value.
func (s *UpdatePipelineInput) SetPipelineActivities(v []*PipelineActivity) *UpdatePipelineInput {
	s.PipelineActivities = v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *UpdatePipelineInput) SetPipelineName(v string) *UpdatePipelineInput {
	s.PipelineName = &v
	return s
}

type UpdatePipelineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePipelineOutput) GoString() string {
	return s.String()
}

// An instance of a variable to be passed to the "containerAction" execution.
// Each variable must have a name and a value given by one of "stringValue",
// "datasetContentVersionValue", or "outputFileUriValue".
type Variable struct {
	_ struct{} `type:"structure"`

	// The value of the variable as a structure that specifies a data set content
	// version.
	DatasetContentVersionValue *DatasetContentVersionValue `locationName:"datasetContentVersionValue" type:"structure"`

	// The value of the variable as a double (numeric).
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// The name of the variable.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The value of the variable as a structure that specifies an output file URI.
	OutputFileUriValue *OutputFileUriValue `locationName:"outputFileUriValue" type:"structure"`

	// The value of the variable as a string.
	StringValue *string `locationName:"stringValue" type:"string"`
}

// String returns the string representation
func (s Variable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Variable) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Variable) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Variable"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.DatasetContentVersionValue != nil {
		if err := s.DatasetContentVersionValue.Validate(); err != nil {
			invalidParams.AddNested("DatasetContentVersionValue", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputFileUriValue != nil {
		if err := s.OutputFileUriValue.Validate(); err != nil {
			invalidParams.AddNested("OutputFileUriValue", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetContentVersionValue sets the DatasetContentVersionValue field's value.
func (s *Variable) SetDatasetContentVersionValue(v *DatasetContentVersionValue) *Variable {
	s.DatasetContentVersionValue = v
	return s
}

// SetDoubleValue sets the DoubleValue field's value.
func (s *Variable) SetDoubleValue(v float64) *Variable {
	s.DoubleValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *Variable) SetName(v string) *Variable {
	s.Name = &v
	return s
}

// SetOutputFileUriValue sets the OutputFileUriValue field's value.
func (s *Variable) SetOutputFileUriValue(v *OutputFileUriValue) *Variable {
	s.OutputFileUriValue = v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *Variable) SetStringValue(v string) *Variable {
	s.StringValue = &v
	return s
}

const (
	// ChannelStatusCreating is a ChannelStatus enum value
	ChannelStatusCreating = "CREATING"

	// ChannelStatusActive is a ChannelStatus enum value
	ChannelStatusActive = "ACTIVE"

	// ChannelStatusDeleting is a ChannelStatus enum value
	ChannelStatusDeleting = "DELETING"
)

const (
	// ComputeTypeAcu1 is a ComputeType enum value
	ComputeTypeAcu1 = "ACU_1"

	// ComputeTypeAcu2 is a ComputeType enum value
	ComputeTypeAcu2 = "ACU_2"
)

const (
	// DatasetActionTypeQuery is a DatasetActionType enum value
	DatasetActionTypeQuery = "QUERY"

	// DatasetActionTypeContainer is a DatasetActionType enum value
	DatasetActionTypeContainer = "CONTAINER"
)

const (
	// DatasetContentStateCreating is a DatasetContentState enum value
	DatasetContentStateCreating = "CREATING"

	// DatasetContentStateSucceeded is a DatasetContentState enum value
	DatasetContentStateSucceeded = "SUCCEEDED"

	// DatasetContentStateFailed is a DatasetContentState enum value
	DatasetContentStateFailed = "FAILED"
)

const (
	// DatasetStatusCreating is a DatasetStatus enum value
	DatasetStatusCreating = "CREATING"

	// DatasetStatusActive is a DatasetStatus enum value
	DatasetStatusActive = "ACTIVE"

	// DatasetStatusDeleting is a DatasetStatus enum value
	DatasetStatusDeleting = "DELETING"
)

const (
	// DatastoreStatusCreating is a DatastoreStatus enum value
	DatastoreStatusCreating = "CREATING"

	// DatastoreStatusActive is a DatastoreStatus enum value
	DatastoreStatusActive = "ACTIVE"

	// DatastoreStatusDeleting is a DatastoreStatus enum value
	DatastoreStatusDeleting = "DELETING"
)

const (
	// LoggingLevelError is a LoggingLevel enum value
	LoggingLevelError = "ERROR"
)

const (
	// ReprocessingStatusRunning is a ReprocessingStatus enum value
	ReprocessingStatusRunning = "RUNNING"

	// ReprocessingStatusSucceeded is a ReprocessingStatus enum value
	ReprocessingStatusSucceeded = "SUCCEEDED"

	// ReprocessingStatusCancelled is a ReprocessingStatus enum value
	ReprocessingStatusCancelled = "CANCELLED"

	// ReprocessingStatusFailed is a ReprocessingStatus enum value
	ReprocessingStatusFailed = "FAILED"
)
