// Code generated by radius-dict-gen. DO NOT EDIT.

package rfc6911

import (
	"net"

	"layeh.com/radius"
)

const (
	FramedIPv6Address_Type       radius.Type = 168
	DNSServerIPv6Address_Type    radius.Type = 169
	RouteIPv6Information_Type    radius.Type = 170
	DelegatedIPv6PrefixPool_Type radius.Type = 171
	StatefulIPv6AddressPool_Type radius.Type = 172
)

func FramedIPv6Address_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPv6Addr(value)
	if err != nil {
		return
	}
	p.Add(FramedIPv6Address_Type, a)
	return
}

func FramedIPv6Address_Get(p *radius.Packet) (value net.IP) {
	value, _ = FramedIPv6Address_Lookup(p)
	return
}

func FramedIPv6Address_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, attr := range p.Attributes[FramedIPv6Address_Type] {
		i, err = radius.IPv6Addr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func FramedIPv6Address_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := p.Lookup(FramedIPv6Address_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPv6Addr(a)
	return
}

func FramedIPv6Address_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPv6Addr(value)
	if err != nil {
		return
	}
	p.Set(FramedIPv6Address_Type, a)
	return
}

func FramedIPv6Address_Del(p *radius.Packet) {
	p.Attributes.Del(FramedIPv6Address_Type)
}

func DNSServerIPv6Address_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPv6Addr(value)
	if err != nil {
		return
	}
	p.Add(DNSServerIPv6Address_Type, a)
	return
}

func DNSServerIPv6Address_Get(p *radius.Packet) (value net.IP) {
	value, _ = DNSServerIPv6Address_Lookup(p)
	return
}

func DNSServerIPv6Address_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, attr := range p.Attributes[DNSServerIPv6Address_Type] {
		i, err = radius.IPv6Addr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func DNSServerIPv6Address_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := p.Lookup(DNSServerIPv6Address_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPv6Addr(a)
	return
}

func DNSServerIPv6Address_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPv6Addr(value)
	if err != nil {
		return
	}
	p.Set(DNSServerIPv6Address_Type, a)
	return
}

func DNSServerIPv6Address_Del(p *radius.Packet) {
	p.Attributes.Del(DNSServerIPv6Address_Type)
}

func RouteIPv6Information_Add(p *radius.Packet, value *net.IPNet) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPv6Prefix(value)
	if err != nil {
		return
	}
	p.Add(RouteIPv6Information_Type, a)
	return
}

func RouteIPv6Information_Get(p *radius.Packet) (value *net.IPNet) {
	value, _ = RouteIPv6Information_Lookup(p)
	return
}

func RouteIPv6Information_Gets(p *radius.Packet) (values []*net.IPNet, err error) {
	var i *net.IPNet
	for _, attr := range p.Attributes[RouteIPv6Information_Type] {
		i, err = radius.IPv6Prefix(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func RouteIPv6Information_Lookup(p *radius.Packet) (value *net.IPNet, err error) {
	a, ok := p.Lookup(RouteIPv6Information_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPv6Prefix(a)
	return
}

func RouteIPv6Information_Set(p *radius.Packet, value *net.IPNet) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPv6Prefix(value)
	if err != nil {
		return
	}
	p.Set(RouteIPv6Information_Type, a)
	return
}

func RouteIPv6Information_Del(p *radius.Packet) {
	p.Attributes.Del(RouteIPv6Information_Type)
}

func DelegatedIPv6PrefixPool_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(DelegatedIPv6PrefixPool_Type, a)
	return
}

func DelegatedIPv6PrefixPool_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(DelegatedIPv6PrefixPool_Type, a)
	return
}

func DelegatedIPv6PrefixPool_Get(p *radius.Packet) (value []byte) {
	value, _ = DelegatedIPv6PrefixPool_Lookup(p)
	return
}

func DelegatedIPv6PrefixPool_GetString(p *radius.Packet) (value string) {
	value, _ = DelegatedIPv6PrefixPool_LookupString(p)
	return
}

func DelegatedIPv6PrefixPool_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range p.Attributes[DelegatedIPv6PrefixPool_Type] {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func DelegatedIPv6PrefixPool_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range p.Attributes[DelegatedIPv6PrefixPool_Type] {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func DelegatedIPv6PrefixPool_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(DelegatedIPv6PrefixPool_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func DelegatedIPv6PrefixPool_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(DelegatedIPv6PrefixPool_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func DelegatedIPv6PrefixPool_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(DelegatedIPv6PrefixPool_Type, a)
	return
}

func DelegatedIPv6PrefixPool_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(DelegatedIPv6PrefixPool_Type, a)
	return
}

func DelegatedIPv6PrefixPool_Del(p *radius.Packet) {
	p.Attributes.Del(DelegatedIPv6PrefixPool_Type)
}

func StatefulIPv6AddressPool_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(StatefulIPv6AddressPool_Type, a)
	return
}

func StatefulIPv6AddressPool_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(StatefulIPv6AddressPool_Type, a)
	return
}

func StatefulIPv6AddressPool_Get(p *radius.Packet) (value []byte) {
	value, _ = StatefulIPv6AddressPool_Lookup(p)
	return
}

func StatefulIPv6AddressPool_GetString(p *radius.Packet) (value string) {
	value, _ = StatefulIPv6AddressPool_LookupString(p)
	return
}

func StatefulIPv6AddressPool_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range p.Attributes[StatefulIPv6AddressPool_Type] {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func StatefulIPv6AddressPool_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range p.Attributes[StatefulIPv6AddressPool_Type] {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func StatefulIPv6AddressPool_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(StatefulIPv6AddressPool_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func StatefulIPv6AddressPool_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(StatefulIPv6AddressPool_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func StatefulIPv6AddressPool_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(StatefulIPv6AddressPool_Type, a)
	return
}

func StatefulIPv6AddressPool_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(StatefulIPv6AddressPool_Type, a)
	return
}

func StatefulIPv6AddressPool_Del(p *radius.Packet) {
	p.Attributes.Del(StatefulIPv6AddressPool_Type)
}
