package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetFileCacheExpiredConfig invokes the cdn.SetFileCacheExpiredConfig API synchronously
// api document: https://help.aliyun.com/api/cdn/setfilecacheexpiredconfig.html
func (client *Client) SetFileCacheExpiredConfig(request *SetFileCacheExpiredConfigRequest) (response *SetFileCacheExpiredConfigResponse, err error) {
	response = CreateSetFileCacheExpiredConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SetFileCacheExpiredConfigWithChan invokes the cdn.SetFileCacheExpiredConfig API asynchronously
// api document: https://help.aliyun.com/api/cdn/setfilecacheexpiredconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetFileCacheExpiredConfigWithChan(request *SetFileCacheExpiredConfigRequest) (<-chan *SetFileCacheExpiredConfigResponse, <-chan error) {
	responseChan := make(chan *SetFileCacheExpiredConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetFileCacheExpiredConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetFileCacheExpiredConfigWithCallback invokes the cdn.SetFileCacheExpiredConfig API asynchronously
// api document: https://help.aliyun.com/api/cdn/setfilecacheexpiredconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetFileCacheExpiredConfigWithCallback(request *SetFileCacheExpiredConfigRequest, callback func(response *SetFileCacheExpiredConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetFileCacheExpiredConfigResponse
		var err error
		defer close(result)
		response, err = client.SetFileCacheExpiredConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetFileCacheExpiredConfigRequest is the request struct for api SetFileCacheExpiredConfig
type SetFileCacheExpiredConfigRequest struct {
	*requests.RpcRequest
	DomainName   string           `position:"Query" name:"DomainName"`
	CacheContent string           `position:"Query" name:"CacheContent"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	TTL          string           `position:"Query" name:"TTL"`
	ConfigId     requests.Integer `position:"Query" name:"ConfigId"`
}

// SetFileCacheExpiredConfigResponse is the response struct for api SetFileCacheExpiredConfig
type SetFileCacheExpiredConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetFileCacheExpiredConfigRequest creates a request to invoke SetFileCacheExpiredConfig API
func CreateSetFileCacheExpiredConfigRequest() (request *SetFileCacheExpiredConfigRequest) {
	request = &SetFileCacheExpiredConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "SetFileCacheExpiredConfig", "", "")
	return
}

// CreateSetFileCacheExpiredConfigResponse creates a response to parse from SetFileCacheExpiredConfig response
func CreateSetFileCacheExpiredConfigResponse() (response *SetFileCacheExpiredConfigResponse) {
	response = &SetFileCacheExpiredConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
