package csb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteUnionCasService invokes the csb.DeleteUnionCasService API synchronously
// api document: https://help.aliyun.com/api/csb/deleteunioncasservice.html
func (client *Client) DeleteUnionCasService(request *DeleteUnionCasServiceRequest) (response *DeleteUnionCasServiceResponse, err error) {
	response = CreateDeleteUnionCasServiceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteUnionCasServiceWithChan invokes the csb.DeleteUnionCasService API asynchronously
// api document: https://help.aliyun.com/api/csb/deleteunioncasservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteUnionCasServiceWithChan(request *DeleteUnionCasServiceRequest) (<-chan *DeleteUnionCasServiceResponse, <-chan error) {
	responseChan := make(chan *DeleteUnionCasServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteUnionCasService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteUnionCasServiceWithCallback invokes the csb.DeleteUnionCasService API asynchronously
// api document: https://help.aliyun.com/api/csb/deleteunioncasservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteUnionCasServiceWithCallback(request *DeleteUnionCasServiceRequest, callback func(response *DeleteUnionCasServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteUnionCasServiceResponse
		var err error
		defer close(result)
		response, err = client.DeleteUnionCasService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteUnionCasServiceRequest is the request struct for api DeleteUnionCasService
type DeleteUnionCasServiceRequest struct {
	*requests.RpcRequest
	LeafOnly     requests.Boolean `position:"Query" name:"LeafOnly"`
	CasCsbName   string           `position:"Query" name:"CasCsbName"`
	SrcUserId    string           `position:"Query" name:"SrcUserId"`
	CasServiceId string           `position:"Query" name:"CasServiceId"`
}

// DeleteUnionCasServiceResponse is the response struct for api DeleteUnionCasService
type DeleteUnionCasServiceResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteUnionCasServiceRequest creates a request to invoke DeleteUnionCasService API
func CreateDeleteUnionCasServiceRequest() (request *DeleteUnionCasServiceRequest) {
	request = &DeleteUnionCasServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CSB", "2017-11-18", "DeleteUnionCasService", "", "")
	return
}

// CreateDeleteUnionCasServiceResponse creates a response to parse from DeleteUnionCasService response
func CreateDeleteUnionCasServiceResponse() (response *DeleteUnionCasServiceResponse) {
	response = &DeleteUnionCasServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
