package ots

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInstance invokes the ots.ListInstance API synchronously
// api document: https://help.aliyun.com/api/ots/listinstance.html
func (client *Client) ListInstance(request *ListInstanceRequest) (response *ListInstanceResponse, err error) {
	response = CreateListInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ListInstanceWithChan invokes the ots.ListInstance API asynchronously
// api document: https://help.aliyun.com/api/ots/listinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListInstanceWithChan(request *ListInstanceRequest) (<-chan *ListInstanceResponse, <-chan error) {
	responseChan := make(chan *ListInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInstanceWithCallback invokes the ots.ListInstance API asynchronously
// api document: https://help.aliyun.com/api/ots/listinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListInstanceWithCallback(request *ListInstanceRequest, callback func(response *ListInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInstanceResponse
		var err error
		defer close(result)
		response, err = client.ListInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInstanceRequest is the request struct for api ListInstance
type ListInstanceRequest struct {
	*requests.RpcRequest
	AccessKeyId     string                 `position:"Query" name:"access_key_id"`
	ResourceOwnerId requests.Integer       `position:"Query" name:"ResourceOwnerId"`
	PageSize        requests.Integer       `position:"Query" name:"PageSize"`
	PageNum         requests.Integer       `position:"Query" name:"PageNum"`
	TagInfo         *[]ListInstanceTagInfo `position:"Query" name:"TagInfo"  type:"Repeated"`
}

// ListInstanceTagInfo is a repeated param struct in ListInstanceRequest
type ListInstanceTagInfo struct {
	TagKey   string `name:"TagKey"`
	TagValue string `name:"TagValue"`
}

// ListInstanceResponse is the response struct for api ListInstance
type ListInstanceResponse struct {
	*responses.BaseResponse
	TotalCount    int           `json:"TotalCount" xml:"TotalCount"`
	PageNum       int           `json:"PageNum" xml:"PageNum"`
	PageSize      int           `json:"PageSize" xml:"PageSize"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	InstanceInfos InstanceInfos `json:"InstanceInfos" xml:"InstanceInfos"`
}

// CreateListInstanceRequest creates a request to invoke ListInstance API
func CreateListInstanceRequest() (request *ListInstanceRequest) {
	request = &ListInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ots", "2016-06-20", "ListInstance", "ots", "openAPI")
	return
}

// CreateListInstanceResponse creates a response to parse from ListInstance response
func CreateListInstanceResponse() (response *ListInstanceResponse) {
	response = &ListInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
