package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTemplate invokes the rtc.CreateTemplate API synchronously
// api document: https://help.aliyun.com/api/rtc/createtemplate.html
func (client *Client) CreateTemplate(request *CreateTemplateRequest) (response *CreateTemplateResponse, err error) {
	response = CreateCreateTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTemplateWithChan invokes the rtc.CreateTemplate API asynchronously
// api document: https://help.aliyun.com/api/rtc/createtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTemplateWithChan(request *CreateTemplateRequest) (<-chan *CreateTemplateResponse, <-chan error) {
	responseChan := make(chan *CreateTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTemplateWithCallback invokes the rtc.CreateTemplate API asynchronously
// api document: https://help.aliyun.com/api/rtc/createtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTemplateWithCallback(request *CreateTemplateRequest, callback func(response *CreateTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTemplateResponse
		var err error
		defer close(result)
		response, err = client.CreateTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTemplateRequest is the request struct for api CreateTemplate
type CreateTemplateRequest struct {
	*requests.RpcRequest
	ServiceMode       requests.Integer              `position:"Query" name:"ServiceMode"`
	LiveConfig        *[]CreateTemplateLiveConfig   `position:"Query" name:"LiveConfig"  type:"Repeated"`
	MediaConfig       requests.Integer              `position:"Query" name:"MediaConfig"`
	MaxMixStreamCount requests.Integer              `position:"Query" name:"MaxMixStreamCount"`
	RecordConfig      *[]CreateTemplateRecordConfig `position:"Query" name:"RecordConfig"  type:"Repeated"`
	OwnerId           requests.Integer              `position:"Query" name:"OwnerId"`
	LayOut            *[]CreateTemplateLayOut       `position:"Query" name:"LayOut"  type:"Repeated"`
	AppId             string                        `position:"Query" name:"AppId"`
	CallBack          string                        `position:"Query" name:"CallBack"`
	MixMode           requests.Integer              `position:"Query" name:"MixMode"`
}

// CreateTemplateLiveConfig is a repeated param struct in CreateTemplateRequest
type CreateTemplateLiveConfig struct {
	DomainName string `name:"DomainName"`
	AppName    string `name:"AppName"`
}

// CreateTemplateRecordConfig is a repeated param struct in CreateTemplateRequest
type CreateTemplateRecordConfig struct {
	StorageType         string `name:"StorageType"`
	FileFormat          string `name:"FileFormat"`
	OssEndPoint         string `name:"OssEndPoint"`
	OssBucket           string `name:"OssBucket"`
	VodTransCodeGroupId string `name:"VodTransCodeGroupId"`
}

// CreateTemplateLayOut is a repeated param struct in CreateTemplateRequest
type CreateTemplateLayOut struct {
	Color    string `name:"Color"`
	CutMode  string `name:"CutMode"`
	LayOutId string `name:"LayOutId"`
}

// CreateTemplateResponse is the response struct for api CreateTemplate
type CreateTemplateResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TemplateId int    `json:"TemplateId" xml:"TemplateId"`
}

// CreateCreateTemplateRequest creates a request to invoke CreateTemplate API
func CreateCreateTemplateRequest() (request *CreateTemplateRequest) {
	request = &CreateTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "CreateTemplate", "rtc", "openAPI")
	return
}

// CreateCreateTemplateResponse creates a response to parse from CreateTemplate response
func CreateCreateTemplateResponse() (response *CreateTemplateResponse) {
	response = &CreateTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
