/*
 * Minio Cloud Storage, (C) 2016 Minio, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Copyright (c) 2009 The Go Authors. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Using this part of Minio codebase under the license
// Apache License Version 2.0 with modifications

// SHA256 hash algorithm.  See FIPS 180-2.

package sha256

import (
	"encoding/hex"
	"fmt"
	"strings"
	"testing"
)

type sha256Test struct {
	out [32]byte
	in  string
}

var golden = []sha256Test{
	{[32]byte{(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128)},
		""},
	{[32]byte{(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128)},
		"a"},
	{[32]byte{(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128)},
		"ab"},
	{[32]byte{(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128)},
		"abc"},
	{[32]byte{(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128)},
		"abcd"},
	{[32]byte{(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128)},
		"abcde"},
	{[32]byte{(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128)},
		"abcdef"},
	{[32]byte{(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128)},
		"abcdefg"},
	{[32]byte{(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128)},
		"abcdefgh"},
	{[32]byte{(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128)},
		"abcdefghi"},
	{[32]byte{(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128)},
		"abcdefghij"},
	{[32]byte{(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128)},
		"Discard medicine more than two years old."},
	{[32]byte{(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128)},
		"He who has a shady past knows that nice guys finish last."},
	{[32]byte{(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128)},
		"I wouldn't marry him with a ten foot pole."},
	{[32]byte{(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128)},
		"Free! Free!/A trip/to Mars/for 900/empty jars/Burma Shave"},
	{[32]byte{(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128)},
		"The days of the digital watch are numbered.  -Tom Stoppard"},
	{[32]byte{(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128)},
		"Nepal premier won't resign."},
	{[32]byte{(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128)},
		"For every action there is an equal and opposite government program."},
	{[32]byte{(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128)},
		"His money is twice tainted: 'taint yours and 'taint mine."},
	{[32]byte{(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128)},
		"There is no reason for any individual to have a computer in their home. -Ken Olsen, 1977"},
	{[32]byte{(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128)},
		"It's a tiny change to the code and not completely disgusting. - Bob Manchek"},
	{[32]byte{(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128)},
		"size:  a.out:  bad magic"},
	{[32]byte{(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128)},
		"The major problem is with sendmail.  -Mark Horton"},
	{[32]byte{(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128)},
		"Give me a rock, paper and scissors and I will move the world.  CCFestoon"},
	{[32]byte{(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128)},
		"If the enemy is within range, then so are you."},
	{[32]byte{(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128)},
		"It's well we cannot hear the screams/That we create in others' dreams."},
	{[32]byte{(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128)},
		"You remind me of a TV show, but that's all right: I watch it anyway."},
	{[32]byte{(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128)},
		"C is as portable as Stonehedge!!"},
	{[32]byte{(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128)},
		"Even if I could be Shakespeare, I think I should still choose to be Faraday. - A. Huxley"},
	{[32]byte{(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128)},
		"The fugacity of a constituent in a mixture of gases at a given temperature is proportional to its mole fraction.  Lewis-Randall Rule"},
	{[32]byte{(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128)},
		"How can you write a big system without C++?  -Paul Glick"},
	// $ echo -n "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz123" | sha256sum
	// 13d8b6bf5cc79c03c07c719c48597bd33b79677e65098589b1580fca7f22bb22
	{[32]byte{(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128)},
		"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz123"},
	// $ echo -n "BCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234" | sha256sum
	// 624ddef3009879c6874da2dd771d54f7330781b60e1955ceff5f9dce8bf4ea43
	{[32]byte{(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128)},
		"BCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234"},
	// $ echo -n "CDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz12345" | sha256sum
	// cc031589b70dd4b24dc6def2121835ef1aa8074ff6952cdd3f81b5099a93c58d
	{[32]byte{(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128)},
		"CDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz12345"},
	// $ echo -n "DEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz123456" | sha256sum
	// d354abb6d538402db3d73daf95537a255ebaf3a943c80205be163e044fc46a70
	{[32]byte{(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128)},
		"DEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz123456"},
	// $ echo -n "EFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567" | sha256sum
	// f78410b90a20b521afb28f41d6388482afab7265ff8884aa6290cc9f9ada30d3
	{[32]byte{(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128)},
		"EFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567"},
	// $ echo -n "FGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz12345678" | sha256sum
	// c93a8cb7ed80166b15b79c8617410ca69e46fa1e3c1d14876699d3ce6090384f
	{[32]byte{(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128)},
		"FGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz12345678"},
	// $ echo -n "GHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz123456789" | sha256sum
	// 6cb808e9a7fb53fa680824f08554b660d29a4afc9a101f990b4bae3a12b7fbd8
	{[32]byte{(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128)},
		"GHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz123456789"},
	// $ echo -n "HIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890" | sha256sum
	// 84e8dd1afa78db222860ed40b6fcfc7a269469365f81f5712fb589555bdb01fe
	{[32]byte{(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128)},
		"HIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890"},
	// $ echo -n "IJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890A" | sha256sum
	// accab8e85b6bd178e975aaaa354aed8258bcd6af3e61bd4f12267635856cab0b
	{[32]byte{(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128)},
		"IJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890A"},
	// $ echo -n "JKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890AB" | sha256sum
	// 107f5ad8bc5d427246fc5f9c581134b61d8ba447e877df56cddad2bf53789172
	{[32]byte{(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128)},
		"JKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890AB"},
	// $ echo -n "KLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890ABC" | sha256sum
	// 7666f65b234f78aa537c8d098b181091ce8b7866a0285b52e6bf31b6f21ca9bb
	{[32]byte{(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128)},
		"KLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890ABC"},
	// $ echo -n "LMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890ABCD" | sha256sum
	// 4eba948ccee7289ab1f01628a1ab756dee39a6894aed217edc9a91a8b35e50ca
	{[32]byte{(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128)},
		"LMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890ABCD"},
	// $ echo -n "MNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890ABCDE" | sha256sum
	// 5011218873e7ca84871668d26461e449e7033b7959d69cfb5c2fee773c3d432d
	{[32]byte{(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128)},
		"MNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890ABCDE"},
	// $ echo -n "NOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890ABCDEF" | sha256sum
	// 6932b4ddaf3696e5d5270739bdbe6ab120bb8034b877bd3a8e5a5d5ca263e1c5
	{[32]byte{(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128)},
		"NOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890ABCDEF"},
	// $ echo -n "OPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890ABCDEFG" | sha256sum
	// 91bb1bcbfcb4c093aab255a0b8c8b5b93605e2f51dd6b0898b70b9f3c10fc1f9
	{[32]byte{(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128)},
		"OPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890ABCDEFG"},
	// $ echo -n "PQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890ABCDEFGH" | sha256sum
	// 0d1fa5355388e361c4591bd49c004e3d99044be274db43e91036611365aead02
	{[32]byte{(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128)},
		"PQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890ABCDEFGH"},
	// $ echo -n "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" | sha256sum
	// b6ac3cc10386331c765f04f041c147d0f278f2aed8eaa021e2d0057fc6f6ff9e
	{[32]byte{(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128)},
		strings.Repeat("A", 128)},
	// $ echo -n "BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB" | sha256sum
	// 7abaa701a6f4bb8d9ea3872a315597eb6f2ccfd03392d8d10560837f6136d06a
	{[32]byte{(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128)},
		strings.Repeat("B", 128)},
	// $ echo -n "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC" | sha256sum
	// 6e8b9325f779dba60c4c148dee5ded43b19ed20d25d66e338abec53b99174fe8
	{[32]byte{(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128)},
		strings.Repeat("C", 128)},
	// $ echo -n "DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD" | sha256sum
	// 7aa020c91ac4d32e17efd9b64648b92e375987e0eae7d0a58544ca1e4fc32c3c
	{[32]byte{(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128)},
		strings.Repeat("D", 128)},
	// $ echo -n "EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE" | sha256sum
	// 997f6a2fc44f1400e9f64d7eac11fe99e21f4b7a3fc2ff3ec95c2ef016abb9e5
	{[32]byte{(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128)},
		strings.Repeat("E", 128)},
	// $ echo -n "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" | sha256sum
	// 5c6cdeb9ccaa1d9c57662605ab738ec4ecf0467f576d4c2d7fae48710215582a
	{[32]byte{(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128)},
		strings.Repeat("F", 128)},
	// $ echo -n "GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG" | sha256sum
	// 394394b5f0e91a21d1e932f9ed55e098c8b05f3668f77134eeee843fef1d1758
	{[32]byte{(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128)},
		strings.Repeat("G", 128)},
	// $ echo -n "HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH" | sha256sum
	// cab546612de68eaa849487342baadbac2561df6380ddac66137ef649e0cdfd0a
	{[32]byte{(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128)},
		strings.Repeat("H", 128)},
	// $ echo -n "IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII" | sha256sum
	// 2be96cc28445876429be3005db465d1b9c8ed1432e3ac6f1514b6e9eee725ad8
	{[32]byte{(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128)},
		strings.Repeat("I", 128)},
	// $ echo -n "JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ" | sha256sum
	// 238e5f81d54f2af58049b944c4a1b9516a36c2ef1e20887450b3482045714444
	{[32]byte{(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128)},
		strings.Repeat("J", 128)},
	// $ echo -n "KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK" | sha256sum
	// f3a5b826c64951661ce22dc67f0f79d13f633f0601aca2f5e1cf1a9f17dffd4f
	{[32]byte{(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128)},
		strings.Repeat("K", 128)},
	// $ echo -n "LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL" | sha256sum
	// 1e90c05bedd24dc3e297d5b8fb215b95d8b7f4a040ee912069614c7a3382725d
	{[32]byte{(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128)},
		strings.Repeat("L", 128)},
	// $ echo -n "MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM" | sha256sum
	// 96239ac6fb99822797308f18d8455778fb5885103aa5ff59afe2219df657df99
	{[32]byte{(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128)},
		strings.Repeat("M", 128)},
	// $ echo -n "NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN" | sha256sum
	// 11e7f5a6f15a4addba9b6b21bc4f8ecbdd969e179335269fc68d3a05f0f3da4a
	{[32]byte{(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128)},
		strings.Repeat("N", 128)},
	// $ echo -n "OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO" | sha256sum
	// ae843b7e4e00afeb972bf948a345b319cca8bd0bcaa1428c1c67c88ea663c1e0
	{[32]byte{(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128)},
		strings.Repeat("O", 128)},
	// $ echo -n "PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP" | sha256sum
	// f16ef3e254ffb74b7e3c97d99486ef8c549e4c80bc6dfed7fe8c5e7e76f4fbcd
	{[32]byte{(1 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (0 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (0 * 4) + (0 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (0 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (0 * 64) + (1 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (0 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (1 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (0 * 128),
		(0 * 1) + (0 * 2) + (1 * 4) + (0 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (1 * 2) + (0 * 4) + (1 * 8) + (1 * 16) + (1 * 32) + (1 * 64) + (1 * 128),
		(1 * 1) + (0 * 2) + (1 * 4) + (1 * 8) + (0 * 16) + (0 * 32) + (1 * 64) + (1 * 128)},
		strings.Repeat("P", 128)},
}

func TestGolden(t *testing.T) {
	blockfuncSaved := blockfunc

	if sha && ssse3 && sse41 {
		blockfunc = blockfuncSha
		for _, g := range golden {
			s := fmt.Sprintf("%x", Sum256([]byte(g.in)))
			if Sum256([]byte(g.in)) != g.out {
				t.Fatalf("SHA: Sum256 function: sha256(%s) = %s want %s", g.in, s, hex.EncodeToString(g.out[:]))
			}
		}
	}
	if avx2 {
		blockfunc = blockfuncAvx2
		for _, g := range golden {
			s := fmt.Sprintf("%x", Sum256([]byte(g.in)))
			if Sum256([]byte(g.in)) != g.out {
				t.Fatalf("AVX2: Sum256 function: sha256(%s) = %s want %s", g.in, s, hex.EncodeToString(g.out[:]))
			}
		}
	}
	if avx {
		blockfunc = blockfuncAvx
		for _, g := range golden {
			s := fmt.Sprintf("%x", Sum256([]byte(g.in)))
			if Sum256([]byte(g.in)) != g.out {
				t.Fatalf("AVX: Sum256 function: sha256(%s) = %s want %s", g.in, s, hex.EncodeToString(g.out[:]))
			}
		}
	}
	if ssse3 {
		blockfunc = blockfuncSsse
		for _, g := range golden {
			s := fmt.Sprintf("%x", Sum256([]byte(g.in)))
			if Sum256([]byte(g.in)) != g.out {
				t.Fatalf("SSSE3: Sum256 function: sha256(%s) = %s want %s", g.in, s, hex.EncodeToString(g.out[:]))
			}
		}
	}
	if true {
		blockfunc = blockfuncGeneric
		for _, g := range golden {
			s := fmt.Sprintf("%x", Sum256([]byte(g.in)))
			if Sum256([]byte(g.in)) != g.out {
				t.Fatalf("Generic: Sum256 function: sha256(%s) = %s want %s", g.in, s, hex.EncodeToString(g.out[:]))
			}
		}
	}

	blockfunc = blockfuncSaved
}

func TestSize(t *testing.T) {
	c := New()
	if got := c.Size(); got != Size {
		t.Errorf("Size = %d; want %d", got, Size)
	}
}

func TestBlockSize(t *testing.T) {
	c := New()
	if got := c.BlockSize(); got != BlockSize {
		t.Errorf("BlockSize = %d want %d", got, BlockSize)
	}
}

func benchmarkSize(b *testing.B, size int) {
	var bench = New()
	var buf = make([]byte, size)
	b.SetBytes(int64(size))
	sum := make([]byte, bench.Size())
	b.ResetTimer()
	for i := 0; i < b.N; i++ {
		bench.Reset()
		bench.Write(buf[:size])
		bench.Sum(sum[:0])
	}
}

func BenchmarkHash(b *testing.B) {
	algos := []struct {
		n string
		t blockfuncType
		f bool
	}{
		{"SHA_", blockfuncSha, sha && sse41 && ssse3},
		{"AVX2", blockfuncAvx2, avx2},
		{"AVX_", blockfuncAvx, avx},
		{"SSSE", blockfuncSsse, ssse3},
		{"GEN_", blockfuncGeneric, true},
	}

	sizes := []struct {
		n string
		f func(*testing.B, int)
		s int
	}{
		{"8Bytes", benchmarkSize, 1 << 3},
		{"1K", benchmarkSize, 1 << 10},
		{"8K", benchmarkSize, 1 << 13},
		{"1M", benchmarkSize, 1 << 20},
		{"5M", benchmarkSize, 5 << 20},
		{"10M", benchmarkSize, 5 << 21},
	}

	for _, a := range algos {
		if a.f {
			blockfuncSaved := blockfunc
			blockfunc = a.t
			for _, y := range sizes {
				s := a.n + "/" + y.n
				b.Run(s, func(b *testing.B) { y.f(b, y.s) })
			}
			blockfunc = blockfuncSaved
		}
	}
}
