// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/resultstore/v2/file.proto

package resultstore

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The metadata for a file or an archive file entry.
type File struct {
	// The identifier of the file or archive entry.
	// User-provided, must be unique for the repeated field it is in. When an
	// Append RPC is called with a Files field populated, if a File already exists
	// with this ID, that File will be overwritten with the new File proto.
	Uid string `protobuf:"bytes,1,opt,name=uid,proto3" json:"uid,omitempty"`
	// The URI of a file.
	// This could also be the URI of an entire archive.
	// Most log data doesn't need to be stored forever, so a ttl is suggested.
	// Note that if you ever move or delete the file at this URI, the link from
	// the server will be broken.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// (Optional) The length of the file in bytes.  Allows the filesize to be
	// shown in the UI.  Omit if file is still being written or length is
	// not known.  This could also be the length of an entire archive.
	Length *wrappers.Int64Value `protobuf:"bytes,3,opt,name=length,proto3" json:"length,omitempty"`
	// (Optional) The content-type (aka MIME-type) of the file.  This is sent to
	// the web browser so it knows how to handle the file. (e.g. text/plain,
	// image/jpeg, text/html, etc). For zip archives, use "application/zip".
	ContentType string `protobuf:"bytes,4,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// (Optional) If the above path, length, and content_type are referring to an
	// archive, and you wish to refer to a particular entry within that archive,
	// put the particular archive entry data here.
	ArchiveEntry *ArchiveEntry `protobuf:"bytes,5,opt,name=archive_entry,json=archiveEntry,proto3" json:"archive_entry,omitempty"`
	// (Optional) A url to a content display app/site for this file or archive
	// entry.
	ContentViewer string `protobuf:"bytes,6,opt,name=content_viewer,json=contentViewer,proto3" json:"content_viewer,omitempty"`
	// (Optional) Whether to hide this file or archive entry in the UI.  Defaults
	// to false. A checkbox lets users see hidden files, but they're hidden by
	// default.
	Hidden bool `protobuf:"varint,7,opt,name=hidden,proto3" json:"hidden,omitempty"`
	// (Optional) A short description of what this file or archive entry
	// contains. This description should help someone viewing the list of these
	// files to understand the purpose of this file and what they would want to
	// view it for.
	Description          string   `protobuf:"bytes,8,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *File) Reset()         { *m = File{} }
func (m *File) String() string { return proto.CompactTextString(m) }
func (*File) ProtoMessage()    {}
func (*File) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f2079cd39696ac1, []int{0}
}

func (m *File) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_File.Unmarshal(m, b)
}
func (m *File) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_File.Marshal(b, m, deterministic)
}
func (m *File) XXX_Merge(src proto.Message) {
	xxx_messageInfo_File.Merge(m, src)
}
func (m *File) XXX_Size() int {
	return xxx_messageInfo_File.Size(m)
}
func (m *File) XXX_DiscardUnknown() {
	xxx_messageInfo_File.DiscardUnknown(m)
}

var xxx_messageInfo_File proto.InternalMessageInfo

func (m *File) GetUid() string {
	if m != nil {
		return m.Uid
	}
	return ""
}

func (m *File) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *File) GetLength() *wrappers.Int64Value {
	if m != nil {
		return m.Length
	}
	return nil
}

func (m *File) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

func (m *File) GetArchiveEntry() *ArchiveEntry {
	if m != nil {
		return m.ArchiveEntry
	}
	return nil
}

func (m *File) GetContentViewer() string {
	if m != nil {
		return m.ContentViewer
	}
	return ""
}

func (m *File) GetHidden() bool {
	if m != nil {
		return m.Hidden
	}
	return false
}

func (m *File) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Information specific to an entry in an archive.
type ArchiveEntry struct {
	// The relative path of the entry within the archive.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// (Optional) The uncompressed length of the archive entry in bytes.  Allows
	// the entry size to be shown in the UI.  Omit if the length is not known.
	Length *wrappers.Int64Value `protobuf:"bytes,2,opt,name=length,proto3" json:"length,omitempty"`
	// (Optional) The content-type (aka MIME-type) of the archive entry. (e.g.
	// text/plain, image/jpeg, text/html, etc). This is sent to the web browser
	// so it knows how to handle the entry.
	ContentType          string   `protobuf:"bytes,3,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ArchiveEntry) Reset()         { *m = ArchiveEntry{} }
func (m *ArchiveEntry) String() string { return proto.CompactTextString(m) }
func (*ArchiveEntry) ProtoMessage()    {}
func (*ArchiveEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f2079cd39696ac1, []int{1}
}

func (m *ArchiveEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ArchiveEntry.Unmarshal(m, b)
}
func (m *ArchiveEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ArchiveEntry.Marshal(b, m, deterministic)
}
func (m *ArchiveEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ArchiveEntry.Merge(m, src)
}
func (m *ArchiveEntry) XXX_Size() int {
	return xxx_messageInfo_ArchiveEntry.Size(m)
}
func (m *ArchiveEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_ArchiveEntry.DiscardUnknown(m)
}

var xxx_messageInfo_ArchiveEntry proto.InternalMessageInfo

func (m *ArchiveEntry) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *ArchiveEntry) GetLength() *wrappers.Int64Value {
	if m != nil {
		return m.Length
	}
	return nil
}

func (m *ArchiveEntry) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

func init() {
	proto.RegisterType((*File)(nil), "google.devtools.resultstore.v2.File")
	proto.RegisterType((*ArchiveEntry)(nil), "google.devtools.resultstore.v2.ArchiveEntry")
}

func init() {
	proto.RegisterFile("google/devtools/resultstore/v2/file.proto", fileDescriptor_0f2079cd39696ac1)
}

var fileDescriptor_0f2079cd39696ac1 = []byte{
	// 350 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x52, 0xdf, 0x4b, 0xeb, 0x30,
	0x14, 0xa6, 0xdb, 0x6e, 0xef, 0x6e, 0xb6, 0x5d, 0x24, 0x0f, 0x12, 0x14, 0xa4, 0x0e, 0x84, 0x09,
	0x92, 0xc0, 0x26, 0xbe, 0xf8, 0xa4, 0xa0, 0xb0, 0x37, 0x2d, 0xb2, 0x07, 0x5f, 0x46, 0xd7, 0x9e,
	0xb5, 0x81, 0x98, 0xc4, 0x34, 0xed, 0x98, 0x7f, 0x98, 0x7f, 0x9f, 0x2c, 0xcd, 0xa0, 0x20, 0x2a,
	0xf8, 0x76, 0xce, 0x77, 0xbe, 0x1f, 0xed, 0x47, 0xd0, 0x79, 0xae, 0x54, 0x2e, 0x80, 0x65, 0x50,
	0x5b, 0xa5, 0x44, 0xc9, 0x0c, 0x94, 0x95, 0xb0, 0xa5, 0x55, 0x06, 0x58, 0x3d, 0x65, 0x6b, 0x2e,
	0x80, 0x6a, 0xa3, 0xac, 0xc2, 0x27, 0x0d, 0x95, 0xee, 0xa9, 0xb4, 0x45, 0xa5, 0xf5, 0xf4, 0xc8,
	0xdf, 0x99, 0x63, 0xaf, 0xaa, 0x35, 0xdb, 0x98, 0x44, 0x6b, 0x30, 0x65, 0xa3, 0x1f, 0xbf, 0x77,
	0x50, 0xef, 0x9e, 0x0b, 0xc0, 0x07, 0xa8, 0x5b, 0xf1, 0x8c, 0x04, 0x51, 0x30, 0xf9, 0x17, 0xef,
	0x46, 0x87, 0x18, 0x4e, 0x3a, 0x1e, 0x31, 0x1c, 0xcf, 0x50, 0x28, 0x40, 0xe6, 0xb6, 0x20, 0xdd,
	0x28, 0x98, 0x0c, 0xa6, 0xc7, 0xd4, 0xa7, 0xef, 0xdd, 0xe9, 0x5c, 0xda, 0xab, 0xcb, 0x45, 0x22,
	0x2a, 0x88, 0x3d, 0x15, 0x9f, 0xa2, 0x61, 0xaa, 0xa4, 0x05, 0x69, 0x97, 0x76, 0xab, 0x81, 0xf4,
	0x9c, 0xdf, 0xc0, 0x63, 0x4f, 0x5b, 0x0d, 0xf8, 0x11, 0x8d, 0x12, 0x93, 0x16, 0xbc, 0x86, 0x25,
	0x48, 0x6b, 0xb6, 0xe4, 0x8f, 0xb3, 0xbf, 0xa0, 0xdf, 0xff, 0x1c, 0xbd, 0x69, 0x44, 0x77, 0x3b,
	0x4d, 0x3c, 0x4c, 0x5a, 0x1b, 0x3e, 0x43, 0xff, 0xf7, 0xa9, 0x35, 0x87, 0x0d, 0x18, 0x12, 0xba,
	0xdc, 0x91, 0x47, 0x17, 0x0e, 0xc4, 0x87, 0x28, 0x2c, 0x78, 0x96, 0x81, 0x24, 0x7f, 0xa3, 0x60,
	0xd2, 0x8f, 0xfd, 0x86, 0x23, 0x34, 0xc8, 0xa0, 0x4c, 0x0d, 0xd7, 0x96, 0x2b, 0x49, 0xfa, 0xcd,
	0x37, 0xb7, 0xa0, 0xf1, 0x1b, 0x1a, 0xb6, 0xe3, 0x31, 0x46, 0x3d, 0x9d, 0xd8, 0xc2, 0x17, 0xe8,
	0xe6, 0x56, 0x5f, 0x9d, 0xdf, 0xf7, 0xd5, 0xfd, 0xd4, 0xd7, 0xed, 0x2b, 0x1a, 0xa7, 0xea, 0xe5,
	0x87, 0x76, 0x1e, 0x82, 0xe7, 0xb9, 0x67, 0xe4, 0x4a, 0x24, 0x32, 0xa7, 0xca, 0xe4, 0x2c, 0x07,
	0xe9, 0xc2, 0x59, 0x73, 0x4a, 0x34, 0x2f, 0xbf, 0x7a, 0x66, 0xd7, 0xad, 0x75, 0x15, 0x3a, 0xd5,
	0xec, 0x23, 0x00, 0x00, 0xff, 0xff, 0x65, 0xa9, 0x29, 0x4f, 0x9b, 0x02, 0x00, 0x00,
}
