// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/monitoring/v3/uptime.proto

package monitoring

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	monitoredres "google.golang.org/genproto/googleapis/api/monitoredres"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The regions from which an uptime check can be run.
type UptimeCheckRegion int32

const (
	// Default value if no region is specified. Will result in uptime checks
	// running from all regions.
	UptimeCheckRegion_REGION_UNSPECIFIED UptimeCheckRegion = 0
	// Allows checks to run from locations within the United States of America.
	UptimeCheckRegion_USA UptimeCheckRegion = 1
	// Allows checks to run from locations within the continent of Europe.
	UptimeCheckRegion_EUROPE UptimeCheckRegion = 2
	// Allows checks to run from locations within the continent of South
	// America.
	UptimeCheckRegion_SOUTH_AMERICA UptimeCheckRegion = 3
	// Allows checks to run from locations within the Asia Pacific area (ex:
	// Singapore).
	UptimeCheckRegion_ASIA_PACIFIC UptimeCheckRegion = 4
)

var UptimeCheckRegion_name = map[int32]string{
	0: "REGION_UNSPECIFIED",
	1: "USA",
	2: "EUROPE",
	3: "SOUTH_AMERICA",
	4: "ASIA_PACIFIC",
}

var UptimeCheckRegion_value = map[string]int32{
	"REGION_UNSPECIFIED": 0,
	"USA":                1,
	"EUROPE":             2,
	"SOUTH_AMERICA":      3,
	"ASIA_PACIFIC":       4,
}

func (x UptimeCheckRegion) String() string {
	return proto.EnumName(UptimeCheckRegion_name, int32(x))
}

func (UptimeCheckRegion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{0}
}

// The supported resource types that can be used as values of
// `group_resource.resource_type`.
// `INSTANCE` includes `gce_instance` and `aws_ec2_instance` resource types.
// The resource types `gae_app` and `uptime_url` are not valid here because
// group checks on App Engine modules and URLs are not allowed.
type GroupResourceType int32

const (
	// Default value (not valid).
	GroupResourceType_RESOURCE_TYPE_UNSPECIFIED GroupResourceType = 0
	// A group of instances from Google Cloud Platform (GCP) or
	// Amazon Web Services (AWS).
	GroupResourceType_INSTANCE GroupResourceType = 1
	// A group of Amazon ELB load balancers.
	GroupResourceType_AWS_ELB_LOAD_BALANCER GroupResourceType = 2
)

var GroupResourceType_name = map[int32]string{
	0: "RESOURCE_TYPE_UNSPECIFIED",
	1: "INSTANCE",
	2: "AWS_ELB_LOAD_BALANCER",
}

var GroupResourceType_value = map[string]int32{
	"RESOURCE_TYPE_UNSPECIFIED": 0,
	"INSTANCE":                  1,
	"AWS_ELB_LOAD_BALANCER":     2,
}

func (x GroupResourceType) String() string {
	return proto.EnumName(GroupResourceType_name, int32(x))
}

func (GroupResourceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{1}
}

// Nimbus InternalCheckers.
type InternalChecker struct {
	// The GCP project ID. Not necessarily the same as the project_id for the
	// config.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The internal network to perform this uptime check on.
	Network string `protobuf:"bytes,2,opt,name=network,proto3" json:"network,omitempty"`
	// The GCP zone the uptime check should egress from. Only respected for
	// internal uptime checks, where internal_network is specified.
	GcpZone string `protobuf:"bytes,3,opt,name=gcp_zone,json=gcpZone,proto3" json:"gcp_zone,omitempty"`
	// The checker ID.
	CheckerId string `protobuf:"bytes,4,opt,name=checker_id,json=checkerId,proto3" json:"checker_id,omitempty"`
	// The checker's human-readable name.
	DisplayName          string   `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InternalChecker) Reset()         { *m = InternalChecker{} }
func (m *InternalChecker) String() string { return proto.CompactTextString(m) }
func (*InternalChecker) ProtoMessage()    {}
func (*InternalChecker) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{0}
}

func (m *InternalChecker) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InternalChecker.Unmarshal(m, b)
}
func (m *InternalChecker) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InternalChecker.Marshal(b, m, deterministic)
}
func (m *InternalChecker) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InternalChecker.Merge(m, src)
}
func (m *InternalChecker) XXX_Size() int {
	return xxx_messageInfo_InternalChecker.Size(m)
}
func (m *InternalChecker) XXX_DiscardUnknown() {
	xxx_messageInfo_InternalChecker.DiscardUnknown(m)
}

var xxx_messageInfo_InternalChecker proto.InternalMessageInfo

func (m *InternalChecker) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *InternalChecker) GetNetwork() string {
	if m != nil {
		return m.Network
	}
	return ""
}

func (m *InternalChecker) GetGcpZone() string {
	if m != nil {
		return m.GcpZone
	}
	return ""
}

func (m *InternalChecker) GetCheckerId() string {
	if m != nil {
		return m.CheckerId
	}
	return ""
}

func (m *InternalChecker) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

// This message configures which resources and services to monitor for
// availability.
type UptimeCheckConfig struct {
	// A unique resource name for this UptimeCheckConfig. The format is:
	//
	//
	//   `projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID]`.
	//
	// This field should be omitted when creating the uptime check configuration;
	// on create, the resource name is assigned by the server and included in the
	// response.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A human-friendly name for the uptime check configuration. The display name
	// should be unique within a Stackdriver Account in order to make it easier
	// to identify; however, uniqueness is not enforced. Required.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The resource the check is checking. Required.
	//
	// Types that are valid to be assigned to Resource:
	//	*UptimeCheckConfig_MonitoredResource
	//	*UptimeCheckConfig_ResourceGroup_
	Resource isUptimeCheckConfig_Resource `protobuf_oneof:"resource"`
	// The type of uptime check request.
	//
	// Types that are valid to be assigned to CheckRequestType:
	//	*UptimeCheckConfig_HttpCheck_
	//	*UptimeCheckConfig_TcpCheck_
	CheckRequestType isUptimeCheckConfig_CheckRequestType `protobuf_oneof:"check_request_type"`
	// How often, in seconds, the uptime check is performed.
	// Currently, the only supported values are `60s` (1 minute), `300s`
	// (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
	// defaults to `300s`.
	Period *duration.Duration `protobuf:"bytes,7,opt,name=period,proto3" json:"period,omitempty"`
	// The maximum amount of time to wait for the request to complete (must be
	// between 1 and 60 seconds). Required.
	Timeout *duration.Duration `protobuf:"bytes,8,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The expected content on the page the check is run against.
	// Currently, only the first entry in the list is supported, and other entries
	// will be ignored. The server will look for an exact match of the string in
	// the page response's content. This field is optional and should only be
	// specified if a content match is required.
	ContentMatchers []*UptimeCheckConfig_ContentMatcher `protobuf:"bytes,9,rep,name=content_matchers,json=contentMatchers,proto3" json:"content_matchers,omitempty"`
	// The list of regions from which the check will be run.
	// If this field is specified, enough regions to include a minimum of
	// 3 locations must be provided, or an error message is returned.
	// Not specifying this field will result in uptime checks running from all
	// regions.
	SelectedRegions []UptimeCheckRegion `protobuf:"varint,10,rep,packed,name=selected_regions,json=selectedRegions,proto3,enum=google.monitoring.v3.UptimeCheckRegion" json:"selected_regions,omitempty"`
	// Denotes whether this is a check that egresses from InternalCheckers.
	IsInternal bool `protobuf:"varint,15,opt,name=is_internal,json=isInternal,proto3" json:"is_internal,omitempty"`
	// The internal checkers that this check will egress from. If `is_internal` is
	// true and this list is empty, the check will egress from all
	// InternalCheckers configured for the project that owns this CheckConfig.
	InternalCheckers     []*InternalChecker `protobuf:"bytes,14,rep,name=internal_checkers,json=internalCheckers,proto3" json:"internal_checkers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *UptimeCheckConfig) Reset()         { *m = UptimeCheckConfig{} }
func (m *UptimeCheckConfig) String() string { return proto.CompactTextString(m) }
func (*UptimeCheckConfig) ProtoMessage()    {}
func (*UptimeCheckConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{1}
}

func (m *UptimeCheckConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UptimeCheckConfig.Unmarshal(m, b)
}
func (m *UptimeCheckConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UptimeCheckConfig.Marshal(b, m, deterministic)
}
func (m *UptimeCheckConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UptimeCheckConfig.Merge(m, src)
}
func (m *UptimeCheckConfig) XXX_Size() int {
	return xxx_messageInfo_UptimeCheckConfig.Size(m)
}
func (m *UptimeCheckConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_UptimeCheckConfig.DiscardUnknown(m)
}

var xxx_messageInfo_UptimeCheckConfig proto.InternalMessageInfo

func (m *UptimeCheckConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UptimeCheckConfig) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

type isUptimeCheckConfig_Resource interface {
	isUptimeCheckConfig_Resource()
}

type UptimeCheckConfig_MonitoredResource struct {
	MonitoredResource *monitoredres.MonitoredResource `protobuf:"bytes,3,opt,name=monitored_resource,json=monitoredResource,proto3,oneof"`
}

type UptimeCheckConfig_ResourceGroup_ struct {
	ResourceGroup *UptimeCheckConfig_ResourceGroup `protobuf:"bytes,4,opt,name=resource_group,json=resourceGroup,proto3,oneof"`
}

func (*UptimeCheckConfig_MonitoredResource) isUptimeCheckConfig_Resource() {}

func (*UptimeCheckConfig_ResourceGroup_) isUptimeCheckConfig_Resource() {}

func (m *UptimeCheckConfig) GetResource() isUptimeCheckConfig_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *UptimeCheckConfig) GetMonitoredResource() *monitoredres.MonitoredResource {
	if x, ok := m.GetResource().(*UptimeCheckConfig_MonitoredResource); ok {
		return x.MonitoredResource
	}
	return nil
}

func (m *UptimeCheckConfig) GetResourceGroup() *UptimeCheckConfig_ResourceGroup {
	if x, ok := m.GetResource().(*UptimeCheckConfig_ResourceGroup_); ok {
		return x.ResourceGroup
	}
	return nil
}

type isUptimeCheckConfig_CheckRequestType interface {
	isUptimeCheckConfig_CheckRequestType()
}

type UptimeCheckConfig_HttpCheck_ struct {
	HttpCheck *UptimeCheckConfig_HttpCheck `protobuf:"bytes,5,opt,name=http_check,json=httpCheck,proto3,oneof"`
}

type UptimeCheckConfig_TcpCheck_ struct {
	TcpCheck *UptimeCheckConfig_TcpCheck `protobuf:"bytes,6,opt,name=tcp_check,json=tcpCheck,proto3,oneof"`
}

func (*UptimeCheckConfig_HttpCheck_) isUptimeCheckConfig_CheckRequestType() {}

func (*UptimeCheckConfig_TcpCheck_) isUptimeCheckConfig_CheckRequestType() {}

func (m *UptimeCheckConfig) GetCheckRequestType() isUptimeCheckConfig_CheckRequestType {
	if m != nil {
		return m.CheckRequestType
	}
	return nil
}

func (m *UptimeCheckConfig) GetHttpCheck() *UptimeCheckConfig_HttpCheck {
	if x, ok := m.GetCheckRequestType().(*UptimeCheckConfig_HttpCheck_); ok {
		return x.HttpCheck
	}
	return nil
}

func (m *UptimeCheckConfig) GetTcpCheck() *UptimeCheckConfig_TcpCheck {
	if x, ok := m.GetCheckRequestType().(*UptimeCheckConfig_TcpCheck_); ok {
		return x.TcpCheck
	}
	return nil
}

func (m *UptimeCheckConfig) GetPeriod() *duration.Duration {
	if m != nil {
		return m.Period
	}
	return nil
}

func (m *UptimeCheckConfig) GetTimeout() *duration.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *UptimeCheckConfig) GetContentMatchers() []*UptimeCheckConfig_ContentMatcher {
	if m != nil {
		return m.ContentMatchers
	}
	return nil
}

func (m *UptimeCheckConfig) GetSelectedRegions() []UptimeCheckRegion {
	if m != nil {
		return m.SelectedRegions
	}
	return nil
}

func (m *UptimeCheckConfig) GetIsInternal() bool {
	if m != nil {
		return m.IsInternal
	}
	return false
}

func (m *UptimeCheckConfig) GetInternalCheckers() []*InternalChecker {
	if m != nil {
		return m.InternalCheckers
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*UptimeCheckConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _UptimeCheckConfig_OneofMarshaler, _UptimeCheckConfig_OneofUnmarshaler, _UptimeCheckConfig_OneofSizer, []interface{}{
		(*UptimeCheckConfig_MonitoredResource)(nil),
		(*UptimeCheckConfig_ResourceGroup_)(nil),
		(*UptimeCheckConfig_HttpCheck_)(nil),
		(*UptimeCheckConfig_TcpCheck_)(nil),
	}
}

func _UptimeCheckConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*UptimeCheckConfig)
	// resource
	switch x := m.Resource.(type) {
	case *UptimeCheckConfig_MonitoredResource:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MonitoredResource); err != nil {
			return err
		}
	case *UptimeCheckConfig_ResourceGroup_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResourceGroup); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("UptimeCheckConfig.Resource has unexpected type %T", x)
	}
	// check_request_type
	switch x := m.CheckRequestType.(type) {
	case *UptimeCheckConfig_HttpCheck_:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HttpCheck); err != nil {
			return err
		}
	case *UptimeCheckConfig_TcpCheck_:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TcpCheck); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("UptimeCheckConfig.CheckRequestType has unexpected type %T", x)
	}
	return nil
}

func _UptimeCheckConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*UptimeCheckConfig)
	switch tag {
	case 3: // resource.monitored_resource
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(monitoredres.MonitoredResource)
		err := b.DecodeMessage(msg)
		m.Resource = &UptimeCheckConfig_MonitoredResource{msg}
		return true, err
	case 4: // resource.resource_group
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UptimeCheckConfig_ResourceGroup)
		err := b.DecodeMessage(msg)
		m.Resource = &UptimeCheckConfig_ResourceGroup_{msg}
		return true, err
	case 5: // check_request_type.http_check
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UptimeCheckConfig_HttpCheck)
		err := b.DecodeMessage(msg)
		m.CheckRequestType = &UptimeCheckConfig_HttpCheck_{msg}
		return true, err
	case 6: // check_request_type.tcp_check
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UptimeCheckConfig_TcpCheck)
		err := b.DecodeMessage(msg)
		m.CheckRequestType = &UptimeCheckConfig_TcpCheck_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _UptimeCheckConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*UptimeCheckConfig)
	// resource
	switch x := m.Resource.(type) {
	case *UptimeCheckConfig_MonitoredResource:
		s := proto.Size(x.MonitoredResource)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UptimeCheckConfig_ResourceGroup_:
		s := proto.Size(x.ResourceGroup)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// check_request_type
	switch x := m.CheckRequestType.(type) {
	case *UptimeCheckConfig_HttpCheck_:
		s := proto.Size(x.HttpCheck)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UptimeCheckConfig_TcpCheck_:
		s := proto.Size(x.TcpCheck)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The resource submessage for group checks. It can be used instead of a
// monitored resource, when multiple resources are being monitored.
type UptimeCheckConfig_ResourceGroup struct {
	// The group of resources being monitored. Should be only the
	// group_id, not projects/<project_id>/groups/<group_id>.
	GroupId string `protobuf:"bytes,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// The resource type of the group members.
	ResourceType         GroupResourceType `protobuf:"varint,2,opt,name=resource_type,json=resourceType,proto3,enum=google.monitoring.v3.GroupResourceType" json:"resource_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UptimeCheckConfig_ResourceGroup) Reset()         { *m = UptimeCheckConfig_ResourceGroup{} }
func (m *UptimeCheckConfig_ResourceGroup) String() string { return proto.CompactTextString(m) }
func (*UptimeCheckConfig_ResourceGroup) ProtoMessage()    {}
func (*UptimeCheckConfig_ResourceGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{1, 0}
}

func (m *UptimeCheckConfig_ResourceGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UptimeCheckConfig_ResourceGroup.Unmarshal(m, b)
}
func (m *UptimeCheckConfig_ResourceGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UptimeCheckConfig_ResourceGroup.Marshal(b, m, deterministic)
}
func (m *UptimeCheckConfig_ResourceGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UptimeCheckConfig_ResourceGroup.Merge(m, src)
}
func (m *UptimeCheckConfig_ResourceGroup) XXX_Size() int {
	return xxx_messageInfo_UptimeCheckConfig_ResourceGroup.Size(m)
}
func (m *UptimeCheckConfig_ResourceGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_UptimeCheckConfig_ResourceGroup.DiscardUnknown(m)
}

var xxx_messageInfo_UptimeCheckConfig_ResourceGroup proto.InternalMessageInfo

func (m *UptimeCheckConfig_ResourceGroup) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

func (m *UptimeCheckConfig_ResourceGroup) GetResourceType() GroupResourceType {
	if m != nil {
		return m.ResourceType
	}
	return GroupResourceType_RESOURCE_TYPE_UNSPECIFIED
}

// Information involved in an HTTP/HTTPS uptime check request.
type UptimeCheckConfig_HttpCheck struct {
	// If true, use HTTPS instead of HTTP to run the check.
	UseSsl bool `protobuf:"varint,1,opt,name=use_ssl,json=useSsl,proto3" json:"use_ssl,omitempty"`
	// The path to the page to run the check against. Will be combined with the
	// host (specified within the MonitoredResource) and port to construct the
	// full URL. Optional (defaults to "/").
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// The port to the page to run the check against. Will be combined with host
	// (specified within the MonitoredResource) and path to construct the full
	// URL. Optional (defaults to 80 without SSL, or 443 with SSL).
	Port int32 `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
	// The authentication information. Optional when creating an HTTP check;
	// defaults to empty.
	AuthInfo *UptimeCheckConfig_HttpCheck_BasicAuthentication `protobuf:"bytes,4,opt,name=auth_info,json=authInfo,proto3" json:"auth_info,omitempty"`
	// Boolean specifiying whether to encrypt the header information.
	// Encryption should be specified for any headers related to authentication
	// that you do not wish to be seen when retrieving the configuration. The
	// server will be responsible for encrypting the headers.
	// On Get/List calls, if mask_headers is set to True then the headers
	// will be obscured with ******.
	MaskHeaders bool `protobuf:"varint,5,opt,name=mask_headers,json=maskHeaders,proto3" json:"mask_headers,omitempty"`
	// The list of headers to send as part of the uptime check request.
	// If two headers have the same key and different values, they should
	// be entered as a single header, with the value being a comma-separated
	// list of all the desired values as described at
	// https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
	// Entering two separate headers with the same key in a Create call will
	// cause the first to be overwritten by the second.
	// The maximum number of headers allowed is 100.
	Headers              map[string]string `protobuf:"bytes,6,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UptimeCheckConfig_HttpCheck) Reset()         { *m = UptimeCheckConfig_HttpCheck{} }
func (m *UptimeCheckConfig_HttpCheck) String() string { return proto.CompactTextString(m) }
func (*UptimeCheckConfig_HttpCheck) ProtoMessage()    {}
func (*UptimeCheckConfig_HttpCheck) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{1, 1}
}

func (m *UptimeCheckConfig_HttpCheck) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UptimeCheckConfig_HttpCheck.Unmarshal(m, b)
}
func (m *UptimeCheckConfig_HttpCheck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UptimeCheckConfig_HttpCheck.Marshal(b, m, deterministic)
}
func (m *UptimeCheckConfig_HttpCheck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UptimeCheckConfig_HttpCheck.Merge(m, src)
}
func (m *UptimeCheckConfig_HttpCheck) XXX_Size() int {
	return xxx_messageInfo_UptimeCheckConfig_HttpCheck.Size(m)
}
func (m *UptimeCheckConfig_HttpCheck) XXX_DiscardUnknown() {
	xxx_messageInfo_UptimeCheckConfig_HttpCheck.DiscardUnknown(m)
}

var xxx_messageInfo_UptimeCheckConfig_HttpCheck proto.InternalMessageInfo

func (m *UptimeCheckConfig_HttpCheck) GetUseSsl() bool {
	if m != nil {
		return m.UseSsl
	}
	return false
}

func (m *UptimeCheckConfig_HttpCheck) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *UptimeCheckConfig_HttpCheck) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *UptimeCheckConfig_HttpCheck) GetAuthInfo() *UptimeCheckConfig_HttpCheck_BasicAuthentication {
	if m != nil {
		return m.AuthInfo
	}
	return nil
}

func (m *UptimeCheckConfig_HttpCheck) GetMaskHeaders() bool {
	if m != nil {
		return m.MaskHeaders
	}
	return false
}

func (m *UptimeCheckConfig_HttpCheck) GetHeaders() map[string]string {
	if m != nil {
		return m.Headers
	}
	return nil
}

// A type of authentication to perform against the specified resource or URL
// that uses username and password.
// Currently, only Basic authentication is supported in Uptime Monitoring.
type UptimeCheckConfig_HttpCheck_BasicAuthentication struct {
	// The username to authenticate.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// The password to authenticate.
	Password             string   `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) Reset() {
	*m = UptimeCheckConfig_HttpCheck_BasicAuthentication{}
}
func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) String() string {
	return proto.CompactTextString(m)
}
func (*UptimeCheckConfig_HttpCheck_BasicAuthentication) ProtoMessage() {}
func (*UptimeCheckConfig_HttpCheck_BasicAuthentication) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{1, 1, 0}
}

func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UptimeCheckConfig_HttpCheck_BasicAuthentication.Unmarshal(m, b)
}
func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UptimeCheckConfig_HttpCheck_BasicAuthentication.Marshal(b, m, deterministic)
}
func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UptimeCheckConfig_HttpCheck_BasicAuthentication.Merge(m, src)
}
func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) XXX_Size() int {
	return xxx_messageInfo_UptimeCheckConfig_HttpCheck_BasicAuthentication.Size(m)
}
func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) XXX_DiscardUnknown() {
	xxx_messageInfo_UptimeCheckConfig_HttpCheck_BasicAuthentication.DiscardUnknown(m)
}

var xxx_messageInfo_UptimeCheckConfig_HttpCheck_BasicAuthentication proto.InternalMessageInfo

func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

// Information required for a TCP uptime check request.
type UptimeCheckConfig_TcpCheck struct {
	// The port to the page to run the check against. Will be combined with host
	// (specified within the MonitoredResource) to construct the full URL.
	// Required.
	Port                 int32    `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UptimeCheckConfig_TcpCheck) Reset()         { *m = UptimeCheckConfig_TcpCheck{} }
func (m *UptimeCheckConfig_TcpCheck) String() string { return proto.CompactTextString(m) }
func (*UptimeCheckConfig_TcpCheck) ProtoMessage()    {}
func (*UptimeCheckConfig_TcpCheck) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{1, 2}
}

func (m *UptimeCheckConfig_TcpCheck) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UptimeCheckConfig_TcpCheck.Unmarshal(m, b)
}
func (m *UptimeCheckConfig_TcpCheck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UptimeCheckConfig_TcpCheck.Marshal(b, m, deterministic)
}
func (m *UptimeCheckConfig_TcpCheck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UptimeCheckConfig_TcpCheck.Merge(m, src)
}
func (m *UptimeCheckConfig_TcpCheck) XXX_Size() int {
	return xxx_messageInfo_UptimeCheckConfig_TcpCheck.Size(m)
}
func (m *UptimeCheckConfig_TcpCheck) XXX_DiscardUnknown() {
	xxx_messageInfo_UptimeCheckConfig_TcpCheck.DiscardUnknown(m)
}

var xxx_messageInfo_UptimeCheckConfig_TcpCheck proto.InternalMessageInfo

func (m *UptimeCheckConfig_TcpCheck) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

// Used to perform string matching. Currently, this matches on the exact
// content. In the future, it can be expanded to allow for regular expressions
// and more complex matching.
type UptimeCheckConfig_ContentMatcher struct {
	// String content to match (max 1024 bytes)
	Content              string   `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UptimeCheckConfig_ContentMatcher) Reset()         { *m = UptimeCheckConfig_ContentMatcher{} }
func (m *UptimeCheckConfig_ContentMatcher) String() string { return proto.CompactTextString(m) }
func (*UptimeCheckConfig_ContentMatcher) ProtoMessage()    {}
func (*UptimeCheckConfig_ContentMatcher) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{1, 3}
}

func (m *UptimeCheckConfig_ContentMatcher) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UptimeCheckConfig_ContentMatcher.Unmarshal(m, b)
}
func (m *UptimeCheckConfig_ContentMatcher) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UptimeCheckConfig_ContentMatcher.Marshal(b, m, deterministic)
}
func (m *UptimeCheckConfig_ContentMatcher) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UptimeCheckConfig_ContentMatcher.Merge(m, src)
}
func (m *UptimeCheckConfig_ContentMatcher) XXX_Size() int {
	return xxx_messageInfo_UptimeCheckConfig_ContentMatcher.Size(m)
}
func (m *UptimeCheckConfig_ContentMatcher) XXX_DiscardUnknown() {
	xxx_messageInfo_UptimeCheckConfig_ContentMatcher.DiscardUnknown(m)
}

var xxx_messageInfo_UptimeCheckConfig_ContentMatcher proto.InternalMessageInfo

func (m *UptimeCheckConfig_ContentMatcher) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

// Contains the region, location, and list of IP
// addresses where checkers in the location run from.
type UptimeCheckIp struct {
	// A broad region category in which the IP address is located.
	Region UptimeCheckRegion `protobuf:"varint,1,opt,name=region,proto3,enum=google.monitoring.v3.UptimeCheckRegion" json:"region,omitempty"`
	// A more specific location within the region that typically encodes
	// a particular city/town/metro (and its containing state/province or country)
	// within the broader umbrella region category.
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// The IP address from which the uptime check originates. This is a full
	// IP address (not an IP address range). Most IP addresses, as of this
	// publication, are in IPv4 format; however, one should not rely on the
	// IP addresses being in IPv4 format indefinitely and should support
	// interpreting this field in either IPv4 or IPv6 format.
	IpAddress            string   `protobuf:"bytes,3,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UptimeCheckIp) Reset()         { *m = UptimeCheckIp{} }
func (m *UptimeCheckIp) String() string { return proto.CompactTextString(m) }
func (*UptimeCheckIp) ProtoMessage()    {}
func (*UptimeCheckIp) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{2}
}

func (m *UptimeCheckIp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UptimeCheckIp.Unmarshal(m, b)
}
func (m *UptimeCheckIp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UptimeCheckIp.Marshal(b, m, deterministic)
}
func (m *UptimeCheckIp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UptimeCheckIp.Merge(m, src)
}
func (m *UptimeCheckIp) XXX_Size() int {
	return xxx_messageInfo_UptimeCheckIp.Size(m)
}
func (m *UptimeCheckIp) XXX_DiscardUnknown() {
	xxx_messageInfo_UptimeCheckIp.DiscardUnknown(m)
}

var xxx_messageInfo_UptimeCheckIp proto.InternalMessageInfo

func (m *UptimeCheckIp) GetRegion() UptimeCheckRegion {
	if m != nil {
		return m.Region
	}
	return UptimeCheckRegion_REGION_UNSPECIFIED
}

func (m *UptimeCheckIp) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *UptimeCheckIp) GetIpAddress() string {
	if m != nil {
		return m.IpAddress
	}
	return ""
}

func init() {
	proto.RegisterType((*InternalChecker)(nil), "google.monitoring.v3.InternalChecker")
	proto.RegisterType((*UptimeCheckConfig)(nil), "google.monitoring.v3.UptimeCheckConfig")
	proto.RegisterType((*UptimeCheckConfig_ResourceGroup)(nil), "google.monitoring.v3.UptimeCheckConfig.ResourceGroup")
	proto.RegisterType((*UptimeCheckConfig_HttpCheck)(nil), "google.monitoring.v3.UptimeCheckConfig.HttpCheck")
	proto.RegisterMapType((map[string]string)(nil), "google.monitoring.v3.UptimeCheckConfig.HttpCheck.HeadersEntry")
	proto.RegisterType((*UptimeCheckConfig_HttpCheck_BasicAuthentication)(nil), "google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication")
	proto.RegisterType((*UptimeCheckConfig_TcpCheck)(nil), "google.monitoring.v3.UptimeCheckConfig.TcpCheck")
	proto.RegisterType((*UptimeCheckConfig_ContentMatcher)(nil), "google.monitoring.v3.UptimeCheckConfig.ContentMatcher")
	proto.RegisterType((*UptimeCheckIp)(nil), "google.monitoring.v3.UptimeCheckIp")
	proto.RegisterEnum("google.monitoring.v3.UptimeCheckRegion", UptimeCheckRegion_name, UptimeCheckRegion_value)
	proto.RegisterEnum("google.monitoring.v3.GroupResourceType", GroupResourceType_name, GroupResourceType_value)
}

func init() { proto.RegisterFile("google/monitoring/v3/uptime.proto", fileDescriptor_7ca0e36dfc8221d8) }

var fileDescriptor_7ca0e36dfc8221d8 = []byte{
	// 1043 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0xed, 0x6e, 0xe3, 0x44,
	0x17, 0x5e, 0x27, 0x6d, 0x3e, 0x4e, 0xfa, 0xe1, 0xce, 0xdb, 0x17, 0xdc, 0x48, 0x5d, 0xba, 0x45,
	0x88, 0xaa, 0x3f, 0x1c, 0xb6, 0x11, 0x08, 0x2d, 0xd2, 0x22, 0x27, 0x35, 0x8d, 0xa5, 0x36, 0x89,
	0x26, 0xcd, 0x02, 0x4b, 0x85, 0xe5, 0xda, 0x53, 0xc7, 0x34, 0xf1, 0x18, 0xcf, 0xb8, 0x4b, 0xb9,
	0x05, 0x2e, 0x83, 0x1f, 0x48, 0x5c, 0x01, 0xd7, 0xc0, 0x05, 0x70, 0x3d, 0xc8, 0xe3, 0x99, 0xb4,
	0x69, 0x8b, 0xb6, 0xfd, 0x37, 0xcf, 0xf9, 0x78, 0xe6, 0xf8, 0xcc, 0x79, 0x66, 0x0c, 0x2f, 0x42,
	0x4a, 0xc3, 0x29, 0x69, 0xcd, 0x68, 0x1c, 0x71, 0x9a, 0x46, 0x71, 0xd8, 0xba, 0x6a, 0xb7, 0xb2,
	0x84, 0x47, 0x33, 0x62, 0x26, 0x29, 0xe5, 0x14, 0x6d, 0x16, 0x21, 0xe6, 0x4d, 0x88, 0x79, 0xd5,
	0x6e, 0x7e, 0x2c, 0x13, 0xbd, 0x24, 0x52, 0xc9, 0x24, 0x70, 0x53, 0xc2, 0x68, 0x96, 0xfa, 0x32,
	0xb5, 0xf9, 0x5c, 0x06, 0x09, 0x74, 0x9e, 0x5d, 0xb4, 0x82, 0x2c, 0xf5, 0x78, 0x44, 0xe3, 0xc2,
	0xbf, 0xfb, 0x87, 0x06, 0xeb, 0x4e, 0xcc, 0x49, 0x1a, 0x7b, 0xd3, 0xee, 0x84, 0xf8, 0x97, 0x24,
	0x45, 0xdb, 0x00, 0x49, 0x4a, 0x7f, 0x22, 0x3e, 0x77, 0xa3, 0xc0, 0xd0, 0x76, 0xb4, 0xbd, 0x3a,
	0xae, 0x4b, 0x8b, 0x13, 0x20, 0x03, 0xaa, 0x31, 0xe1, 0xef, 0x68, 0x7a, 0x69, 0x94, 0x84, 0x4f,
	0x41, 0xb4, 0x05, 0xb5, 0xd0, 0x4f, 0xdc, 0x5f, 0x69, 0x4c, 0x8c, 0x72, 0xe1, 0x0a, 0xfd, 0xe4,
	0x2d, 0x8d, 0x49, 0xce, 0xe9, 0x17, 0xf4, 0x39, 0xe7, 0x52, 0xc1, 0x29, 0x2d, 0x4e, 0x80, 0x5e,
	0xc0, 0x4a, 0x10, 0xb1, 0x64, 0xea, 0x5d, 0xbb, 0xb1, 0x37, 0x23, 0xc6, 0xb2, 0x08, 0x68, 0x48,
	0x5b, 0xdf, 0x9b, 0x91, 0xdd, 0x7f, 0x1a, 0xb0, 0x31, 0x16, 0x5d, 0x11, 0x75, 0x76, 0x69, 0x7c,
	0x11, 0x85, 0x08, 0xc1, 0x92, 0x48, 0x28, 0xaa, 0x14, 0xeb, 0x7b, 0x64, 0xa5, 0x7b, 0x64, 0xa8,
	0x0f, 0xe8, 0x7e, 0xcb, 0x44, 0xcd, 0x8d, 0x83, 0x6d, 0x53, 0xb6, 0xdb, 0x4b, 0x22, 0xf3, 0x44,
	0x45, 0x61, 0x19, 0xd4, 0x7b, 0x86, 0x37, 0x66, 0x77, 0x8d, 0xe8, 0x47, 0x58, 0x53, 0x2c, 0x6e,
	0x98, 0xd2, 0x2c, 0x11, 0x9f, 0xd8, 0x38, 0xf8, 0xdc, 0x7c, 0xe8, 0xe8, 0xcc, 0x7b, 0xdf, 0x61,
	0x2a, 0xa6, 0xa3, 0x3c, 0xb9, 0xf7, 0x0c, 0xaf, 0xa6, 0xb7, 0x0d, 0x08, 0x03, 0x4c, 0x38, 0x4f,
	0x5c, 0xd1, 0x31, 0xd1, 0x9d, 0xc6, 0xc1, 0xcb, 0xc7, 0x72, 0xf7, 0x38, 0x4f, 0x04, 0xee, 0x69,
	0xb8, 0x3e, 0x51, 0x00, 0x0d, 0xa0, 0xce, 0x7d, 0x45, 0x59, 0x11, 0x94, 0x9f, 0x3d, 0x96, 0xf2,
	0xd4, 0x9f, 0x33, 0xd6, 0xb8, 0x5c, 0xa3, 0x97, 0x50, 0x49, 0x48, 0x1a, 0xd1, 0xc0, 0xa8, 0x0a,
	0xb6, 0x2d, 0xc5, 0xa6, 0x86, 0xcf, 0x3c, 0x94, 0xc3, 0x87, 0x65, 0x20, 0x6a, 0x43, 0x35, 0xa7,
	0xa6, 0x19, 0x37, 0x6a, 0xef, 0xcb, 0x51, 0x91, 0xc8, 0x03, 0xdd, 0xa7, 0x31, 0x27, 0x31, 0x77,
	0x67, 0x1e, 0xf7, 0x27, 0x24, 0x65, 0x46, 0x7d, 0xa7, 0xbc, 0xd7, 0x38, 0xf8, 0xe2, 0xb1, 0xf5,
	0x77, 0x8b, 0xfc, 0x93, 0x22, 0x1d, 0xaf, 0xfb, 0x0b, 0x98, 0x21, 0x0c, 0x3a, 0x23, 0x53, 0xe2,
	0x73, 0x31, 0x1e, 0x61, 0x44, 0x63, 0x66, 0xc0, 0x4e, 0x79, 0x6f, 0xed, 0xe0, 0xd3, 0xf7, 0x6e,
	0x81, 0x45, 0x3c, 0x5e, 0x57, 0x04, 0x05, 0x66, 0xe8, 0x23, 0x68, 0x44, 0xcc, 0x8d, 0xa4, 0xd8,
	0x8c, 0xf5, 0x1d, 0x6d, 0xaf, 0x86, 0x21, 0x62, 0x4a, 0x7e, 0x08, 0xc3, 0x86, 0xf2, 0xba, 0x52,
	0x1a, 0xcc, 0x58, 0x13, 0x1f, 0xf6, 0xc9, 0xc3, 0xbb, 0xde, 0x51, 0x2e, 0xd6, 0xa3, 0x45, 0x03,
	0x6b, 0xfe, 0x02, 0xab, 0x0b, 0xa3, 0x25, 0x34, 0x9a, 0x2f, 0x6e, 0xa4, 0x5d, 0x15, 0xd8, 0x09,
	0xd0, 0x31, 0xcc, 0xa7, 0xce, 0xe5, 0xd7, 0x49, 0x21, 0x9c, 0xff, 0xfc, 0x62, 0x41, 0xa7, 0xb8,
	0x4f, 0xaf, 0x13, 0x82, 0x57, 0xd2, 0x5b, 0xa8, 0xf9, 0x57, 0x19, 0xea, 0xf3, 0xc9, 0x43, 0x1f,
	0x42, 0x35, 0x63, 0xc4, 0x65, 0x6c, 0x2a, 0x76, 0xad, 0xe1, 0x4a, 0xc6, 0xc8, 0x88, 0x4d, 0x73,
	0x01, 0x27, 0x1e, 0x9f, 0x48, 0x91, 0x8a, 0xb5, 0xb0, 0xd1, 0x94, 0x0b, 0x3d, 0x2e, 0x63, 0xb1,
	0x46, 0xe7, 0x50, 0xf7, 0x32, 0x3e, 0x71, 0xa3, 0xf8, 0x82, 0x4a, 0x71, 0xd9, 0x4f, 0x16, 0x80,
	0xd9, 0xf1, 0x58, 0xe4, 0x5b, 0x19, 0x9f, 0x90, 0x98, 0x47, 0x7e, 0x31, 0x57, 0xb5, 0x9c, 0xd7,
	0x89, 0x2f, 0x68, 0x7e, 0x71, 0xcc, 0x3c, 0x76, 0xe9, 0x4e, 0x88, 0x17, 0xe4, 0xbd, 0x5f, 0x16,
	0x95, 0x36, 0x72, 0x5b, 0xaf, 0x30, 0xa1, 0xef, 0xa0, 0xaa, 0xbc, 0x15, 0x71, 0x32, 0xaf, 0x9f,
	0x5e, 0x84, 0xe4, 0xb2, 0x63, 0x9e, 0x5e, 0x63, 0x45, 0xd7, 0x3c, 0x81, 0xff, 0x3d, 0x50, 0x1d,
	0x6a, 0x42, 0x2d, 0x63, 0xf9, 0x99, 0xce, 0x2f, 0xb9, 0x39, 0xce, 0x7d, 0x89, 0xc7, 0xd8, 0x3b,
	0x9a, 0x06, 0xb2, 0x7f, 0x73, 0xdc, 0x7c, 0x05, 0x2b, 0xb7, 0xf7, 0x41, 0x3a, 0x94, 0x2f, 0xc9,
	0xb5, 0xa4, 0xc8, 0x97, 0x68, 0x13, 0x96, 0xaf, 0xbc, 0x69, 0xa6, 0xee, 0xc7, 0x02, 0xbc, 0x2a,
	0x7d, 0xa9, 0x35, 0x9f, 0x43, 0x4d, 0x09, 0x7c, 0x7e, 0x16, 0xda, 0xcd, 0x59, 0x34, 0xf7, 0x61,
	0x6d, 0x51, 0x40, 0xf9, 0x9b, 0x20, 0x25, 0xa4, 0x86, 0x4a, 0xc2, 0x0e, 0x40, 0x4d, 0x8d, 0x45,
	0x67, 0x13, 0x90, 0x98, 0x6b, 0x37, 0x25, 0x3f, 0x67, 0x84, 0x71, 0x31, 0x65, 0xbb, 0xbf, 0x69,
	0xb0, 0x7a, 0xab, 0x5d, 0x4e, 0x82, 0xbe, 0x86, 0x4a, 0x21, 0x3a, 0x41, 0xf6, 0x04, 0xcd, 0xc9,
	0xb4, 0xbc, 0x31, 0x53, 0x5a, 0x34, 0x50, 0x35, 0x46, 0xe1, 0xfc, 0x25, 0x8a, 0x12, 0xd7, 0x0b,
	0x82, 0x94, 0x30, 0x26, 0x9f, 0xa9, 0x7a, 0x94, 0x58, 0x85, 0x61, 0x9f, 0x2c, 0xbc, 0x32, 0x05,
	0x2f, 0xfa, 0x00, 0x10, 0xb6, 0x8f, 0x9c, 0x41, 0xdf, 0x1d, 0xf7, 0x47, 0x43, 0xbb, 0xeb, 0x7c,
	0xe3, 0xd8, 0x87, 0xfa, 0x33, 0x54, 0x85, 0xf2, 0x78, 0x64, 0xe9, 0x1a, 0x02, 0xa8, 0xd8, 0x63,
	0x3c, 0x18, 0xda, 0x7a, 0x09, 0x6d, 0xc0, 0xea, 0x68, 0x30, 0x3e, 0xed, 0xb9, 0xd6, 0x89, 0x8d,
	0x9d, 0xae, 0xa5, 0x97, 0x91, 0x0e, 0x2b, 0xd6, 0xc8, 0xb1, 0xdc, 0xa1, 0x95, 0xa7, 0x76, 0xf5,
	0xa5, 0xfd, 0x1f, 0x60, 0xe3, 0x9e, 0x80, 0xd0, 0x36, 0x6c, 0x61, 0x7b, 0x34, 0x18, 0xe3, 0xae,
	0xed, 0x9e, 0x7e, 0x3f, 0xb4, 0xef, 0xec, 0xb6, 0x02, 0x35, 0xa7, 0x3f, 0x3a, 0xb5, 0xfa, 0x5d,
	0x5b, 0xd7, 0xd0, 0x16, 0xfc, 0xdf, 0xfa, 0x76, 0xe4, 0xda, 0xc7, 0x1d, 0xf7, 0x78, 0x60, 0x1d,
	0xba, 0x1d, 0xeb, 0x38, 0xf7, 0x60, 0xbd, 0xd4, 0xf9, 0x5d, 0x03, 0xc3, 0xa7, 0xb3, 0x07, 0xbb,
	0xd6, 0x69, 0x14, 0x9f, 0x37, 0xcc, 0xef, 0xd7, 0xa1, 0xf6, 0xf6, 0xb5, 0x0c, 0x0a, 0xe9, 0xd4,
	0x8b, 0x43, 0x93, 0xa6, 0x61, 0x2b, 0x24, 0xb1, 0xb8, 0x7d, 0x5b, 0x85, 0xcb, 0x4b, 0x22, 0xb6,
	0xf8, 0x77, 0xf2, 0xd5, 0x0d, 0xfa, 0xb3, 0xd4, 0x3c, 0x2a, 0x08, 0xba, 0x53, 0x9a, 0x05, 0xea,
	0xbd, 0xcc, 0xf7, 0x7a, 0xd3, 0xfe, 0x5b, 0x39, 0xcf, 0x84, 0xf3, 0xec, 0xc6, 0x79, 0xf6, 0xa6,
	0x7d, 0x5e, 0x11, 0x9b, 0xb4, 0xff, 0x0d, 0x00, 0x00, 0xff, 0xff, 0x01, 0x68, 0xd9, 0xde, 0x01,
	0x09, 0x00, 0x00,
}
