package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGroupDynamicRule invokes the cms.DeleteGroupDynamicRule API synchronously
// api document: https://help.aliyun.com/api/cms/deletegroupdynamicrule.html
func (client *Client) DeleteGroupDynamicRule(request *DeleteGroupDynamicRuleRequest) (response *DeleteGroupDynamicRuleResponse, err error) {
	response = CreateDeleteGroupDynamicRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGroupDynamicRuleWithChan invokes the cms.DeleteGroupDynamicRule API asynchronously
// api document: https://help.aliyun.com/api/cms/deletegroupdynamicrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteGroupDynamicRuleWithChan(request *DeleteGroupDynamicRuleRequest) (<-chan *DeleteGroupDynamicRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteGroupDynamicRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGroupDynamicRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGroupDynamicRuleWithCallback invokes the cms.DeleteGroupDynamicRule API asynchronously
// api document: https://help.aliyun.com/api/cms/deletegroupdynamicrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteGroupDynamicRuleWithCallback(request *DeleteGroupDynamicRuleRequest, callback func(response *DeleteGroupDynamicRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGroupDynamicRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteGroupDynamicRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGroupDynamicRuleRequest is the request struct for api DeleteGroupDynamicRule
type DeleteGroupDynamicRuleRequest struct {
	*requests.RpcRequest
	GroupId  requests.Integer `position:"Query" name:"GroupId"`
	Category string           `position:"Query" name:"Category"`
}

// DeleteGroupDynamicRuleResponse is the response struct for api DeleteGroupDynamicRule
type DeleteGroupDynamicRuleResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorCode    int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDeleteGroupDynamicRuleRequest creates a request to invoke DeleteGroupDynamicRule API
func CreateDeleteGroupDynamicRuleRequest() (request *DeleteGroupDynamicRuleRequest) {
	request = &DeleteGroupDynamicRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "DeleteGroupDynamicRule", "cms", "openAPI")
	return
}

// CreateDeleteGroupDynamicRuleResponse creates a response to parse from DeleteGroupDynamicRule response
func CreateDeleteGroupDynamicRuleResponse() (response *DeleteGroupDynamicRuleResponse) {
	response = &DeleteGroupDynamicRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
