package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAgilityTunnelAgentInfo invokes the cs.DescribeAgilityTunnelAgentInfo API synchronously
// api document: https://help.aliyun.com/api/cs/describeagilitytunnelagentinfo.html
func (client *Client) DescribeAgilityTunnelAgentInfo(request *DescribeAgilityTunnelAgentInfoRequest) (response *DescribeAgilityTunnelAgentInfoResponse, err error) {
	response = CreateDescribeAgilityTunnelAgentInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAgilityTunnelAgentInfoWithChan invokes the cs.DescribeAgilityTunnelAgentInfo API asynchronously
// api document: https://help.aliyun.com/api/cs/describeagilitytunnelagentinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAgilityTunnelAgentInfoWithChan(request *DescribeAgilityTunnelAgentInfoRequest) (<-chan *DescribeAgilityTunnelAgentInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeAgilityTunnelAgentInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAgilityTunnelAgentInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAgilityTunnelAgentInfoWithCallback invokes the cs.DescribeAgilityTunnelAgentInfo API asynchronously
// api document: https://help.aliyun.com/api/cs/describeagilitytunnelagentinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAgilityTunnelAgentInfoWithCallback(request *DescribeAgilityTunnelAgentInfoRequest, callback func(response *DescribeAgilityTunnelAgentInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAgilityTunnelAgentInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeAgilityTunnelAgentInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAgilityTunnelAgentInfoRequest is the request struct for api DescribeAgilityTunnelAgentInfo
type DescribeAgilityTunnelAgentInfoRequest struct {
	*requests.RoaRequest
	Token string `position:"Path" name:"Token"`
}

// DescribeAgilityTunnelAgentInfoResponse is the response struct for api DescribeAgilityTunnelAgentInfo
type DescribeAgilityTunnelAgentInfoResponse struct {
	*responses.BaseResponse
}

// CreateDescribeAgilityTunnelAgentInfoRequest creates a request to invoke DescribeAgilityTunnelAgentInfo API
func CreateDescribeAgilityTunnelAgentInfoRequest() (request *DescribeAgilityTunnelAgentInfoRequest) {
	request = &DescribeAgilityTunnelAgentInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeAgilityTunnelAgentInfo", "/agility/[Token]/agent_info", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeAgilityTunnelAgentInfoResponse creates a response to parse from DescribeAgilityTunnelAgentInfo response
func CreateDescribeAgilityTunnelAgentInfoResponse() (response *DescribeAgilityTunnelAgentInfoResponse) {
	response = &DescribeAgilityTunnelAgentInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
