package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMonitorInfo invokes the edas.QueryMonitorInfo API synchronously
// api document: https://help.aliyun.com/api/edas/querymonitorinfo.html
func (client *Client) QueryMonitorInfo(request *QueryMonitorInfoRequest) (response *QueryMonitorInfoResponse, err error) {
	response = CreateQueryMonitorInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMonitorInfoWithChan invokes the edas.QueryMonitorInfo API asynchronously
// api document: https://help.aliyun.com/api/edas/querymonitorinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMonitorInfoWithChan(request *QueryMonitorInfoRequest) (<-chan *QueryMonitorInfoResponse, <-chan error) {
	responseChan := make(chan *QueryMonitorInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMonitorInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMonitorInfoWithCallback invokes the edas.QueryMonitorInfo API asynchronously
// api document: https://help.aliyun.com/api/edas/querymonitorinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMonitorInfoWithCallback(request *QueryMonitorInfoRequest, callback func(response *QueryMonitorInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMonitorInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryMonitorInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMonitorInfoRequest is the request struct for api QueryMonitorInfo
type QueryMonitorInfoRequest struct {
	*requests.RoaRequest
	Metric     string           `position:"Query" name:"Metric"`
	Aggregator string           `position:"Query" name:"Aggregator"`
	Start      requests.Integer `position:"Query" name:"Start"`
	End        requests.Integer `position:"Query" name:"End"`
	Interval   string           `position:"Query" name:"Interval"`
	Tags       string           `position:"Query" name:"Tags"`
}

// QueryMonitorInfoResponse is the response struct for api QueryMonitorInfo
type QueryMonitorInfoResponse struct {
	*responses.BaseResponse
	Code        int    `json:"Code" xml:"Code"`
	Message     string `json:"Message" xml:"Message"`
	MonitorInfo string `json:"MonitorInfo" xml:"MonitorInfo"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateQueryMonitorInfoRequest creates a request to invoke QueryMonitorInfo API
func CreateQueryMonitorInfoRequest() (request *QueryMonitorInfoRequest) {
	request = &QueryMonitorInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "QueryMonitorInfo", "/pop/v5/monitor/queryMonitorInfo", "edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateQueryMonitorInfoResponse creates a response to parse from QueryMonitorInfo response
func CreateQueryMonitorInfoResponse() (response *QueryMonitorInfoResponse) {
	response = &QueryMonitorInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
