package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RetrievalDomainName invokes the alidns.RetrievalDomainName API synchronously
// api document: https://help.aliyun.com/api/alidns/retrievaldomainname.html
func (client *Client) RetrievalDomainName(request *RetrievalDomainNameRequest) (response *RetrievalDomainNameResponse, err error) {
	response = CreateRetrievalDomainNameResponse()
	err = client.DoAction(request, response)
	return
}

// RetrievalDomainNameWithChan invokes the alidns.RetrievalDomainName API asynchronously
// api document: https://help.aliyun.com/api/alidns/retrievaldomainname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RetrievalDomainNameWithChan(request *RetrievalDomainNameRequest) (<-chan *RetrievalDomainNameResponse, <-chan error) {
	responseChan := make(chan *RetrievalDomainNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RetrievalDomainName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RetrievalDomainNameWithCallback invokes the alidns.RetrievalDomainName API asynchronously
// api document: https://help.aliyun.com/api/alidns/retrievaldomainname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RetrievalDomainNameWithCallback(request *RetrievalDomainNameRequest, callback func(response *RetrievalDomainNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RetrievalDomainNameResponse
		var err error
		defer close(result)
		response, err = client.RetrievalDomainName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RetrievalDomainNameRequest is the request struct for api RetrievalDomainName
type RetrievalDomainNameRequest struct {
	*requests.RpcRequest
	Lang         string `position:"Query" name:"Lang"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	DomainName   string `position:"Query" name:"DomainName"`
}

// RetrievalDomainNameResponse is the response struct for api RetrievalDomainName
type RetrievalDomainNameResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DomainName string `json:"DomainName" xml:"DomainName"`
	WhoisEmail string `json:"WhoisEmail" xml:"WhoisEmail"`
}

// CreateRetrievalDomainNameRequest creates a request to invoke RetrievalDomainName API
func CreateRetrievalDomainNameRequest() (request *RetrievalDomainNameRequest) {
	request = &RetrievalDomainNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "RetrievalDomainName", "", "")
	return
}

// CreateRetrievalDomainNameResponse creates a response to parse from RetrievalDomainName response
func CreateRetrievalDomainNameResponse() (response *RetrievalDomainNameResponse) {
	response = &RetrievalDomainNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
