package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadSdk invokes the baas.DownloadSdk API synchronously
// api document: https://help.aliyun.com/api/baas/downloadsdk.html
func (client *Client) DownloadSdk(request *DownloadSdkRequest) (response *DownloadSdkResponse, err error) {
	response = CreateDownloadSdkResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadSdkWithChan invokes the baas.DownloadSdk API asynchronously
// api document: https://help.aliyun.com/api/baas/downloadsdk.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadSdkWithChan(request *DownloadSdkRequest) (<-chan *DownloadSdkResponse, <-chan error) {
	responseChan := make(chan *DownloadSdkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadSdk(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadSdkWithCallback invokes the baas.DownloadSdk API asynchronously
// api document: https://help.aliyun.com/api/baas/downloadsdk.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadSdkWithCallback(request *DownloadSdkRequest, callback func(response *DownloadSdkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadSdkResponse
		var err error
		defer close(result)
		response, err = client.DownloadSdk(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadSdkRequest is the request struct for api DownloadSdk
type DownloadSdkRequest struct {
	*requests.RpcRequest
	Bizid string `position:"Body" name:"Bizid"`
}

// DownloadSdkResponse is the response struct for api DownloadSdk
type DownloadSdkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateDownloadSdkRequest creates a request to invoke DownloadSdk API
func CreateDownloadSdkRequest() (request *DownloadSdkRequest) {
	request = &DownloadSdkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DownloadSdk", "", "")
	return
}

// CreateDownloadSdkResponse creates a response to parse from DownloadSdk response
func CreateDownloadSdkResponse() (response *DownloadSdkResponse) {
	response = &DownloadSdkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
