package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyForLoan invokes the finmall.ApplyForLoan API synchronously
// api document: https://help.aliyun.com/api/finmall/applyforloan.html
func (client *Client) ApplyForLoan(request *ApplyForLoanRequest) (response *ApplyForLoanResponse, err error) {
	response = CreateApplyForLoanResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyForLoanWithChan invokes the finmall.ApplyForLoan API asynchronously
// api document: https://help.aliyun.com/api/finmall/applyforloan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApplyForLoanWithChan(request *ApplyForLoanRequest) (<-chan *ApplyForLoanResponse, <-chan error) {
	responseChan := make(chan *ApplyForLoanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyForLoan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyForLoanWithCallback invokes the finmall.ApplyForLoan API asynchronously
// api document: https://help.aliyun.com/api/finmall/applyforloan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApplyForLoanWithCallback(request *ApplyForLoanRequest, callback func(response *ApplyForLoanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyForLoanResponse
		var err error
		defer close(result)
		response, err = client.ApplyForLoan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyForLoanRequest is the request struct for api ApplyForLoan
type ApplyForLoanRequest struct {
	*requests.RpcRequest
	BizType     string `position:"Query" name:"BizType"`
	CreditId    string `position:"Query" name:"CreditId"`
	ProductId   string `position:"Query" name:"ProductId"`
	FundpartyId string `position:"Query" name:"FundpartyId"`
	BizData     string `position:"Query" name:"BizData"`
	UserId      string `position:"Query" name:"UserId"`
}

// ApplyForLoanResponse is the response struct for api ApplyForLoan
type ApplyForLoanResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateApplyForLoanRequest creates a request to invoke ApplyForLoan API
func CreateApplyForLoanRequest() (request *ApplyForLoanRequest) {
	request = &ApplyForLoanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "ApplyForLoan", "finmall", "openAPI")
	return
}

// CreateApplyForLoanResponse creates a response to parse from ApplyForLoan response
func CreateApplyForLoanResponse() (response *ApplyForLoanResponse) {
	response = &ApplyForLoanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
