package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRoom invokes the live.CreateRoom API synchronously
// api document: https://help.aliyun.com/api/live/createroom.html
func (client *Client) CreateRoom(request *CreateRoomRequest) (response *CreateRoomResponse, err error) {
	response = CreateCreateRoomResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRoomWithChan invokes the live.CreateRoom API asynchronously
// api document: https://help.aliyun.com/api/live/createroom.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateRoomWithChan(request *CreateRoomRequest) (<-chan *CreateRoomResponse, <-chan error) {
	responseChan := make(chan *CreateRoomResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRoom(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRoomWithCallback invokes the live.CreateRoom API asynchronously
// api document: https://help.aliyun.com/api/live/createroom.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateRoomWithCallback(request *CreateRoomRequest, callback func(response *CreateRoomResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRoomResponse
		var err error
		defer close(result)
		response, err = client.CreateRoom(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRoomRequest is the request struct for api CreateRoom
type CreateRoomRequest struct {
	*requests.RpcRequest
	AnchorId string           `position:"Query" name:"AnchorId"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	RoomId   string           `position:"Query" name:"RoomId"`
	AppId    string           `position:"Query" name:"AppId"`
}

// CreateRoomResponse is the response struct for api CreateRoom
type CreateRoomResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	AppId     string `json:"AppId" xml:"AppId"`
	RoomId    string `json:"RoomId" xml:"RoomId"`
	AnchorId  string `json:"AnchorId" xml:"AnchorId"`
}

// CreateCreateRoomRequest creates a request to invoke CreateRoom API
func CreateCreateRoomRequest() (request *CreateRoomRequest) {
	request = &CreateRoomRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "CreateRoom", "live", "openAPI")
	return
}

// CreateCreateRoomResponse creates a response to parse from CreateRoom response
func CreateCreateRoomResponse() (response *CreateRoomResponse) {
	response = &CreateRoomResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
