// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2beta1/session.proto

package dialogflow

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_struct "github.com/golang/protobuf/ptypes/struct"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	math "math"
)

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Audio encoding of the audio content sent in the conversational query request.
// Refer to the
// [Cloud Speech API
// documentation](https://cloud.google.com/speech-to-text/docs/basics) for more
// details.
type AudioEncoding int32

const (
	// Not specified.
	AudioEncoding_AUDIO_ENCODING_UNSPECIFIED AudioEncoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	AudioEncoding_AUDIO_ENCODING_LINEAR_16 AudioEncoding = 1
	// [`FLAC`](https://xiph.org/flac/documentation.html) (Free Lossless Audio
	// Codec) is the recommended encoding because it is lossless (therefore
	// recognition is not compromised) and requires only about half the
	// bandwidth of `LINEAR16`. `FLAC` stream encoding supports 16-bit and
	// 24-bit samples, however, not all fields in `STREAMINFO` are supported.
	AudioEncoding_AUDIO_ENCODING_FLAC AudioEncoding = 2
	// 8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
	AudioEncoding_AUDIO_ENCODING_MULAW AudioEncoding = 3
	// Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
	AudioEncoding_AUDIO_ENCODING_AMR AudioEncoding = 4
	// Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
	AudioEncoding_AUDIO_ENCODING_AMR_WB AudioEncoding = 5
	// Opus encoded audio frames in Ogg container
	// ([OggOpus](https://wiki.xiph.org/OggOpus)).
	// `sample_rate_hertz` must be 16000.
	AudioEncoding_AUDIO_ENCODING_OGG_OPUS AudioEncoding = 6
	// Although the use of lossy encodings is not recommended, if a very low
	// bitrate encoding is required, `OGG_OPUS` is highly preferred over
	// Speex encoding. The [Speex](https://speex.org/) encoding supported by
	// Dialogflow API has a header byte in each block, as in MIME type
	// `audio/x-speex-with-header-byte`.
	// It is a variant of the RTP Speex encoding defined in
	// [RFC 5574](https://tools.ietf.org/html/rfc5574).
	// The stream is a sequence of blocks, one block per RTP packet. Each block
	// starts with a byte containing the length of the block, in bytes, followed
	// by one or more frames of Speex data, padded to an integral number of
	// bytes (octets) as specified in RFC 5574. In other words, each RTP header
	// is replaced with a single byte containing the block length. Only Speex
	// wideband is supported. `sample_rate_hertz` must be 16000.
	AudioEncoding_AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE AudioEncoding = 7
)

var AudioEncoding_name = map[int32]string{
	0: "AUDIO_ENCODING_UNSPECIFIED",
	1: "AUDIO_ENCODING_LINEAR_16",
	2: "AUDIO_ENCODING_FLAC",
	3: "AUDIO_ENCODING_MULAW",
	4: "AUDIO_ENCODING_AMR",
	5: "AUDIO_ENCODING_AMR_WB",
	6: "AUDIO_ENCODING_OGG_OPUS",
	7: "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE",
}

var AudioEncoding_value = map[string]int32{
	"AUDIO_ENCODING_UNSPECIFIED":            0,
	"AUDIO_ENCODING_LINEAR_16":              1,
	"AUDIO_ENCODING_FLAC":                   2,
	"AUDIO_ENCODING_MULAW":                  3,
	"AUDIO_ENCODING_AMR":                    4,
	"AUDIO_ENCODING_AMR_WB":                 5,
	"AUDIO_ENCODING_OGG_OPUS":               6,
	"AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE": 7,
}

func (x AudioEncoding) String() string {
	return proto.EnumName(AudioEncoding_name, int32(x))
}

func (AudioEncoding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{0}
}

// Represents the system's confidence that this knowledge answer is a good
// match for this conversational query.
type KnowledgeAnswers_Answer_MatchConfidenceLevel int32

const (
	// Not specified.
	KnowledgeAnswers_Answer_MATCH_CONFIDENCE_LEVEL_UNSPECIFIED KnowledgeAnswers_Answer_MatchConfidenceLevel = 0
	// Indicates that the confidence is low.
	KnowledgeAnswers_Answer_LOW KnowledgeAnswers_Answer_MatchConfidenceLevel = 1
	// Indicates our confidence is medium.
	KnowledgeAnswers_Answer_MEDIUM KnowledgeAnswers_Answer_MatchConfidenceLevel = 2
	// Indicates our confidence is high.
	KnowledgeAnswers_Answer_HIGH KnowledgeAnswers_Answer_MatchConfidenceLevel = 3
)

var KnowledgeAnswers_Answer_MatchConfidenceLevel_name = map[int32]string{
	0: "MATCH_CONFIDENCE_LEVEL_UNSPECIFIED",
	1: "LOW",
	2: "MEDIUM",
	3: "HIGH",
}

var KnowledgeAnswers_Answer_MatchConfidenceLevel_value = map[string]int32{
	"MATCH_CONFIDENCE_LEVEL_UNSPECIFIED": 0,
	"LOW":                                1,
	"MEDIUM":                             2,
	"HIGH":                               3,
}

func (x KnowledgeAnswers_Answer_MatchConfidenceLevel) String() string {
	return proto.EnumName(KnowledgeAnswers_Answer_MatchConfidenceLevel_name, int32(x))
}

func (KnowledgeAnswers_Answer_MatchConfidenceLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{5, 0, 0}
}

// Type of the response message.
type StreamingRecognitionResult_MessageType int32

const (
	// Not specified. Should never be used.
	StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED StreamingRecognitionResult_MessageType = 0
	// Message contains a (possibly partial) transcript.
	StreamingRecognitionResult_TRANSCRIPT StreamingRecognitionResult_MessageType = 1
	// Event indicates that the server has detected the end of the user's speech
	// utterance and expects no additional speech. Therefore, the server will
	// not process additional audio (although it may subsequently return
	// additional results). The client should stop sending additional audio
	// data, half-close the gRPC connection, and wait for any additional results
	// until the server closes the gRPC connection. This message is only sent if
	// `single_utterance` was set to `true`, and is not used otherwise.
	StreamingRecognitionResult_END_OF_SINGLE_UTTERANCE StreamingRecognitionResult_MessageType = 2
)

var StreamingRecognitionResult_MessageType_name = map[int32]string{
	0: "MESSAGE_TYPE_UNSPECIFIED",
	1: "TRANSCRIPT",
	2: "END_OF_SINGLE_UTTERANCE",
}

var StreamingRecognitionResult_MessageType_value = map[string]int32{
	"MESSAGE_TYPE_UNSPECIFIED": 0,
	"TRANSCRIPT":               1,
	"END_OF_SINGLE_UTTERANCE":  2,
}

func (x StreamingRecognitionResult_MessageType) String() string {
	return proto.EnumName(StreamingRecognitionResult_MessageType_name, int32(x))
}

func (StreamingRecognitionResult_MessageType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{8, 0}
}

// The request to detect user's intent.
type DetectIntentRequest struct {
	// Required. The name of the session this query is sent to. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>`, or
	// `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
	// ID>/sessions/<Session ID>`. If `Environment ID` is not specified, we assume
	// default 'draft' environment. If `User ID` is not specified, we are using
	// "-". It’s up to the API caller to choose an appropriate `Session ID` and
	// `User Id`. They can be a random numbers or some type of user and session
	// identifiers (preferably hashed). The length of the `Session ID` and
	// `User ID` must not exceed 36 characters.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Optional. The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification. It can be set to:
	//
	// 1.  an audio config
	//     which instructs the speech recognizer how to process the speech audio,
	//
	// 2.  a conversational query in the form of text, or
	//
	// 3.  an event that specifies which intent to trigger.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Optional. Instructs the speech synthesizer how to generate the output
	// audio. If this field is not set and agent-level speech synthesizer is not
	// configured, no output audio is generated.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,4,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	// Optional. The natural language speech audio to be processed. This field
	// should be populated iff `query_input` is set to an input audio config.
	// A single request can contain up to 1 minute of speech audio data.
	InputAudio           []byte   `protobuf:"bytes,5,opt,name=input_audio,json=inputAudio,proto3" json:"input_audio,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DetectIntentRequest) Reset()         { *m = DetectIntentRequest{} }
func (m *DetectIntentRequest) String() string { return proto.CompactTextString(m) }
func (*DetectIntentRequest) ProtoMessage()    {}
func (*DetectIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{0}
}

func (m *DetectIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectIntentRequest.Unmarshal(m, b)
}
func (m *DetectIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectIntentRequest.Marshal(b, m, deterministic)
}
func (m *DetectIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectIntentRequest.Merge(m, src)
}
func (m *DetectIntentRequest) XXX_Size() int {
	return xxx_messageInfo_DetectIntentRequest.Size(m)
}
func (m *DetectIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DetectIntentRequest proto.InternalMessageInfo

func (m *DetectIntentRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *DetectIntentRequest) GetQueryParams() *QueryParameters {
	if m != nil {
		return m.QueryParams
	}
	return nil
}

func (m *DetectIntentRequest) GetQueryInput() *QueryInput {
	if m != nil {
		return m.QueryInput
	}
	return nil
}

func (m *DetectIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

func (m *DetectIntentRequest) GetInputAudio() []byte {
	if m != nil {
		return m.InputAudio
	}
	return nil
}

// The message returned from the DetectIntent method.
type DetectIntentResponse struct {
	// The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The selected results of the conversational query or event processing.
	// See `alternative_query_results` for additional potential results.
	QueryResult *QueryResult `protobuf:"bytes,2,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// If Knowledge Connectors are enabled, there could be more than one result
	// returned for a given query or event, and this field will contain all
	// results except for the top one, which is captured in query_result. The
	// alternative results are ordered by decreasing
	// `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
	// disabled, this field will be empty until multiple responses for regular
	// intents are supported, at which point those additional results will be
	// surfaced here.
	AlternativeQueryResults []*QueryResult `protobuf:"bytes,5,rep,name=alternative_query_results,json=alternativeQueryResults,proto3" json:"alternative_query_results,omitempty"`
	// Specifies the status of the webhook request. `webhook_status`
	// is never populated in webhook requests.
	WebhookStatus *status.Status `protobuf:"bytes,3,opt,name=webhook_status,json=webhookStatus,proto3" json:"webhook_status,omitempty"`
	// The audio data bytes encoded as specified in the request.
	OutputAudio []byte `protobuf:"bytes,4,opt,name=output_audio,json=outputAudio,proto3" json:"output_audio,omitempty"`
	// Instructs the speech synthesizer how to generate the output audio. This
	// field is populated from the agent-level speech synthesizer configuration,
	// if enabled.
	OutputAudioConfig    *OutputAudioConfig `protobuf:"bytes,6,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *DetectIntentResponse) Reset()         { *m = DetectIntentResponse{} }
func (m *DetectIntentResponse) String() string { return proto.CompactTextString(m) }
func (*DetectIntentResponse) ProtoMessage()    {}
func (*DetectIntentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{1}
}

func (m *DetectIntentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectIntentResponse.Unmarshal(m, b)
}
func (m *DetectIntentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectIntentResponse.Marshal(b, m, deterministic)
}
func (m *DetectIntentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectIntentResponse.Merge(m, src)
}
func (m *DetectIntentResponse) XXX_Size() int {
	return xxx_messageInfo_DetectIntentResponse.Size(m)
}
func (m *DetectIntentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectIntentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DetectIntentResponse proto.InternalMessageInfo

func (m *DetectIntentResponse) GetResponseId() string {
	if m != nil {
		return m.ResponseId
	}
	return ""
}

func (m *DetectIntentResponse) GetQueryResult() *QueryResult {
	if m != nil {
		return m.QueryResult
	}
	return nil
}

func (m *DetectIntentResponse) GetAlternativeQueryResults() []*QueryResult {
	if m != nil {
		return m.AlternativeQueryResults
	}
	return nil
}

func (m *DetectIntentResponse) GetWebhookStatus() *status.Status {
	if m != nil {
		return m.WebhookStatus
	}
	return nil
}

func (m *DetectIntentResponse) GetOutputAudio() []byte {
	if m != nil {
		return m.OutputAudio
	}
	return nil
}

func (m *DetectIntentResponse) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

// Represents the parameters of the conversational query.
type QueryParameters struct {
	// Optional. The time zone of this conversational query from the
	// [time zone database](https://www.iana.org/time-zones), e.g.,
	// America/New_York, Europe/Paris. If not provided, the time zone specified in
	// agent settings is used.
	TimeZone string `protobuf:"bytes,1,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Optional. The geo location of this conversational query.
	GeoLocation *latlng.LatLng `protobuf:"bytes,2,opt,name=geo_location,json=geoLocation,proto3" json:"geo_location,omitempty"`
	// Optional. The collection of contexts to be activated before this query is
	// executed.
	Contexts []*Context `protobuf:"bytes,3,rep,name=contexts,proto3" json:"contexts,omitempty"`
	// Optional. Specifies whether to delete all contexts in the current session
	// before the new ones are activated.
	ResetContexts bool `protobuf:"varint,4,opt,name=reset_contexts,json=resetContexts,proto3" json:"reset_contexts,omitempty"`
	// Optional. The collection of session entity types to replace or extend
	// developer entities with for this query only. The entity synonyms apply
	// to all languages.
	SessionEntityTypes []*SessionEntityType `protobuf:"bytes,5,rep,name=session_entity_types,json=sessionEntityTypes,proto3" json:"session_entity_types,omitempty"`
	// Optional. This field can be used to pass custom data into the webhook
	// associated with the agent. Arbitrary JSON objects are supported.
	Payload *_struct.Struct `protobuf:"bytes,6,opt,name=payload,proto3" json:"payload,omitempty"`
	// Optional. KnowledgeBases to get alternative results from. If not set, the
	// KnowledgeBases enabled in the agent (through UI) will be used.
	// Format:  `projects/<Project ID>/knowledgeBases/<Knowledge Base ID>`.
	//
	// Note: This field is `repeated` for forward compatibility, currently only
	// the first one is supported, we may return an error if multiple
	// KnowledgeBases are specified.
	KnowledgeBaseNames []string `protobuf:"bytes,12,rep,name=knowledge_base_names,json=knowledgeBaseNames,proto3" json:"knowledge_base_names,omitempty"`
	// Optional. Configures the type of sentiment analysis to perform. If not
	// provided, sentiment analysis is not performed.
	// Note: Sentiment Analysis is only currently available for Enterprise Edition
	// agents.
	SentimentAnalysisRequestConfig *SentimentAnalysisRequestConfig `protobuf:"bytes,10,opt,name=sentiment_analysis_request_config,json=sentimentAnalysisRequestConfig,proto3" json:"sentiment_analysis_request_config,omitempty"`
	XXX_NoUnkeyedLiteral           struct{}                        `json:"-"`
	XXX_unrecognized               []byte                          `json:"-"`
	XXX_sizecache                  int32                           `json:"-"`
}

func (m *QueryParameters) Reset()         { *m = QueryParameters{} }
func (m *QueryParameters) String() string { return proto.CompactTextString(m) }
func (*QueryParameters) ProtoMessage()    {}
func (*QueryParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{2}
}

func (m *QueryParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryParameters.Unmarshal(m, b)
}
func (m *QueryParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryParameters.Marshal(b, m, deterministic)
}
func (m *QueryParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryParameters.Merge(m, src)
}
func (m *QueryParameters) XXX_Size() int {
	return xxx_messageInfo_QueryParameters.Size(m)
}
func (m *QueryParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryParameters.DiscardUnknown(m)
}

var xxx_messageInfo_QueryParameters proto.InternalMessageInfo

func (m *QueryParameters) GetTimeZone() string {
	if m != nil {
		return m.TimeZone
	}
	return ""
}

func (m *QueryParameters) GetGeoLocation() *latlng.LatLng {
	if m != nil {
		return m.GeoLocation
	}
	return nil
}

func (m *QueryParameters) GetContexts() []*Context {
	if m != nil {
		return m.Contexts
	}
	return nil
}

func (m *QueryParameters) GetResetContexts() bool {
	if m != nil {
		return m.ResetContexts
	}
	return false
}

func (m *QueryParameters) GetSessionEntityTypes() []*SessionEntityType {
	if m != nil {
		return m.SessionEntityTypes
	}
	return nil
}

func (m *QueryParameters) GetPayload() *_struct.Struct {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *QueryParameters) GetKnowledgeBaseNames() []string {
	if m != nil {
		return m.KnowledgeBaseNames
	}
	return nil
}

func (m *QueryParameters) GetSentimentAnalysisRequestConfig() *SentimentAnalysisRequestConfig {
	if m != nil {
		return m.SentimentAnalysisRequestConfig
	}
	return nil
}

// Represents the query input. It can contain either:
//
// 1.  An audio config which
//     instructs the speech recognizer how to process the speech audio.
//
// 2.  A conversational query in the form of text,.
//
// 3.  An event that specifies which intent to trigger.
type QueryInput struct {
	// Required. The input specification.
	//
	// Types that are valid to be assigned to Input:
	//	*QueryInput_AudioConfig
	//	*QueryInput_Text
	//	*QueryInput_Event
	Input                isQueryInput_Input `protobuf_oneof:"input"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *QueryInput) Reset()         { *m = QueryInput{} }
func (m *QueryInput) String() string { return proto.CompactTextString(m) }
func (*QueryInput) ProtoMessage()    {}
func (*QueryInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{3}
}

func (m *QueryInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryInput.Unmarshal(m, b)
}
func (m *QueryInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryInput.Marshal(b, m, deterministic)
}
func (m *QueryInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryInput.Merge(m, src)
}
func (m *QueryInput) XXX_Size() int {
	return xxx_messageInfo_QueryInput.Size(m)
}
func (m *QueryInput) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryInput.DiscardUnknown(m)
}

var xxx_messageInfo_QueryInput proto.InternalMessageInfo

type isQueryInput_Input interface {
	isQueryInput_Input()
}

type QueryInput_AudioConfig struct {
	AudioConfig *InputAudioConfig `protobuf:"bytes,1,opt,name=audio_config,json=audioConfig,proto3,oneof"`
}

type QueryInput_Text struct {
	Text *TextInput `protobuf:"bytes,2,opt,name=text,proto3,oneof"`
}

type QueryInput_Event struct {
	Event *EventInput `protobuf:"bytes,3,opt,name=event,proto3,oneof"`
}

func (*QueryInput_AudioConfig) isQueryInput_Input() {}

func (*QueryInput_Text) isQueryInput_Input() {}

func (*QueryInput_Event) isQueryInput_Input() {}

func (m *QueryInput) GetInput() isQueryInput_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (m *QueryInput) GetAudioConfig() *InputAudioConfig {
	if x, ok := m.GetInput().(*QueryInput_AudioConfig); ok {
		return x.AudioConfig
	}
	return nil
}

func (m *QueryInput) GetText() *TextInput {
	if x, ok := m.GetInput().(*QueryInput_Text); ok {
		return x.Text
	}
	return nil
}

func (m *QueryInput) GetEvent() *EventInput {
	if x, ok := m.GetInput().(*QueryInput_Event); ok {
		return x.Event
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*QueryInput) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _QueryInput_OneofMarshaler, _QueryInput_OneofUnmarshaler, _QueryInput_OneofSizer, []interface{}{
		(*QueryInput_AudioConfig)(nil),
		(*QueryInput_Text)(nil),
		(*QueryInput_Event)(nil),
	}
}

func _QueryInput_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*QueryInput)
	// input
	switch x := m.Input.(type) {
	case *QueryInput_AudioConfig:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AudioConfig); err != nil {
			return err
		}
	case *QueryInput_Text:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Text); err != nil {
			return err
		}
	case *QueryInput_Event:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Event); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("QueryInput.Input has unexpected type %T", x)
	}
	return nil
}

func _QueryInput_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*QueryInput)
	switch tag {
	case 1: // input.audio_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InputAudioConfig)
		err := b.DecodeMessage(msg)
		m.Input = &QueryInput_AudioConfig{msg}
		return true, err
	case 2: // input.text
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TextInput)
		err := b.DecodeMessage(msg)
		m.Input = &QueryInput_Text{msg}
		return true, err
	case 3: // input.event
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EventInput)
		err := b.DecodeMessage(msg)
		m.Input = &QueryInput_Event{msg}
		return true, err
	default:
		return false, nil
	}
}

func _QueryInput_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*QueryInput)
	// input
	switch x := m.Input.(type) {
	case *QueryInput_AudioConfig:
		s := proto.Size(x.AudioConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *QueryInput_Text:
		s := proto.Size(x.Text)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *QueryInput_Event:
		s := proto.Size(x.Event)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Represents the result of conversational query or event processing.
type QueryResult struct {
	// The original conversational query text:
	// - If natural language text was provided as input, `query_text` contains
	//   a copy of the input.
	// - If natural language speech audio was provided as input, `query_text`
	//   contains the speech recognition result. If speech recognizer produced
	//   multiple alternatives, a particular one is picked.
	// - If an event was provided as input, `query_text` is not set.
	QueryText string `protobuf:"bytes,1,opt,name=query_text,json=queryText,proto3" json:"query_text,omitempty"`
	// The language that was triggered during intent detection.
	// See [Language Support](https://dialogflow.com/docs/reference/language)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,15,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The Speech recognition confidence between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. The default of 0.0 is a sentinel value indicating that confidence
	// was not set.
	//
	// This field is not guaranteed to be accurate or set. In particular this
	// field isn't set for StreamingDetectIntent since the streaming endpoint has
	// separate confidence estimates per portion of the audio in
	// StreamingRecognitionResult.
	SpeechRecognitionConfidence float32 `protobuf:"fixed32,2,opt,name=speech_recognition_confidence,json=speechRecognitionConfidence,proto3" json:"speech_recognition_confidence,omitempty"`
	// The action name from the matched intent.
	Action string `protobuf:"bytes,3,opt,name=action,proto3" json:"action,omitempty"`
	// The collection of extracted parameters.
	Parameters *_struct.Struct `protobuf:"bytes,4,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// This field is set to:
	// - `false` if the matched intent has required parameters and not all of
	//    the required parameter values have been collected.
	// - `true` if all required parameter values have been collected, or if the
	//    matched intent doesn't contain any required parameters.
	AllRequiredParamsPresent bool `protobuf:"varint,5,opt,name=all_required_params_present,json=allRequiredParamsPresent,proto3" json:"all_required_params_present,omitempty"`
	// The text to be pronounced to the user or shown on the screen.
	FulfillmentText string `protobuf:"bytes,6,opt,name=fulfillment_text,json=fulfillmentText,proto3" json:"fulfillment_text,omitempty"`
	// The collection of rich messages to present to the user.
	FulfillmentMessages []*Intent_Message `protobuf:"bytes,7,rep,name=fulfillment_messages,json=fulfillmentMessages,proto3" json:"fulfillment_messages,omitempty"`
	// If the query was fulfilled by a webhook call, this field is set to the
	// value of the `source` field returned in the webhook response.
	WebhookSource string `protobuf:"bytes,8,opt,name=webhook_source,json=webhookSource,proto3" json:"webhook_source,omitempty"`
	// If the query was fulfilled by a webhook call, this field is set to the
	// value of the `payload` field returned in the webhook response.
	WebhookPayload *_struct.Struct `protobuf:"bytes,9,opt,name=webhook_payload,json=webhookPayload,proto3" json:"webhook_payload,omitempty"`
	// The collection of output contexts. If applicable,
	// `output_contexts.parameters` contains entries with name
	// `<parameter name>.original` containing the original parameter values
	// before the query.
	OutputContexts []*Context `protobuf:"bytes,10,rep,name=output_contexts,json=outputContexts,proto3" json:"output_contexts,omitempty"`
	// The intent that matched the conversational query. Some, not
	// all fields are filled in this message, including but not limited to:
	// `name`, `display_name` and `webhook_state`.
	Intent *Intent `protobuf:"bytes,11,opt,name=intent,proto3" json:"intent,omitempty"`
	// The intent detection confidence. Values range from 0.0
	// (completely uncertain) to 1.0 (completely certain).
	// If there are `multiple knowledge_answers` messages, this value is set to
	// the greatest `knowledgeAnswers.match_confidence` value in the list.
	IntentDetectionConfidence float32 `protobuf:"fixed32,12,opt,name=intent_detection_confidence,json=intentDetectionConfidence,proto3" json:"intent_detection_confidence,omitempty"`
	// The free-form diagnostic info. For example, this field
	// could contain webhook call latency.
	DiagnosticInfo *_struct.Struct `protobuf:"bytes,14,opt,name=diagnostic_info,json=diagnosticInfo,proto3" json:"diagnostic_info,omitempty"`
	// The sentiment analysis result, which depends on the
	// `sentiment_analysis_request_config` specified in the request.
	SentimentAnalysisResult *SentimentAnalysisResult `protobuf:"bytes,17,opt,name=sentiment_analysis_result,json=sentimentAnalysisResult,proto3" json:"sentiment_analysis_result,omitempty"`
	// The result from Knowledge Connector (if any), ordered by decreasing
	// `KnowledgeAnswers.match_confidence`.
	KnowledgeAnswers     *KnowledgeAnswers `protobuf:"bytes,18,opt,name=knowledge_answers,json=knowledgeAnswers,proto3" json:"knowledge_answers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *QueryResult) Reset()         { *m = QueryResult{} }
func (m *QueryResult) String() string { return proto.CompactTextString(m) }
func (*QueryResult) ProtoMessage()    {}
func (*QueryResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{4}
}

func (m *QueryResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryResult.Unmarshal(m, b)
}
func (m *QueryResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryResult.Marshal(b, m, deterministic)
}
func (m *QueryResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResult.Merge(m, src)
}
func (m *QueryResult) XXX_Size() int {
	return xxx_messageInfo_QueryResult.Size(m)
}
func (m *QueryResult) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResult.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResult proto.InternalMessageInfo

func (m *QueryResult) GetQueryText() string {
	if m != nil {
		return m.QueryText
	}
	return ""
}

func (m *QueryResult) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *QueryResult) GetSpeechRecognitionConfidence() float32 {
	if m != nil {
		return m.SpeechRecognitionConfidence
	}
	return 0
}

func (m *QueryResult) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *QueryResult) GetParameters() *_struct.Struct {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *QueryResult) GetAllRequiredParamsPresent() bool {
	if m != nil {
		return m.AllRequiredParamsPresent
	}
	return false
}

func (m *QueryResult) GetFulfillmentText() string {
	if m != nil {
		return m.FulfillmentText
	}
	return ""
}

func (m *QueryResult) GetFulfillmentMessages() []*Intent_Message {
	if m != nil {
		return m.FulfillmentMessages
	}
	return nil
}

func (m *QueryResult) GetWebhookSource() string {
	if m != nil {
		return m.WebhookSource
	}
	return ""
}

func (m *QueryResult) GetWebhookPayload() *_struct.Struct {
	if m != nil {
		return m.WebhookPayload
	}
	return nil
}

func (m *QueryResult) GetOutputContexts() []*Context {
	if m != nil {
		return m.OutputContexts
	}
	return nil
}

func (m *QueryResult) GetIntent() *Intent {
	if m != nil {
		return m.Intent
	}
	return nil
}

func (m *QueryResult) GetIntentDetectionConfidence() float32 {
	if m != nil {
		return m.IntentDetectionConfidence
	}
	return 0
}

func (m *QueryResult) GetDiagnosticInfo() *_struct.Struct {
	if m != nil {
		return m.DiagnosticInfo
	}
	return nil
}

func (m *QueryResult) GetSentimentAnalysisResult() *SentimentAnalysisResult {
	if m != nil {
		return m.SentimentAnalysisResult
	}
	return nil
}

func (m *QueryResult) GetKnowledgeAnswers() *KnowledgeAnswers {
	if m != nil {
		return m.KnowledgeAnswers
	}
	return nil
}

// Represents the result of querying a Knowledge base.
type KnowledgeAnswers struct {
	// A list of answers from Knowledge Connector.
	Answers              []*KnowledgeAnswers_Answer `protobuf:"bytes,1,rep,name=answers,proto3" json:"answers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *KnowledgeAnswers) Reset()         { *m = KnowledgeAnswers{} }
func (m *KnowledgeAnswers) String() string { return proto.CompactTextString(m) }
func (*KnowledgeAnswers) ProtoMessage()    {}
func (*KnowledgeAnswers) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{5}
}

func (m *KnowledgeAnswers) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KnowledgeAnswers.Unmarshal(m, b)
}
func (m *KnowledgeAnswers) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KnowledgeAnswers.Marshal(b, m, deterministic)
}
func (m *KnowledgeAnswers) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KnowledgeAnswers.Merge(m, src)
}
func (m *KnowledgeAnswers) XXX_Size() int {
	return xxx_messageInfo_KnowledgeAnswers.Size(m)
}
func (m *KnowledgeAnswers) XXX_DiscardUnknown() {
	xxx_messageInfo_KnowledgeAnswers.DiscardUnknown(m)
}

var xxx_messageInfo_KnowledgeAnswers proto.InternalMessageInfo

func (m *KnowledgeAnswers) GetAnswers() []*KnowledgeAnswers_Answer {
	if m != nil {
		return m.Answers
	}
	return nil
}

// An answer from Knowledge Connector.
type KnowledgeAnswers_Answer struct {
	// Indicates which Knowledge Document this answer was extracted from.
	// Format: `projects/<Project ID>/knowledgeBases/<Knowledge Base
	// ID>/documents/<Document ID>`.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The corresponding FAQ question if the answer was extracted from a FAQ
	// Document, empty otherwise.
	FaqQuestion string `protobuf:"bytes,2,opt,name=faq_question,json=faqQuestion,proto3" json:"faq_question,omitempty"`
	// The piece of text from the `source` knowledge base document that answers
	// this conversational query.
	Answer string `protobuf:"bytes,3,opt,name=answer,proto3" json:"answer,omitempty"`
	// The system's confidence level that this knowledge answer is a good match
	// for this conversational query.
	// NOTE: The confidence level for a given `<query, answer>` pair may change
	// without notice, as it depends on models that are constantly being
	// improved. However, it will change less frequently than the confidence
	// score below, and should be preferred for referencing the quality of an
	// answer.
	MatchConfidenceLevel KnowledgeAnswers_Answer_MatchConfidenceLevel `protobuf:"varint,4,opt,name=match_confidence_level,json=matchConfidenceLevel,proto3,enum=google.cloud.dialogflow.v2beta1.KnowledgeAnswers_Answer_MatchConfidenceLevel" json:"match_confidence_level,omitempty"`
	// The system's confidence score that this Knowledge answer is a good match
	// for this converstational query, range from 0.0 (completely uncertain)
	// to 1.0 (completely certain).
	// Note: The confidence score is likely to vary somewhat (possibly even for
	// identical requests), as the underlying model is under constant
	// improvement, we may deprecate it in the future. We recommend using
	// `match_confidence_level` which should be generally more stable.
	MatchConfidence      float32  `protobuf:"fixed32,5,opt,name=match_confidence,json=matchConfidence,proto3" json:"match_confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KnowledgeAnswers_Answer) Reset()         { *m = KnowledgeAnswers_Answer{} }
func (m *KnowledgeAnswers_Answer) String() string { return proto.CompactTextString(m) }
func (*KnowledgeAnswers_Answer) ProtoMessage()    {}
func (*KnowledgeAnswers_Answer) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{5, 0}
}

func (m *KnowledgeAnswers_Answer) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KnowledgeAnswers_Answer.Unmarshal(m, b)
}
func (m *KnowledgeAnswers_Answer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KnowledgeAnswers_Answer.Marshal(b, m, deterministic)
}
func (m *KnowledgeAnswers_Answer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KnowledgeAnswers_Answer.Merge(m, src)
}
func (m *KnowledgeAnswers_Answer) XXX_Size() int {
	return xxx_messageInfo_KnowledgeAnswers_Answer.Size(m)
}
func (m *KnowledgeAnswers_Answer) XXX_DiscardUnknown() {
	xxx_messageInfo_KnowledgeAnswers_Answer.DiscardUnknown(m)
}

var xxx_messageInfo_KnowledgeAnswers_Answer proto.InternalMessageInfo

func (m *KnowledgeAnswers_Answer) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *KnowledgeAnswers_Answer) GetFaqQuestion() string {
	if m != nil {
		return m.FaqQuestion
	}
	return ""
}

func (m *KnowledgeAnswers_Answer) GetAnswer() string {
	if m != nil {
		return m.Answer
	}
	return ""
}

func (m *KnowledgeAnswers_Answer) GetMatchConfidenceLevel() KnowledgeAnswers_Answer_MatchConfidenceLevel {
	if m != nil {
		return m.MatchConfidenceLevel
	}
	return KnowledgeAnswers_Answer_MATCH_CONFIDENCE_LEVEL_UNSPECIFIED
}

func (m *KnowledgeAnswers_Answer) GetMatchConfidence() float32 {
	if m != nil {
		return m.MatchConfidence
	}
	return 0
}

// The top-level message sent by the client to the
// `StreamingDetectIntent` method.
//
// Multiple request messages should be sent in order:
//
// 1.  The first message must contain `session`, `query_input` plus optionally
//     `query_params` and/or `single_utterance`. If the client wants to receive
//     an audio response, it should also contain `output_audio_config`.
//     The message must not contain `input_audio`.
//
// 2.  If `query_input` was set to a streaming input audio config,
//     all subsequent messages must contain only `input_audio`.
//     Otherwise, finish the request stream.
type StreamingDetectIntentRequest struct {
	// Required. The name of the session the query is sent to.
	// Format of the session name:
	// `projects/<Project ID>/agent/sessions/<Session ID>`, or
	// `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
	// ID>/sessions/<Session ID>`. If `Environment ID` is not specified, we assume
	// default 'draft' environment. If `User ID` is not specified, we are using
	// "-". It’s up to the API caller to choose an appropriate `Session ID` and
	// `User Id`. They can be a random numbers or some type of user and session
	// identifiers (preferably hashed). The length of the `Session ID` and
	// `User ID` must not exceed 36 characters.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Optional. The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification. It can be set to:
	//
	// 1.  an audio config which instructs the speech recognizer how to process
	//     the speech audio,
	//
	// 2.  a conversational query in the form of text, or
	//
	// 3.  an event that specifies which intent to trigger.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Optional. If `false` (default), recognition does not cease until the
	// client closes the stream.
	// If `true`, the recognizer will detect a single spoken utterance in input
	// audio. Recognition ceases when it detects the audio's voice has
	// stopped or paused. In this case, once a detected intent is received, the
	// client should close the stream and start a new request with a new stream as
	// needed.
	// This setting is ignored when `query_input` is a piece of text or an event.
	SingleUtterance bool `protobuf:"varint,4,opt,name=single_utterance,json=singleUtterance,proto3" json:"single_utterance,omitempty"`
	// Optional. Instructs the speech synthesizer how to generate the output
	// audio. If this field is not set and agent-level speech synthesizer is not
	// configured, no output audio is generated.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,5,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	// Optional. The input audio content to be recognized. Must be sent if
	// `query_input` was set to a streaming input audio config. The complete audio
	// over all streaming messages must not exceed 1 minute.
	InputAudio           []byte   `protobuf:"bytes,6,opt,name=input_audio,json=inputAudio,proto3" json:"input_audio,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingDetectIntentRequest) Reset()         { *m = StreamingDetectIntentRequest{} }
func (m *StreamingDetectIntentRequest) String() string { return proto.CompactTextString(m) }
func (*StreamingDetectIntentRequest) ProtoMessage()    {}
func (*StreamingDetectIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{6}
}

func (m *StreamingDetectIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingDetectIntentRequest.Unmarshal(m, b)
}
func (m *StreamingDetectIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingDetectIntentRequest.Marshal(b, m, deterministic)
}
func (m *StreamingDetectIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingDetectIntentRequest.Merge(m, src)
}
func (m *StreamingDetectIntentRequest) XXX_Size() int {
	return xxx_messageInfo_StreamingDetectIntentRequest.Size(m)
}
func (m *StreamingDetectIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingDetectIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingDetectIntentRequest proto.InternalMessageInfo

func (m *StreamingDetectIntentRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *StreamingDetectIntentRequest) GetQueryParams() *QueryParameters {
	if m != nil {
		return m.QueryParams
	}
	return nil
}

func (m *StreamingDetectIntentRequest) GetQueryInput() *QueryInput {
	if m != nil {
		return m.QueryInput
	}
	return nil
}

func (m *StreamingDetectIntentRequest) GetSingleUtterance() bool {
	if m != nil {
		return m.SingleUtterance
	}
	return false
}

func (m *StreamingDetectIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

func (m *StreamingDetectIntentRequest) GetInputAudio() []byte {
	if m != nil {
		return m.InputAudio
	}
	return nil
}

// The top-level message returned from the
// `StreamingDetectIntent` method.
//
// Multiple response messages can be returned in order:
//
// 1.  If the input was set to streaming audio, the first one or more messages
//     contain `recognition_result`. Each `recognition_result` represents a more
//     complete transcript of what the user said. The last `recognition_result`
//     has `is_final` set to `true`.
//
// 2.  The next message contains `response_id`, `query_result`,
//     `alternative_query_results` and optionally `webhook_status` if a WebHook
//     was called.
//
// 3.  If `output_audio_config` was specified in the request or agent-level
//     speech synthesizer is configured, all subsequent messages contain
//     `output_audio` and `output_audio_config`.
type StreamingDetectIntentResponse struct {
	// The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The result of speech recognition.
	RecognitionResult *StreamingRecognitionResult `protobuf:"bytes,2,opt,name=recognition_result,json=recognitionResult,proto3" json:"recognition_result,omitempty"`
	// The selected results of the conversational query or event processing.
	// See `alternative_query_results` for additional potential results.
	QueryResult *QueryResult `protobuf:"bytes,3,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// If Knowledge Connectors are enabled, there could be more than one result
	// returned for a given query or event, and this field will contain all
	// results except for the top one, which is captured in query_result. The
	// alternative results are ordered by decreasing
	// `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
	// disabled, this field will be empty until multiple responses for regular
	// intents are supported, at which point those additional results will be
	// surfaced here.
	AlternativeQueryResults []*QueryResult `protobuf:"bytes,7,rep,name=alternative_query_results,json=alternativeQueryResults,proto3" json:"alternative_query_results,omitempty"`
	// Specifies the status of the webhook request.
	WebhookStatus *status.Status `protobuf:"bytes,4,opt,name=webhook_status,json=webhookStatus,proto3" json:"webhook_status,omitempty"`
	// The audio data bytes encoded as specified in the request.
	OutputAudio []byte `protobuf:"bytes,5,opt,name=output_audio,json=outputAudio,proto3" json:"output_audio,omitempty"`
	// Instructs the speech synthesizer how to generate the output audio. This
	// field is populated from the agent-level speech synthesizer configuration,
	// if enabled.
	OutputAudioConfig    *OutputAudioConfig `protobuf:"bytes,6,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamingDetectIntentResponse) Reset()         { *m = StreamingDetectIntentResponse{} }
func (m *StreamingDetectIntentResponse) String() string { return proto.CompactTextString(m) }
func (*StreamingDetectIntentResponse) ProtoMessage()    {}
func (*StreamingDetectIntentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{7}
}

func (m *StreamingDetectIntentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingDetectIntentResponse.Unmarshal(m, b)
}
func (m *StreamingDetectIntentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingDetectIntentResponse.Marshal(b, m, deterministic)
}
func (m *StreamingDetectIntentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingDetectIntentResponse.Merge(m, src)
}
func (m *StreamingDetectIntentResponse) XXX_Size() int {
	return xxx_messageInfo_StreamingDetectIntentResponse.Size(m)
}
func (m *StreamingDetectIntentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingDetectIntentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingDetectIntentResponse proto.InternalMessageInfo

func (m *StreamingDetectIntentResponse) GetResponseId() string {
	if m != nil {
		return m.ResponseId
	}
	return ""
}

func (m *StreamingDetectIntentResponse) GetRecognitionResult() *StreamingRecognitionResult {
	if m != nil {
		return m.RecognitionResult
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetQueryResult() *QueryResult {
	if m != nil {
		return m.QueryResult
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetAlternativeQueryResults() []*QueryResult {
	if m != nil {
		return m.AlternativeQueryResults
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetWebhookStatus() *status.Status {
	if m != nil {
		return m.WebhookStatus
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetOutputAudio() []byte {
	if m != nil {
		return m.OutputAudio
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

// Contains a speech recognition result corresponding to a portion of the audio
// that is currently being processed or an indication that this is the end
// of the single requested utterance.
//
// Example:
//
// 1.  transcript: "tube"
//
// 2.  transcript: "to be a"
//
// 3.  transcript: "to be"
//
// 4.  transcript: "to be or not to be"
//     is_final: true
//
// 5.  transcript: " that's"
//
// 6.  transcript: " that is"
//
// 7.  recognition_event_type: `RECOGNITION_EVENT_END_OF_SINGLE_UTTERANCE`
//
// 8.  transcript: " that is the question"
//     is_final: true
//
// Only two of the responses contain final results (#4 and #8 indicated by
// `is_final: true`). Concatenating these generates the full transcript: "to be
// or not to be that is the question".
//
// In each response we populate:
//
// *  for `MESSAGE_TYPE_TRANSCRIPT`: `transcript` and possibly `is_final`.
//
// *  for `MESSAGE_TYPE_END_OF_SINGLE_UTTERANCE`: only `event_type`.
type StreamingRecognitionResult struct {
	// Type of the result message.
	MessageType StreamingRecognitionResult_MessageType `protobuf:"varint,1,opt,name=message_type,json=messageType,proto3,enum=google.cloud.dialogflow.v2beta1.StreamingRecognitionResult_MessageType" json:"message_type,omitempty"`
	// Transcript text representing the words that the user spoke.
	// Populated if and only if `event_type` = `RECOGNITION_EVENT_TRANSCRIPT`.
	Transcript string `protobuf:"bytes,2,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	// If `false`, the `StreamingRecognitionResult` represents an
	// interim result that may change. If `true`, the recognizer will not return
	// any further hypotheses about this piece of the audio. May only be populated
	// for `event_type` = `RECOGNITION_EVENT_TRANSCRIPT`.
	IsFinal bool `protobuf:"varint,3,opt,name=is_final,json=isFinal,proto3" json:"is_final,omitempty"`
	// The Speech confidence between 0.0 and 1.0 for the current portion of audio.
	// A higher number indicates an estimated greater likelihood that the
	// recognized words are correct. The default of 0.0 is a sentinel value
	// indicating that confidence was not set.
	//
	// This field is typically only provided if `is_final` is true and you should
	// not rely on it being accurate or even set.
	Confidence           float32  `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingRecognitionResult) Reset()         { *m = StreamingRecognitionResult{} }
func (m *StreamingRecognitionResult) String() string { return proto.CompactTextString(m) }
func (*StreamingRecognitionResult) ProtoMessage()    {}
func (*StreamingRecognitionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{8}
}

func (m *StreamingRecognitionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingRecognitionResult.Unmarshal(m, b)
}
func (m *StreamingRecognitionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingRecognitionResult.Marshal(b, m, deterministic)
}
func (m *StreamingRecognitionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingRecognitionResult.Merge(m, src)
}
func (m *StreamingRecognitionResult) XXX_Size() int {
	return xxx_messageInfo_StreamingRecognitionResult.Size(m)
}
func (m *StreamingRecognitionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingRecognitionResult.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingRecognitionResult proto.InternalMessageInfo

func (m *StreamingRecognitionResult) GetMessageType() StreamingRecognitionResult_MessageType {
	if m != nil {
		return m.MessageType
	}
	return StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED
}

func (m *StreamingRecognitionResult) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *StreamingRecognitionResult) GetIsFinal() bool {
	if m != nil {
		return m.IsFinal
	}
	return false
}

func (m *StreamingRecognitionResult) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Instructs the speech recognizer how to process the audio content.
type InputAudioConfig struct {
	// Required. Audio encoding of the audio content to process.
	AudioEncoding AudioEncoding `protobuf:"varint,1,opt,name=audio_encoding,json=audioEncoding,proto3,enum=google.cloud.dialogflow.v2beta1.AudioEncoding" json:"audio_encoding,omitempty"`
	// Required. Sample rate (in Hertz) of the audio content sent in the query.
	// Refer to
	// [Cloud Speech API
	// documentation](https://cloud.google.com/speech-to-text/docs/basics) for
	// more details.
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// Required. The language of the supplied audio. Dialogflow does not do
	// translations. See [Language
	// Support](https://dialogflow.com/docs/languages) for a list of the
	// currently supported language codes. Note that queries in the same session
	// do not necessarily need to specify the same language.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The collection of phrase hints which are used to boost accuracy
	// of speech recognition.
	// Refer to
	// [Cloud Speech API
	// documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
	// for more details.
	PhraseHints []string `protobuf:"bytes,4,rep,name=phrase_hints,json=phraseHints,proto3" json:"phrase_hints,omitempty"`
	// Optional. Which Speech model to select for the given request. Select the
	// model best suited to your domain to get best results. If a model is not
	// explicitly specified, then we auto-select a model based on the parameters
	// in the InputAudioConfig.
	// If enhanced speech model is enabled for the agent and an enhanced
	// version of the specified model for the language does not exist, then the
	// speech is recognized using the standard version of the specified model.
	// Refer to
	// [Cloud Speech API
	// documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
	// for more details.
	Model                string   `protobuf:"bytes,7,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InputAudioConfig) Reset()         { *m = InputAudioConfig{} }
func (m *InputAudioConfig) String() string { return proto.CompactTextString(m) }
func (*InputAudioConfig) ProtoMessage()    {}
func (*InputAudioConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{9}
}

func (m *InputAudioConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InputAudioConfig.Unmarshal(m, b)
}
func (m *InputAudioConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InputAudioConfig.Marshal(b, m, deterministic)
}
func (m *InputAudioConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputAudioConfig.Merge(m, src)
}
func (m *InputAudioConfig) XXX_Size() int {
	return xxx_messageInfo_InputAudioConfig.Size(m)
}
func (m *InputAudioConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InputAudioConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InputAudioConfig proto.InternalMessageInfo

func (m *InputAudioConfig) GetAudioEncoding() AudioEncoding {
	if m != nil {
		return m.AudioEncoding
	}
	return AudioEncoding_AUDIO_ENCODING_UNSPECIFIED
}

func (m *InputAudioConfig) GetSampleRateHertz() int32 {
	if m != nil {
		return m.SampleRateHertz
	}
	return 0
}

func (m *InputAudioConfig) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *InputAudioConfig) GetPhraseHints() []string {
	if m != nil {
		return m.PhraseHints
	}
	return nil
}

func (m *InputAudioConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Represents the natural language text to be processed.
type TextInput struct {
	// Required. The UTF-8 encoded natural language text to be processed.
	// Text length must not exceed 256 bytes.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Required. The language of this conversational query. See [Language
	// Support](https://dialogflow.com/docs/languages) for a list of the
	// currently supported language codes. Note that queries in the same session
	// do not necessarily need to specify the same language.
	LanguageCode         string   `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TextInput) Reset()         { *m = TextInput{} }
func (m *TextInput) String() string { return proto.CompactTextString(m) }
func (*TextInput) ProtoMessage()    {}
func (*TextInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{10}
}

func (m *TextInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextInput.Unmarshal(m, b)
}
func (m *TextInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextInput.Marshal(b, m, deterministic)
}
func (m *TextInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextInput.Merge(m, src)
}
func (m *TextInput) XXX_Size() int {
	return xxx_messageInfo_TextInput.Size(m)
}
func (m *TextInput) XXX_DiscardUnknown() {
	xxx_messageInfo_TextInput.DiscardUnknown(m)
}

var xxx_messageInfo_TextInput proto.InternalMessageInfo

func (m *TextInput) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *TextInput) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Events allow for matching intents by event name instead of the natural
// language input. For instance, input `<event: { name: “welcome_event”,
// parameters: { name: “Sam” } }>` can trigger a personalized welcome response.
// The parameter `name` may be used by the agent in the response:
// `“Hello #welcome_event.name! What can I do for you today?”`.
type EventInput struct {
	// Required. The unique identifier of the event.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The collection of parameters associated with the event.
	Parameters *_struct.Struct `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// Required. The language of this query. See [Language
	// Support](https://dialogflow.com/docs/languages) for a list of the
	// currently supported language codes. Note that queries in the same session
	// do not necessarily need to specify the same language.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventInput) Reset()         { *m = EventInput{} }
func (m *EventInput) String() string { return proto.CompactTextString(m) }
func (*EventInput) ProtoMessage()    {}
func (*EventInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{11}
}

func (m *EventInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventInput.Unmarshal(m, b)
}
func (m *EventInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventInput.Marshal(b, m, deterministic)
}
func (m *EventInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventInput.Merge(m, src)
}
func (m *EventInput) XXX_Size() int {
	return xxx_messageInfo_EventInput.Size(m)
}
func (m *EventInput) XXX_DiscardUnknown() {
	xxx_messageInfo_EventInput.DiscardUnknown(m)
}

var xxx_messageInfo_EventInput proto.InternalMessageInfo

func (m *EventInput) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EventInput) GetParameters() *_struct.Struct {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *EventInput) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Configures the types of sentiment analysis to perform.
type SentimentAnalysisRequestConfig struct {
	// Optional. Instructs the service to perform sentiment analysis on
	// `query_text`. If not provided, sentiment analysis is not performed on
	// `query_text`.
	AnalyzeQueryTextSentiment bool     `protobuf:"varint,1,opt,name=analyze_query_text_sentiment,json=analyzeQueryTextSentiment,proto3" json:"analyze_query_text_sentiment,omitempty"`
	XXX_NoUnkeyedLiteral      struct{} `json:"-"`
	XXX_unrecognized          []byte   `json:"-"`
	XXX_sizecache             int32    `json:"-"`
}

func (m *SentimentAnalysisRequestConfig) Reset()         { *m = SentimentAnalysisRequestConfig{} }
func (m *SentimentAnalysisRequestConfig) String() string { return proto.CompactTextString(m) }
func (*SentimentAnalysisRequestConfig) ProtoMessage()    {}
func (*SentimentAnalysisRequestConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{12}
}

func (m *SentimentAnalysisRequestConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SentimentAnalysisRequestConfig.Unmarshal(m, b)
}
func (m *SentimentAnalysisRequestConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SentimentAnalysisRequestConfig.Marshal(b, m, deterministic)
}
func (m *SentimentAnalysisRequestConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SentimentAnalysisRequestConfig.Merge(m, src)
}
func (m *SentimentAnalysisRequestConfig) XXX_Size() int {
	return xxx_messageInfo_SentimentAnalysisRequestConfig.Size(m)
}
func (m *SentimentAnalysisRequestConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SentimentAnalysisRequestConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SentimentAnalysisRequestConfig proto.InternalMessageInfo

func (m *SentimentAnalysisRequestConfig) GetAnalyzeQueryTextSentiment() bool {
	if m != nil {
		return m.AnalyzeQueryTextSentiment
	}
	return false
}

// The result of sentiment analysis as configured by
// `sentiment_analysis_request_config`.
type SentimentAnalysisResult struct {
	// The sentiment analysis result for `query_text`.
	QueryTextSentiment   *Sentiment `protobuf:"bytes,1,opt,name=query_text_sentiment,json=queryTextSentiment,proto3" json:"query_text_sentiment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *SentimentAnalysisResult) Reset()         { *m = SentimentAnalysisResult{} }
func (m *SentimentAnalysisResult) String() string { return proto.CompactTextString(m) }
func (*SentimentAnalysisResult) ProtoMessage()    {}
func (*SentimentAnalysisResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{13}
}

func (m *SentimentAnalysisResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SentimentAnalysisResult.Unmarshal(m, b)
}
func (m *SentimentAnalysisResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SentimentAnalysisResult.Marshal(b, m, deterministic)
}
func (m *SentimentAnalysisResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SentimentAnalysisResult.Merge(m, src)
}
func (m *SentimentAnalysisResult) XXX_Size() int {
	return xxx_messageInfo_SentimentAnalysisResult.Size(m)
}
func (m *SentimentAnalysisResult) XXX_DiscardUnknown() {
	xxx_messageInfo_SentimentAnalysisResult.DiscardUnknown(m)
}

var xxx_messageInfo_SentimentAnalysisResult proto.InternalMessageInfo

func (m *SentimentAnalysisResult) GetQueryTextSentiment() *Sentiment {
	if m != nil {
		return m.QueryTextSentiment
	}
	return nil
}

// The sentiment, such as positive/negative feeling or association, for a unit
// of analysis, such as the query text.
type Sentiment struct {
	// Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
	// sentiment).
	Score float32 `protobuf:"fixed32,1,opt,name=score,proto3" json:"score,omitempty"`
	// A non-negative number in the [0, +inf) range, which represents the absolute
	// magnitude of sentiment, regardless of score (positive or negative).
	Magnitude            float32  `protobuf:"fixed32,2,opt,name=magnitude,proto3" json:"magnitude,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Sentiment) Reset()         { *m = Sentiment{} }
func (m *Sentiment) String() string { return proto.CompactTextString(m) }
func (*Sentiment) ProtoMessage()    {}
func (*Sentiment) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{14}
}

func (m *Sentiment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Sentiment.Unmarshal(m, b)
}
func (m *Sentiment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Sentiment.Marshal(b, m, deterministic)
}
func (m *Sentiment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Sentiment.Merge(m, src)
}
func (m *Sentiment) XXX_Size() int {
	return xxx_messageInfo_Sentiment.Size(m)
}
func (m *Sentiment) XXX_DiscardUnknown() {
	xxx_messageInfo_Sentiment.DiscardUnknown(m)
}

var xxx_messageInfo_Sentiment proto.InternalMessageInfo

func (m *Sentiment) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *Sentiment) GetMagnitude() float32 {
	if m != nil {
		return m.Magnitude
	}
	return 0
}

func init() {
	proto.RegisterType((*DetectIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.DetectIntentRequest")
	proto.RegisterType((*DetectIntentResponse)(nil), "google.cloud.dialogflow.v2beta1.DetectIntentResponse")
	proto.RegisterType((*QueryParameters)(nil), "google.cloud.dialogflow.v2beta1.QueryParameters")
	proto.RegisterType((*QueryInput)(nil), "google.cloud.dialogflow.v2beta1.QueryInput")
	proto.RegisterType((*QueryResult)(nil), "google.cloud.dialogflow.v2beta1.QueryResult")
	proto.RegisterType((*KnowledgeAnswers)(nil), "google.cloud.dialogflow.v2beta1.KnowledgeAnswers")
	proto.RegisterType((*KnowledgeAnswers_Answer)(nil), "google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer")
	proto.RegisterType((*StreamingDetectIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest")
	proto.RegisterType((*StreamingDetectIntentResponse)(nil), "google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse")
	proto.RegisterType((*StreamingRecognitionResult)(nil), "google.cloud.dialogflow.v2beta1.StreamingRecognitionResult")
	proto.RegisterType((*InputAudioConfig)(nil), "google.cloud.dialogflow.v2beta1.InputAudioConfig")
	proto.RegisterType((*TextInput)(nil), "google.cloud.dialogflow.v2beta1.TextInput")
	proto.RegisterType((*EventInput)(nil), "google.cloud.dialogflow.v2beta1.EventInput")
	proto.RegisterType((*SentimentAnalysisRequestConfig)(nil), "google.cloud.dialogflow.v2beta1.SentimentAnalysisRequestConfig")
	proto.RegisterType((*SentimentAnalysisResult)(nil), "google.cloud.dialogflow.v2beta1.SentimentAnalysisResult")
	proto.RegisterType((*Sentiment)(nil), "google.cloud.dialogflow.v2beta1.Sentiment")
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.AudioEncoding", AudioEncoding_name, AudioEncoding_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.KnowledgeAnswers_Answer_MatchConfidenceLevel", KnowledgeAnswers_Answer_MatchConfidenceLevel_name, KnowledgeAnswers_Answer_MatchConfidenceLevel_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.StreamingRecognitionResult_MessageType", StreamingRecognitionResult_MessageType_name, StreamingRecognitionResult_MessageType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SessionsClient is the client API for Sessions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SessionsClient interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause contexts
	// and session entity types to be updated, which in turn might affect
	// results of future queries.
	DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error)
}

type sessionsClient struct {
	cc *grpc.ClientConn
}

func NewSessionsClient(cc *grpc.ClientConn) SessionsClient {
	return &sessionsClient{cc}
}

func (c *sessionsClient) DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error) {
	out := new(DetectIntentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Sessions/DetectIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionsClient) StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Sessions_serviceDesc.Streams[0], "/google.cloud.dialogflow.v2beta1.Sessions/StreamingDetectIntent", opts...)
	if err != nil {
		return nil, err
	}
	x := &sessionsStreamingDetectIntentClient{stream}
	return x, nil
}

type Sessions_StreamingDetectIntentClient interface {
	Send(*StreamingDetectIntentRequest) error
	Recv() (*StreamingDetectIntentResponse, error)
	grpc.ClientStream
}

type sessionsStreamingDetectIntentClient struct {
	grpc.ClientStream
}

func (x *sessionsStreamingDetectIntentClient) Send(m *StreamingDetectIntentRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentClient) Recv() (*StreamingDetectIntentResponse, error) {
	m := new(StreamingDetectIntentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SessionsServer is the server API for Sessions service.
type SessionsServer interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause contexts
	// and session entity types to be updated, which in turn might affect
	// results of future queries.
	DetectIntent(context.Context, *DetectIntentRequest) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	StreamingDetectIntent(Sessions_StreamingDetectIntentServer) error
}

func RegisterSessionsServer(s *grpc.Server, srv SessionsServer) {
	s.RegisterService(&_Sessions_serviceDesc, srv)
}

func _Sessions_DetectIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetectIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).DetectIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Sessions/DetectIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).DetectIntent(ctx, req.(*DetectIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sessions_StreamingDetectIntent_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SessionsServer).StreamingDetectIntent(&sessionsStreamingDetectIntentServer{stream})
}

type Sessions_StreamingDetectIntentServer interface {
	Send(*StreamingDetectIntentResponse) error
	Recv() (*StreamingDetectIntentRequest, error)
	grpc.ServerStream
}

type sessionsStreamingDetectIntentServer struct {
	grpc.ServerStream
}

func (x *sessionsStreamingDetectIntentServer) Send(m *StreamingDetectIntentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentServer) Recv() (*StreamingDetectIntentRequest, error) {
	m := new(StreamingDetectIntentRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Sessions_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.Sessions",
	HandlerType: (*SessionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DetectIntent",
			Handler:    _Sessions_DetectIntent_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingDetectIntent",
			Handler:       _Sessions_StreamingDetectIntent_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/dialogflow/v2beta1/session.proto",
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2beta1/session.proto", fileDescriptor_40a53f854d709740)
}

var fileDescriptor_40a53f854d709740 = []byte{
	// 2081 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x58, 0xcd, 0x73, 0x1b, 0x49,
	0x15, 0xcf, 0x48, 0xfe, 0x90, 0x9f, 0x14, 0x5b, 0xe9, 0x78, 0x63, 0xd9, 0x71, 0xbe, 0xb4, 0xb5,
	0xe0, 0x98, 0x45, 0x4a, 0x0c, 0x2c, 0xbb, 0x9b, 0xca, 0x26, 0xb2, 0x34, 0xb6, 0x55, 0xc8, 0xb2,
	0xd3, 0xb2, 0x93, 0xdd, 0x14, 0xd0, 0xd5, 0x1e, 0xb5, 0xe4, 0x49, 0x46, 0x33, 0xf2, 0x74, 0x2b,
	0x59, 0x87, 0x82, 0x03, 0x9c, 0x80, 0x23, 0x27, 0xaa, 0x28, 0x8a, 0xe2, 0xc6, 0x72, 0xe5, 0xca,
	0x3f, 0xc0, 0x15, 0xaa, 0xf8, 0x07, 0xb8, 0x71, 0x84, 0x03, 0x55, 0x5c, 0xa8, 0xfe, 0x18, 0x69,
	0x22, 0xdb, 0x91, 0x12, 0x48, 0x51, 0xb5, 0x27, 0xa9, 0x5f, 0xbf, 0xf7, 0xeb, 0xee, 0xf7, 0x5e,
	0xff, 0xfa, 0xbd, 0x81, 0xaf, 0xb7, 0x83, 0xa0, 0xed, 0xb1, 0xa2, 0xe3, 0x05, 0xbd, 0x66, 0xb1,
	0xe9, 0x52, 0x2f, 0x68, 0xb7, 0xbc, 0xe0, 0x79, 0xf1, 0xd9, 0xda, 0x01, 0x13, 0xf4, 0x76, 0x91,
	0x33, 0xce, 0xdd, 0xc0, 0x2f, 0x74, 0xc3, 0x40, 0x04, 0xe8, 0x9a, 0x56, 0x2f, 0x28, 0xf5, 0xc2,
	0x40, 0xbd, 0x60, 0xd4, 0x97, 0x96, 0x0d, 0x1e, 0xed, 0xba, 0x45, 0xea, 0xfb, 0x81, 0xa0, 0xc2,
	0x0d, 0x7c, 0xae, 0xcd, 0x97, 0xd6, 0x46, 0xad, 0x46, 0x7b, 0x4d, 0x37, 0x20, 0x4e, 0xe0, 0xb7,
	0xdc, 0xb6, 0xb1, 0x19, 0xb9, 0x43, 0x27, 0xf0, 0x05, 0xfb, 0x5c, 0x18, 0xf5, 0xf7, 0x47, 0xa9,
	0xbb, 0xbe, 0x60, 0x7e, 0xa4, 0xfd, 0xd1, 0x98, 0xc7, 0x27, 0xcc, 0x17, 0xae, 0x38, 0x26, 0xe2,
	0xb8, 0xcb, 0x8c, 0x69, 0x74, 0x52, 0x35, 0x3a, 0xe8, 0xb5, 0x8a, 0x5c, 0x84, 0x3d, 0x27, 0x02,
	0x5e, 0x30, 0xb3, 0x61, 0xd7, 0x29, 0x72, 0x41, 0x45, 0x2f, 0x72, 0x41, 0xce, 0x4c, 0x48, 0xa4,
	0xa2, 0x47, 0x85, 0xe7, 0x9b, 0x83, 0xe6, 0xff, 0x9a, 0x80, 0x8b, 0x15, 0x26, 0x98, 0x23, 0xaa,
	0x6a, 0x8b, 0x98, 0x1d, 0xf5, 0x18, 0x17, 0x28, 0x07, 0xd3, 0x66, 0x17, 0x39, 0xeb, 0xba, 0xb5,
	0x32, 0x83, 0xa3, 0x21, 0x6a, 0x40, 0xe6, 0xa8, 0xc7, 0xc2, 0x63, 0xd2, 0xa5, 0x21, 0xed, 0xf0,
	0x5c, 0xe2, 0xba, 0xb5, 0x92, 0x5e, 0xbb, 0x55, 0x18, 0x11, 0xa4, 0xc2, 0x03, 0x69, 0xb4, 0x2b,
	0x6d, 0x98, 0x60, 0x21, 0xc7, 0xe9, 0xa3, 0xbe, 0x80, 0xa3, 0x1a, 0xe8, 0x21, 0x71, 0xfd, 0x6e,
	0x4f, 0xe4, 0x92, 0x0a, 0xf3, 0x6b, 0xe3, 0x61, 0x56, 0xa5, 0x09, 0x86, 0xa3, 0xfe, 0x7f, 0x74,
	0x00, 0x17, 0x83, 0x9e, 0xe8, 0xf6, 0x04, 0x89, 0x87, 0x36, 0x37, 0xa1, 0x50, 0xd7, 0x46, 0xa2,
	0xee, 0x28, 0xdb, 0x92, 0x34, 0x2d, 0x2b, 0x4b, 0x7c, 0x21, 0x18, 0x16, 0xa1, 0x6b, 0x90, 0x56,
	0x7b, 0xd5, 0x4b, 0xe4, 0x26, 0xaf, 0x5b, 0x2b, 0x19, 0x0c, 0x4a, 0xa4, 0xd4, 0xf2, 0x7f, 0x48,
	0xc2, 0xfc, 0xcb, 0x9e, 0xe5, 0xdd, 0xc0, 0xe7, 0x4c, 0x5a, 0x86, 0xe6, 0x3f, 0x71, 0x9b, 0xc6,
	0xbd, 0x10, 0x89, 0xaa, 0x4d, 0xb4, 0x13, 0x79, 0x38, 0x64, 0xbc, 0xe7, 0x09, 0xe3, 0xe1, 0xf7,
	0xc7, 0xf3, 0x06, 0x56, 0x36, 0xc6, 0xbb, 0x7a, 0x80, 0x0e, 0x61, 0x91, 0x7a, 0x82, 0x85, 0x3e,
	0x15, 0xee, 0x33, 0x46, 0xe2, 0xe0, 0x3c, 0x37, 0x79, 0x3d, 0xf9, 0xda, 0xe8, 0x0b, 0x31, 0xb8,
	0x98, 0x9c, 0xa3, 0x8f, 0x60, 0xf6, 0x39, 0x3b, 0x38, 0x0c, 0x82, 0xa7, 0x44, 0x27, 0xa0, 0x09,
	0x25, 0x8a, 0xe0, 0xc3, 0xae, 0x53, 0x68, 0xa8, 0x19, 0x7c, 0xde, 0x68, 0xea, 0x21, 0xba, 0x01,
	0x99, 0x78, 0xd0, 0x54, 0xb4, 0x32, 0x38, 0x1d, 0xf3, 0xfc, 0x59, 0x71, 0x9d, 0xfa, 0x1f, 0xc6,
	0x35, 0xff, 0xfb, 0x09, 0x98, 0x1b, 0x4a, 0x55, 0x74, 0x19, 0x66, 0x84, 0xdb, 0x61, 0xe4, 0x45,
	0xe0, 0x33, 0x13, 0xaf, 0x94, 0x14, 0x3c, 0x0e, 0x7c, 0x86, 0x3e, 0x80, 0x4c, 0x9b, 0x05, 0xc4,
	0x0b, 0x1c, 0xc5, 0x3a, 0x26, 0x5a, 0x17, 0xa3, 0xdd, 0xa8, 0xcb, 0x5b, 0xa3, 0xa2, 0xe6, 0xb7,
	0x71, 0xba, 0xcd, 0x82, 0x9a, 0xd1, 0x43, 0x15, 0x48, 0x19, 0x12, 0x91, 0x4e, 0x92, 0x31, 0x58,
	0x19, 0x79, 0x82, 0xb2, 0x36, 0xc0, 0x7d, 0x4b, 0xf4, 0x1e, 0xcc, 0x86, 0x8c, 0x33, 0x41, 0xfa,
	0x58, 0xd2, 0x6f, 0x29, 0x7c, 0x5e, 0x49, 0xcb, 0x91, 0x5a, 0x13, 0xe6, 0x4f, 0x21, 0x95, 0x28,
	0xf8, 0xa3, 0x5d, 0xd7, 0xd0, 0xc6, 0xb6, 0xb2, 0xdd, 0x3b, 0xee, 0x32, 0x8c, 0xf8, 0xb0, 0x88,
	0xa3, 0xdb, 0x30, 0xdd, 0xa5, 0xc7, 0x5e, 0x40, 0x9b, 0x26, 0x26, 0x0b, 0x11, 0x70, 0xc4, 0x57,
	0x85, 0x86, 0xe2, 0x2b, 0x1c, 0xe9, 0xa1, 0x5b, 0x30, 0xff, 0xd4, 0x0f, 0x9e, 0x7b, 0xac, 0xd9,
	0x66, 0xe4, 0x80, 0x72, 0x46, 0x7c, 0xda, 0x61, 0x3c, 0x97, 0xb9, 0x9e, 0x5c, 0x99, 0xc1, 0xa8,
	0x3f, 0xb7, 0x4e, 0x39, 0xab, 0xcb, 0x19, 0xf4, 0x33, 0x0b, 0x6e, 0x70, 0x79, 0x88, 0x0e, 0xf3,
	0x05, 0xa1, 0x3e, 0xf5, 0x8e, 0xb9, 0xcb, 0x49, 0xa8, 0x89, 0x2b, 0xca, 0x09, 0x50, 0xeb, 0xdf,
	0x1b, 0xe3, 0x60, 0x06, 0xa9, 0x64, 0x80, 0x0c, 0x01, 0x9a, 0x04, 0xb9, 0xca, 0x5f, 0x39, 0x9f,
	0xff, 0xa7, 0x05, 0x30, 0x20, 0x21, 0xf4, 0x10, 0x32, 0x2f, 0x65, 0xa6, 0xa5, 0x76, 0x71, 0x7b,
	0xe4, 0x2e, 0xaa, 0xfe, 0xcb, 0x59, 0xb8, 0x75, 0x0e, 0xa7, 0x69, 0x8c, 0x6c, 0xee, 0xc3, 0x84,
	0x8c, 0xa3, 0xc9, 0xad, 0xd5, 0x91, 0x78, 0x7b, 0xec, 0x73, 0xa1, 0x30, 0xb7, 0xce, 0x61, 0x65,
	0x89, 0xca, 0x30, 0xc9, 0x9e, 0x31, 0x7f, 0x7c, 0x6a, 0xb5, 0xa5, 0x76, 0x84, 0xa1, 0x6d, 0xd7,
	0xa7, 0x61, 0x52, 0x11, 0x5c, 0xfe, 0xa7, 0x29, 0x48, 0xc7, 0xee, 0x3d, 0xba, 0x02, 0x9a, 0x7e,
	0x89, 0xda, 0xa5, 0xbe, 0x21, 0x33, 0x4a, 0x22, 0x77, 0x82, 0xde, 0x85, 0xf3, 0x1e, 0xf5, 0xdb,
	0x3d, 0xda, 0x66, 0xc4, 0x09, 0x9a, 0x2c, 0x37, 0xa7, 0x34, 0x32, 0x91, 0xb0, 0x1c, 0x34, 0x19,
	0x5a, 0x87, 0x2b, 0xbc, 0xcb, 0x98, 0x73, 0x48, 0x42, 0xe6, 0x04, 0x6d, 0xdf, 0x95, 0xb7, 0x44,
	0x3b, 0xb2, 0xc9, 0x7c, 0x87, 0xa9, 0xc3, 0x27, 0xf0, 0x65, 0xad, 0x84, 0x07, 0x3a, 0xe5, 0xbe,
	0x0a, 0xba, 0x04, 0x53, 0xd4, 0x51, 0xb7, 0x30, 0xa9, 0x56, 0x30, 0x23, 0xf4, 0x6d, 0x80, 0x6e,
	0xff, 0x3a, 0x9b, 0x77, 0xe0, 0xcc, 0xdc, 0x8c, 0xa9, 0xa2, 0xbb, 0x70, 0x99, 0x7a, 0x9e, 0x4a,
	0x2e, 0x37, 0x64, 0x4d, 0xf3, 0xe6, 0x91, 0xae, 0xbc, 0x5d, 0xbe, 0x50, 0xac, 0x9f, 0xc2, 0x39,
	0xea, 0x79, 0xd8, 0x68, 0xe8, 0xf7, 0x6c, 0x57, 0xcf, 0xa3, 0x9b, 0x90, 0x6d, 0xf5, 0xbc, 0x96,
	0xeb, 0x79, 0x2a, 0x59, 0x95, 0x77, 0xa6, 0xd4, 0xce, 0xe6, 0x62, 0x72, 0xe5, 0xa3, 0x03, 0x98,
	0x8f, 0xab, 0x76, 0x18, 0xe7, 0xb4, 0xcd, 0x78, 0x6e, 0x5a, 0xdd, 0xd0, 0xe2, 0x18, 0x29, 0xa4,
	0x2a, 0x8c, 0x6d, 0x6d, 0x87, 0x2f, 0xc6, 0xc0, 0x8c, 0x4c, 0x91, 0x45, 0x9f, 0x9d, 0x83, 0x5e,
	0xe8, 0xb0, 0x5c, 0x4a, 0x6d, 0xa6, 0xcf, 0xc4, 0x4a, 0x88, 0xee, 0xc3, 0x5c, 0xa4, 0x16, 0x5d,
	0xe7, 0x99, 0x57, 0xbb, 0x2c, 0x82, 0xdd, 0x35, 0xb7, 0xfa, 0x01, 0xcc, 0x19, 0xa2, 0xee, 0xd3,
	0x12, 0xbc, 0x26, 0xc5, 0xcd, 0x6a, 0x80, 0x3e, 0x83, 0xdd, 0x83, 0x29, 0x5d, 0x44, 0xe5, 0xd2,
	0x6a, 0x2f, 0x5f, 0x1d, 0xd3, 0x23, 0xd8, 0x98, 0xa1, 0x4f, 0xe0, 0xb2, 0xfe, 0x47, 0x9a, 0xea,
	0x55, 0x1e, 0xca, 0xae, 0x8c, 0xca, 0xae, 0x45, 0xad, 0x52, 0x89, 0x34, 0x62, 0xb9, 0x75, 0x1f,
	0xe6, 0x9a, 0x2e, 0x6d, 0xfb, 0x01, 0x17, 0xae, 0x43, 0x5c, 0xbf, 0x15, 0xe4, 0x66, 0x47, 0x78,
	0x65, 0xa0, 0x5f, 0xf5, 0x5b, 0x01, 0x12, 0xb0, 0x78, 0x2a, 0x71, 0xa9, 0x47, 0xfe, 0x82, 0xc2,
	0xfa, 0xf0, 0x4d, 0x08, 0x4b, 0x3f, 0xc9, 0xfc, 0xf4, 0x09, 0xf4, 0x7d, 0xb8, 0x30, 0x60, 0x58,
	0xea, 0xf3, 0xe7, 0xf2, 0x0a, 0xa0, 0x31, 0x89, 0xe9, 0x3b, 0x91, 0x65, 0x49, 0x1b, 0xe2, 0xec,
	0xd3, 0x21, 0x49, 0xfe, 0x2f, 0x49, 0xc8, 0x0e, 0xab, 0x21, 0x0c, 0xd3, 0xd1, 0x52, 0x96, 0x0a,
	0xfc, 0x87, 0xaf, 0xbd, 0x54, 0x41, 0xff, 0xe2, 0x08, 0x68, 0xe9, 0xef, 0x09, 0x98, 0xd2, 0x32,
	0x79, 0xcf, 0x4d, 0x02, 0x6b, 0xae, 0x31, 0x23, 0x59, 0x43, 0xb4, 0xe8, 0x11, 0x51, 0x0c, 0x1d,
	0xbd, 0xc5, 0x33, 0x38, 0xdd, 0xa2, 0x47, 0x0f, 0x8c, 0x48, 0x51, 0x84, 0x02, 0xe9, 0x53, 0x84,
	0x86, 0xfc, 0x89, 0x05, 0x97, 0x3a, 0x54, 0x38, 0x87, 0xb1, 0xa4, 0x20, 0x1e, 0x7b, 0xc6, 0x3c,
	0xc5, 0x17, 0xb3, 0x6b, 0xdb, 0x6f, 0x7a, 0x82, 0xc2, 0xb6, 0x84, 0x1d, 0x64, 0x52, 0x4d, 0x82,
	0xe2, 0xf9, 0xce, 0x29, 0x52, 0x49, 0x18, 0xc3, 0x9b, 0x50, 0x24, 0x93, 0xc0, 0x73, 0x43, 0xfa,
	0xf9, 0xef, 0xc1, 0xfc, 0x69, 0xc0, 0xe8, 0x2b, 0x90, 0xdf, 0x2e, 0xed, 0x95, 0xb7, 0x48, 0x79,
	0xa7, 0xbe, 0x51, 0xad, 0xd8, 0xf5, 0xb2, 0x4d, 0x6a, 0xf6, 0x43, 0xbb, 0x46, 0xf6, 0xeb, 0x8d,
	0x5d, 0xbb, 0x5c, 0xdd, 0xa8, 0xda, 0x95, 0xec, 0x39, 0x34, 0x0d, 0xc9, 0xda, 0xce, 0xa3, 0xac,
	0x85, 0x00, 0xa6, 0xb6, 0xed, 0x4a, 0x75, 0x7f, 0x3b, 0x9b, 0x40, 0x29, 0x98, 0xd8, 0xaa, 0x6e,
	0x6e, 0x65, 0x93, 0xf9, 0x9f, 0x27, 0x61, 0xb9, 0x21, 0x42, 0x46, 0x3b, 0xae, 0xdf, 0xfe, 0xd2,
	0x75, 0x08, 0x37, 0x21, 0xcb, 0x5d, 0xbf, 0xed, 0x31, 0xd2, 0x13, 0x82, 0x85, 0x54, 0xfa, 0x59,
	0x17, 0x4e, 0x73, 0x5a, 0xbe, 0x1f, 0x89, 0xcf, 0x2a, 0x3a, 0x27, 0xdf, 0x62, 0x33, 0x31, 0x75,
	0xa2, 0x99, 0xf8, 0xdd, 0x04, 0x5c, 0x39, 0x23, 0x1a, 0xe3, 0x76, 0x15, 0x4f, 0x00, 0xc5, 0x1f,
	0xd6, 0x97, 0x7a, 0x8b, 0x3b, 0xa3, 0x69, 0x27, 0x5a, 0x3c, 0xf6, 0xf0, 0x1a, 0xe6, 0xb9, 0x10,
	0x0e, 0x8b, 0x4e, 0x74, 0x30, 0xc9, 0xb7, 0xda, 0xc1, 0x4c, 0xbf, 0xdd, 0x0e, 0x66, 0xe2, 0x4d,
	0x3b, 0x98, 0xc9, 0xff, 0x4f, 0x07, 0xf3, 0xc7, 0x04, 0x2c, 0x9d, 0x1d, 0x2e, 0xf4, 0x04, 0x32,
	0xa6, 0xb8, 0x50, 0x3d, 0x80, 0xca, 0x94, 0xd9, 0xb5, 0xcd, 0xff, 0x22, 0x03, 0xa2, 0xa2, 0x43,
	0xf5, 0x05, 0xe9, 0xce, 0x60, 0x80, 0xae, 0x02, 0x88, 0x90, 0xfa, 0xdc, 0x09, 0xdd, 0xae, 0x30,
	0x6c, 0x1c, 0x93, 0xa0, 0x45, 0x48, 0xb9, 0x9c, 0xb4, 0x5c, 0x9f, 0x7a, 0x2a, 0x47, 0x52, 0x78,
	0xda, 0xe5, 0x1b, 0x72, 0x28, 0x4d, 0x63, 0x1c, 0x38, 0xa1, 0x38, 0x30, 0x26, 0xc9, 0x7f, 0x0a,
	0xe9, 0xd8, 0xb2, 0x68, 0x19, 0x72, 0xdb, 0x76, 0xa3, 0x51, 0xda, 0xb4, 0xc9, 0xde, 0x67, 0xbb,
	0xf6, 0x10, 0xd7, 0xcd, 0x02, 0xec, 0xe1, 0x52, 0xbd, 0x51, 0xc6, 0xd5, 0xdd, 0xbd, 0xac, 0x85,
	0x2e, 0xc3, 0x82, 0x5d, 0xaf, 0x90, 0x9d, 0x0d, 0xd2, 0xa8, 0xd6, 0x37, 0x6b, 0x36, 0xd9, 0xdf,
	0xdb, 0xb3, 0x71, 0xa9, 0x5e, 0xb6, 0xb3, 0x89, 0xfc, 0x3f, 0x2c, 0xc8, 0x0e, 0x17, 0xe4, 0x68,
	0x1f, 0x66, 0x75, 0xc4, 0x98, 0xef, 0x04, 0x4d, 0xd7, 0x6f, 0x1b, 0xbf, 0x15, 0x46, 0xfa, 0x4d,
	0xa1, 0xd8, 0xc6, 0x0a, 0x9f, 0xa7, 0xf1, 0x21, 0x5a, 0x85, 0x0b, 0x9c, 0x76, 0xba, 0x1e, 0x23,
	0x21, 0x15, 0x8c, 0x1c, 0xb2, 0x50, 0xbc, 0x50, 0x7e, 0x9a, 0xc4, 0x73, 0x7a, 0x02, 0x53, 0xc1,
	0xb6, 0xa4, 0xf8, 0x64, 0x15, 0x9d, 0x3c, 0xa5, 0x8a, 0xbe, 0x01, 0x99, 0xee, 0x61, 0x28, 0xfb,
	0xa8, 0x43, 0xd7, 0x57, 0xdd, 0xa0, 0xec, 0xa3, 0xd2, 0x5a, 0xb6, 0x25, 0x45, 0x68, 0x1e, 0x26,
	0x3b, 0x41, 0x93, 0x79, 0xb9, 0x69, 0x65, 0xaf, 0x07, 0xf9, 0x0a, 0xcc, 0xf4, 0xbb, 0x06, 0x84,
	0x4c, 0xbf, 0xa1, 0x59, 0x44, 0x77, 0x10, 0x27, 0x96, 0x4f, 0x9c, 0x5c, 0x3e, 0xff, 0x23, 0x80,
	0x41, 0xe3, 0x20, 0x61, 0x64, 0x37, 0x17, 0xc1, 0xc8, 0xff, 0x43, 0xa5, 0x78, 0x62, 0xfc, 0x52,
	0x7c, 0x9c, 0xe3, 0xe7, 0x29, 0x5c, 0x7d, 0x75, 0x47, 0x87, 0xee, 0xc1, 0xb2, 0x2a, 0xbd, 0x5e,
	0x44, 0x2c, 0x22, 0x0f, 0x47, 0xfa, 0xc5, 0x93, 0xda, 0x6b, 0x0a, 0x2f, 0x1a, 0x9d, 0x07, 0x51,
	0x0f, 0xd3, 0x47, 0xcd, 0x3f, 0x87, 0x85, 0x33, 0x6a, 0x30, 0xf4, 0x5d, 0x98, 0x3f, 0x13, 0x73,
	0x9c, 0xb6, 0xad, 0x8f, 0x8b, 0xd1, 0xd1, 0xc9, 0x85, 0xef, 0xc1, 0x4c, 0x7f, 0x20, 0x83, 0xc8,
	0x9d, 0x20, 0xd4, 0xbe, 0x4d, 0x60, 0x3d, 0x40, 0xcb, 0x30, 0xd3, 0xa1, 0xf2, 0x6e, 0xf6, 0x9a,
	0x51, 0xbf, 0x34, 0x10, 0xac, 0xfe, 0xdb, 0x82, 0xf3, 0x2f, 0x65, 0x23, 0xba, 0x0a, 0x4b, 0xa5,
	0xfd, 0x4a, 0x75, 0x87, 0xd8, 0xf5, 0xf2, 0x4e, 0xa5, 0x5a, 0xdf, 0x1c, 0xba, 0x37, 0xcb, 0x90,
	0x1b, 0x9a, 0xaf, 0x55, 0xeb, 0x76, 0x09, 0x93, 0xdb, 0x1f, 0x64, 0x2d, 0xb4, 0x00, 0x17, 0x87,
	0x66, 0x37, 0x6a, 0xa5, 0x72, 0x36, 0x81, 0x72, 0x30, 0x3f, 0x34, 0xb1, 0xbd, 0x5f, 0x2b, 0x3d,
	0xca, 0x26, 0xd1, 0x25, 0x40, 0x43, 0x33, 0xa5, 0x6d, 0x9c, 0x9d, 0x40, 0x8b, 0xf0, 0xce, 0x49,
	0x39, 0x79, 0xb4, 0x9e, 0x9d, 0x94, 0x77, 0x75, 0x68, 0x6a, 0x67, 0x73, 0x93, 0xec, 0xec, 0xee,
	0x37, 0xb2, 0x53, 0xe8, 0x26, 0xbc, 0x37, 0x34, 0xd9, 0xd8, 0xb5, 0xed, 0x4f, 0xc9, 0xa3, 0xea,
	0xde, 0x16, 0xd9, 0xb2, 0x4b, 0x15, 0x1b, 0x93, 0xf5, 0xcf, 0xf6, 0xec, 0xec, 0xf4, 0xda, 0x9f,
	0x92, 0x90, 0x32, 0x9f, 0x31, 0x38, 0xfa, 0x75, 0x02, 0x32, 0xf1, 0x67, 0x14, 0x7d, 0x73, 0x64,
	0x70, 0x4e, 0xa9, 0x81, 0x96, 0xbe, 0xf5, 0x9a, 0x56, 0xfa, 0x31, 0xce, 0xff, 0xc6, 0xfa, 0xf1,
	0x9f, 0xff, 0xf6, 0x8b, 0xc4, 0x2f, 0xad, 0xfc, 0x9d, 0xfe, 0x37, 0xdf, 0x1f, 0x98, 0xea, 0xe9,
	0x6e, 0x37, 0x0c, 0x9e, 0x30, 0x47, 0xf0, 0xe2, 0x6a, 0x91, 0xb6, 0x99, 0x2f, 0xa2, 0xaf, 0xc1,
	0xbc, 0xb8, 0xfa, 0xc3, 0x8f, 0x9b, 0x31, 0xb8, 0x8f, 0xad, 0xd5, 0xc7, 0x8f, 0xf2, 0x78, 0x0c,
	0x04, 0xe6, 0x3f, 0x73, 0xc3, 0xc0, 0x97, 0x89, 0x23, 0x85, 0x3d, 0xce, 0x42, 0xf9, 0xfb, 0x0a,
	0x60, 0xf4, 0x2b, 0x0b, 0xde, 0x39, 0xb5, 0xe0, 0x40, 0x77, 0xc7, 0x7f, 0x29, 0x4e, 0x73, 0xd9,
	0x27, 0x6f, 0x6a, 0x6e, 0x7c, 0x77, 0x6e, 0xc5, 0xba, 0x65, 0xad, 0x7f, 0x61, 0xc1, 0xbb, 0x4e,
	0xd0, 0x19, 0x85, 0xb5, 0x9e, 0x31, 0x11, 0xdf, 0x95, 0xc4, 0xb2, 0x6b, 0x3d, 0xae, 0x1a, 0x83,
	0x76, 0x20, 0x69, 0xa3, 0x10, 0x84, 0xed, 0x62, 0x9b, 0xf9, 0x8a, 0x76, 0x8a, 0x7a, 0x8a, 0x76,
	0x5d, 0x7e, 0xe6, 0x97, 0xf9, 0x3b, 0x03, 0xd1, 0xbf, 0x2c, 0xeb, 0xb7, 0x89, 0x44, 0x65, 0xe3,
	0x8b, 0xc4, 0xb5, 0x4d, 0x8d, 0x59, 0x56, 0x9b, 0xa8, 0x0c, 0x36, 0xf1, 0x50, 0x1b, 0x1d, 0x4c,
	0x29, 0xfc, 0x6f, 0xfc, 0x27, 0x00, 0x00, 0xff, 0xff, 0xfa, 0x78, 0x67, 0x76, 0xf7, 0x18, 0x00,
	0x00,
}
